/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFRectangleRange;
import org.cip4.jdflib.datatypes.JDFRectangleRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;

public class JDFRectangleEvaluation
extends JDFEvaluation {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[3];

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFRectangleEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFRectangleEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFRectangleEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFRectangleEvaluation[ --> " + super.toString() + " ]";
    }

    public void setValueList(JDFRectangleRangeList value) {
        this.setAttribute("ValueList", value.toString());
    }

    public void setValueList(JDFRectangle value) {
        this.setAttribute("ValueList", value.toString());
    }

    public JDFRectangleRangeList getValueList() {
        String vl = this.getAttribute("ValueList", null, null);
        if (vl == null) {
            return null;
        }
        try {
            return new JDFRectangleRangeList(vl);
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFRectangleEvaluation.getValueList: Attribute VALUELIST is not capable to create JDFRectangleRangeList");
        }
    }

    public void setHWRelation(JDFElement.EnumXYRelation value) {
        this.setAttribute("HWRelation", value.getName(), null);
    }

    public JDFElement.EnumXYRelation getHWRelation() {
        return JDFElement.EnumXYRelation.getEnum(this.getAttribute("HWRelation", null, null));
    }

    public void setTolerance(JDFXYPair value) {
        this.setAttribute("Tolerance", value.toString(), null);
    }

    @Override
    public JDFXYPair getTolerance() {
        return super.getTolerance();
    }

    @Override
    public final boolean fitsValue(String value) {
        if (!this.fitsListType(value)) {
            return false;
        }
        JDFRectangleRangeList rrl = null;
        try {
            rrl = new JDFRectangleRangeList(value);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        int siz = rrl.size();
        for (int i = 0; i < siz; ++i) {
            JDFRectangle rectangle;
            JDFRectangle right;
            JDFRectangleRange range = (JDFRectangleRange)rrl.at(i);
            JDFRectangle left = range.getLeft();
            if (!(left.equals(right = range.getRight()) ? !(this.fitsValueList(new JDFRectangleRange(rectangle = left)) && this.fitsHWRelation(rectangle)) : !(this.fitsValueList(range) && this.fitsHWRelation(left) && this.fitsHWRelation(right)))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsListType(String value) {
        JDFRectangleRangeList rangelist;
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        try {
            rangelist = new JDFRectangleRangeList(value);
        }
        catch (DataFormatException e) {
            return false;
        }
        catch (JDFException e) {
            return false;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.SingleValue) || listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.getEnum(0))) {
            try {
                new JDFRectangle(value);
            }
            catch (JDFException e) {
                return false;
            }
            catch (DataFormatException e) {
                return false;
            }
            return true;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.RangeList)) {
            return true;
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.List)) {
            return rangelist.isList();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.OrderedList)) {
            return rangelist.isList() && rangelist.isOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueList)) {
            return rangelist.isList() && rangelist.isUnique();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedList)) {
            return rangelist.isList() && rangelist.isUniqueOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.OrderedRangeList)) {
            return rangelist.isOrdered();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueRangeList)) {
            return rangelist.isUnique();
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.UniqueOrderedRangeList)) {
            return rangelist.isUniqueOrdered();
        }
        throw new JDFException("JDFRectangleEvaluation.fitsListType illegal ListType attribute");
    }

    private final boolean fitsValueList(JDFRectangleRange range) {
        if (!this.hasAttribute("ValueList")) {
            return true;
        }
        JDFRectangleRangeList rangelist = this.getValueList();
        if (this.hasAttribute("Tolerance")) {
            return this.fitsTolerance(rangelist).isPartOfRange(range);
        }
        return rangelist.isPartOfRange(range);
    }

    private JDFRectangleRangeList fitsTolerance(JDFRectangleRangeList origRangeList) {
        double nt = this.getTolerance().getX();
        double pt = this.getTolerance().getY();
        if (nt == 0.0 && pt == 0.0) {
            return origRangeList;
        }
        JDFRectangleRangeList rangeList = new JDFRectangleRangeList(origRangeList);
        JDFRectangleRangeList tolRangeList = new JDFRectangleRangeList();
        int size = rangeList.size();
        for (int i = 0; i < size; ++i) {
            JDFRectangleRange range = (JDFRectangleRange)rangeList.at(i);
            JDFRectangle left = range.getLeft();
            double leftLlx = left.getLlx();
            double leftLly = left.getLly();
            double leftUrx = left.getUrx();
            double leftUry = left.getUry();
            left.setLlx(leftLlx - nt);
            left.setLly(leftLly - nt);
            left.setUrx(leftUrx - nt);
            left.setUry(leftUry - nt);
            JDFRectangle right = range.getRight();
            double rightLlx = right.getLlx();
            double rightLly = right.getLly();
            double rightUrx = right.getUrx();
            double rightUry = right.getUry();
            right.setLlx(rightLlx + pt);
            right.setLly(rightLly + pt);
            right.setUrx(rightUrx + pt);
            right.setUry(rightUry + pt);
            range.setLeft(left);
            range.setRight(right);
            tolRangeList.append(range);
        }
        return tolRangeList;
    }

    private final boolean fitsHWRelation(JDFRectangle rect) {
        double width = rect.getUrx() - rect.getLlx();
        double height = rect.getUry() - rect.getLly();
        if (!this.hasAttribute("HWRelation")) {
            return true;
        }
        if (!this.hasAttribute("Tolerance")) {
            return this.getHWRelation().evaluateXY(width, height, 1.0E-6, 1.0E-6);
        }
        double nt = this.getTolerance().getX();
        double pt = this.getTolerance().getY();
        return this.getHWRelation().evaluateXY(width, height, nt, pt);
    }

    static {
        JDFRectangleEvaluation.atrInfoTable[0] = new AtrInfoTable("HWRelation", 0x33333333L, AttributeInfo.EnumAttributeType.XYRelation, null, null);
        JDFRectangleEvaluation.atrInfoTable[1] = new AtrInfoTable("Tolerance", 0x33333333L, AttributeInfo.EnumAttributeType.XYPair, null, "0 0");
        JDFRectangleEvaluation.atrInfoTable[2] = new AtrInfoTable("ValueList", 0x33333333L, AttributeInfo.EnumAttributeType.RectangleRangeList, null, null);
    }
}

