/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPosition;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.w3c.dom.DOMException;

public class JDFPosition
extends JDFAutoPosition {
    private static final long serialVersionUID = 1L;

    public static JDFPosition createPosition(KElement parent, int x, int y, int nX, int nY) throws IllegalArgumentException {
        if (x < 0 || x >= nX || y < 0 || y >= nY) {
            throw new IllegalArgumentException("bad x or y: x=" + x + " nX=" + nX + " y=" + y + " nY=" + nY);
        }
        JDFPosition p = (JDFPosition)(parent == null ? new JDFDoc("Position").getRoot() : parent.appendElement("Position"));
        JDFRectangle r = new JDFRectangle((double)x / (double)nX, (double)y / (double)nY, (double)(x + 1) / (double)nX, (double)(y + 1) / (double)nY);
        p.setRelativeBox(r);
        return p;
    }

    public JDFPosition(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPosition(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPosition(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPosition[  --> " + super.toString() + " ]";
    }
}

