/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.util.ListMap;
import org.cip4.jdflib.util.VectorMap;

public class ContainerUtil {
    public static <A> Set<A> toHashSet(Enumeration<A> enumeration) {
        if (enumeration == null) {
            return null;
        }
        HashSet<A> s = new HashSet<A>();
        while (enumeration.hasMoreElements()) {
            s.add(enumeration.nextElement());
        }
        return s;
    }

    public static Collection<?> getNonEmpty(Collection<?> c) {
        return c == null || c.isEmpty() ? null : c;
    }

    public static Map<?, ?> getNonEmpty(Map<?, ?> c) {
        return c == null || c.isEmpty() ? null : c;
    }

    public static Collection<?> getNonEmptyCollection(Collection<? extends Collection<?>> c) {
        return c == null || c.isEmpty() || c.size() == 1 && ContainerUtil.getNonEmpty(c.iterator().next()) == null ? null : c;
    }

    public static <A> Set<A> toHashSet(List<A> list) {
        return ContainerUtil.toHashSet(list);
    }

    public static <A> Set<A> toHashSet(Collection<A> list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        HashSet<A> s = new HashSet<A>(size + 10);
        Iterator<A> it = list.iterator();
        while (it.hasNext()) {
            s.add(it.next());
        }
        return s;
    }

    public static <A> Set<A> toHashSet(A[] l) {
        if (l == null) {
            return null;
        }
        HashSet<A> s = new HashSet<A>(l.length + 10);
        for (A element : l) {
            s.add(element);
        }
        return s;
    }

    public static <A> Vector<A> toVector(A[] array) {
        if (array == null) {
            return null;
        }
        Vector<A> v = new Vector<A>();
        v.ensureCapacity(array.length);
        for (A element : array) {
            if (element == null) continue;
            v.add(element);
        }
        return v;
    }

    public static <A> String toString(Collection<A> c) {
        if (c == null) {
            return "";
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(c);
        l.sort(null);
        StringBuilder b = new StringBuilder();
        int i = 0;
        for (Object e : l) {
            if (i++ > 0) {
                b.append(",");
            }
            b.append(e.toString());
        }
        return b.toString();
    }

    public static <A> List<A> toArrayList(A[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<A> v = new ArrayList<A>();
        v.ensureCapacity(array.length);
        for (A element : array) {
            if (element == null) continue;
            v.add(element);
        }
        return v;
    }

    public static <A> Collection<A> addAll(Collection<A> c1, Collection<A> c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        c1.addAll(c2);
        return c1;
    }

    public static <A> boolean containsAny(Collection<A> c, Collection<A> others) {
        if (ContainerUtil.isEmpty(others)) {
            return true;
        }
        if (ContainerUtil.isEmpty(c)) {
            return false;
        }
        for (A other : others) {
            if (!c.contains(other)) continue;
            return true;
        }
        return false;
    }

    public static <A> boolean contains(Collection<A> c, A other) {
        if (other == null || c == null) {
            return false;
        }
        return c.contains(other);
    }

    public static <A> int count(Collection<A> c, A other) {
        int n = 0;
        if (c != null) {
            for (A a : c) {
                if (!ContainerUtil.equals(a, other)) continue;
                ++n;
            }
        }
        return n;
    }

    public static <A> boolean containsAll(Collection<A> c, Collection<A> others) {
        if (ContainerUtil.isEmpty(others)) {
            return true;
        }
        if (ContainerUtil.isEmpty(c)) {
            return false;
        }
        return c.containsAll(others);
    }

    public static <A> List<A> getOverlapping(Collection<A> c, Collection<A> others) {
        if (others == null) {
            return null;
        }
        ArrayList<A> ret = new ArrayList<A>();
        for (A s : c) {
            if (!others.contains(s)) continue;
            ret.add(s);
        }
        return !ret.isEmpty() ? ret : null;
    }

    public static <A> void addAll(Collection<A> c, A[] a) {
        if (a != null && c != null) {
            for (A aa : a) {
                if (aa == null) continue;
                c.add(aa);
            }
        }
    }

    public static <A> void add(Collection<A> c, A a) {
        if (c != null && a != null) {
            c.add(a);
        }
    }

    public static <a> IMatches getMatch(Collection<? extends IMatches> c, a obj, int iSkip) {
        if (c == null) {
            return null;
        }
        if (iSkip < 0) {
            List<IMatches> v = ContainerUtil.getMatchesList(c, obj);
            if (v == null) {
                return null;
            }
            iSkip = v.size() + iSkip;
            if (iSkip < 0) {
                return null;
            }
            return v.get(iSkip);
        }
        for (IMatches iMatches : c) {
            if (!iMatches.matches(obj) || iSkip-- > 0) continue;
            return iMatches;
        }
        return null;
    }

    public static <A> A getMatch(IMatches match, Collection<A> c, int iSkip) {
        if (c == null) {
            return null;
        }
        if (iSkip < 0) {
            List<A> v = ContainerUtil.getMatchesList(match, c);
            if (v == null) {
                return null;
            }
            iSkip = v.size() + iSkip;
            if (iSkip < 0) {
                return null;
            }
            return v.get(iSkip);
        }
        for (A b : c) {
            if (!match.matches(b) || iSkip-- > 0) continue;
            return b;
        }
        return null;
    }

    public static <A> Vector<IMatches> getMatches(Collection<? extends IMatches> c, A obj) {
        if (c == null) {
            return null;
        }
        Vector<IMatches> v = new Vector<IMatches>();
        for (IMatches iMatches : c) {
            if (!iMatches.matches(obj)) continue;
            v.add(iMatches);
        }
        return v.isEmpty() ? null : v;
    }

    public static <A> List<IMatches> getMatchesList(Collection<? extends IMatches> c, A obj) {
        if (c == null) {
            return null;
        }
        ArrayList<IMatches> l = new ArrayList<IMatches>();
        for (IMatches iMatches : c) {
            if (!iMatches.matches(obj)) continue;
            l.add(iMatches);
        }
        return l.isEmpty() ? null : l;
    }

    public static <A> Vector<A> getMatches(IMatches m, Collection<A> c) {
        if (c == null) {
            return null;
        }
        Vector<A> v = new Vector<A>();
        for (A b : c) {
            if (!m.matches(b)) continue;
            v.add(b);
        }
        return v.isEmpty() ? null : v;
    }

    public static <A> List<A> getMatchesList(IMatches m, Collection<A> c) {
        if (c == null) {
            return null;
        }
        ArrayList<A> v = new ArrayList<A>();
        for (A b : c) {
            if (!m.matches(b)) continue;
            v.add(b);
        }
        return v.isEmpty() ? null : v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <a extends Comparable<? super a>, b> Vector<b> toValueVector(Map<a, b> m, boolean sortByKey) {
        if (!sortByKey) {
            return ContainerUtil.toValueVector(m);
        }
        if (m == null) {
            return null;
        }
        Map<a, b> map = m;
        synchronized (map) {
            Set<Map.Entry<a, b>> entrySet = m.entrySet();
            if (entrySet.isEmpty()) {
                return null;
            }
            Vector<b> v = new Vector<b>();
            v.ensureCapacity(entrySet.size());
            Iterator<Map.Entry<a, b>> it = entrySet.iterator();
            Vector<Comparable> keys = new Vector<Comparable>();
            keys.ensureCapacity(entrySet.size());
            while (it.hasNext()) {
                Comparable key = (Comparable)it.next().getKey();
                if (key == null) continue;
                keys.add(key);
            }
            Collections.sort(keys);
            for (Comparable key : keys) {
                v.add(m.get(key));
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends Comparable<? super A>, B> List<B> toArrayList(Map<A, B> m, boolean sortByKey) {
        if (!sortByKey) {
            return ContainerUtil.toArrayList(m);
        }
        if (m == null) {
            return null;
        }
        Map<A, B> map = m;
        synchronized (map) {
            Set<Map.Entry<A, B>> entrySet = m.entrySet();
            if (entrySet.isEmpty()) {
                return null;
            }
            ArrayList<B> v = new ArrayList<B>();
            v.ensureCapacity(entrySet.size());
            Iterator<Map.Entry<A, B>> it = entrySet.iterator();
            ArrayList<Comparable> keys = new ArrayList<Comparable>();
            keys.ensureCapacity(entrySet.size());
            while (it.hasNext()) {
                Comparable key = (Comparable)it.next().getKey();
                if (key == null) continue;
                keys.add(key);
            }
            Collections.sort(keys);
            for (Comparable key : keys) {
                v.add(m.get(key));
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A, B> Vector<B> toValueVector(Map<A, B> m) {
        if (m == null) {
            return null;
        }
        Map<A, B> map = m;
        synchronized (map) {
            Vector<B> v = new Vector<B>();
            Collection<B> values = m.values();
            if (values.isEmpty()) {
                return null;
            }
            v.addAll(values);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A, B> List<B> toArrayList(Map<A, B> m) {
        if (m == null) {
            return null;
        }
        Map<A, B> map = m;
        synchronized (map) {
            ArrayList<B> v = new ArrayList<B>();
            Collection<B> values = m.values();
            if (values.size() == 0) {
                return null;
            }
            v.addAll(values);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static <A, B> VectorMap<B, A> getInvertedMap(Map<A, B> m) {
        if (m == null) {
            return null;
        }
        Map<A, B> map = m;
        synchronized (map) {
            VectorMap inv = new VectorMap();
            Set<A> keys = m.keySet();
            if (keys.size() == 0) {
                return null;
            }
            for (Object key : keys) {
                B val = m.get(key);
                if (val == null) continue;
                inv.putOne(val, key);
            }
            return inv;
        }
    }

    public static <A> void appendUnique(Collection<A> c, A a) {
        if (a != null && !c.contains(a)) {
            c.add(a);
        }
    }

    public static <A> Collection<A> appendUnique(Collection<A> c, Collection<A> a) {
        if (c == null) {
            return a;
        }
        if (!ContainerUtil.isEmpty(a)) {
            c.addAll(a);
            ContainerUtil.unify(c);
        }
        return c;
    }

    public static <A> int index(List<A> l, int i) {
        if (l == null) {
            return -1;
        }
        int size = l.size();
        if (i < 0) {
            i += size;
        }
        return i >= size ? -2 : i;
    }

    public static <A> A get(List<A> l, int i) {
        return (i = ContainerUtil.index(l, i)) >= 0 ? (A)l.get(i) : null;
    }

    public static <A> A remove(List<A> l, int i) {
        return (i = ContainerUtil.index(l, i)) >= 0 ? (A)l.remove(i) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A, B> ListMap<B, A> getInvertedListMap(Map<A, B> m) {
        if (m == null) {
            return null;
        }
        Map<A, B> map = m;
        synchronized (map) {
            ListMap inv = new ListMap();
            Set<A> keys = m.keySet();
            if (keys.size() == 0) {
                return null;
            }
            for (Object key : keys) {
                B val = m.get(key);
                if (val == null) continue;
                inv.putOne(val, key);
            }
            return inv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static <A> Vector<A> getKeyVector(Map<A, ?> m) {
        if (m == null) {
            return null;
        }
        Map<A, ?> map = m;
        synchronized (map) {
            Set<A> keySet = m.keySet();
            if (keySet.isEmpty()) {
                return null;
            }
            Vector<A> v = new Vector<A>();
            v.ensureCapacity(keySet.size());
            v.addAll(keySet);
            return v;
        }
    }

    public static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean matches(IMatches a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.matches(b);
    }

    public static boolean matchesExisting(IMatches a, Object b) {
        if (a == null || b == null) {
            return true;
        }
        return a.matches(b);
    }

    public static int compare(Comparable c0, Comparable c1) {
        if (c0 == null) {
            return c1 == null ? 0 : -1;
        }
        if (c1 == null) {
            return 1;
        }
        return c0.compareTo(c1);
    }

    public static <A> void ensureSize(int size, Collection<A> coll) {
        int s2 = coll.size();
        if (s2 < size) {
            for (int i = s2; i < size; ++i) {
                coll.add(null);
            }
        }
    }

    public static <A> Collection<A> unify(Collection<A> c) {
        if (ContainerUtil.size(c) < 2) {
            return c;
        }
        LinkedHashSet<A> lhsIn = new LinkedHashSet<A>(c.size());
        for (A el : c) {
            if (lhsIn.contains(el)) continue;
            lhsIn.add(el);
        }
        if (lhsIn.size() < c.size()) {
            c.clear();
            c.addAll(lhsIn);
        }
        return c;
    }

    public static <A extends IMatches> Collection<A> unifyMatches(Collection<A> c) {
        List<IMatches> mm;
        if (c == null || c.size() < 2) {
            return c;
        }
        ArrayList<IMatches> al = new ArrayList<IMatches>(c.size());
        for (IMatches el : c) {
            mm = ContainerUtil.getMatchesList(al, el);
            if (mm != null) continue;
            al.add(el);
        }
        if (al.size() < c.size()) {
            ArrayList<IMatches> v2 = new ArrayList<IMatches>();
            for (int i = al.size() - 1; i >= 0; --i) {
                mm = ContainerUtil.getMatchesList(v2, (IMatches)al.get(i));
                if (mm != null) continue;
                v2.add((IMatches)al.get(i));
            }
            c.clear();
            c.addAll(v2);
        }
        return c;
    }

    public static int length(Object[] c) {
        return c == null ? 0 : c.length;
    }

    public static boolean isEmpty(Object[] c) {
        return c == null ? true : c.length == 0;
    }

    public static int size(Collection<?> c) {
        return c == null ? 0 : c.size();
    }

    public static int size(Map<?, ?> c) {
        return c == null ? 0 : c.size();
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null ? true : c.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> c) {
        return c == null ? true : c.isEmpty();
    }

    public static <A> Collection<A> getKeyArray(Map<A, ?> m) {
        if (m == null) {
            return null;
        }
        Set<A> keySet = m.keySet();
        if (keySet.isEmpty()) {
            return null;
        }
        ArrayList<A> v = new ArrayList<A>();
        v.ensureCapacity(keySet.size());
        v.addAll(keySet);
        return v;
    }

    public static <A> List<A> getKeyList(Map<A, ?> m) {
        return (List)ContainerUtil.getKeyArray(m);
    }

    public static <A, B> Map<A, B> putAll(Map<A, B> map, Map<A, B> map2) {
        if (map == null) {
            return map2;
        }
        if (map2 != null) {
            map.putAll(map2);
        }
        return map;
    }

    public static <A, B> Map<A, B> retainAll(Map<A, B> map, Collection<A> keep) {
        if (map != null) {
            if (ContainerUtil.isEmpty(keep)) {
                map.clear();
            } else {
                for (A key : ContainerUtil.getKeyArray(map)) {
                    if (keep.contains(key)) continue;
                    map.remove(key);
                }
            }
        }
        return map;
    }

    public static <A, B> B put(Map<A, B> map, A key, B value) {
        if (map != null && key != null && value != null) {
            return map.put(key, value);
        }
        return null;
    }

    public static void close(Closeable w) {
        if (w != null) {
            try {
                w.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

