/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.net;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.MyInteger;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.net.IPollDetails;
import org.cip4.jdflib.util.net.IPollHandler;
import org.cip4.jdflib.util.thread.MyMutex;

public class NetPoll {
    private final Log log;
    private final VString vUrl;
    protected int idleWait;
    protected int busyWait;
    protected PollThread pollThread;
    static int threadCount = 0;
    protected IPollHandler poller;
    protected MyMutex mutex;
    protected String method;
    protected String contentType;

    public NetPoll(VString urls, IPollHandler poller) {
        this.vUrl = urls;
        this.idleWait = 15000;
        this.busyWait = 500;
        this.pollThread = null;
        this.poller = poller;
        this.mutex = new MyMutex();
        this.method = UrlUtil.GET;
        this.contentType = "text/unknown";
        this.log = LogFactory.getLog(this.getClass());
    }

    public NetPoll(String url, IPollHandler poller) {
        this(new VString(url, null), poller);
    }

    public boolean isRunning() {
        return this.pollThread != null && this.pollThread.running;
    }

    public void start() {
        if (this.pollThread == null) {
            this.pollThread = new PollThread();
            this.log.info((Object)("starting poll thread " + this.pollThread.getName()));
            this.pollThread.start();
        }
    }

    public void stop() {
        if (this.pollThread != null) {
            this.log.info((Object)("shutting down poll thread " + this.pollThread.getName()));
            this.pollThread.running = false;
            ThreadUtil.notifyAll(this.mutex);
            this.pollThread = null;
        }
    }

    protected int getUrlSize() {
        int size = this.vUrl.size();
        if (size <= 0) {
            size = 1;
        }
        return size;
    }

    protected IPollDetails poll(String baseUrl) {
        String url = this.getUrl(baseUrl);
        UrlPart p = UrlUtil.writeToURL(url, null, this.method, this.contentType, null);
        return p;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void addURL(String url) {
        this.vUrl.appendUnique(url);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String toString() {
        return "NetPoll: " + this.vUrl + " method: " + this.method + " content-type: " + this.contentType + "\n" + this.pollThread;
    }

    public void setIdleWait(int idleWait) {
        this.idleWait = idleWait;
    }

    public void setBusyWait(int busyWait) {
        this.busyWait = busyWait;
    }

    protected String getUrl(String baseUrl) {
        return baseUrl;
    }

    public VString getUrls() {
        return this.vUrl;
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    protected int getIdleWait() {
        int iw = this.idleWait / this.getUrlSize();
        if (iw < this.busyWait) {
            iw = this.busyWait;
        }
        return iw;
    }

    private class PollThread
    extends Thread {
        protected boolean running;

        public PollThread() {
            super("NetPoll_" + threadCount++);
            this.running = true;
        }

        @Override
        public String toString() {
            return "PollThread: idle: " + NetPoll.this.getIdleWait() + " busy: " + NetPoll.this.busyWait + " running: " + this.running + "\n" + NetPoll.this.poller;
        }

        @Override
        public void run() {
            int n = 0;
            int nSinceBad = 0;
            HashMap<String, MyInteger> badMap = new HashMap<String, MyInteger>();
            if (NetPoll.this.vUrl == null || NetPoll.this.vUrl.size() == 0) {
                NetPoll.this.log.warn((Object)"polling 0 urls - bailing out");
                this.running = false;
            }
            while (this.running) {
                String url = NetPoll.this.vUrl.get(n);
                MyInteger bad = (MyInteger)badMap.get(url);
                if (bad == null || ++nSinceBad > bad.i) {
                    IPollHandler.PollResult result;
                    IPollDetails details = NetPoll.this.poll(url);
                    try {
                        result = NetPoll.this.poller.handlePoll(details, url);
                    }
                    catch (Exception x) {
                        result = null;
                    }
                    if (result == null || !IPollHandler.PollResult.success.equals((Object)result)) {
                        if (IPollHandler.PollResult.error.equals((Object)result)) {
                            if (bad == null) {
                                bad = new MyInteger(1);
                                badMap.put(url, bad);
                            }
                            ++bad.i;
                            nSinceBad = 0;
                        } else {
                            badMap.remove(url);
                        }
                        if (!ThreadUtil.wait(NetPoll.this.mutex, NetPoll.this.getIdleWait())) break;
                        int size = NetPoll.this.getUrlSize();
                        ++n;
                        n %= size;
                        continue;
                    }
                    if (ThreadUtil.wait(NetPoll.this.mutex, NetPoll.this.getIdleWait())) continue;
                    break;
                }
                if (ThreadUtil.wait(NetPoll.this.mutex, NetPoll.this.getIdleWait())) continue;
                break;
            }
            NetPoll.this.pollThread = null;
        }
    }
}

