/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFFileSpec;

public abstract class JDFAutoScanParams
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[11];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoScanParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoScanParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoScanParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Parameter);
        return bRet;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Parameter;
    }

    public void setBitDepth(int value) {
        this.setAttribute("BitDepth", value, (String)null);
    }

    public int getBitDepth() {
        return this.getIntAttribute("BitDepth", null, 0);
    }

    public void setMagnification(JDFXYPair value) {
        this.setAttribute("Magnification", (JDFNumList)value, (String)null);
    }

    public JDFXYPair getMagnification() {
        String strAttrName = this.getAttribute("Magnification", null, null);
        JDFXYPair nPlaceHolder = JDFXYPair.createXYPair(strAttrName);
        return nPlaceHolder;
    }

    public void setOutputColorSpace(EnumOutputColorSpace enumVar) {
        this.setAttribute("OutputColorSpace", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumOutputColorSpace getOutputColorSpace() {
        return EnumOutputColorSpace.getEnum(this.getAttribute("OutputColorSpace", null, null));
    }

    public void setCompressionFilter(EnumCompressionFilter enumVar) {
        this.setAttribute("CompressionFilter", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumCompressionFilter getCompressionFilter() {
        return EnumCompressionFilter.getEnum(this.getAttribute("CompressionFilter", null, null));
    }

    public void setDCTQuality(double value) {
        this.setAttribute("DCTQuality", value, null);
    }

    public double getDCTQuality() {
        return this.getRealAttribute("DCTQuality", null, 0.0);
    }

    public void setInputBox(JDFRectangle value) {
        this.setAttribute("InputBox", (JDFNumList)value, (String)null);
    }

    public JDFRectangle getInputBox() {
        String strAttrName = this.getAttribute("InputBox", null, null);
        JDFRectangle nPlaceHolder = JDFRectangle.createRectangle(strAttrName);
        return nPlaceHolder;
    }

    public void setMountID(String value) {
        this.setAttribute("MountID", value, null);
    }

    public String getMountID() {
        return this.getAttribute("MountID", null, "");
    }

    public void setMounting(EnumMounting enumVar) {
        this.setAttribute("Mounting", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumMounting getMounting() {
        return EnumMounting.getEnum(this.getAttribute("Mounting", null, null));
    }

    public void setOutputResolution(JDFXYPair value) {
        this.setAttribute("OutputResolution", (JDFNumList)value, (String)null);
    }

    public JDFXYPair getOutputResolution() {
        String strAttrName = this.getAttribute("OutputResolution", null, null);
        JDFXYPair nPlaceHolder = JDFXYPair.createXYPair(strAttrName);
        return nPlaceHolder;
    }

    public void setOutputSize(JDFXYPair value) {
        this.setAttribute("OutputSize", (JDFNumList)value, (String)null);
    }

    public JDFXYPair getOutputSize() {
        String strAttrName = this.getAttribute("OutputSize", null, null);
        JDFXYPair nPlaceHolder = JDFXYPair.createXYPair(strAttrName);
        return nPlaceHolder;
    }

    public void setSplitDocuments(int value) {
        this.setAttribute("SplitDocuments", value, (String)null);
    }

    public int getSplitDocuments() {
        return this.getIntAttribute("SplitDocuments", null, 0);
    }

    public JDFFileSpec getFileSpec() {
        return (JDFFileSpec)this.getElement("FileSpec", null, 0);
    }

    public JDFFileSpec getCreateFileSpec() {
        return (JDFFileSpec)this.getCreateElement_JDFElement("FileSpec", null, 0);
    }

    public JDFFileSpec getCreateFileSpec(int iSkip) {
        return (JDFFileSpec)this.getCreateElement_JDFElement("FileSpec", null, iSkip);
    }

    public JDFFileSpec getFileSpec(int iSkip) {
        return (JDFFileSpec)this.getElement("FileSpec", null, iSkip);
    }

    public Collection<JDFFileSpec> getAllFileSpec() {
        return this.getChildArrayByClass(JDFFileSpec.class, false, 0);
    }

    public JDFFileSpec appendFileSpec() {
        return (JDFFileSpec)this.appendElement("FileSpec", null);
    }

    public void refFileSpec(JDFFileSpec refTarget) {
        this.refElement(refTarget);
    }

    static {
        JDFAutoScanParams.atrInfoTable[0] = new AtrInfoTable("BitDepth", 0x2222222222L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoScanParams.atrInfoTable[1] = new AtrInfoTable("Magnification", 0x3333333333L, AttributeInfo.EnumAttributeType.XYPair, null, "1 1");
        JDFAutoScanParams.atrInfoTable[2] = new AtrInfoTable("OutputColorSpace", 0x2222222222L, AttributeInfo.EnumAttributeType.enumeration, EnumOutputColorSpace.getEnum(0), null);
        JDFAutoScanParams.atrInfoTable[3] = new AtrInfoTable("CompressionFilter", 0x3333333333L, AttributeInfo.EnumAttributeType.enumeration, EnumCompressionFilter.getEnum(0), null);
        JDFAutoScanParams.atrInfoTable[4] = new AtrInfoTable("DCTQuality", 0x3333333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoScanParams.atrInfoTable[5] = new AtrInfoTable("InputBox", 0x3333333333L, AttributeInfo.EnumAttributeType.rectangle, null, null);
        JDFAutoScanParams.atrInfoTable[6] = new AtrInfoTable("MountID", 0x3333333333L, AttributeInfo.EnumAttributeType.shortString, null, null);
        JDFAutoScanParams.atrInfoTable[7] = new AtrInfoTable("Mounting", 0x3333333333L, AttributeInfo.EnumAttributeType.enumeration, EnumMounting.getEnum(0), null);
        JDFAutoScanParams.atrInfoTable[8] = new AtrInfoTable("OutputResolution", 0x3333333333L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFAutoScanParams.atrInfoTable[9] = new AtrInfoTable("OutputSize", 0x3333333333L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFAutoScanParams.atrInfoTable[10] = new AtrInfoTable("SplitDocuments", 0x3333333333L, AttributeInfo.EnumAttributeType.integer, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFAutoScanParams.elemInfoTable[0] = new ElemInfoTable("FileSpec", 0x3333333333L);
    }

    public static class EnumMounting
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumMounting Unfixed = new EnumMounting("Unfixed");
        public static final EnumMounting Fixed = new EnumMounting("Fixed");
        public static final EnumMounting Wet = new EnumMounting("Wet");
        public static final EnumMounting Registered = new EnumMounting("Registered");

        protected EnumMounting(String name) {
            super(name, m_startValue++);
        }

        public static EnumMounting getEnum(String enumName) {
            return (EnumMounting)EnumMounting.getEnum(EnumMounting.class, (String)enumName);
        }

        public static EnumMounting getEnum(int enumValue) {
            return (EnumMounting)EnumMounting.getEnum(EnumMounting.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumMounting.getEnumMap(EnumMounting.class);
        }

        public static List getEnumList() {
            return EnumMounting.getEnumList(EnumMounting.class);
        }

        public static Iterator iterator() {
            return EnumMounting.iterator(EnumMounting.class);
        }
    }

    public static class EnumCompressionFilter
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumCompressionFilter CCITTFaxEncode = new EnumCompressionFilter("CCITTFaxEncode");
        public static final EnumCompressionFilter DCTEncode = new EnumCompressionFilter("DCTEncode");
        public static final EnumCompressionFilter FlateEncode = new EnumCompressionFilter("FlateEncode");
        public static final EnumCompressionFilter WaveletEncode = new EnumCompressionFilter("WaveletEncode");
        public static final EnumCompressionFilter JBIG2Encode = new EnumCompressionFilter("JBIG2Encode");

        protected EnumCompressionFilter(String name) {
            super(name, m_startValue++);
        }

        public static EnumCompressionFilter getEnum(String enumName) {
            return (EnumCompressionFilter)EnumCompressionFilter.getEnum(EnumCompressionFilter.class, (String)enumName);
        }

        public static EnumCompressionFilter getEnum(int enumValue) {
            return (EnumCompressionFilter)EnumCompressionFilter.getEnum(EnumCompressionFilter.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumCompressionFilter.getEnumMap(EnumCompressionFilter.class);
        }

        public static List getEnumList() {
            return EnumCompressionFilter.getEnumList(EnumCompressionFilter.class);
        }

        public static Iterator iterator() {
            return EnumCompressionFilter.iterator(EnumCompressionFilter.class);
        }
    }

    public static class EnumOutputColorSpace
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumOutputColorSpace LAB = new EnumOutputColorSpace("LAB");
        public static final EnumOutputColorSpace RGB = new EnumOutputColorSpace("RGB");
        public static final EnumOutputColorSpace CMYK = new EnumOutputColorSpace("CMYK");
        public static final EnumOutputColorSpace GrayScale = new EnumOutputColorSpace("GrayScale");

        protected EnumOutputColorSpace(String name) {
            super(name, m_startValue++);
        }

        public static EnumOutputColorSpace getEnum(String enumName) {
            return (EnumOutputColorSpace)EnumOutputColorSpace.getEnum(EnumOutputColorSpace.class, (String)enumName);
        }

        public static EnumOutputColorSpace getEnum(int enumValue) {
            return (EnumOutputColorSpace)EnumOutputColorSpace.getEnum(EnumOutputColorSpace.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumOutputColorSpace.getEnumMap(EnumOutputColorSpace.class);
        }

        public static List getEnumList() {
            return EnumOutputColorSpace.getEnumList(EnumOutputColorSpace.class);
        }

        public static Iterator iterator() {
            return EnumOutputColorSpace.iterator(EnumOutputColorSpace.class);
        }
    }
}

