/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.Collection;
import java.util.Vector;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.ifaces.IXJDFSplit;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.LinkInfo;
import org.cip4.jdflib.node.LinkInfoMap;
import org.cip4.jdflib.node.LinkValidatorMap;
import org.cip4.jdflib.util.StringUtil;

public abstract class AbstractXJDFSplit
implements IXJDFSplit {
    private static VString productResNames = new VString(new String[]{"CustomerInfo", "NodeInfo", "Contact"});

    @Override
    public abstract Collection<XJDFHelper> splitXJDF(XJDFHelper var1);

    @Deprecated
    protected void fixInOutLinks(XJDFHelper xjdf) {
        this.fixInOutLinks(xjdf, xjdf.getTypes());
    }

    protected void fixInOutLinks(XJDFHelper xjdf, VString allTypes) {
        Vector<SetHelper> sets;
        LinkInfoMap map = this.getLinkInfoMap(xjdf);
        if (map != null && (sets = xjdf.getSets()) != null) {
            VString types = xjdf.getTypes();
            for (SetHelper set : sets) {
                SetHelper set2 = this.matchesType(set, types, allTypes);
                this.fixInOutLink(set2, map);
            }
        }
    }

    @Deprecated
    protected SetHelper matchesType(SetHelper set, VString types) {
        return this.matchesType(set, types, types);
    }

    protected SetHelper matchesType(SetHelper set, VString types, VString allTypes) {
        if (set != null && types != null) {
            set = this.checkProcessUsage(set, types);
            set = this.checkCPI(set, types, allTypes);
            set = this.checkProduct(set, types);
        }
        return set;
    }

    protected SetHelper checkProduct(SetHelper set, VString types) {
        String name;
        if (set != null && types.contains("Product") && ((name = set.getName()) == null || !this.getProductResources().contains(name))) {
            set.deleteNode();
            set = null;
        }
        return set;
    }

    protected VString getProductResources() {
        return productResNames;
    }

    protected SetHelper checkProcessUsage(SetHelper set, VString types) {
        String processUsage = set.getProcessUsage();
        if (processUsage != null) {
            if ("EndCustomer".equals(processUsage) && types.contains("Product")) {
                processUsage = "Product";
                set = null;
            } else if (JDFNode.EnumType.getEnum(processUsage) != null) {
                if (!types.contains(processUsage)) {
                    set.deleteNode();
                }
                set = null;
            }
        }
        return set;
    }

    protected SetHelper checkCPI(SetHelper set, VString types, VString allTypes) {
        JDFIntegerList cpi;
        if (set != null && allTypes != null && (cpi = set.getCombinedProcessIndex()) != null) {
            boolean ok = false;
            for (int i = 0; i < cpi.size(); ++i) {
                int pos = cpi.getInt(i);
                String proc = allTypes.get(pos);
                if (proc == null || !types.contains(proc)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                set.deleteNode();
                set = null;
            }
        }
        return set;
    }

    protected LinkInfoMap getLinkInfoMap(XJDFHelper xjdf) {
        JDFNode.EnumType typ = xjdf.getType();
        VString types = JDFNode.EnumType.ProcessGroup.equals((Object)typ) ? xjdf.getTypes() : null;
        LinkInfoMap map = LinkValidatorMap.getLinkValidatorMap().getLinkInfoMap(typ, types);
        return map;
    }

    protected void fixInOutLink(SetHelper set, LinkInfoMap map) {
        if (map == null || set == null) {
            return;
        }
        String name = this.getName(set);
        LinkInfo li = map.getStar(name, true);
        if (li == null) {
            set.setUsage(null);
        } else {
            this.fixUsage(set, li);
            this.fixCPI(set, li);
        }
    }

    protected String getName(SetHelper set) {
        String name = set.getName();
        if ("Color".equals(name)) {
            name = "ColorPool";
        } else if ("Content".equals(name)) {
            name = "PageList";
        }
        return name;
    }

    protected void fixCPI(SetHelper set, LinkInfo li) {
        set.removeAttribute("CombinedProcessIndex", null);
    }

    protected void fixUsage(SetHelper set, LinkInfo li) {
        String processUsage;
        JDFResourceLink.EnumUsage usage = set.getUsage();
        if (!li.isValidLink(usage, processUsage = set.getProcessUsage(), 1)) {
            if (usage == null || !li.isValidLink(usage.invert(), processUsage, 1)) {
                set.deleteNode();
            } else if (usage != null) {
                set.setUsage(usage.invert());
            }
        } else if (usage == null) {
            boolean outReq;
            boolean inReq;
            usage = li.getUsage(processUsage);
            if (usage == null) {
                usage = li.getUsage(null);
            }
            if (usage == null && (inReq = li.isRequired(JDFResourceLink.EnumUsage.Input)) ^ (outReq = li.isRequired(JDFResourceLink.EnumUsage.Output))) {
                usage = inReq ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output;
            }
            set.setUsage(usage);
        }
    }

    protected void consolidateExchangeResources(Vector<XJDFHelper> v) {
        if (v == null || v.size() < 2) {
            return;
        }
        for (int i = 1; i < v.size(); ++i) {
            XJDFHelper h0 = v.get(i - 1);
            XJDFHelper h1 = v.get(i);
            Vector<SetHelper> sets0 = h0.getSets(null, JDFResourceLink.EnumUsage.Output);
            Vector<SetHelper> sets1 = h1.getSets(null, JDFResourceLink.EnumUsage.Output);
            if (sets0 == null || sets1 == null) continue;
            for (SetHelper set0 : sets0) {
                for (SetHelper set1 : sets1) {
                    if (!set0.isEqual(set1)) continue;
                    this.consolidateExchangeResource(h0, set0, h1, set1);
                }
            }
        }
    }

    protected void consolidateExchangeResource(XJDFHelper h0, SetHelper set0, XJDFHelper h1, SetHelper set1) {
        String newID = "ID_Ex_" + StringUtil.setvString(h0.getTypes(), "_", null, null);
        SetHelper set0Out = h0.appendSet(set0.getFamily().name(), this.getName(set0), JDFResourceLink.EnumUsage.Output);
        set0Out.setID(newID);
        set0.deleteNode();
        SetHelper newSet = new SetHelper(h1.getRoot().copyElement(set0Out.getRoot(), null));
        newSet.setUsage(JDFResourceLink.EnumUsage.Input);
    }
}

