/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.ArrayList;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFResponse;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.StatusCounter;

public class MultiModuleStatusCounter {
    private final ArrayList<StatusCounter> counters = new ArrayList();
    private StatusCounter deviceCounter;

    public MultiModuleStatusCounter() {
        this(null);
    }

    public MultiModuleStatusCounter(StatusCounter deviceCounter) {
        this.deviceCounter = deviceCounter;
    }

    public synchronized void addModule(StatusCounter sc) {
        if (sc != null) {
            if (this.deviceCounter == null) {
                this.deviceCounter = sc;
            } else {
                this.counters.add(sc);
            }
        }
    }

    public synchronized void removeModule(StatusCounter sc) {
        if (sc != null) {
            this.counters.remove(sc);
            if (this.counters.isEmpty()) {
                this.deviceCounter.setActiveNode(null, null, null);
            }
        }
    }

    public JDFDoc getStatusResponse() {
        if (this.counters.isEmpty() && this.deviceCounter == null) {
            return null;
        }
        JDFDoc d = this.deviceCounter.getDocJMFPhaseTime().clone();
        JDFJMF jmf = d.getJMFRoot();
        int maxresp = this.getNumResponses();
        JDFResponse response = jmf.getResponse(0);
        for (int i = 0; i < maxresp; ++i) {
            response = this.copyResponse(jmf, response, i);
        }
        return d;
    }

    synchronized JDFResponse copyResponse(JDFJMF jmf, JDFResponse response, int i) {
        if (i > 0) {
            response = this.copyResponse(jmf, response);
        }
        JDFDeviceInfo di = response.getDeviceInfo(0);
        for (StatusCounter counter : this.counters) {
            this.copyPhaseTime(i, di, counter);
        }
        return response;
    }

    void copyPhaseTime(int i, JDFDeviceInfo di, StatusCounter counter) {
        JDFJMF jmfRoot;
        int nResp;
        JDFDoc docJMFPhaseTime = counter.getDocJMFPhaseTime();
        if (docJMFPhaseTime != null && (nResp = (jmfRoot = docJMFPhaseTime.getJMFRoot()).numChildElements("Response", null)) > 0) {
            JDFDeviceInfo di2 = jmfRoot.getResponse(Math.min(i, nResp - 1)).getDeviceInfo(0);
            VElement phases = di2.getChildElementVector("JobPhase", null, null, true, -1, false);
            for (int j = 0; j < phases.size(); ++j) {
                di.copyElement(phases.elementAt(j), null);
            }
            di.setDeviceStatus(this.getDeviceStatus());
            di.setStatusDetails(this.getStatusDetails());
            di.removeAttribute("IdleStartTime");
        }
    }

    JDFResponse copyResponse(JDFJMF jmf, JDFResponse response) {
        JDFResponse response2 = jmf.appendResponse();
        response2.setAttributes(response);
        JDFDeviceInfo di2 = response2.appendDeviceInfo();
        di2.setAttributes(response.getDeviceInfo(0));
        response2.setID(KElement.uniqueID(0));
        response = response2;
        return response;
    }

    synchronized int getNumResponses() {
        int maxresp = 0;
        for (StatusCounter counter : this.counters) {
            JDFDoc docJMFPhaseTime = counter.getDocJMFPhaseTime();
            if (docJMFPhaseTime == null) continue;
            JDFJMF jmfRoot = docJMFPhaseTime.getJMFRoot();
            int nResp = jmfRoot.numChildElements("Response", null);
            maxresp = Math.max(maxresp, nResp);
        }
        return maxresp;
    }

    String getStatusDetails() {
        StatusCounter maxModule = this.getMaxModule();
        return maxModule == null ? JDFAutoDeviceInfo.EnumDeviceStatus.Idle.getName() : maxModule.getStatusDetails();
    }

    public int size() {
        return this.counters.size();
    }

    public JDFAutoDeviceInfo.EnumDeviceStatus getDeviceStatus() {
        StatusCounter maxModule = this.getMaxModule();
        return maxModule == null ? JDFAutoDeviceInfo.EnumDeviceStatus.Idle : maxModule.getStatus();
    }

    public synchronized StatusCounter getMaxModule() {
        JDFAutoDeviceInfo.EnumDeviceStatus maxStatus = JDFAutoDeviceInfo.EnumDeviceStatus.Idle;
        StatusCounter ret = this.deviceCounter;
        for (StatusCounter counter : this.counters) {
            if (maxStatus.getValue() >= EnumUtil.getValue(counter.getStatus())) continue;
            maxStatus = counter.getStatus();
            ret = counter;
        }
        return ret;
    }

    public StatusCounter getDeviceCounter() {
        return this.deviceCounter;
    }

    public String toString() {
        return "MultiModuleStatusCounter [counters=" + this.getJobIDS() + ", deviceCounter=" + this.deviceCounter.shortString() + "]";
    }

    public StringArray getJobIDS() {
        StringArray b = new StringArray();
        for (StatusCounter c : this.counters) {
            b.add(c.getJobID());
        }
        return b;
    }
}

