/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.MyPair;
import org.cip4.jdflib.util.RollingBackupFile;
import org.cip4.jdflib.util.ThreadUtil;
import org.cip4.jdflib.util.file.FileSorter;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.hotfolder.StorageHotFolder;
import org.cip4.jdflib.util.thread.MultiTaskQueue;

class StorageHotFolderListener
implements HotFolderListener {
    private final File storage;
    private File errorStorage;
    private File okStorage;
    final StorageHotFolder parent;
    private static final Log log = LogFactory.getLog(StorageHotFolderListener.class);
    private final AtomicInteger nHotOK = new AtomicInteger();
    private final AtomicInteger nHotError = new AtomicInteger();
    private final AtomicInteger nQueued = new AtomicInteger();
    private int maxStore;
    HotFolderListener theListener;
    private int maxAux;

    StorageHotFolderListener(File storageDir, HotFolderListener hfListener, StorageHotFolder parent) {
        this.setMaxStore(42);
        if (hfListener == null) {
            log.error((Object)"hfListner MUST NOT be null");
            throw new IllegalArgumentException("hfListner MUST NOT be null");
        }
        this.theListener = hfListener;
        this.storage = storageDir;
        this.parent = parent;
        this.errorStorage = new File(parent.getHfDirectory(), "error");
        this.okStorage = new File(parent.getHfDirectory(), "ok");
    }

    void setOKStorage(File ok) {
        this.okStorage = ok;
        if (ok != null) {
            this.okStorage.mkdirs();
            this.okStorage.setWritable(true);
            if (!this.okStorage.isDirectory()) {
                log.error((Object)("OK Directory is not a directory: " + this.okStorage.getAbsolutePath()));
            }
        }
    }

    void setErrorStorage(File error) {
        this.errorStorage = error;
        if (error != null) {
            this.errorStorage.mkdirs();
            this.errorStorage.setWritable(true);
            if (!this.errorStorage.isDirectory()) {
                log.error((Object)("Error Directory is not a directory: " + this.errorStorage.getAbsolutePath()));
            }
        }
    }

    @Override
    public boolean hotFile(File hotFile) {
        DelayedRunner runner = new DelayedRunner(hotFile);
        if (this.parent.isSynchronous()) {
            runner.run();
            return runner.ok;
        }
        MultiTaskQueue.getCreateQueue("DelayedRunner", this.parent.getMaxConcurrent()).queue(runner);
        return true;
    }

    void copyCompleted(File storedFile, boolean bOK, Throwable t) {
        File auxFile = this.parent.isProcessAux() ? FileUtil.getAuxDir(storedFile) : null;
        File current = bOK ? this.okStorage : this.errorStorage;
        File dest = new File(current, storedFile.getName());
        RollingBackupFile roller = new RollingBackupFile(dest, 10);
        roller.setWantExtension(true);
        roller.getNewFile();
        File copied = FileUtil.moveFileToDir(storedFile, current);
        if (copied == null) {
            this.handleBad(storedFile, bOK);
        } else {
            log.info((Object)("Copied file: " + storedFile.getName() + " to " + current));
            copied.setLastModified(System.currentTimeMillis());
            if (auxFile != null) {
                File auxbackup = new File(current, auxFile.getName());
                RollingBackupFile rollingBackupFile = new RollingBackupFile(auxbackup, 10);
                rollingBackupFile.setWantExtension(true);
                rollingBackupFile.getNewFile();
                File movedAux = FileUtil.moveFileToDir(auxFile, current);
                if (movedAux != null) {
                    log.info((Object)("Copied aux dir: " + auxFile.getName() + " to " + movedAux));
                } else {
                    log.warn((Object)("Could not copy aux dir: " + auxFile.getName() + " to " + this.okStorage));
                }
            }
            if (t != null) {
                File except = new File(copied.getPath() + ".error.txt");
                FileUtil.dumpException(except, t);
            }
        }
        this.cleanup(bOK);
    }

    protected boolean handleBad(File storedFile, boolean bOK) {
        if (bOK) {
            log.warn((Object)("could not move ok " + storedFile + " to " + this.okStorage.getAbsolutePath()));
        } else {
            log.warn((Object)("could not move error " + storedFile + " to " + this.errorStorage.getAbsolutePath()));
        }
        File auxFile = this.parent.isProcessAux() ? null : FileUtil.getAuxDir(storedFile);
        FileUtil.deleteAll(auxFile);
        boolean bZapp = storedFile.delete();
        if (bZapp) {
            log.warn((Object)("utterly removed hot file: " + storedFile));
        } else {
            log.error((Object)("cannot delete hot file: " + storedFile));
        }
        return bZapp;
    }

    void cleanup(boolean bOK) {
        int check;
        int nHot = bOK ? this.nHotOK.incrementAndGet() : this.nHotError.incrementAndGet();
        if (nHot % (check = Math.max(1, this.maxAux / 4)) == 0 || Math.random() < 0.1) {
            FileSorter fs = new FileSorter(bOK ? this.okStorage : this.errorStorage);
            File[] list = fs.sortLastModified(true);
            ArrayList<File> vList = new ArrayList<File>();
            for (File f : list) {
                if (f.isDirectory()) continue;
                vList.add(f);
            }
            int i = 0;
            for (File hotFile : vList) {
                this.cleanupSingle(i++, hotFile);
            }
        }
    }

    void cleanupSingle(int i, File hotFile) {
        File aux;
        boolean ok;
        if (i > this.maxStore && !(ok = FileUtil.forceDelete(hotFile))) {
            log.warn((Object)("failed to delete temporary file " + hotFile.getAbsolutePath()));
        }
        File file = aux = this.parent.isProcessAux() && (i > this.maxStore || i > this.maxAux) ? FileUtil.getAuxDir(hotFile) : null;
        if (aux != null) {
            boolean ok2 = FileUtil.deleteAll(aux);
            if (ok2) {
                log.info((Object)("deleted temporary aux directory " + aux.getAbsolutePath()));
            } else {
                log.warn((Object)("failed to delete temporary aux directory " + aux.getAbsolutePath()));
            }
        }
    }

    MyPair<File, File> getStoredFile(File hotFile) {
        if (hotFile == null) {
            log.error((Object)("invalid hot file: " + hotFile));
            return null;
        }
        String name = hotFile.getName();
        File tmpDir = this.getTmpDir();
        File newAbsoluteFile = new File(tmpDir, name);
        boolean ok = false;
        for (int i = 0; !ok && i < this.parent.getRetry(); ++i) {
            ok = FileUtil.moveFile(hotFile, newAbsoluteFile);
            if (ok) continue;
            log.warn((Object)("retry " + i + " moving file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
            if (!hotFile.exists() || !hotFile.canRead()) {
                log.error((Object)("file disappeared while waiting: " + hotFile.getAbsolutePath()));
                return null;
            }
            if (ThreadUtil.sleep((i + 2) * this.parent.getStabilizeTime())) continue;
            log.error((Object)("Interrupted while waiting to move file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
            return null;
        }
        if (ok) {
            log.info((Object)("moving file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
            this.processAux(hotFile, tmpDir);
        } else {
            log.error((Object)("cannot move file from: " + hotFile.getAbsolutePath() + " to " + newAbsoluteFile.getAbsolutePath()));
        }
        return ok ? new MyPair<File, File>(newAbsoluteFile, tmpDir) : null;
    }

    void processAux(File hotFile, File tmpDir) {
        File aux;
        File file = aux = this.parent.isProcessAux() ? FileUtil.getAuxDir(hotFile) : null;
        if (aux != null) {
            File newaux = FileUtil.getFileInDirectory(tmpDir, new File(aux.getName()));
            FileUtil.moveFile(aux, newaux);
            log.info((Object)("moving aux file " + aux + " to " + tmpDir));
            int i = 1;
            while (true) {
                File moved;
                if ((moved = FileUtil.moveFileToDir(newaux, tmpDir)) != null) {
                    log.info((Object)("moved aux dir " + aux + " to " + moved));
                    break;
                }
                log.warn((Object)("could not move aux dir " + aux + " to " + tmpDir + " #" + i));
                if (i == 3 || !ThreadUtil.sleep(4242 * i)) break;
                ++i;
            }
        }
    }

    private synchronized File getTmpDir() {
        return FileUtil.getFileInDirectory(this.storage, new File("tmp." + this.nQueued.incrementAndGet()));
    }

    void setMaxStore(int maxStore) {
        this.maxStore = maxStore;
        this.maxAux = maxStore;
    }

    public void setMaxAux(int maxAuxDirs) {
        this.maxAux = maxAuxDirs;
    }

    public String toString() {
        return "StorageHotFolderListener [" + (String)(this.storage != null ? "storage=" + this.storage + ", " : "") + (String)(this.errorStorage != null ? "errorStorage=" + this.errorStorage + ", " : "") + (String)(this.okStorage != null ? "okStorage=" + this.okStorage + ", " : "") + (String)(this.parent != null ? "parent=" + this.parent + ", " : "") + "nHotOK=" + this.nHotOK + ", nHotError=" + this.nHotError + ", nQueued=" + this.nQueued + ", maxStore=" + this.maxStore + ", maxAux=" + this.maxAux + "]";
    }

    class DelayedRunner
    implements Runnable {
        boolean ok;
        final File hotFile;

        public DelayedRunner(File hotFile) {
            this.hotFile = hotFile;
            this.ok = false;
        }

        public String toString() {
            return "DelayedRunner [hotFile=" + this.hotFile + ", ok=" + this.ok + "]";
        }

        @Override
        public void run() {
            log.info((Object)("processing hot file: " + this.hotFile + " #" + StorageHotFolderListener.this.nQueued.get()));
            MyPair<File, File> storedFiles = StorageHotFolderListener.this.getStoredFile(this.hotFile);
            if (storedFiles == null) {
                StorageHotFolderListener.this.copyCompleted(this.hotFile, false, new FileNotFoundException("snafu retrieving file " + this.hotFile.getAbsolutePath()));
                this.ok = false;
            } else {
                boolean deleted;
                Throwable t0 = null;
                try {
                    this.ok = StorageHotFolderListener.this.theListener.hotFile(storedFiles.getA());
                }
                catch (Throwable t) {
                    log.error((Object)("Could not process " + this.hotFile), t);
                    t0 = t;
                }
                StorageHotFolderListener.this.copyCompleted(storedFiles.getA(), this.ok, t0);
                if (StorageHotFolderListener.this.nQueued.get() % 100 == 0) {
                    log.info((Object)("deleting tmp file: " + storedFiles.getB()));
                }
                if (!(deleted = FileUtil.deleteAll(storedFiles.getB()))) {
                    log.warn((Object)("Problems deleting: " + storedFiles.getB()));
                }
            }
        }
    }
}

