/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFGeneralID;

public abstract class JDFAutoPreview
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[7];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoPreview(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoPreview(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoPreview(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Parameter);
        return bRet;
    }

    public void setPreviewFileType(String value) {
        this.setAttribute("PreviewFileType", value, null);
    }

    public String getPreviewFileType() {
        return this.getAttribute("PreviewFileType", null, "PNG");
    }

    public void setPreviewUsage(EnumPreviewUsage enumVar) {
        this.setAttribute("PreviewUsage", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumPreviewUsage getPreviewUsage() {
        return EnumPreviewUsage.getEnum(this.getAttribute("PreviewUsage", null, "Separation"));
    }

    public void setURL(String value) {
        this.setAttribute("URL", value, null);
    }

    public String getURL() {
        return this.getAttribute("URL", null, "");
    }

    public void setCompensation(EnumCompensation enumVar) {
        this.setAttribute("Compensation", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumCompensation getCompensation() {
        return EnumCompensation.getEnum(this.getAttribute("Compensation", null, null));
    }

    public void setCTM(JDFMatrix value) {
        this.setAttribute("CTM", (JDFNumList)value, (String)null);
    }

    public JDFMatrix getCTM() {
        String strAttrName = this.getAttribute("CTM", null, null);
        JDFMatrix nPlaceHolder = JDFMatrix.createMatrix(strAttrName);
        return nPlaceHolder;
    }

    public void setDirectory(String value) {
        this.setAttribute("Directory", value, null);
    }

    public String getDirectory() {
        return this.getAttribute("Directory", null, "");
    }

    public void setMimeTypeDetails(String value) {
        this.setAttribute("MimeTypeDetails", value, null);
    }

    public String getMimeTypeDetails() {
        return this.getAttribute("MimeTypeDetails", null, "");
    }

    public JDFComment getComment() {
        return (JDFComment)this.getElement("Comment", null, 0);
    }

    public JDFComment getCreateComment() {
        return (JDFComment)this.getCreateElement_JDFElement("Comment", null, 0);
    }

    @Override
    public JDFComment getCreateComment(int iSkip) {
        return (JDFComment)this.getCreateElement_JDFElement("Comment", null, iSkip);
    }

    @Override
    public JDFComment getComment(int iSkip) {
        return (JDFComment)this.getElement("Comment", null, iSkip);
    }

    public Collection<JDFComment> getAllComment() {
        return this.getChildArrayByClass(JDFComment.class, false, 0);
    }

    @Override
    public JDFComment appendComment() {
        return (JDFComment)this.appendElement("Comment", null);
    }

    public JDFGeneralID getGeneralID() {
        return (JDFGeneralID)this.getElement("GeneralID", null, 0);
    }

    public JDFGeneralID getCreateGeneralID() {
        return (JDFGeneralID)this.getCreateElement_JDFElement("GeneralID", null, 0);
    }

    public JDFGeneralID getCreateGeneralID(int iSkip) {
        return (JDFGeneralID)this.getCreateElement_JDFElement("GeneralID", null, iSkip);
    }

    @Override
    public JDFGeneralID getGeneralID(int iSkip) {
        return (JDFGeneralID)this.getElement("GeneralID", null, iSkip);
    }

    public Collection<JDFGeneralID> getAllGeneralID() {
        return this.getChildArrayByClass(JDFGeneralID.class, false, 0);
    }

    @Override
    public JDFGeneralID appendGeneralID() {
        return (JDFGeneralID)this.appendElement("GeneralID", null);
    }

    static {
        JDFAutoPreview.atrInfoTable[0] = new AtrInfoTable("PreviewFileType", 0x3333333333L, AttributeInfo.EnumAttributeType.string, null, "PNG");
        JDFAutoPreview.atrInfoTable[1] = new AtrInfoTable("PreviewUsage", 0x3333333333L, AttributeInfo.EnumAttributeType.enumeration, EnumPreviewUsage.getEnum(0), "Separation");
        JDFAutoPreview.atrInfoTable[2] = new AtrInfoTable("URL", 0x3333333333L, AttributeInfo.EnumAttributeType.URL, null, null);
        JDFAutoPreview.atrInfoTable[3] = new AtrInfoTable("Compensation", 0x3333333333L, AttributeInfo.EnumAttributeType.enumeration, EnumCompensation.getEnum(0), null);
        JDFAutoPreview.atrInfoTable[4] = new AtrInfoTable("CTM", 0x3333333333L, AttributeInfo.EnumAttributeType.matrix, null, null);
        JDFAutoPreview.atrInfoTable[5] = new AtrInfoTable("Directory", 0x3333333333L, AttributeInfo.EnumAttributeType.URL, null, null);
        JDFAutoPreview.atrInfoTable[6] = new AtrInfoTable("MimeTypeDetails", 0x3333333333L, AttributeInfo.EnumAttributeType.string, null, null);
        elemInfoTable = new ElemInfoTable[2];
        JDFAutoPreview.elemInfoTable[0] = new ElemInfoTable("Comment", 0x3333333333L);
        JDFAutoPreview.elemInfoTable[1] = new ElemInfoTable("GeneralID", 0x3333333333L);
    }

    public static class EnumCompensation
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumCompensation Unknown = new EnumCompensation("Unknown");
        public static final EnumCompensation None = new EnumCompensation("None");
        public static final EnumCompensation Film = new EnumCompensation("Film");
        public static final EnumCompensation Plate = new EnumCompensation("Plate");
        public static final EnumCompensation Press = new EnumCompensation("Press");

        protected EnumCompensation(String name) {
            super(name, m_startValue++);
        }

        public static EnumCompensation getEnum(String enumName) {
            return (EnumCompensation)EnumCompensation.getEnum(EnumCompensation.class, (String)enumName);
        }

        public static EnumCompensation getEnum(int enumValue) {
            return (EnumCompensation)EnumCompensation.getEnum(EnumCompensation.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumCompensation.getEnumMap(EnumCompensation.class);
        }

        public static List getEnumList() {
            return EnumCompensation.getEnumList(EnumCompensation.class);
        }

        public static Iterator iterator() {
            return EnumCompensation.iterator(EnumCompensation.class);
        }
    }

    public static class EnumPreviewUsage
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPreviewUsage Animation = new EnumPreviewUsage("Animation");
        public static final EnumPreviewUsage Identification = new EnumPreviewUsage("Identification");
        public static final EnumPreviewUsage Separation = new EnumPreviewUsage("Separation");
        public static final EnumPreviewUsage SeparatedThumbNail = new EnumPreviewUsage("SeparatedThumbNail");
        public static final EnumPreviewUsage SeparationRaw = new EnumPreviewUsage("SeparationRaw");
        public static final EnumPreviewUsage ThumbNail = new EnumPreviewUsage("ThumbNail");
        public static final EnumPreviewUsage Static3D = new EnumPreviewUsage("Static3D");
        public static final EnumPreviewUsage Viewable = new EnumPreviewUsage("Viewable");

        protected EnumPreviewUsage(String name) {
            super(name, m_startValue++);
        }

        public static EnumPreviewUsage getEnum(String enumName) {
            return (EnumPreviewUsage)EnumPreviewUsage.getEnum(EnumPreviewUsage.class, (String)enumName);
        }

        public static EnumPreviewUsage getEnum(int enumValue) {
            return (EnumPreviewUsage)EnumPreviewUsage.getEnum(EnumPreviewUsage.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumPreviewUsage.getEnumMap(EnumPreviewUsage.class);
        }

        public static List getEnumList() {
            return EnumPreviewUsage.getEnumList(EnumPreviewUsage.class);
        }

        public static Iterator iterator() {
            return EnumPreviewUsage.iterator(EnumPreviewUsage.class);
        }
    }
}

