/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ParentNode;
import org.cip4.jdflib.core.DocumentData;
import org.cip4.jdflib.core.DocumentXMLImpl;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDocUserData;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.thread.MyMutex;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentJDFImpl
extends DocumentXMLImpl {
    static final String CORE_KELEMENT = "org.cip4.jdflib.core.KElement";
    static final String CORE_JDFELEMENT = "org.cip4.jdflib.core.JDFElement";
    static final String CORE_JDFRESOURCE = "org.cip4.jdflib.resource.JDFResource";
    private static DocumentData data = new DocumentData();
    private static final long serialVersionUID = 1L;
    private static boolean bStaticStrictNSCheck = true;
    static MyMutex mutex = new MyMutex();
    public boolean bKElementOnly = false;
    public boolean bInitOnCreate = true;
    private XMLDocUserData myXMLUserDat = new XMLDocUserData(this);
    private boolean bInJDFJMF = false;
    private Node m_ParentNode = null;
    private static final String jdfNSURIPrefix = StringUtil.leftStr(JDFElement.getSchemaURL(), -3);
    private static final String PRINTTALK = "PrintTalk";
    private static final String PRINTTALK_URI = "http://www.printtalk.org/schema_";

    public static boolean isStaticStrictNSCheck() {
        return bStaticStrictNSCheck;
    }

    public static void setStaticStrictNSCheck(boolean staticStrictNSCheck) {
        bStaticStrictNSCheck = staticStrictNSCheck;
    }

    @Override
    public DocumentJDFImpl clone() {
        DocumentJDFImpl clon = (DocumentJDFImpl)super.clone();
        clon.myXMLUserDat = new XMLDocUserData(clon);
        clon.bInitOnCreate = this.bInitOnCreate;
        clon.bKElementOnly = this.bKElementOnly;
        clon.m_Bodypart = this.m_Bodypart;
        clon.m_ZipReader = this.m_ZipReader;
        clon.m_OriginalFileName = this.m_OriginalFileName;
        return clon;
    }

    public static void registerCustomClass(String strElement, String packagepath) {
        data.registerCustomClass(strElement, packagepath);
    }

    @Override
    KElement factoryCreate(ParentNode parent, String qualifiedName) {
        this.setParentNode((Node)parent);
        return (KElement)this.createElement(qualifiedName);
    }

    @Override
    KElement factoryCreate(ParentNode parent, String namespaceURI, String qualifiedName) {
        this.setParentNode((Node)parent);
        return (KElement)this.createElementNS(namespaceURI, qualifiedName);
    }

    public static List<Class<?>> getClasses(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        new DocumentJDFImpl().fillAllClasses();
        for (Class<?> c : DocumentJDFImpl.data.sm_hashPathToClass.values()) {
            if (!clazz.isAssignableFrom(c)) continue;
            classes.add(c);
        }
        return classes;
    }

    void fillAllClasses() {
        this.bInJDFJMF = true;
        if (DocumentJDFImpl.data.sm_PackageNames.size() > DocumentJDFImpl.data.sm_hashPathToClass.size()) {
            for (String classPath : DocumentJDFImpl.data.sm_PackageNames.keySet()) {
                this.getFactoryClass(classPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName, String localPart) {
        Constructor<?> constructi;
        Class<?> classOfConstructor = null;
        if (this.bKElementOnly) {
            return new KElement((CoreDocumentImpl)this, namespaceURI, qualifiedName, localPart);
        }
        if (!this.bInJDFJMF) {
            if (namespaceURI != null) {
                this.bInJDFJMF = namespaceURI.startsWith(jdfNSURIPrefix);
            }
            this.bInJDFJMF = this.bInJDFJMF || "JDF".equals(localPart) || "XJDF".equals(localPart) || "XJMF".equals(localPart) || "JMF".equals(localPart) || PRINTTALK.equals(localPart);
        }
        HashMap<String, Constructor<?>> hashMap = DocumentJDFImpl.data.sm_hashCtorElementNS;
        synchronized (hashMap) {
            constructi = DocumentJDFImpl.data.sm_hashCtorElementNS.get(qualifiedName);
            String path = null;
            if (constructi == null) {
                path = this.getFactoryClassPath(namespaceURI, qualifiedName, localPart);
                if (path == null) {
                    path = this.getSpecialClassPath(namespaceURI, qualifiedName);
                }
                if (path != null) {
                    constructi = DocumentJDFImpl.data.sm_hashCtorElementNS.get(path);
                }
            }
            if (constructi == null) {
                try {
                    classOfConstructor = this.getFactoryClass(namespaceURI, qualifiedName, localPart, path);
                    if (classOfConstructor != null) {
                        Class[] constructorParameters = new Class[]{CoreDocumentImpl.class, String.class, String.class, String.class};
                        constructi = classOfConstructor.getDeclaredConstructor(constructorParameters);
                        this.putConstructorToHashMap(qualifiedName, constructi, path);
                    }
                }
                catch (ClassNotFoundException e) {
                    String message = "(DocumentJDFImpl.createElementNS) getFactoryClass() class " + e.getMessage() + " could not be created (surplus line in sm_PackageNames or non existing class ???)";
                    throw new DOMException(8, message);
                }
                catch (NoSuchMethodException e) {
                    Object message = "(DocumentJDFImpl.createElementNS) getDeclaredConstructor() not found: ";
                    if (classOfConstructor != null) {
                        message = (String)message + classOfConstructor.getName() + "(CoreDocumentImpl, String, String, String)";
                    }
                    throw new DOMException(8, (String)message);
                }
            }
        }
        Object[] constructorArguments = new Object[]{this, namespaceURI, qualifiedName, localPart};
        KElement newElement = this.createKElement(constructi, constructorArguments);
        return newElement == null ? new KElement((CoreDocumentImpl)this, namespaceURI, qualifiedName, localPart) : newElement;
    }

    private void putConstructorToHashMap(String qualifiedName, Constructor<?> constructi, String path) {
        String className = constructi.getDeclaringClass().getName();
        boolean bSpecialClass = this.isSpecialClass(qualifiedName, className);
        if (bSpecialClass) {
            DocumentJDFImpl.data.sm_hashCtorElementNS.put(qualifiedName, constructi);
        } else if (path != null) {
            DocumentJDFImpl.data.sm_hashCtorElementNS.put(path, constructi);
        }
    }

    private boolean isSpecialClass(String qualifiedName, String className) {
        return !DocumentJDFImpl.data.contextSensitive.contains(qualifiedName = KElement.xmlnsLocalName(qualifiedName)) && (className == null || !DocumentJDFImpl.data.contextSensitive.contains(className));
    }

    KElement createKElement(Constructor<?> constructi, Object[] constructorArguments) {
        try {
            return (KElement)constructi.newInstance(constructorArguments);
        }
        catch (Exception e) {
            LogFactory.getLog(DocumentJDFImpl.class).error((Object)" Exception caught :", (Throwable)e);
            return null;
        }
    }

    public Class<?> getFactoryClass(String qualifiedName) {
        try {
            return this.getFactoryClass(null, qualifiedName, qualifiedName, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getFactoryClass(String strNameSpaceURI, String qualifiedName, String localPart, String strClassPath) throws ClassNotFoundException {
        Class<?> packageNameClass = DocumentJDFImpl.data.sm_ClassAlreadyInstantiated.get(qualifiedName);
        if (packageNameClass == null) {
            HashMap<String, String> hashMap = DocumentJDFImpl.data.sm_PackageNames;
            synchronized (hashMap) {
                if (strClassPath == null) {
                    strClassPath = this.getFactoryClassPath(strNameSpaceURI, qualifiedName, localPart);
                }
                boolean normalElement = true;
                if (strClassPath == null) {
                    normalElement = false;
                    strClassPath = this.getSpecialClassPath(strNameSpaceURI, qualifiedName);
                } else {
                    normalElement = this.isSpecialClass(qualifiedName, strClassPath);
                }
                packageNameClass = DocumentJDFImpl.data.sm_hashPathToClass.get(strClassPath);
                if (packageNameClass == null) {
                    try {
                        packageNameClass = Class.forName(strClassPath);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException(e.getMessage(), e);
                    }
                    DocumentJDFImpl.data.sm_hashPathToClass.put(strClassPath, packageNameClass);
                }
                if (normalElement || strClassPath.equals(DocumentJDFImpl.data.sm_PackageNames.get("ResDefault"))) {
                    DocumentJDFImpl.data.sm_ClassAlreadyInstantiated.put(qualifiedName, packageNameClass);
                }
            }
        }
        return packageNameClass;
    }

    private String getFactoryClassPath(String strNameSpaceURI, String qualifiedName, String localPart) {
        if (!this.bInJDFJMF) {
            return CORE_KELEMENT;
        }
        String strClassPath = null;
        if (qualifiedName.endsWith("Link") && !"CreateLink".equals(qualifiedName) && !"RemoveLink".equals(qualifiedName)) {
            strClassPath = DocumentJDFImpl.data.sm_PackageNames.get("ResourceLink");
        } else if (qualifiedName.endsWith("Ref") && !qualifiedName.equals("TestRef")) {
            strClassPath = DocumentJDFImpl.data.sm_PackageNames.get("RefElement");
        } else {
            strClassPath = DocumentJDFImpl.data.sm_PackageNames.get(qualifiedName);
            if (strClassPath == null && (null == strNameSpaceURI || strNameSpaceURI != null && strNameSpaceURI.startsWith(jdfNSURIPrefix) || "".equals(strNameSpaceURI))) {
                strClassPath = DocumentJDFImpl.data.sm_PackageNames.get(localPart);
            }
        }
        return strClassPath;
    }

    private String getSpecialClassPath(String nameSpaceURI, String strName) {
        String strParentNodeClass = this.m_ParentNode == null ? null : this.m_ParentNode.getClass().getName();
        String strClassPath = !this.isSpecialClass(strName = KElement.xmlnsLocalName(strName), null) ? ("HoleType".equals(strName) ? this.getHoleTypeClass(strParentNodeClass) : ("Method".equals(strName) ? this.getMethodClass(strParentNodeClass) : ("Shape".equals(strName) ? this.getShapeClass(strParentNodeClass) : ("Surface".equals(strName) ? this.getSurfaceClass(strParentNodeClass) : ("Position".equals(strName) ? this.getPositionClass(strParentNodeClass) : (nameSpaceURI == null && this.bInJDFJMF || nameSpaceURI != null && nameSpaceURI.startsWith(jdfNSURIPrefix) ? DocumentJDFImpl.data.sm_PackageNames.get("EleDefault") : DocumentJDFImpl.data.sm_PackageNames.get("OtherNSDefault"))))))) : (this.isDeepResource(strName, nameSpaceURI) ? DocumentJDFImpl.data.sm_PackageNames.get("ResDefault") : (nameSpaceURI == null && this.bInJDFJMF || nameSpaceURI != null && nameSpaceURI.startsWith(jdfNSURIPrefix) ? DocumentJDFImpl.data.sm_PackageNames.get("EleDefault") : DocumentJDFImpl.data.sm_PackageNames.get("OtherNSDefault")));
        return strClassPath;
    }

    protected String getPositionClass(String strParentNodeClass) {
        String strClassPath = "org.cip4.jdflib.resource.JDFEmbossingItem".equals(strParentNodeClass) ? "org.cip4.jdflib.span.JDFXYPairSpan" : "org.cip4.jdflib.resource.process.JDFPosition";
        return strClassPath;
    }

    protected String getSurfaceClass(String strParentNodeClass) {
        String strClassPath = "org.cip4.jdflib.resource.intent.JDFLaminatingIntent".equals(strParentNodeClass) ? "org.cip4.jdflib.span.JDFSpanSurface" : "org.cip4.jdflib.resource.process.JDFLayout";
        return strClassPath;
    }

    protected String getShapeClass(String strParentNodeClass) {
        String strClassPath = "org.cip4.jdflib.resource.intent.JDFBookCase".equals(strParentNodeClass) ? "org.cip4.jdflib.span.JDFSpanShape" : "org.cip4.jdflib.resource.JDFShapeElement";
        return strClassPath;
    }

    protected String getMethodClass(String strParentNodeClass) {
        String strClassPath = "org.cip4.jdflib.resource.intent.JDFInsertingIntent".equals(strParentNodeClass) || "org.cip4.jdflib.resource.JDFInsert".equals(strParentNodeClass) ? "org.cip4.jdflib.span.JDFSpanMethod" : "org.cip4.jdflib.span.JDFNameSpan";
        return strClassPath;
    }

    protected String getHoleTypeClass(String strParentNodeClass) {
        String simple = StringUtil.token(strParentNodeClass, -1, ".");
        String strClassPath = "JDFRingBinding".equals(simple) || "JDFCoilBinding".equals(simple) ? "org.cip4.jdflib.span.JDFSpanHoleType" : "org.cip4.jdflib.span.JDFStringSpan";
        return strClassPath;
    }

    @Override
    public String toString() {
        Element rootElement = this.getDocumentElement();
        if (rootElement != null) {
            return super.toString() + rootElement.toString();
        }
        return super.toString();
    }

    public void setParentNode(Node node) {
        this.m_ParentNode = node;
    }

    private boolean isDeepResource(String strName, String nameSpaceURI) {
        if (this.m_ParentNode == null) {
            return false;
        }
        if (this.m_ParentNode instanceof JDFResourcePool) {
            return true;
        }
        if (this.m_ParentNode instanceof JDFResourceInfo) {
            return true;
        }
        if (this.m_ParentNode instanceof JDFResource) {
            return this.m_ParentNode.getLocalName().equals(strName);
        }
        return false;
    }

    protected XMLDocUserData getXMLDocUserData() {
        return (XMLDocUserData)this.getUserData();
    }

    public Node removeChild(Node arg0) throws DOMException {
        XMLDocUserData ud = this.getXMLDocUserData();
        if (ud != null) {
            ud.clearTargets();
        }
        return super.removeChild(arg0);
    }

    public Node replaceChild(Node arg0, Node arg1) throws DOMException {
        XMLDocUserData ud = this.getXMLDocUserData();
        if (ud != null) {
            ud.clearTargets();
        }
        return super.replaceChild(arg0, arg1);
    }

    public XMLDocUserData getMyUserData() {
        return this.myXMLUserDat;
    }
}

