/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFRGBColor;

public class JDFCMYKColor
extends JDFNumList {
    private static final long serialVersionUID = 1L;

    public JDFCMYKColor() {
        super(4);
    }

    @Deprecated
    public JDFCMYKColor(Vector v) throws DataFormatException {
        super(v);
    }

    public JDFCMYKColor(String s) throws DataFormatException {
        super(s);
    }

    public static JDFCMYKColor createCMYKColor(String s) {
        if (s != null && s.length() >= 7) {
            try {
                return new JDFCMYKColor(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFCMYKColor(JDFNumList nl) throws DataFormatException {
        super(nl);
    }

    public JDFCMYKColor(double c, double m, double y, double k) {
        super(4);
        this.set(0, Double.valueOf(c));
        this.set(1, Double.valueOf(m));
        this.set(2, Double.valueOf(y));
        this.set(3, Double.valueOf(k));
    }

    public JDFCMYKColor(double[] cmykArray) {
        this(cmykArray[0], cmykArray[1], cmykArray[2], cmykArray[3]);
    }

    @Override
    public boolean isValid() throws DataFormatException {
        if (this.size() != 4) {
            throw new DataFormatException("Data format exception!");
        }
        for (Object o : this) {
            if (o instanceof Double) continue;
            throw new DataFormatException("Data format exception!");
        }
        return true;
    }

    public double getC() {
        return this.doubleAt(0);
    }

    public void setC(double c) {
        this.set(0, c);
    }

    public double getM() {
        return this.doubleAt(1);
    }

    public void setM(double m) {
        this.set(1, m);
    }

    public double getY() {
        return this.doubleAt(2);
    }

    public void setY(double y) {
        this.set(2, y);
    }

    public double getK() {
        return this.doubleAt(3);
    }

    public void setK(double k) {
        this.set(3, k);
    }

    public JDFRGBColor getRGB() {
        JDFRGBColor rgb = new JDFRGBColor(JDFCMYKColor.getRGBArray(this.getC(), this.getM(), this.getY(), this.getK()));
        return rgb;
    }

    public static double[] getRGBArray(double c, double m, double y, double k) {
        double[] rgb = new double[3];
        double colors = 1.0 - k;
        rgb[0] = colors * (1.0 - c);
        rgb[1] = colors * (1.0 - m);
        rgb[2] = colors * (1.0 - y);
        return rgb;
    }

    public void setNamedColor(String name) {
        for (int i = 0; i < 4; ++i) {
            this.set(i, 0.0);
        }
        if ("Black".equalsIgnoreCase(name)) {
            this.setK(1.0);
        }
        if ("Cyan".equalsIgnoreCase(name)) {
            this.setC(1.0);
        }
        if ("Magenta".equalsIgnoreCase(name)) {
            this.setM(1.0);
        }
        if ("Yellow".equalsIgnoreCase(name)) {
            this.setY(1.0);
        }
    }
}

