/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.extensions.XJDFEnums;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFSubElement;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.resource.JDFModuleStatus;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.StringUtil;

public class WalkModuleStatus
extends WalkJDFSubElement {
    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll();
    }

    @Override
    public VString getElementNames() {
        return new VString("ModuleStatus", null);
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        String deviceStatus;
        super.updateAttributes(map);
        map.remove("ModuleType");
        String id = map.remove("ModuleIndex");
        if (id != null && map.get("ModuleID") == null) {
            map.put("ModuleID", StringUtil.token(id, 0, null));
        }
        if ("Running".equals(deviceStatus = map.remove("DeviceStatus"))) {
            deviceStatus = XJDFEnums.eDeviceStatus.Production.name();
        }
        map.putNotNull("Status", deviceStatus);
        map.remove("CombinedProcessIndex");
    }

    @Override
    protected String getXJDFName(KElement jdf) {
        return "ModuleInfo";
    }

    public KElement walkOld(KElement jdf, KElement xjdf) {
        boolean needCopy;
        boolean parentIdle;
        if (xjdf instanceof JDFJobPhase) {
            JDFElement.EnumNodeStatus ns = ((JDFJobPhase)xjdf).getStatus();
            parentIdle = !JDFElement.EnumNodeStatus.InProgress.equals((Object)ns) && !JDFElement.EnumNodeStatus.Setup.equals((Object)ns) && !JDFElement.EnumNodeStatus.Cleanup.equals((Object)ns);
        } else {
            JDFAutoDeviceInfo.EnumDeviceStatus eDeviceInfoStatus;
            String deviceStatus;
            String string = deviceStatus = xjdf instanceof JDFDeviceInfo ? xjdf.getAttribute("Status") : null;
            if ("Production".equals(deviceStatus)) {
                deviceStatus = "Running";
            }
            parentIdle = JDFAutoDeviceInfo.EnumDeviceStatus.Down.equals((Object)(eDeviceInfoStatus = JDFAutoDeviceInfo.EnumDeviceStatus.getEnum(deviceStatus))) || JDFAutoDeviceInfo.EnumDeviceStatus.Idle.equals((Object)eDeviceInfoStatus) || JDFAutoDeviceInfo.EnumDeviceStatus.Stopped.equals((Object)eDeviceInfoStatus);
        }
        JDFModuleStatus ms = (JDFModuleStatus)jdf;
        String moduleStatus = ms.getNonEmpty("DeviceStatus");
        JDFAutoDeviceInfo.EnumDeviceStatus eModuleStatus = JDFAutoDeviceInfo.EnumDeviceStatus.getEnum(moduleStatus);
        boolean bModuleIdle = JDFAutoDeviceInfo.EnumDeviceStatus.Down.equals((Object)eModuleStatus) || JDFAutoDeviceInfo.EnumDeviceStatus.Idle.equals((Object)eModuleStatus) || JDFAutoDeviceInfo.EnumDeviceStatus.Stopped.equals((Object)eModuleStatus);
        boolean bl = needCopy = moduleStatus == null || bModuleIdle == parentIdle;
        if (needCopy) {
            String id = StringUtil.getNonEmpty(ms.getModuleID());
            if (id != null && xjdf != null) {
                xjdf.appendAttribute("ModuleIDs", id, null, null, true);
            } else {
                JDFIntegerRangeList index = ms.getModuleIndex();
                if (index != null && xjdf != null) {
                    JDFIntegerList il = index.getIntegerList();
                    il.unify();
                    int size = il.size();
                    for (int i = 0; i < size; ++i) {
                        xjdf.appendAttribute("ModuleIDs", "" + il.getInt(i), null, null, true);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFElement.EnumVersion v = this.jdfToXJDF.getNewVersion();
        if (EnumUtil.aLessThanB(v, JDFElement.EnumVersion.Version_2_3)) {
            return this.walkOld(jdf, xjdf);
        }
        return super.walk(jdf, xjdf);
    }
}

