/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDFDataCache;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.resource.JDFResource;

public class WalkResource
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFResource r = (JDFResource)jdf;
        if (r.getNoOp() || jdf.getNodeName().equals(xjdf.getNodeName())) {
            return null;
        }
        KElement newResLeaf = super.walk(jdf, xjdf);
        if (newResLeaf != null) {
            newResLeaf.removeAttribute("ID");
            this.moveAttribsToBase(xjdf, newResLeaf);
            this.removeDeprecatedResourceAttribs(r, newResLeaf);
            boolean bRoot = this.isRootXJDFResource(xjdf);
            if (bRoot) {
                ResourceHelper h;
                this.removeDeprecatedResourceAttribs(r, xjdf);
                JDFResource.EnumResStatus status = r.getResStatus(false);
                if (status != null && (h = ResourceHelper.getHelper(xjdf)) != null) {
                    JDFResource.EnumResStatus newStatus = status.compareTo((Object)JDFResource.EnumResStatus.Available) >= 0 ? JDFResource.EnumResStatus.Available : JDFResource.EnumResStatus.Unavailable;
                    h.setStatus(newStatus);
                }
                xjdf.removeAttribute("StatusDetails");
            }
        }
        return newResLeaf;
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        if (!this.jdfToXJDF.isRetainAll()) {
            map.remove("DocCopies");
            map.remove("SetCopies");
            map.remove("RunTag");
            map.remove("AmountProduced");
            map.remove("AmountRequired");
            map.remove("PartUsage");
            map.remove("MinStatus");
            map.remove("NoOp");
        }
        super.updateAttributes(map);
    }

    protected void moveAttribsToBase(KElement xjdf, KElement newResLeaf) {
        boolean bRoot = this.isRootXJDFResource(xjdf);
        StringArray resAttribs = JDFToXJDFDataCache.getResAttribs();
        for (String attrib : resAttribs) {
            if (!newResLeaf.hasAttribute(attrib)) continue;
            if (bRoot) {
                if (this.retainRoot(attrib)) {
                    xjdf.copyAttribute(attrib, newResLeaf);
                    continue;
                }
                xjdf.moveAttribute(attrib, newResLeaf);
                continue;
            }
            if (this.retainRoot(attrib)) continue;
            newResLeaf.removeAttribute(attrib);
        }
    }

    protected boolean retainRoot(String attrib) {
        return false;
    }

    private boolean isRootXJDFResource(KElement xjdf) {
        String localName = xjdf == null ? null : xjdf.getLocalName();
        boolean bRoot = "Intent".equals(localName) || "Parameter".equals(localName) || "Resource".equals(localName);
        return bRoot;
    }

    protected void moveToDetails(KElement eNew, String details, String key, String oldKey) {
        String val = eNew.getNonEmpty(key);
        if (val != null) {
            eNew.getCreateElement(details).moveAttribute(key, eNew, oldKey, null, null);
        }
    }

    private void removeDeprecatedResourceAttribs(JDFResource r, KElement newResLeaf) {
        newResLeaf.removeAttributes(r.getPartIDKeys());
        newResLeaf.removeAttribute("PartIDKeys");
        newResLeaf.removeAttribute("PartUsage");
        newResLeaf.removeAttribute("Class");
        newResLeaf.removeAttribute("Locked");
        newResLeaf.removeAttribute("SpawnIDs");
        newResLeaf.removeAttribute("SpawnStatus");
        newResLeaf.removeAttribute("AgentName");
        newResLeaf.removeAttribute("AgentVersion");
    }

    protected String getClassName(JDFResource r) {
        String className;
        KElement r2;
        if (r == null) {
            return null;
        }
        JDFResource.EnumResourceClass resourceClass = r.getResourceClass();
        if (resourceClass == null && (r2 = new JDFDoc(r.getLocalName()).getRoot()) instanceof JDFResource) {
            r2.init();
            resourceClass = ((JDFResource)r2).getResourceClass();
        }
        String string = className = this.jdfToXJDF.isParameterSet() ? "Parameter" : "Resource";
        if (resourceClass == null) {
            return className;
        }
        if (resourceClass.equals((Object)JDFResource.EnumResourceClass.Intent)) {
            className = this.jdfToXJDF.wantProduct ? resourceClass.getName() : null;
        } else {
            if (resourceClass.equals((Object)JDFResource.EnumResourceClass.PlaceHolder)) {
                return null;
            }
            if (!JDFResource.EnumResourceClass.Parameter.equals((Object)resourceClass)) {
                return "Resource";
            }
        }
        return className;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFResource;
    }

    protected boolean isProductResource(JDFResource linkTarget) {
        return JDFResource.EnumResourceClass.Intent.equals((Object)linkTarget.getResourceClass());
    }
}

