/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDFDataCache;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

class XJDFPrepWalker
extends BaseElementWalker {
    private final BaseXJDFHelper h;
    private static final Log sLog = LogFactory.getLog(XJDFPrepWalker.class);

    XJDFPrepWalker(BaseXJDFHelper h) {
        super(new BaseWalkerFactory());
        this.h = h;
    }

    public void convert() {
        this.walkTreeKidsFirst(this.h.getRoot());
    }

    protected class WalkLayoutSet
    extends WalkElement {
        @Override
        public boolean matches(KElement e) {
            return SetHelper.isSet(e) && "Layout".equals(SetHelper.getResourceName(e));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            SetHelper sh = SetHelper.getHelper(xjdf);
            if (ContainerUtil.containsAny(sh.getXJDF().getTypes(), new StringArray("ImpositionPreparation Stripping")) || xjdf.getXPathElement("Resource/Layout/Position") != null || xjdf.getXPathElement("Resource/Layout/FileSpec") != null) {
                this.moveToStrippingParams(xjdf, sh);
                if (sh.isEmpty()) {
                    sh.deleteNode();
                    return null;
                }
            }
            return super.walk(xjdf, dummy);
        }

        void moveToStrippingParams(KElement xjdf, SetHelper sh) {
            KElement parent = xjdf.getParentNode_KElement();
            for (ResourceHelper loRes : sh.getPartitionList()) {
                if (!this.isStripping(loRes)) continue;
                SetHelper shStrip = SetHelper.getCreateSet(parent, "StrippingParams", JDFResourceLink.EnumUsage.Input);
                KElement lo = loRes.getResource();
                if (lo != null) {
                    JDFStrippingParams sp = (JDFStrippingParams)loRes.getRoot().appendElement("StrippingParams");
                    sp.mergeElement(lo, true);
                }
                shStrip.getRoot().moveElement(loRes.getRoot(), null);
                if (!JDFResourceLink.EnumUsage.Output.equals((Object)sh.getUsage())) continue;
                sh.appendResource(loRes.getPartMapVector(), false);
            }
        }

        boolean isStripping(ResourceHelper loRes) {
            return loRes.getPartKey("Side") == null && !VJDFAttributeMap.isEmpty(loRes.getPartMapList()) || loRes.getXPathElement("Layout/Position") != null || loRes.getXPathElement("Layout/FileSpec") != null;
        }
    }

    protected class WalkStripMark
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            ResourceHelper helper = ResourceHelper.getHelper(xjdf.getDeepParent("Resource", 0));
            if (helper != null && !StringUtil.isEmpty(helper.getPartKey("Side"))) {
                List<KElement> kids = xjdf.getChildList();
                StringArray names = JDFToXJDFDataCache.getStripMarkElements();
                for (KElement kid : kids) {
                    if (!names.contains(kid.getLocalName())) continue;
                    KElement parent = xjdf.getParentNode_KElement();
                    KElement mo = parent.getElement("PlacedObject/MarkObject");
                    if (mo == null) {
                        KElement po = parent.insertBefore("PlacedObject", xjdf, null);
                        mo = po.appendElement("MarkObject");
                    }
                    for (KElement kid2 : kids) {
                        mo.moveElement(kid2, null);
                    }
                    KElement dm = mo.appendElement("DeviceMark");
                    dm.setAttributes(xjdf);
                    xjdf.deleteNode();
                    return super.walk(mo, dummy);
                }
            }
            return super.walk(xjdf, dummy);
        }

        @Override
        public VString getElementNames() {
            return new VString("StripMark");
        }
    }

    protected class WalkResourceInfo
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            SetHelper sh;
            KElement parent = xjdf.getParentNode_KElement();
            if (parent != null && (sh = SetHelper.getHelper(xjdf.getElement("ResourceSet"))) != null) {
                boolean i = true;
                while (1 < sh.size()) {
                    KElement newRI = parent.appendElement("ResourceInfo");
                    newRI.setAttributes(xjdf);
                    SetHelper newSet = SetHelper.appendSet(newRI, sh.getName(), sh.getUsage());
                    ResourceHelper part = sh.getPartition(1);
                    newSet.getRoot().moveElement(part.getRoot(), null);
                }
            }
            return super.walk(xjdf, dummy);
        }

        @Override
        public VString getElementNames() {
            return new VString("ResourceInfo");
        }
    }

    protected class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(XJDFPrepWalker.this.getFactory());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            return xjdf;
        }
    }

    protected class WalkRoot
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String ver = e.getNonEmpty("Version");
            JDFElement.EnumVersion v = JDFElement.EnumVersion.getEnum(ver);
            if (!(StringUtil.isEmpty(ver) || v != null && v.getMajorVersion() == 2)) {
                e.removeAttribute("Version");
                sLog.warn((Object)("removing invalid version:'" + ver + "' from " + e.getLocalName()));
            }
            return e;
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("XJDF XJMF", null);
        }
    }

    protected class WalkContact
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            VString cTypes;
            VJDFAttributeMap vMap;
            JDFContact c = (JDFContact)e;
            ResourceHelper contactHelper = ResourceHelper.getHelper(c);
            VJDFAttributeMap vJDFAttributeMap = vMap = contactHelper == null ? null : contactHelper.getPartMapVector();
            if (!VJDFAttributeMap.isEmpty(vMap) && !VString.isEmpty(cTypes = vMap.getPartValues("ContactType", true))) {
                String ctypeString;
                SetHelper sh = contactHelper.getSet();
                c.setContactTypes(cTypes);
                vMap.removeKey("ContactType");
                if (vMap.getKeys().isEmpty() && sh.size() > 1 && !"Employee".equals(ctypeString = cTypes.getString("_", null, null))) {
                    vMap.put("Option", ctypeString);
                }
                vMap.unify();
                contactHelper.setPartMapVector(vMap);
            }
            KElement ret = super.walk(e, trackElem);
            return ret;
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("Contact", null);
        }
    }
}

