/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.auto.JDFAutoConventionalPrintingParams;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.auto.JDFAutoMedia;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFCMYKColor;
import org.cip4.jdflib.datatypes.JDFLabColor;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.goldenticket.ProductGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.process.JDFColor;
import org.cip4.jdflib.resource.process.JDFColorPool;
import org.cip4.jdflib.resource.process.JDFColorantControl;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFExposedMedia;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.JDFRunList;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StatusCounter;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class BaseGoldenTicket {
    protected VString amountLinks = null;
    protected JDFNode theNode = null;
    protected JDFNode theExpandedNode = null;
    protected JDFNode thePreviousNode = null;
    protected JDFNode theParentNode = null;
    protected String category;
    protected Map<String, VString> catMap = new HashMap<String, VString>();
    public JDFNode theParentProduct = null;
    protected JDFElement.EnumVersion theVersion = null;
    protected int baseICSLevel;
    protected int icsLevel = 0;
    protected StatusCounter theStatusCounter;
    public static String misURL = null;
    public static String deviceURL = null;
    private final Vector<BaseGoldenTicket> vKids = new Vector();
    public VJDFAttributeMap vParts = null;
    public VString cols = this.getCols();
    public VString colsActual = new VString("Schwarz,Cyan,Magenta,Gelb,RIP 4711,RIP 4712,RIP 4713,RIP 4714", ",");
    public String plateReduction = "Side Separation PartVersion";
    public int[] nCols = new int[]{0, 0};
    public String paperProductID;
    protected VString partIDKeys = null;
    public JDFAutoConventionalPrintingParams.EnumWorkStyle workStyle = JDFAutoConventionalPrintingParams.EnumWorkStyle.Simplex;
    public String devID = "DeviceID";
    public int good = 1000;
    public int waste = 100;
    public int partsAtOnce = 0;
    public int partsForAvailable = 1;
    public boolean bExpandGrayBox = true;
    public boolean bPartitionedPlateMedia = false;
    public JDFMedia paperMedia;
    public String returnURL = null;
    public boolean getNIFromParent = false;
    public String m_pdfFile = "file://server/dir/file.pdf";

    protected VString getCols() {
        return new VString("Black,Cyan,Magenta,Yellow,Spot1,Spot2,Spot3,Spot4", ",");
    }

    public static VJDFAttributeMap createSheetMap(int n) {
        VJDFAttributeMap vMap = new VJDFAttributeMap();
        for (int i = 1; i <= n; ++i) {
            JDFAttributeMap map = new JDFAttributeMap();
            map.put((ValuedEnum)JDFResource.EnumPartIDKey.SignatureName, "Sig1");
            map.put((ValuedEnum)JDFResource.EnumPartIDKey.SheetName, "Sheet1");
            map.put((ValuedEnum)JDFResource.EnumPartIDKey.Side, "Front");
            vMap.add(new JDFAttributeMap(map));
            map.put((ValuedEnum)JDFResource.EnumPartIDKey.Side, "Back");
            vMap.add(new JDFAttributeMap(map));
        }
        return vMap;
    }

    public BaseGoldenTicket(int pIcsLevel, JDFElement.EnumVersion jdfVersion) {
        this.category = null;
        this.fillCatMaps();
        this.paperProductID = "paperID";
        this.baseICSLevel = pIcsLevel;
        this.theVersion = jdfVersion == null ? JDFElement.getDefaultJDFVersion() : jdfVersion;
        this.theStatusCounter = new StatusCounter(null, null, null);
        KElement.setLongID(false);
    }

    public BaseGoldenTicket(BaseGoldenTicket parent) {
        this.category = parent.category;
        this.fillCatMaps();
        this.baseICSLevel = parent.baseICSLevel;
        this.theVersion = parent.theVersion;
        this.theStatusCounter = new StatusCounter(null, null, null);
        this.bExpandGrayBox = parent.bExpandGrayBox;
        this.bPartitionedPlateMedia = parent.bPartitionedPlateMedia;
        this.cols = new VString(parent.cols);
        this.colsActual = new VString(parent.colsActual);
        this.nCols = parent.nCols;
        this.devID = parent.devID;
        this.good = parent.good;
        this.waste = parent.waste;
        this.paperMedia = parent.paperMedia;
        this.partsAtOnce = parent.partsAtOnce;
        this.theParentNode = parent.getNode();
        this.vParts = new VJDFAttributeMap(parent.vParts);
        this.partIDKeys = new VString(parent.partIDKeys);
        this.workStyle = parent.workStyle;
        this.paperProductID = parent.paperProductID;
        this.icsLevel = parent.icsLevel;
        KElement.setLongID(false);
        parent.addKid(this);
    }

    protected JDFNodeInfo initNodeInfo() {
        JDFNodeInfo ni;
        JDFNodeInfo jDFNodeInfo = ni = this.getNIFromParent && this.theParentNode != null ? this.theParentNode.getNodeInfo() : null;
        if (ni == null) {
            ni = this.theNode.getCreateNodeInfo();
            ni.setResStatus(JDFResource.EnumResStatus.Available, false);
        } else {
            this.theNode.linkResource((JDFResource)ni, JDFResourceLink.EnumUsage.Input, null);
        }
        if (this.returnURL != null) {
            ni.setTargetRoute(this.returnURL);
        }
        return ni;
    }

    public void assign(JDFNode node) {
        this.vKids.clear();
        this.vKids.add(this);
        this.theNode = node == null ? (this.theParentNode == null ? new JDFDoc("JDF").getJDFRoot() : this.theParentNode.addJDFNode((String)null)) : node;
        this.theExpandedNode = this.theNode;
        if (this.theNode.getParentJDF() != null) {
            this.theParentNode = this.theNode.getParentJDF();
        }
        this.theParentProduct = this.theParentNode;
        while (this.theParentProduct != null && !JDFNode.EnumType.Product.equals((Object)this.theParentProduct.getEnumType())) {
            this.theParentProduct = this.theParentProduct.getParentJDF();
        }
        this.setVersion();
        this.init();
    }

    public void setPreviousNode(JDFNode node) {
        this.thePreviousNode = node;
    }

    public void addKid(BaseGoldenTicket bt) {
        if (!this.vKids.contains(bt)) {
            this.vKids.add(bt);
        }
    }

    public void makeReadyAll() {
        for (BaseGoldenTicket kid : this.vKids) {
            kid.makeReady();
        }
    }

    public void makeReady() {
        if (this.bExpandGrayBox && JDFNode.EnumType.ProcessGroup.equals((Object)this.theNode.getEnumType()) && this.theNode.hasAttribute("Types")) {
            this.theExpandedNode = this.theNode.addCombined(this.theNode.getTypes());
            VElement resLinks = this.theNode.getResourceLinks(null);
            if (resLinks != null) {
                int size = resLinks.size();
                for (int i = 0; i < size; ++i) {
                    ((JDFResourceLink)resLinks.get(i)).removeAttribute("CombinedProcessIndex");
                }
            }
            this.initAuditPool(this.theExpandedNode);
            this.theExpandedNode.copyElement(this.theNode.getResourceLinkPool(), null);
        } else {
            this.theExpandedNode = this.theNode;
        }
        VElement nodeLinks = this.getNodeLinks();
        this.theStatusCounter.setActiveNode(this.theExpandedNode, null, nodeLinks);
        VElement vResLinks = this.theExpandedNode.getResourceLinks(null);
        if (vResLinks != null) {
            int siz = vResLinks.size();
            for (int i = 0; i < siz; ++i) {
                JDFResourceLink rl = (JDFResourceLink)vResLinks.elementAt(i);
                if (!JDFResourceLink.EnumUsage.Input.equals((Object)rl.getUsage())) continue;
                VElement vRes = rl.getTargetVector(-1);
                for (int j = 0; j < vRes.size(); ++j) {
                    VElement leaves = ((JDFResource)vRes.elementAt(j)).getLeaves(false);
                    for (int k = 0; k < leaves.size(); ++k) {
                        JDFResource r = (JDFResource)leaves.elementAt(k);
                        r.setResStatus(JDFResource.EnumResStatus.Available, true);
                    }
                }
            }
        }
    }

    public void setActivePart(VJDFAttributeMap vp, boolean bFirst) {
        this.theStatusCounter.setActiveNode(this.theExpandedNode, vp, this.getNodeLinks());
    }

    public void executeAll(VJDFAttributeMap parts) {
        Vector<VJDFAttributeMap> vvMap = new Vector<VJDFAttributeMap>();
        if (parts == null) {
            if (this.partsAtOnce > 0) {
                int size = this.vParts == null ? 0 : this.vParts.size();
                VJDFAttributeMap vCurr = new VJDFAttributeMap();
                for (int i = 0; i < size; ++i) {
                    if (i % this.partsAtOnce == 0) {
                        vCurr = new VJDFAttributeMap();
                        vvMap.add(vCurr);
                    }
                    vCurr.add(this.vParts.elementAt(i));
                }
            } else {
                vvMap.add(this.vParts);
            }
        } else {
            vvMap.add(parts);
        }
        for (int i = 0; i < vvMap.size(); ++i) {
            this.setActivePart((VJDFAttributeMap)vvMap.get(i), i % this.partsForAvailable == 0);
            for (int j = 0; j < this.vKids.size(); ++j) {
                this.vKids.get(j).execute((VJDFAttributeMap)vvMap.get(i), i % this.partsForAvailable == this.partsForAvailable - 1, i % this.partsForAvailable == 0);
            }
        }
    }

    public void execute(VJDFAttributeMap vMap, boolean bOutAvail, boolean bFirst) {
        this.theExpandedNode.setPartStatus(vMap, JDFElement.EnumNodeStatus.Completed, null);
        this.theNode.setPartStatus(vMap, JDFElement.EnumNodeStatus.Completed, null);
        this.runphases(this.good, this.waste, bOutAvail, bFirst);
        this.theExpandedNode.synchParentAmounts();
    }

    protected void runphases(int pgood, int pwaste, boolean bOutAvail, boolean bFirst) {
        this.theStatusCounter.setPhase(JDFElement.EnumNodeStatus.InProgress, "NodeDetails", JDFAutoDeviceInfo.EnumDeviceStatus.Running, "DeviceDetails");
        this.runSinglePhase(pgood, pwaste, bOutAvail, bFirst);
        this.finalizeProcess();
        this.theStatusCounter.setPhase(JDFElement.EnumNodeStatus.Completed, "NodeDetails", JDFAutoDeviceInfo.EnumDeviceStatus.Idle, "DeviceDetails");
    }

    public void schedule(VJDFAttributeMap partsToSchedule, int starthours, int durationhours) {
        this.theNode.setPartStatus(partsToSchedule, JDFElement.EnumNodeStatus.Waiting, null);
        JDFNodeInfo ni = this.theNode.getNodeInfo();
        if (partsToSchedule == null) {
            partsToSchedule = new VJDFAttributeMap();
            partsToSchedule.add(null);
        }
        JDFDate d = new JDFDate();
        for (int i = 0; i < partsToSchedule.size(); ++i) {
            JDFNodeInfo nip = (JDFNodeInfo)ni.getCreatePartition(partsToSchedule.elementAt(i), null);
            if (starthours > 0) {
                d.addOffset(0, 0, starthours, 0);
                nip.setStart(d);
            }
            if (durationhours <= 0) continue;
            d.addOffset(0, 0, durationhours, 0);
            nip.setEnd(d);
        }
    }

    protected final void runSinglePhase(int pgood, int pwaste, boolean bOutAvail, boolean bFirst) {
        VElement vResLinks = this.theExpandedNode.getResourceLinks(null);
        if (vResLinks != null) {
            int siz = vResLinks.size();
            for (int i = 0; i < siz; ++i) {
                int _good = pgood;
                JDFResourceLink rl = (JDFResourceLink)vResLinks.elementAt(i);
                if (!bFirst && JDFResourceLink.EnumUsage.Input.equals((Object)rl.getUsage())) {
                    _good = 0;
                }
                this.theStatusCounter.addPhase(rl.getrRef(), _good, pwaste, true);
            }
        }
    }

    protected void finalizeProcess() {
        this.theStatusCounter.setEvent("ID_42", "Event", StringUtil.getRandomString());
    }

    protected void setVersion() {
        if (this.theVersion == null) {
            this.theVersion = this.theNode.getVersion(true);
        }
        if (this.theVersion == null) {
            this.theVersion = JDFElement.getDefaultJDFVersion();
        }
    }

    public void setParent(boolean bProduct) {
        this.theParentNode = new JDFDoc("JDF").getJDFRoot();
        this.theParentNode.setType(bProduct ? JDFNode.EnumType.Product : JDFNode.EnumType.ProcessGroup);
    }

    public void setParent(ProductGoldenTicket parent) {
        this.theParentNode = parent == null ? null : parent.theNode;
    }

    public void init() {
        this.initJDF();
        this.initAuditPool(this.theNode);
        this.initDevice(null);
    }

    protected JDFDevice initDevice(JDFNode previousNode) {
        JDFDevice dev = (JDFDevice)this.theNode.getResource("Device", JDFResourceLink.EnumUsage.Input, 0);
        if (dev == null && this.devID != null) {
            JDFResourceLink rl = null;
            dev = (JDFDevice)(this.theParentNode != null ? this.theParentNode.getResource("Device", JDFResourceLink.EnumUsage.Input, 0) : null);
            if (dev == null) {
                dev = (JDFDevice)this.theNode.getCreateResource("Device", JDFResourceLink.EnumUsage.Input, 0);
                dev.setDeviceID(this.devID);
                dev.setResStatus(JDFResource.EnumResStatus.Available, true);
                rl = this.theNode.getLink((JDFResource)dev, JDFResourceLink.EnumUsage.Input);
            } else {
                rl = this.theNode.getLink((JDFResource)dev, JDFResourceLink.EnumUsage.Input);
                if (rl == null) {
                    JDFResourceLink jDFResourceLink = this.theNode.linkResource((JDFResource)dev, JDFResourceLink.EnumUsage.Input, null);
                }
            }
        }
        return dev;
    }

    public void initAuditPool(JDFNode node) {
        JDFAuditPool auditPool = node.getCreateAuditPool();
        JDFAudit a = auditPool.getAudit(-1, JDFAudit.EnumAuditType.Created, null, null);
        if (a == null) {
            a = auditPool.addAudit(JDFAudit.EnumAuditType.Created, null);
        }
    }

    protected JDFNode addJDFNode(JDFNode node, JDFNode.EnumType t) {
        JDFNode newNode = node.addJDFNode(t);
        newNode.setStatus(JDFElement.EnumNodeStatus.Waiting);
        this.initAuditPool(newNode);
        return newNode;
    }

    protected void initJDF() {
        VString types;
        String icsTag = StringUtil.setvString(this.getICSVersions(), " ", null, null);
        this.theNode.appendAttribute("ICSVersions", icsTag, null, " ", true);
        this.theNode.setVersion(this.theVersion);
        this.theNode.setMaxVersion(this.theVersion);
        this.theNode.setStatus(JDFElement.EnumNodeStatus.Waiting);
        if (!this.theNode.hasAttribute("DescriptiveName")) {
            this.theNode.setDescriptiveName("Base Golden Ticket Example Job - version: " + JDFAudit.software());
        }
        if (this.theParentNode == null && !this.theNode.hasAttribute("CommentURL")) {
            this.theNode.setCommentURL(UrlUtil.stringToURL("http://www.example.com").toExternalForm());
        }
        if ((types = this.getTypes()) != null) {
            this.theNode.setCategory(this.getCategory());
            this.theNode.setCombined(types);
        }
    }

    public VString getICSVersions() {
        String icsTag = "Base_L" + this.baseICSLevel + "-" + this.theVersion.getName();
        return new VString(icsTag, null);
    }

    protected VElement getNodeLinks() {
        VElement nodeLinks = null;
        if (this.amountLinks != null) {
            nodeLinks = new VElement();
            VElement resLinks = this.theExpandedNode.getResourceLinks(null);
            if (resLinks != null) {
                int resLinkSize = resLinks.size();
                for (int i = 0; i < this.amountLinks.size(); ++i) {
                    for (int j = 0; j < resLinkSize; ++j) {
                        JDFResourceLink rl = (JDFResourceLink)resLinks.elementAt(j);
                        if (!rl.matchesString(this.amountLinks.elementAt(i))) continue;
                        nodeLinks.add(rl);
                    }
                }
            }
        }
        return nodeLinks;
    }

    public JDFNode getNode() {
        return this.theNode;
    }

    public JDFNode getExpandedNode() {
        return this.theExpandedNode;
    }

    public String toString() {
        String s = "[" + this.getClass().getName() + " Version: " + EnumUtil.getName(this.theVersion) + "]";
        if (this.theNode != null) {
            s = s + this.theNode.toString();
        }
        return s;
    }

    public void write2File(String file, int indent) {
        if (this.theNode == null) {
            this.assign(null);
        }
        this.theNode.getOwnerDocument_KElement().write2File(file, indent, indent == 0);
    }

    public StatusCounter getStatusCounter() {
        return this.theStatusCounter;
    }

    public static String getDeviceURL() {
        return deviceURL;
    }

    public static void setDeviceURL(String pdeviceURL) {
        deviceURL = pdeviceURL;
    }

    public static String getMisURL() {
        return misURL;
    }

    public static void setMisURL(String _misURL) {
        misURL = _misURL;
    }

    public void addSheet(String sheetName) {
        if (this.vParts == null) {
            this.vParts = new VJDFAttributeMap();
        }
        JDFAttributeMap map = new JDFAttributeMap("SignatureName", "Sig1");
        map.put("SheetName", sheetName);
        map.put("Side", "Front");
        this.vParts.appendUnique(map);
        if (this.nCols.length > 1) {
            map = new JDFAttributeMap(map);
            map.put("Side", "Back");
            this.vParts.appendUnique(map);
        }
    }

    public void addAmountLink(String link) {
        if (this.amountLinks == null) {
            this.amountLinks = new VString();
        }
        this.amountLinks.appendUnique(link);
    }

    protected void initColorantControl() {
        JDFResourceLink ccLink = null;
        if (this.thePreviousNode != null) {
            ccLink = this.theNode.linkResource(this.thePreviousNode.getResource("ColorantControl", JDFResourceLink.EnumUsage.Input, 0), JDFResourceLink.EnumUsage.Input, null);
        }
        if (ccLink == null && this.theParentNode != null) {
            ccLink = this.theNode.linkResource(this.theParentNode.getResource("ColorantControl", JDFResourceLink.EnumUsage.Input, 0), JDFResourceLink.EnumUsage.Input, null);
        }
        JDFColorantControl cc = (JDFColorantControl)(ccLink == null ? (JDFColorantControl)this.theNode.getCreateResource("ColorantControl", JDFResourceLink.EnumUsage.Input, 0) : ccLink.getTarget());
        cc.setResStatus(JDFResource.EnumResStatus.Available, false);
        JDFColorPool cp = this.initColorPool();
        cc.refColorPool(cp);
        for (int i = 4; i < this.getNCols(); ++i) {
            cc.getCreateColorantParams().appendSeparation(this.cols.get(i));
        }
        cc.setProcessColorModel("DeviceCMYK");
        if (this.nCols[0] != this.nCols[1]) {
            for (int ii = 0; ii < 2; ++ii) {
                JDFColorantControl ccP = (JDFColorantControl)cc.addPartition(JDFResource.EnumPartIDKey.Side, ii == 0 ? "Front" : "Back");
                VString colsP = new VString();
                for (int iii = 0; iii < this.nCols[ii]; ++iii) {
                    colsP.add(this.cols.get(iii));
                }
                JDFSeparationList co = ccP.getCreateColorantOrder();
                co.setSeparations(colsP);
            }
        } else {
            JDFSeparationList co = cc.getCreateColorantOrder();
            co.setSeparations(this.cols);
        }
    }

    protected JDFColorPool initColorPool() {
        JDFColorPool cp = (JDFColorPool)this.theNode.getJDFRoot().getChildByTagName("ColorPool", null, 0, null, false, false);
        if (cp == null) {
            cp = (JDFColorPool)this.theNode.getCreateResource("ColorPool", null, 0);
            if (this.theParentNode != null) {
                this.theParentNode.getCreateResourcePool().moveElement(cp, null);
            }
        }
        for (int i = 0; i < this.getNCols(); ++i) {
            String name = this.cols.get(i);
            JDFColor c = cp.getCreateColorWithName(name, null);
            if (i == 0) {
                c.setCMYK(new JDFCMYKColor(0.0, 0.0, 0.0, 1.0));
            }
            if (i == 1) {
                c.setCMYK(new JDFCMYKColor(1.0, 0.0, 0.0, 0.0));
            }
            if (i == 2) {
                c.setCMYK(new JDFCMYKColor(0.0, 1.0, 0.0, 0.0));
            }
            if (i == 3) {
                c.setCMYK(new JDFCMYKColor(0.0, 0.0, 1.0, 0.0));
            }
            if (i == 4) {
                c.setCMYK(new JDFCMYKColor(0.6, 0.2, 0.1, 0.0));
            }
            if (i == 5) {
                c.setCMYK(new JDFCMYKColor(0.3, 0.1, 1.0, 0.0));
            }
            if (i == 6) {
                c.setCMYK(new JDFCMYKColor(0.3, 0.7, 0.1, 0.0));
            }
            if (!"White".equalsIgnoreCase(c.getName())) continue;
            c.setCMYK(new JDFCMYKColor(0.0, 0.0, 0.0, 0.0));
            c.setLab(new JDFLabColor(100.0, 0.0, 0.0));
        }
        return cp;
    }

    protected JDFMedia initPaperMedia() {
        JDFResourceLink rlM = null;
        if (this.thePreviousNode != null) {
            VElement v;
            JDFMedia media = (JDFMedia)this.thePreviousNode.getResource("Media", JDFResourceLink.EnumUsage.Input, 0);
            if (media != null && !JDFAutoMedia.EnumMediaType.Paper.equals((Object)media.getMediaType())) {
                media = (JDFMedia)this.thePreviousNode.getResource("Media", JDFResourceLink.EnumUsage.Input, 1);
            }
            if (media != null && !JDFAutoMedia.EnumMediaType.Paper.equals((Object)media.getMediaType())) {
                media = null;
            }
            if (media == null && (media = this.getMediaFromNode(this.thePreviousNode)) == null && (v = this.thePreviousNode.getPredecessors(true, false)) != null) {
                int siz = v.size();
                for (int i = 0; i < siz && (media = this.getMediaFromNode((JDFNode)v.get(i))) == null; ++i) {
                }
            }
            rlM = this.theNode.linkResource((JDFResource)media, JDFResourceLink.EnumUsage.Input, null);
        }
        if (rlM == null && this.theParentNode != null) {
            rlM = this.theNode.linkResource(this.theParentNode.getResource("Media", JDFResourceLink.EnumUsage.Input, 0), JDFResourceLink.EnumUsage.Input, null);
        }
        this.paperMedia = (JDFMedia)this.theNode.getCreateResource("Media", null, 0);
        this.paperMedia.setDescriptiveName("the paper to print on");
        this.paperMedia.setResStatus(JDFResource.EnumResStatus.Unavailable, false);
        this.paperMedia.setMediaType(JDFAutoMedia.EnumMediaType.Paper);
        this.paperMedia.setDimensionCM(new JDFXYPair(102, 70));
        this.paperMedia.setWeight(90.0);
        this.paperMedia.setThickness(112.5);
        this.paperMedia.setProductID(this.paperProductID);
        return this.paperMedia;
    }

    private JDFMedia getMediaFromNode(JDFNode sNode) {
        JDFMedia m;
        if (sNode == null) {
            return null;
        }
        JDFLayout lo = (JDFLayout)sNode.getResource("Layout", JDFResourceLink.EnumUsage.Input, 0);
        if (lo != null && (m = lo.getMedia(0)) != null) {
            return m;
        }
        JDFStrippingParams sp = (JDFStrippingParams)sNode.getResource("StrippingParams", JDFResourceLink.EnumUsage.Input, 0);
        if (sp != null) {
            return sp.getMedia(0);
        }
        return null;
    }

    protected VJDFAttributeMap getReducedMap(VString reduceKeys) {
        if (this.vParts == null) {
            return null;
        }
        VJDFAttributeMap reducedMap = new VJDFAttributeMap(this.vParts);
        reducedMap.removeKeys(reduceKeys.getSet());
        if (reducedMap.size() == 0 || reducedMap.size() == 1 && reducedMap.elementAt(0).size() == 0) {
            return null;
        }
        return reducedMap;
    }

    protected void initPlateXM(JDFResourceLink.EnumUsage usage) {
        JDFResourceLink rl = null;
        if (this.thePreviousNode != null) {
            rl = this.theNode.linkResource(this.thePreviousNode.getResource("ExposedMedia", null, 0), usage, null);
        }
        if (rl == null && this.theParentNode != null) {
            rl = this.theNode.ensureLink(this.theParentNode.getResource("ExposedMedia", null, 0), usage, null);
        }
        JDFExposedMedia xm = (JDFExposedMedia)this.theNode.getCreateResource("ExposedMedia", usage, 0);
        xm.setPartUsage(JDFResource.EnumPartUsage.Explicit);
        rl = this.theNode.getLink((JDFResource)xm, null);
        JDFMedia m = ((JDFExposedMedia)xm.getLeaves(false).elementAt(0)).getMedia();
        if (m == null) {
            m = this.initPlateMedia();
        } else {
            m = (JDFMedia)m.getResourceRoot();
            if (this.theParentNode != null) {
                this.theNode.ensureLink(this.theParentNode.getResource("Media", JDFResourceLink.EnumUsage.Input, 0), JDFResourceLink.EnumUsage.Input, null);
            }
        }
        xm.setResStatus(JDFResource.EnumResStatus.Unavailable, false);
        if (!this.bPartitionedPlateMedia && xm.getMedia() == null) {
            xm.refElement(m);
        }
        if (JDFResourceLink.EnumUsage.Input.equals((Object)usage)) {
            rl.setProcessUsage(JDFNode.EnumProcessUsage.Plate);
            JDFResourceLink link = this.theNode.getLink((JDFResource)m, null);
            if (link != null) {
                link.deleteNode();
            }
        }
        if (this.vParts != null) {
            for (int i = 0; i < this.vParts.size(); ++i) {
                JDFAttributeMap part = new JDFAttributeMap(this.vParts.elementAt(i));
                JDFResource xmp = xm.getCreatePartition(part, this.partIDKeys);
                int ncols = "Front".equals(part.get("Side")) ? this.nCols[0] : this.nCols[1];
                for (int j = 0; j < ncols; ++j) {
                    part.put((ValuedEnum)JDFResource.EnumPartIDKey.Separation, this.cols.get(j));
                    xmp.getCreatePartition(part, this.partIDKeys);
                }
            }
            if (this.bPartitionedPlateMedia) {
                VJDFAttributeMap vSheets = this.getReducedMap(new VString("Side Separation PartVersion", null));
                for (int i = 0; i < vSheets.size(); ++i) {
                    JDFAttributeMap part = new JDFAttributeMap(vSheets.elementAt(i));
                    JDFExposedMedia xmp = (JDFExposedMedia)xm.getCreatePartition(part, this.partIDKeys);
                    if (xmp.getMedia() != null) continue;
                    xmp.refMedia((JDFMedia)m.getCreatePartition(part, null));
                }
            }
        }
    }

    protected JDFMedia initPlateMedia() {
        JDFMedia m;
        if (this.theParentNode != null) {
            this.theNode.ensureLink(this.theParentNode.getResource("Media", JDFResourceLink.EnumUsage.Input, 0), JDFResourceLink.EnumUsage.Input, null);
        }
        if (JDFAutoMedia.EnumMediaType.Paper.equals((Object)(m = (JDFMedia)this.theNode.getCreateResource("Media", JDFResourceLink.EnumUsage.Input, 0)).getMediaType())) {
            m = (JDFMedia)this.theNode.getCreateResource("Media", JDFResourceLink.EnumUsage.Input, 1);
        }
        m.setResStatus(JDFResource.EnumResStatus.Available, false);
        m.makeRootResource(null, this.theNode.getJDFRoot(), true);
        this.theNode.getJDFRoot().getCreateResourcePool().moveElement(m, null);
        m.setDescriptiveName("the plates to use");
        m.setMediaType(JDFAutoMedia.EnumMediaType.Plate);
        m.setPartUsage(JDFResource.EnumPartUsage.Implicit);
        if (this.bPartitionedPlateMedia && this.vParts != null) {
            VJDFAttributeMap vSheets = this.getReducedMap(new VString(this.plateReduction, null));
            for (int i = 0; i < vSheets.size(); ++i) {
                JDFAttributeMap part = new JDFAttributeMap(vSheets.elementAt(i));
                m.getCreatePartition(part, this.partIDKeys);
                if (this.plateReduction != null && this.plateReduction.indexOf("Separation") >= 0) continue;
                int ncols = "Front".equals(part.get("Side")) ? this.nCols[0] : this.nCols[1];
                for (int ii = 0; ii < ncols; ++ii) {
                    part.put("Separation", this.cols.get(ii));
                    m.getCreatePartition(part, this.partIDKeys);
                }
            }
        } else {
            m.setDimensionCM(new JDFXYPair(103, 71));
        }
        return m;
    }

    public int getNCols() {
        return this.nCols[0] == 0 ? this.cols.size() : Math.max(this.nCols[0], this.nCols[1]);
    }

    protected JDFRunList initDocumentRunList() {
        JDFRunList rl = (JDFRunList)this.theNode.getCreateResource("RunList", JDFResourceLink.EnumUsage.Input, 0);
        JDFResourceLink rll = this.theNode.getLink((JDFResource)rl, null);
        if ("Marks".equals(rll.getProcessUsage())) {
            rl = (JDFRunList)this.theNode.getCreateResource("RunList", JDFResourceLink.EnumUsage.Input, 1);
            rll = this.theNode.getLink((JDFResource)rl, null);
        }
        rll.setProcessUsage(JDFNode.EnumProcessUsage.Document);
        this.m_pdfFile = UrlUtil.normalize(this.m_pdfFile);
        rl.addPDF(this.m_pdfFile, 0, -1);
        rl.setNPage(4);
        rl.setDescriptiveName("Description of this RunList");
        return rl;
    }

    protected JDFComponent initOutputComponent() {
        JDFComponent outComp;
        JDFResource parentOutComp;
        if (this.thePreviousNode != null && (parentOutComp = this.thePreviousNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0)) != null) {
            this.theNode.linkResource(parentOutComp, JDFResourceLink.EnumUsage.Input, null);
        }
        if ((outComp = (JDFComponent)(this.theParentNode != null ? this.theParentNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0) : null)) == null) {
            outComp = (JDFComponent)this.theNode.getCreateResource("Component", JDFResourceLink.EnumUsage.Output, 0);
            outComp.setComponentType(JDFAutoComponent.EnumComponentType.FinalProduct, JDFAutoComponent.EnumComponentType.Sheet);
            outComp.setProductType("Unknown");
            if (this.theParentNode != null) {
                this.theParentNode.linkResource((JDFResource)outComp, JDFResourceLink.EnumUsage.Output, null);
            }
        } else {
            this.theNode.linkResource((JDFResource)outComp, JDFResourceLink.EnumUsage.Output, null);
        }
        JDFResourceLink rl = this.theNode.getLink((JDFResource)outComp, JDFResourceLink.EnumUsage.Output);
        if (this.vParts != null) {
            VJDFAttributeMap reducedMap = this.getReducedMap(new VString("Side Separation", " "));
            if (reducedMap != null) {
                int size = reducedMap.size();
                for (int i = 0; i < size; ++i) {
                    JDFAttributeMap part = reducedMap.elementAt(i);
                    JDFResource partComp = outComp.getCreatePartition(part, this.partIDKeys);
                    partComp.setDescriptiveName("Description for Component part# " + i);
                    JDFAttributeMap newMap = new JDFAttributeMap(part);
                    newMap.put("Condition", "Good");
                    rl.setAmount(this.good, newMap);
                }
            }
        } else {
            outComp.setDescriptiveName("MIS-CP or IDP output Component");
            JDFAttributeMap newMap = new JDFAttributeMap("Condition", "Good");
            rl.setAmount(this.good, newMap);
        }
        JDFMedia inMedia = (JDFMedia)this.theNode.getResource("Media", JDFResourceLink.EnumUsage.Input, 0);
        if (inMedia != null) {
            outComp.setDimensions(inMedia.getDimension());
        }
        return outComp;
    }

    protected void fillCatMaps() {
    }

    public VString getTypes() {
        if (this.category == null) {
            return null;
        }
        return this.catMap.get(this.category);
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String _category) {
        this.category = _category;
    }
}

