/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDevice;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.devicecapability.JDFDeviceCap;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFDevice
extends JDFAutoDevice {
    private static final long serialVersionUID = 1L;

    public JDFDevice(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDevice(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDevice(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDevice[  --> " + super.toString() + " ]";
    }

    public VElement getMatchingTypeNodeVector(JDFNode testRoot) {
        VElement vDeviceCap = this.getChildElementVector("DeviceCap", null, null, false, -1, false);
        if (vDeviceCap == null || vDeviceCap.isEmpty()) {
            return null;
        }
        VElement vRet = new VElement();
        for (int i = 0; i < vDeviceCap.size(); ++i) {
            VElement vMatch = ((JDFDeviceCap)vDeviceCap.elementAt(i)).getMatchingTypeNodeVector(testRoot);
            if (vMatch == null) continue;
            vRet.addAll(vMatch);
        }
        vRet.unify();
        return vRet.isEmpty() ? null : vRet;
    }

    public VElement getMatchingDeviceCapVector(JDFNode testRoot, boolean bLocal) {
        VElement vDeviceCap = this.getChildElementVector("DeviceCap", null, null, false, -1, false);
        if (vDeviceCap == null || vDeviceCap.isEmpty()) {
            return null;
        }
        VElement vRet = new VElement();
        for (int i = 0; i < vDeviceCap.size(); ++i) {
            JDFDeviceCap dc = (JDFDeviceCap)vDeviceCap.elementAt(i);
            if (!dc.matchesType(testRoot, bLocal)) continue;
            vRet.add(dc);
        }
        return vRet.isEmpty() ? null : vRet;
    }

    public boolean matchesType(JDFNode testRoot, boolean bLocal) {
        VElement v = this.getMatchingTypeNodeVector(testRoot);
        if (v == null) {
            return false;
        }
        if (bLocal) {
            return v.contains(testRoot);
        }
        return true;
    }

    public VElement getExecutableJDF(JDFNode docRoot, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel validationLevel) {
        VElement vDC = this.getChildElementVector("DeviceCap", null, null, true, -1, false);
        if (vDC == null || vDC.isEmpty()) {
            return null;
        }
        VElement vn = new VElement();
        for (int i = 0; i < vDC.size(); ++i) {
            JDFDeviceCap dc = (JDFDeviceCap)vDC.elementAt(i);
            VElement executableJDF = dc.getExecutableJDF(docRoot, testlists, validationLevel);
            if (executableJDF == null) continue;
            vn.addAll(executableJDF);
        }
        vn.unify();
        return vn.isEmpty() ? null : vn;
    }

    public final XMLDoc getBadJDFInfo(JDFNode jdfRoot, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level) {
        KElement e;
        int i;
        VElement vDC = this.getChildElementVector("DeviceCap", null, null, true, -1, false);
        if (vDC == null || vDC.isEmpty()) {
            return null;
        }
        VElement vn = new VElement();
        for (int i2 = 0; i2 < vDC.size(); ++i2) {
            JDFDeviceCap dc = (JDFDeviceCap)vDC.elementAt(i2);
            XMLDoc bugReport = dc.getBadJDFInfo(jdfRoot, testlists, level);
            if (bugReport == null) {
                return null;
            }
            vn.addAll(bugReport.getRoot().getChildElementVector(null, null, null, true, -1, false));
        }
        int vnSize = vn.size();
        if (vnSize == 0) {
            return null;
        }
        XMLDoc bugReport = new XMLDoc("BugReport", null);
        KElement root = bugReport.getRoot();
        boolean bFit = false;
        for (i = 0; i < vnSize; ++i) {
            e = vn.elementAt(i);
            if (!"true".equals(e.getAttribute("FitsType"))) continue;
            bFit = true;
        }
        if (bFit) {
            for (i = 0; i < vnSize; ++i) {
                e = vn.elementAt(i);
                if (!"false".equals(e.getAttribute("FitsType"))) continue;
                vn.set(i, null);
            }
        }
        for (i = 0; i < vnSize; ++i) {
            if (vn.elementAt(i) == null) continue;
            root.moveElement(vn.item(i), null);
        }
        return bugReport;
    }

    @Override
    public String getDescriptiveName() {
        String ret = StringUtil.getNonEmpty(super.getDescriptiveName());
        return ret != null ? ret : this.getFriendlyName();
    }

    public String getRestApiBaseURL() {
        return this.getAttribute("RestApiBaseURL", null, "");
    }

    public void setRestApiBaseURL(String value) {
        this.setAttribute("RestApiBaseURL", value, null);
    }
}

