/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PrefixInputStream
extends FilterInputStream {
    private final InputStream streamPre;
    private boolean bDone;
    private boolean markDone;

    public PrefixInputStream(InputStream stream1, InputStream stream2) {
        super(stream2);
        this.markDone = false;
        this.bDone = false;
        this.streamPre = stream1;
    }

    public PrefixInputStream(String prefix, InputStream stream2) {
        super(stream2);
        this.bDone = false;
        this.streamPre = new ByteArrayInputStream(prefix.getBytes());
    }

    @Override
    public int read() throws IOException {
        if (!this.bDone) {
            int read = this.streamPre.read();
            if (read != -1) {
                return read;
            }
            this.bDone = true;
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.bDone) {
            int read = this.streamPre.read(b, off, len);
            if (read != -1) {
                return read;
            }
            this.bDone = true;
        }
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (!this.bDone) {
            int read = this.streamPre.read(b);
            if (read != -1) {
                return read;
            }
            this.bDone = true;
        }
        return super.read(b);
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markDone = this.bDone;
        if (!this.bDone) {
            this.streamPre.mark(readlimit);
        }
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.bDone = this.markDone;
        if (!this.bDone) {
            this.streamPre.reset();
        }
        super.reset();
    }

    public String toString() {
        return "PrefixInputStream [bDone=" + this.bDone + ", markDone=" + this.markDone + "]";
    }
}

