/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.file;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.file.FileTime;

public class FileJanitor {
    private final File baseDir;
    private KillFilter filter;
    boolean logSingle;
    private static final Log log = LogFactory.getLog(FileJanitor.class);
    boolean delEmpty;
    boolean recurseDirs;
    private final ArrayList<FileTime> keep;
    int minKeep;

    public void setMinKeep(int minKeep) {
        this.minKeep = minKeep;
    }

    public void setLogSingle(boolean logSingle) {
        this.logSingle = logSingle;
    }

    public void setDeleteEmptyDir(boolean delEmpty) {
        this.delEmpty = delEmpty;
    }

    public FileJanitor(File baseDir, FileFilter filter) {
        if (filter != null) {
            this.filter = new KillFilter(filter);
        }
        this.baseDir = baseDir;
        this.logSingle = false;
        this.delEmpty = false;
        this.keep = new ArrayList();
        this.minKeep = 0;
        this.recurseDirs = true;
    }

    public boolean isRecurseDirs() {
        return this.recurseDirs;
    }

    public void setRecurseDirs(boolean recurseDirs) {
        this.recurseDirs = recurseDirs;
    }

    public FileJanitor(File baseDir, long age) {
        this(baseDir, null);
        this.filter = new KillFilter(new AgeFilter(age * 1000L));
    }

    public Vector<File> cleanup() {
        this.keep.clear();
        if (this.minKeep > 0 && this.filter instanceof KillFilter) {
            return this.cleanupKeepMin();
        }
        if (this.recurseDirs) {
            return FileUtil.listFilesInTree(this.baseDir, this.filter);
        }
        return this.cleanupFlat();
    }

    Vector<File> cleanupFlat() {
        File[] files = this.baseDir.listFiles(this.filter);
        Vector<File> ret = new Vector<File>();
        ContainerUtil.addAll(ret, files);
        return ret;
    }

    Vector<File> cleanupKeepMin() {
        if (this.recurseDirs) {
            FileUtil.listFilesInTree(this.baseDir, new ListFilter(this.filter.baseFilter));
        } else {
            this.baseDir.listFiles(new ListFilter(this.filter.baseFilter));
        }
        int size = this.keep.size();
        Vector<File> processed = new Vector<File>();
        if (size > this.minKeep) {
            this.keep.sort(null);
            for (int i = this.minKeep; i < size; ++i) {
                File file = this.keep.get(i).getFile();
                FileUtil.forceDelete(file);
                processed.add(file);
            }
        }
        return processed;
    }

    public String toString() {
        return "FileJanitor [baseDir=" + this.baseDir + ", filter=" + this.filter + ", logSingle=" + this.logSingle + ", delEmpty=" + this.delEmpty + ", recurseDirs=" + this.recurseDirs + ", keep=" + this.keep + ", minKeep=" + this.minKeep + "]";
    }

    class ListFilter
    implements FileFilter {
        private final FileFilter baseFilter;

        ListFilter(FileFilter f) {
            this.baseFilter = f;
        }

        @Override
        public boolean accept(File file) {
            boolean accept = this.baseFilter.accept(file);
            if (FileJanitor.this.delEmpty && !accept && file.isDirectory() && file.list().length == 0) {
                accept = true;
            }
            if (accept) {
                this.add(file);
            }
            return accept;
        }

        private void add(File file) {
            FileJanitor.this.keep.add(new FileTime(file));
        }

        public String toString() {
            return "KillFilter [baseFilter=" + this.baseFilter + "]";
        }
    }

    class KillFilter
    implements FileFilter {
        private final FileFilter baseFilter;

        KillFilter(FileFilter f) {
            this.baseFilter = f;
        }

        @Override
        public boolean accept(File file) {
            boolean accept = this.baseFilter.accept(file);
            if (FileJanitor.this.delEmpty && !accept && file.isDirectory() && file.list().length == 0) {
                accept = true;
            }
            if (accept) {
                if (file.isDirectory() && file.list().length > 0) {
                    accept = false;
                }
                if (accept) {
                    if (FileJanitor.this.logSingle) {
                        if (file.isDirectory()) {
                            log.info((Object)("removing empty directory: " + file.getAbsolutePath() + " last touched: " + new JDFDate(file.lastModified()).getFormattedDateTime("dd MMM yyyy HH:mm")));
                        } else {
                            log.info((Object)("removing old file: " + file.getAbsolutePath() + " last touched: " + new JDFDate(file.lastModified()).getFormattedDateTime("dd MMM yyyy HH:mm") + " size=" + file.length()));
                        }
                    }
                    file.delete();
                }
            }
            return accept;
        }

        public String toString() {
            return "KillFilter [baseFilter=" + this.baseFilter + "]";
        }
    }

    static class AgeFilter
    implements FileFilter {
        final long t0 = System.currentTimeMillis();
        final long age;

        AgeFilter(long age) {
            this.age = age;
        }

        @Override
        public boolean accept(File arg0) {
            return arg0.lastModified() + this.age < this.t0;
        }

        public String toString() {
            return "AgeFilter [t0=" + new JDFDate(this.t0).getDateTimeISO() + ", age=" + new JDFDuration(this.age / 1000L).getDurationISO() + "]";
        }
    }
}

