/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.AuditPoolHelper;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFCleanupComparator;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.XJMFHelper;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.ContainerUtil;

public abstract class BaseXJDFHelper {
    protected static final Log log = LogFactory.getLog(BaseXJDFHelper.class);
    private static JDFElement.EnumVersion defaultVersion = JDFElement.EnumVersion.Version_2_2;
    protected KElement theElement;

    public static BaseXJDFHelper getBaseHelper(XMLDoc doc) {
        if (doc == null) {
            return null;
        }
        KElement root = doc.getRoot();
        return BaseXJDFHelper.getBaseHelper(root);
    }

    public static BaseXJDFHelper getBaseHelper(KElement root) {
        BaseXJDFHelper h = AuditPoolHelper.getHelper(root);
        if (h == null) {
            h = ResourceHelper.getHelper(root);
        }
        if (h == null) {
            h = SetHelper.getHelper(root);
        }
        if (h == null) {
            h = ProductHelper.getHelper(root);
        }
        if (h == null) {
            h = XJDFHelper.getHelper(root);
        }
        if (h == null) {
            h = XJMFHelper.getHelper(root);
        }
        return h;
    }

    public static JDFElement.EnumVersion getDefaultVersion() {
        return defaultVersion;
    }

    public static void setDefaultVersion(JDFElement.EnumVersion defaultVersion) {
        BaseXJDFHelper.defaultVersion = defaultVersion;
    }

    protected BaseXJDFHelper() {
        this(null);
    }

    protected BaseXJDFHelper(KElement theElement) {
        this.theElement = theElement;
    }

    public String getXPathValue(String xpath) {
        return this.theElement == null ? null : this.theElement.getXPathAttribute(xpath, null);
    }

    public KElement getXPathElement(String xpath) {
        return this.theElement == null ? null : this.theElement.getXPathElement(xpath);
    }

    public String getAttribute(String attName) {
        return this.theElement == null ? null : this.theElement.getNonEmpty(attName);
    }

    public boolean hasAttribute(String attName) {
        return this.theElement == null ? false : this.theElement.hasNonEmpty(attName);
    }

    public void removeAttribute(String attrib, String nameSpaceURI) {
        if (this.theElement != null) {
            this.theElement.removeAttribute(attrib, nameSpaceURI);
        }
    }

    public void setAttribute(String attName, String value) {
        if (this.theElement != null) {
            this.theElement.setNonEmpty(attName, value);
        }
    }

    public void setAttribute(String attName, int value) {
        this.setAttribute(attName, Integer.toString(value));
    }

    public void setXPathValue(String xpath, String value) {
        if (this.theElement != null) {
            this.theElement.setXPathValue(xpath, value);
        }
    }

    public void cleanUp() {
        XJDFCleanupComparator comparator = new XJDFCleanupComparator();
        this.theElement.sortChildren(comparator, true);
    }

    public KElement getRoot() {
        return this.theElement;
    }

    public JDFDoc getRootDoc() {
        return this.theElement == null ? null : new JDFDoc(this.theElement.getOwnerDocument());
    }

    public BaseXJDFHelper getXRoot() {
        return BaseXJDFHelper.getBaseHelper(this.theElement);
    }

    public XJDFHelper getXJDFRoot() {
        return XJDFHelper.getHelper(this.theElement);
    }

    public XJMFHelper getXJMFRoot() {
        return XJMFHelper.getHelper(this.theElement);
    }

    public JDFElement.EnumVersion getVersion() {
        BaseXJDFHelper helper = XJDFHelper.getHelper(this.theElement);
        if (helper == null) {
            helper = XJMFHelper.getHelper(this.theElement);
        }
        String v = helper == null ? null : helper.getAttribute("Version");
        return JDFElement.EnumVersion.getEnum(v);
    }

    public KElement deleteNode() {
        KElement ret = this.theElement;
        if (this.theElement != null) {
            this.theElement.deleteNode();
            this.theElement = null;
        }
        return ret;
    }

    public boolean isEqual(BaseXJDFHelper other) {
        if (this.theElement == null) {
            return other == null || other.theElement == null;
        }
        return this.theElement.isEqual(other.theElement);
    }

    public String getID() {
        return this.getAttribute("ID");
    }

    public String ensureID() {
        return this.theElement.appendAnchor(null);
    }

    public void setID(String newID) {
        this.setAttribute("ID", newID);
    }

    void setExternalID(String newID) {
        this.setAttribute("ExternalID", newID);
    }

    void setDescriptiveName(String description) {
        this.setAttribute("DescriptiveName", description);
    }

    public int hashCode() {
        int prime = 31;
        int result = 42;
        result = 31 * result + (this.theElement == null ? 0 : this.theElement.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseXJDFHelper other = (BaseXJDFHelper)obj;
        return ContainerUtil.equals(this.theElement, other.theElement);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.theElement;
    }

    public KElement appendElement(String elementName) {
        return this.theElement == null ? null : this.theElement.appendElement(elementName);
    }

    public KElement copyHelper(BaseXJDFHelper src) {
        return this.theElement == null || src == null ? null : this.theElement.copyElement(src.getRoot(), null);
    }

    public KElement getCreateElement(String nodeName) {
        return this.theElement == null ? null : this.theElement.getCreateElement(nodeName);
    }

    public String getLocalName() {
        return this.theElement == null ? null : this.theElement.getLocalName();
    }

    JDFGeneralID setGeneralID(String idUsage, String idValue) {
        if (this.theElement instanceof JDFElement) {
            return ((JDFElement)this.theElement).setGeneralID(idUsage, idValue);
        }
        return null;
    }

    public String getGeneralID(String idUsage) {
        if (this.theElement instanceof JDFElement) {
            return ((JDFElement)this.theElement).getGeneralID(idUsage, 0);
        }
        return null;
    }

    public String getComment(int i) {
        KElement root = this.getRoot();
        KElement c = root == null ? null : root.getElement("Comment", null, i);
        return c == null ? null : c.getText();
    }

    public JDFComment setComment(String text) {
        KElement root = this.getRoot();
        if (root != null) {
            if (text == null) {
                root.removeChildren("Comment", null, null);
            } else {
                JDFComment c = (JDFComment)root.getCreateElement("Comment");
                c.setText(text);
                return c;
            }
        }
        return null;
    }

    public String getExternalID() {
        return this.getAttribute("ExternalID");
    }

    public String getDescriptiveName() {
        return this.getAttribute("DescriptiveName");
    }

    public JDFAttributeMap getAttributeMap() {
        return this.theElement == null ? null : this.theElement.getAttributeMap();
    }

    public KElement appendElement(String elementName, String nameSpaceURI) {
        return this.theElement == null ? null : this.theElement.appendElement(elementName, nameSpaceURI);
    }
}

