/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.HashSet;
import org.cip4.jdflib.auto.JDFAutoGeneralID;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAncestorPool;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.StringUtil;

public class WalkJDF
extends WalkJDFElement {
    private final HashSet<String> deprecatedTypes = new HashSet();
    private final HashSet<String> looseBindingTypes;

    public WalkJDF() {
        this.deprecatedTypes.add(JDFNode.EnumType.Buffer.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.Combine.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.Dividing.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.Ordering.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.Packing.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.ResourceDefinition.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.Split.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.AssetListCreation.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.ContactCopying.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.ContoneCalibration.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.CylinderLayoutPreparation.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.DBDocTemplateLayout.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.DBTemplateMerging.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.DigitalDelivery.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.ImageReplacement.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.PageAssigning.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.PDFToPSConversion.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.Proofing.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.PSToPDFConversion.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.ResourceDefinition.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.Scanning.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.StaticBlocking.getName());
        this.deprecatedTypes.add(JDFNode.EnumType.Tiling.getName());
        this.looseBindingTypes = new HashSet();
        this.looseBindingTypes.add(JDFNode.EnumType.ChannelBinding.getName());
        this.looseBindingTypes.add(JDFNode.EnumType.CoilBinding.getName());
        this.looseBindingTypes.add(JDFNode.EnumType.PlasticCombBinding.getName());
        this.looseBindingTypes.add(JDFNode.EnumType.RingBinding.getName());
        this.looseBindingTypes.add(JDFNode.EnumType.StripBinding.getName());
        this.looseBindingTypes.add(JDFNode.EnumType.WireCombBinding.getName());
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        jdf.appendAnchor(null);
        if (this.jdfToXJDF.first.contains(jdf.getID()) || this.jdfToXJDF.isSingleNode() && this.jdfToXJDF.first.size() > 0) {
            return null;
        }
        JDFNode node = (JDFNode)jdf;
        boolean matchesID = this.matchesRootID(node);
        if (matchesID) {
            this.prepareRoot(node, xjdf);
            this.jdfToXJDF.first.add(jdf.getID());
            return xjdf;
        }
        JDFNode nodeKid = node.getChildJDFNode(this.jdfToXJDF.rootID, false);
        if (nodeKid != null && !nodeKid.equals(jdf)) {
            this.jdfToXJDF.walkTree(nodeKid, xjdf);
        }
        return null;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFNode;
    }

    void prepareRoot(JDFNode node, KElement newRootP) {
        if (JDFNode.EnumType.Product.equals((Object)node.getEnumType()) && node.getParentJDF() != null && !this.jdfToXJDF.first.isEmpty()) {
            return;
        }
        JDFNodeInfo ni = node.getCreateNodeInfo();
        VElement niLeaves = ni.getLeaves(false);
        for (KElement leaf : niLeaves) {
            JDFNodeInfo niLeaf = (JDFNodeInfo)leaf;
            JDFAttributeMap map = niLeaf.getPartMap();
            niLeaf.setNodeStatus(node.getPartStatus(map, 0));
            niLeaf.setNodeStatusDetails(StringUtil.getNonEmpty(node.getPartStatusDetails(map)));
        }
        if (this.jdfToXJDF.rootID.equals(node.getID())) {
            this.setRootAttributes(node, newRootP);
        } else {
            this.updateTypes(newRootP, node.getTypesString());
        }
    }

    private void setRootAttributes(JDFNode node, KElement newRootP) {
        newRootP.setXMLComment("JDFToXJDF version: using: " + JDFAudit.getStaticAgentName() + " " + JDFAudit.getStaticAgentVersion(), true);
        this.setAttributes(node, newRootP);
        this.prepareRootMap(node, newRootP);
        this.removeUnusedElements(newRootP);
        if (this.jdfToXJDF.isUpdateVersion()) {
            newRootP.setID(null);
            newRootP.setAttribute("Version", this.jdfToXJDF.getNewVersion().getName());
        }
        this.updateTypes(newRootP, node.getTypesString());
        this.namedFeaturesToGeneralID(node, newRootP);
        this.updateSpawnInfo(node, newRootP);
        JDFNode parentProduct = node.getParentProduct();
        if (parentProduct != null && parentProduct != node && parentProduct != node.getJDFRoot()) {
            newRootP.setAttribute("ParentID", parentProduct.getJobPartID(false));
        }
    }

    void prepareRootMap(JDFNode node, KElement newRootP) {
        newRootP.setAttribute("JobID", node.getJobID(true));
    }

    private void namedFeaturesToGeneralID(JDFNode node, KElement newRootP) {
        if (node.hasAttribute("NamedFeatures")) {
            VString vnf = node.getNamedFeatures();
            for (int i = 0; i < vnf.size(); i += 2) {
                JDFGeneralID gi = (JDFGeneralID)newRootP.appendElement("GeneralID");
                gi.setIDUsage(vnf.get(i));
                gi.setIDValue(vnf.get(i + 1));
                gi.setDataType(JDFAutoGeneralID.EnumDataType.NMTOKEN);
                gi.setDescriptiveName("Copy from NamedFeatures");
            }
            newRootP.removeAttribute("NamedFeatures");
        }
    }

    void updateTypes(KElement newRootP, String types) {
        if (newRootP.hasAttribute("Types")) {
            newRootP.removeAttribute("Type");
        } else {
            newRootP.renameAttribute("Type", "Types", null, null);
        }
        VString t2 = StringUtil.tokenize(types, null, false);
        VString t1 = StringUtil.tokenize(newRootP.getAttribute("Types"), null, false);
        if (t2 != null) {
            for (String t : t2) {
                t1.appendUnique(t);
            }
        }
        t1.removeStrings("ProcessGroup", 0);
        t1.removeStrings("Combined", 0);
        this.removeDeprecatedTypes(t1);
        if (t1.isEmpty()) {
            t1.add("Product");
        }
        newRootP.setAttribute("Types", t1, (String)null);
    }

    void removeDeprecatedTypes(VString t1) {
        for (int i = t1.size() - 1; i >= 0; --i) {
            String typ = t1.get(i);
            if (this.isDeprecatedType(typ)) {
                t1.setElementAt(JDFNode.EnumType.ManualLabor.getName(), i);
                continue;
            }
            if (!this.looseBindingTypes.contains(typ)) continue;
            t1.setElementAt("LooseBinding", i);
        }
    }

    private boolean isDeprecatedType(String typ) {
        return this.deprecatedTypes.contains(typ);
    }

    private void updateSpawnInfo(JDFNode node, KElement newRootP) {
        if (this.jdfToXJDF.isRetainSpawnInfo() && newRootP.hasAttribute("SpawnID")) {
            VJDFAttributeMap vParts;
            KElement spawnInfo = newRootP.appendElement("SpawnInfo", "www.cip4.org/SpawnInfo");
            spawnInfo.moveAttribute("SpawnID", newRootP, null, null, null);
            JDFAncestorPool ancestorPool = node.getAncestorPool();
            if (ancestorPool != null && (vParts = ancestorPool.getPartMapVector()) != null) {
                int size = vParts.size();
                for (int i = 0; i < size; ++i) {
                    KElement part = spawnInfo.appendElement("Part");
                    part.setAttributes(vParts.elementAt(i));
                }
            }
        }
    }

    @Override
    protected void updateAttributes(JDFAttributeMap map) {
        map.remove("Activation");
        map.remove("AgentVersion");
        map.remove("MaxVersion");
        map.remove("Status");
        map.remove("StatusDetails");
        map.remove("Template");
        map.remove("TemplateID");
        map.remove("TemplateVersion");
        map.remove("Version");
        map.remove("xmlns");
        map.remove("xsi:type");
        super.updateAttributes(map);
    }
}

