/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.ContainerUtil;

class PartitionMap {
    private final HashMap<JDFAttributeMap, JDFResource> leafMap;
    private final List<String> partIDKeys;

    PartitionMap(JDFResource r) {
        StringArray partIDKeyList = r.getPartIDKeyList();
        this.partIDKeys = partIDKeyList == null ? new StringArray() : partIDKeyList;
        this.leafMap = new LinkedHashMap<JDFAttributeMap, JDFResource>();
        this.addPartitionMap(new JDFAttributeMap(), r.getResourceRoot());
    }

    void addPartitionMap(JDFAttributeMap parentMap, JDFResource parent) {
        List<? extends KElement> v;
        this.leafMap.put(parentMap, parent);
        String key = this.partIDKeys.get(parentMap.size());
        List<? extends KElement> list = v = key == null ? null : parent.getDirectPartitionArray();
        if (v != null && !v.isEmpty()) {
            for (KElement kElement : v) {
                JDFResource r = (JDFResource)kElement;
                JDFAttributeMap newMap = parentMap.clone();
                String val = r.getNonEmpty_KElement(key);
                if (val == null) continue;
                newMap.put(key, val);
                this.addPartitionMap(newMap, r);
            }
        }
    }

    JDFResource get(JDFAttributeMap arg0) {
        return this.leafMap.get(arg0);
    }

    Set<JDFAttributeMap> keySet() {
        return this.leafMap.keySet();
    }

    List<String> getPartIDKeys() {
        return this.partIDKeys;
    }

    boolean hasMissingKeys(JDFAttributeMap m) {
        int s = m.size();
        if (s == 0) {
            return false;
        }
        for (String k : this.partIDKeys) {
            if (!m.containsKey(k)) {
                return true;
            }
            if (--s != 0) continue;
            return false;
        }
        return false;
    }

    JDFResource put(JDFAttributeMap arg0, JDFResource arg1) {
        return this.leafMap.put(arg0, arg1);
    }

    void setPartIDKeys(List<String> vPartIDKeys) {
        this.partIDKeys.clear();
        ContainerUtil.addAll(this.partIDKeys, vPartIDKeys);
    }

    HashMap<JDFAttributeMap, JDFResource> getLeafMap() {
        return this.leafMap;
    }

    public String toString() {
        return "PartitionMap [leafMap=" + this.leafMap + ", partIDKeys=" + this.partIDKeys + "]";
    }

    int size() {
        return this.leafMap.size();
    }

    int partSize() {
        return this.partIDKeys.size();
    }

    public JDFResource remove(JDFAttributeMap key) {
        return this.leafMap.remove(key);
    }

    List<JDFAttributeMap> keyVector() {
        return ContainerUtil.getKeyList(this.leafMap);
    }
}

