/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process.postpress;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoFoldingParams;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFFoldingParams
extends JDFAutoFoldingParams {
    private static final long serialVersionUID = 1L;

    public JDFFoldingParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFFoldingParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFFoldingParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFFoldingParams[  --> " + super.toString() + " ]";
    }

    public static String getCatalog(int pages, int index) {
        return "F" + pages + "-" + index;
    }

    public static JDFXYPair getNumUpFromCatalog(String foldCatalog) {
        JDFXYPair xyFold = JDFFoldingParams.getCatalogXY(foldCatalog);
        if (xyFold == null) {
            return null;
        }
        int p = (int)xyFold.getX();
        int i = (int)xyFold.getY();
        if (i <= JDFFoldingParams.getMax(p)) {
            int y = JDFFoldingParams.getY(p, i);
            return new JDFXYPair(p / (y * 2), y);
        }
        return null;
    }

    static int getY(int p, int i) {
        if (JDFFoldingParams.isWrap(p, i)) {
            return 1;
        }
        if (JDFFoldingParams.is2Y(p, i)) {
            return 2;
        }
        if (JDFFoldingParams.is3Y(p, i)) {
            return 3;
        }
        if (JDFFoldingParams.is4Y(p, i)) {
            return 4;
        }
        return 6;
    }

    static int getMax(int p) {
        if (p < 2 || p % 2 != 0 || p > 64) {
            return 0;
        }
        switch (p) {
            case 2: 
            case 14: 
            case 28: 
            case 40: {
                return 1;
            }
            case 4: 
            case 20: 
            case 36: 
            case 48: 
            case 64: {
                return 2;
            }
            case 6: {
                return 8;
            }
            case 8: {
                return 7;
            }
            case 10: {
                return 3;
            }
            case 12: 
            case 16: {
                return 14;
            }
            case 18: 
            case 32: {
                return 9;
            }
            case 24: {
                return 11;
            }
        }
        return 0;
    }

    static boolean isWrap(int p, int i) {
        return p <= 6 || p == 8 && i <= 6 || p == 10 || p == 12 && i <= 6 || p == 14 || p == 16 && i <= 5 || p == 18 && i <= 4 || p == 32 && i <= 1;
    }

    static boolean is2Y(int p, int i) {
        return p == 8 && i >= 7 || p == 12 && i >= 6 && i <= 11 || p == 16 && i >= 6 && i <= 12 || p == 20 || p == 24 && i <= 7 || p == 28 || p == 32 && i >= 2 && i <= 3 || p == 36 && i <= 1;
    }

    static boolean is3Y(int p, int i) {
        return p == 12 && i >= 12 || p == 18 && i >= 5 || p == 24 && i >= 11 || p == 36 && i >= 2;
    }

    static boolean is4Y(int p, int i) {
        return p == 16 && i >= 13 || p == 24 && i >= 8 && i <= 10 || p == 32 && i >= 4 || p == 40 || p == 48 && i <= 1 || p == 64;
    }

    static boolean is6Y(int p, int i) {
        return p == 48 && i >= 2;
    }

    public static JDFXYPair getCatalogXY(String foldCatalog) {
        String pi0 = StringUtil.rightStr(foldCatalog, -1);
        VString v = StringUtil.tokenize(pi0, "-", false);
        if (ContainerUtil.size(v) == 2) {
            int p = StringUtil.parseInt(v.get(0), -1);
            int i = StringUtil.parseInt(v.get(1), -1);
            return i > 0 && p > 0 ? new JDFXYPair(p, i) : null;
        }
        return null;
    }

    public void setFoldCatalog(int pages, int index) {
        this.setFoldCatalog(JDFFoldingParams.getCatalog(pages, index));
    }

    @Override
    public VString getInvalidAttributes(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        String fc;
        VString invalidAttributes = super.getInvalidAttributes(level, bIgnorePrivate, nMax);
        if (!bIgnorePrivate && !StringUtil.isEmpty(fc = this.getFoldCatalog()) && JDFFoldingParams.getNumUpFromCatalog(fc) == null) {
            invalidAttributes.appendUnique("FoldCatalog");
        }
        return invalidAttributes;
    }
}

