/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.file.FileTime;
import org.cip4.jdflib.util.thread.DelayedPersist;
import org.cip4.jdflib.util.thread.IPersistable;

public class BackupDirectory
extends File
implements IPersistable {
    private final int nBackup;
    private boolean isDirectory;
    private static final long serialVersionUID = 1521423479898L;

    public BackupDirectory(String pathname, int nBackupp) {
        this(new File(pathname), nBackupp);
    }

    public BackupDirectory(File file, int nBackupp) throws IllegalArgumentException {
        super(file.getPath());
        this.nBackup = nBackupp;
        if (!this.isDirectory()) {
            this.mkdirs();
        }
        if (!this.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory");
        }
        this.isDirectory = false;
    }

    public File getNewFile(File localFile) {
        boolean ok;
        File file = FileUtil.getFileInDirectory(this, localFile);
        if (file.exists()) {
            FileUtil.forceDelete(file);
        } else {
            DelayedPersist.getDelayedPersist().queue(this, 42000L);
        }
        if (this.isDirectory) {
            ok = file.mkdirs();
        } else {
            try {
                ok = file.createNewFile();
            }
            catch (IOException x) {
                return null;
            }
        }
        return ok ? file : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        File[] all;
        BackupDirectory backupDirectory = this;
        synchronized (backupDirectory) {
            all = this.listFiles();
        }
        if (all != null && all.length >= this.nBackup) {
            int i;
            Object[] time = new FileTime[all.length];
            for (i = 0; i < all.length; ++i) {
                time[i] = new FileTime(all[i]);
            }
            Arrays.sort(time);
            for (i = this.nBackup; i < all.length; ++i) {
                FileUtil.forceDelete(((FileTime)time[i]).getFile());
            }
        }
    }

    public File getNewFile(String fileName) {
        return fileName == null ? null : this.getNewFile(new File(fileName));
    }

    @Override
    public String toString() {
        return super.toString() + "isDir=" + this.isDirectory + " nBackup=" + this.nBackup;
    }

    @Override
    public boolean persist() {
        this.clean();
        return true;
    }

    public boolean isCreateDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }
}

