package org.cip4.jdflib.util.hotfolder;

import java.io.File;

import org.cip4.jdflib.core.JDFConstants;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.JDFDate;

/*
 *
 * The CIP4 Software License, Version 1.0
 *
 *
 * Copyright (c) 2001-2023 The International Cooperation for the Integration of Processes in Prepress, Press and Postpress (CIP4). All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the
 * distribution.
 *
 * 3. The end-user documentation included with the redistribution, if any, must include the following acknowledgment: "This product includes software developed by the The International Cooperation for
 * the Integration of Processes in Prepress, Press and Postpress (www.cip4.org)" Alternately, this acknowledgment may appear in the software itself, if and wherever such third-party acknowledgments
 * normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of Processes in Prepress, Press and Postpress" must not be used to endorse or promote products derived from this software
 * without prior written permission. For written permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4", nor may "CIP4" appear in their name, without prior written permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For details please consult info@cip4.org.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE. ====================================================================
 *
 * This software consists of voluntary contributions made by many individuals on behalf of the The International Cooperation for the Integration of Processes in Prepress, Press and Postpress and was
 * originally based on software copyright (c) 1999-2001, Heidelberger Druckmaschinen AG copyright (c) 1999-2001, Agfa-Gevaert N.V.
 *
 * For more information on The International Cooperation for the Integration of Processes in Prepress, Press and Postpress , please see <http://www.cip4.org/>.
 *
 *
 */
/**
 * simple container class that retains the last known mod date of a file
 *
 * @author prosirai
 *
 */
class FileTime
{
	protected final File f;
	protected long modified;
	protected long length;
	private final boolean readOnly;

	protected FileTime(final File _f, final boolean readOnly)
	{
		f = _f;
		modified = -1;
		length = -1;
		this.readOnly = readOnly;
		if (readOnly)
			updateModified();
	}

	protected long updateModified()
	{
		modified = (modified <= 0) ? System.currentTimeMillis() : Math.max(modified, lastModified());
		length = lastLength();
		return modified;
	}

	protected boolean exists()
	{
		return f == null ? false : f.exists();
	}

	protected boolean sameModified()
	{
		final long lastModified = lastModified();
		final long lastLength = lastLength();
		return lastModified > 0 && modified >= lastModified && lastLength >= 0 && length == lastLength;
	}

	protected long lastModified()
	{
		if (f == null || readOnly && !f.canWrite())
			return 0;
		else if (FileUtil.isLocked(f))
			return System.currentTimeMillis();
		else
			return f.lastModified();
	}

	protected long lastLength()
	{
		return ((f == null) || !readOnly && !f.canWrite()) ? -1 : f.length();
	}

	@Override
	public String toString()
	{
		return f + JDFConstants.BLANK + (modified > 0 ? new JDFDate(modified).getDateTimeISO() : "never") + " l=" + length;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + ((f == null) ? 0 : f.hashCode());
		return result;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj)
	{
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final FileTime other = (FileTime) obj;
		if (f == null)
		{
			if (other.f != null)
				return false;
		}
		else if (!f.equals(other.f))
			return false;
		return true;
	}
}