/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.resource.JDFInspection;
import org.cip4.jdflib.resource.JDFRegistrationQuality;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFBindingQualityParams;
import org.cip4.jdflib.resource.process.JDFFileSpec;
import org.cip4.jdflib.resource.process.JDFQualityMeasurement;
import org.cip4.jdflib.util.JDFDate;

public abstract class JDFAutoQualityControlResult
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[11];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoQualityControlResult(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoQualityControlResult(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoQualityControlResult(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Parameter);
        return bRet;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Parameter;
    }

    public void setBox(JDFRectangle value) {
        this.setAttribute("Box", (JDFNumList)value, (String)null);
    }

    public JDFRectangle getBox() {
        String strAttrName = this.getAttribute("Box", null, null);
        JDFRectangle nPlaceHolder = JDFRectangle.createRectangle(strAttrName);
        return nPlaceHolder;
    }

    public void setEnd(JDFDate value) {
        JDFDate date = value;
        if (date == null) {
            date = new JDFDate();
        }
        this.setAttribute("End", date.getDateTimeISO(), null);
    }

    public JDFDate getEnd() {
        String str = this.getAttribute("End", null, null);
        JDFDate ret = JDFDate.createDate(str);
        return ret;
    }

    public void setFailed(int value) {
        this.setAttribute("Failed", value, (String)null);
    }

    public int getFailed() {
        return this.getIntAttribute("Failed", null, 0);
    }

    public void setMeasurements(int value) {
        this.setAttribute("Measurements", value, (String)null);
    }

    public int getMeasurements() {
        return this.getIntAttribute("Measurements", null, 0);
    }

    public void setMeasurementUsage(Vector<? extends ValuedEnum> v) {
        this.setEnumerationsAttribute("MeasurementUsage", v, null);
    }

    public Vector<? extends ValuedEnum> getMeasurementUsage() {
        return this.getEnumerationsAttribute("MeasurementUsage", null, EnumMeasurementUsage.getEnum(0), false);
    }

    public void setPosition(EnumPosition enumVar) {
        this.setAttribute("Position", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumPosition getPosition() {
        return EnumPosition.getEnum(this.getAttribute("Position", null, null));
    }

    public void setPassed(int value) {
        this.setAttribute("Passed", value, (String)null);
    }

    public int getPassed() {
        return this.getIntAttribute("Passed", null, 0);
    }

    public void setSample(JDFIntegerRange value) {
        this.setAttribute("Sample", value, null);
    }

    public JDFIntegerRange getSample() {
        String strAttrName = this.getAttribute("Sample", null, null);
        JDFIntegerRange nPlaceHolder = JDFIntegerRange.createIntegerRange(strAttrName);
        return nPlaceHolder;
    }

    public void setSeverity(int value) {
        this.setAttribute("Severity", value, (String)null);
    }

    public int getSeverity() {
        return this.getIntAttribute("Severity", null, 0);
    }

    public void setSourceDeviceID(String value) {
        this.setAttribute("SourceDeviceID", value, null);
    }

    public String getSourceDeviceID() {
        return this.getAttribute("SourceDeviceID", null, "");
    }

    public void setStart(JDFDate value) {
        JDFDate date = value;
        if (date == null) {
            date = new JDFDate();
        }
        this.setAttribute("Start", date.getDateTimeISO(), null);
    }

    public JDFDate getStart() {
        String str = this.getAttribute("Start", null, null);
        JDFDate ret = JDFDate.createDate(str);
        return ret;
    }

    public JDFBindingQualityParams getBindingQualityParams() {
        return (JDFBindingQualityParams)this.getElement("BindingQualityParams", null, 0);
    }

    public JDFBindingQualityParams getCreateBindingQualityParams() {
        return (JDFBindingQualityParams)this.getCreateElement_JDFElement("BindingQualityParams", null, 0);
    }

    public JDFBindingQualityParams appendBindingQualityParams() {
        return (JDFBindingQualityParams)this.appendElementN("BindingQualityParams", 1, null);
    }

    public JDFFileSpec getFileSpec() {
        return (JDFFileSpec)this.getElement("FileSpec", null, 0);
    }

    public JDFFileSpec getCreateFileSpec() {
        return (JDFFileSpec)this.getCreateElement_JDFElement("FileSpec", null, 0);
    }

    public JDFFileSpec appendFileSpec() {
        return (JDFFileSpec)this.appendElementN("FileSpec", 1, null);
    }

    public void refFileSpec(JDFFileSpec refTarget) {
        this.refElement(refTarget);
    }

    public JDFInspection getInspection() {
        return (JDFInspection)this.getElement("Inspection", null, 0);
    }

    public JDFInspection getCreateInspection() {
        return (JDFInspection)this.getCreateElement_JDFElement("Inspection", null, 0);
    }

    public JDFInspection appendInspection() {
        return (JDFInspection)this.appendElementN("Inspection", 1, null);
    }

    public JDFQualityMeasurement getCreateQualityMeasurement(int iSkip) {
        return (JDFQualityMeasurement)this.getCreateElement_JDFElement("QualityMeasurement", null, iSkip);
    }

    public JDFQualityMeasurement getQualityMeasurement(int iSkip) {
        return (JDFQualityMeasurement)this.getElement("QualityMeasurement", null, iSkip);
    }

    public Collection<JDFQualityMeasurement> getAllQualityMeasurement() {
        return this.getChildArrayByClass(JDFQualityMeasurement.class, false, 0);
    }

    public JDFQualityMeasurement appendQualityMeasurement() {
        return (JDFQualityMeasurement)this.appendElement("QualityMeasurement", null);
    }

    public JDFRegistrationQuality getRegistrationQuality() {
        return (JDFRegistrationQuality)this.getElement("RegistrationQuality", null, 0);
    }

    public JDFRegistrationQuality getCreateRegistrationQuality() {
        return (JDFRegistrationQuality)this.getCreateElement_JDFElement("RegistrationQuality", null, 0);
    }

    public JDFRegistrationQuality appendRegistrationQuality() {
        return (JDFRegistrationQuality)this.appendElementN("RegistrationQuality", 1, null);
    }

    static {
        JDFAutoQualityControlResult.atrInfoTable[0] = new AtrInfoTable("Box", 0x3331111111L, AttributeInfo.EnumAttributeType.rectangle, null, null);
        JDFAutoQualityControlResult.atrInfoTable[1] = new AtrInfoTable("End", 0x3333111111L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFAutoQualityControlResult.atrInfoTable[2] = new AtrInfoTable("Failed", 0x3333333311L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoQualityControlResult.atrInfoTable[3] = new AtrInfoTable("Measurements", 0x3331111111L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoQualityControlResult.atrInfoTable[4] = new AtrInfoTable("MeasurementUsage", 0x3333333311L, AttributeInfo.EnumAttributeType.enumerations, EnumMeasurementUsage.getEnum(0), null);
        JDFAutoQualityControlResult.atrInfoTable[5] = new AtrInfoTable("Position", 0x3331111111L, AttributeInfo.EnumAttributeType.enumeration, EnumPosition.getEnum(0), null);
        JDFAutoQualityControlResult.atrInfoTable[6] = new AtrInfoTable("Passed", 0x3333333311L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoQualityControlResult.atrInfoTable[7] = new AtrInfoTable("Sample", 0x3331111111L, AttributeInfo.EnumAttributeType.IntegerRange, null, null);
        JDFAutoQualityControlResult.atrInfoTable[8] = new AtrInfoTable("Severity", 0x3331111111L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoQualityControlResult.atrInfoTable[9] = new AtrInfoTable("SourceDeviceID", 0x3331111111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoQualityControlResult.atrInfoTable[10] = new AtrInfoTable("Start", 0x3333111111L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        elemInfoTable = new ElemInfoTable[5];
        JDFAutoQualityControlResult.elemInfoTable[0] = new ElemInfoTable("BindingQualityParams", 0x6666666611L);
        JDFAutoQualityControlResult.elemInfoTable[1] = new ElemInfoTable("FileSpec", 0x6666666611L);
        JDFAutoQualityControlResult.elemInfoTable[2] = new ElemInfoTable("Inspection", 0x6666666611L);
        JDFAutoQualityControlResult.elemInfoTable[3] = new ElemInfoTable("QualityMeasurement", 0x3333333311L);
        JDFAutoQualityControlResult.elemInfoTable[4] = new ElemInfoTable("RegistrationQuality", 0x6666666611L);
    }

    public static class EnumPosition
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPosition Top = new EnumPosition("Top");
        public static final EnumPosition Bottom = new EnumPosition("Bottom");
        public static final EnumPosition Left = new EnumPosition("Left");
        public static final EnumPosition Right = new EnumPosition("Right");
        public static final EnumPosition Front = new EnumPosition("Front");
        public static final EnumPosition Back = new EnumPosition("Back");

        protected EnumPosition(String name) {
            super(name, m_startValue++);
        }

        public static EnumPosition getEnum(String enumName) {
            return (EnumPosition)EnumPosition.getEnum(EnumPosition.class, (String)enumName);
        }

        public static EnumPosition getEnum(int enumValue) {
            return (EnumPosition)EnumPosition.getEnum(EnumPosition.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumPosition.getEnumMap(EnumPosition.class);
        }

        public static List getEnumList() {
            return EnumPosition.getEnumList(EnumPosition.class);
        }

        public static Iterator iterator() {
            return EnumPosition.iterator(EnumPosition.class);
        }
    }

    public static class EnumMeasurementUsage
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumMeasurementUsage Master = new EnumMeasurementUsage("Master");
        public static final EnumMeasurementUsage Standard = new EnumMeasurementUsage("Standard");

        protected EnumMeasurementUsage(String name) {
            super(name, m_startValue++);
        }

        public static EnumMeasurementUsage getEnum(String enumName) {
            return (EnumMeasurementUsage)EnumMeasurementUsage.getEnum(EnumMeasurementUsage.class, (String)enumName);
        }

        public static EnumMeasurementUsage getEnum(int enumValue) {
            return (EnumMeasurementUsage)EnumMeasurementUsage.getEnum(EnumMeasurementUsage.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumMeasurementUsage.getEnumMap(EnumMeasurementUsage.class);
        }

        public static List getEnumList() {
            return EnumMeasurementUsage.getEnumList(EnumMeasurementUsage.class);
        }

        public static Iterator iterator() {
            return EnumMeasurementUsage.iterator(EnumMeasurementUsage.class);
        }
    }
}

