/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.process.JDFTIFFEmbeddedFile;
import org.cip4.jdflib.resource.process.JDFTIFFtag;

public abstract class JDFAutoTIFFFormatParams
extends JDFElement {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[7];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoTIFFFormatParams(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoTIFFFormatParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoTIFFFormatParams(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public void setByteOrder(EnumByteOrder enumVar) {
        this.setAttribute("ByteOrder", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumByteOrder getByteOrder() {
        return EnumByteOrder.getEnum(this.getAttribute("ByteOrder", null, null));
    }

    public void setInterleaving(int value) {
        this.setAttribute("Interleaving", value, (String)null);
    }

    public int getInterleaving() {
        return this.getIntAttribute("Interleaving", null, 1);
    }

    public void setWhiteIsZero(boolean value) {
        this.setAttribute("WhiteIsZero", value, null);
    }

    public boolean getWhiteIsZero() {
        return this.getBoolAttribute("WhiteIsZero", null, true);
    }

    public void setSegmentation(EnumSegmentation enumVar) {
        this.setAttribute("Segmentation", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumSegmentation getSegmentation() {
        return EnumSegmentation.getEnum(this.getAttribute("Segmentation", null, null));
    }

    public void setRowsPerStrip(int value) {
        this.setAttribute("RowsPerStrip", value, (String)null);
    }

    public int getRowsPerStrip() {
        return this.getIntAttribute("RowsPerStrip", null, 0);
    }

    public void setTileSize(JDFXYPair value) {
        this.setAttribute("TileSize", (JDFNumList)value, (String)null);
    }

    public JDFXYPair getTileSize() {
        String strAttrName = this.getAttribute("TileSize", null, null);
        JDFXYPair nPlaceHolder = JDFXYPair.createXYPair(strAttrName);
        return nPlaceHolder;
    }

    public void setSeparationNameTag(int value) {
        this.setAttribute("SeparationNameTag", value, (String)null);
    }

    public int getSeparationNameTag() {
        return this.getIntAttribute("SeparationNameTag", null, 270);
    }

    public JDFTIFFtag getCreateTIFFtag(int iSkip) {
        return (JDFTIFFtag)this.getCreateElement_JDFElement("TIFFtag", null, iSkip);
    }

    public JDFTIFFtag getTIFFtag(int iSkip) {
        return (JDFTIFFtag)this.getElement("TIFFtag", null, iSkip);
    }

    public Collection<JDFTIFFtag> getAllTIFFtag() {
        return this.getChildArrayByClass(JDFTIFFtag.class, false, 0);
    }

    public JDFTIFFtag appendTIFFtag() {
        return (JDFTIFFtag)this.appendElement("TIFFtag", null);
    }

    public JDFTIFFEmbeddedFile getCreateTIFFEmbeddedFile(int iSkip) {
        return (JDFTIFFEmbeddedFile)this.getCreateElement_JDFElement("TIFFEmbeddedFile", null, iSkip);
    }

    public JDFTIFFEmbeddedFile getTIFFEmbeddedFile(int iSkip) {
        return (JDFTIFFEmbeddedFile)this.getElement("TIFFEmbeddedFile", null, iSkip);
    }

    public Collection<JDFTIFFEmbeddedFile> getAllTIFFEmbeddedFile() {
        return this.getChildArrayByClass(JDFTIFFEmbeddedFile.class, false, 0);
    }

    public JDFTIFFEmbeddedFile appendTIFFEmbeddedFile() {
        return (JDFTIFFEmbeddedFile)this.appendElement("TIFFEmbeddedFile", null);
    }

    static {
        JDFAutoTIFFFormatParams.atrInfoTable[0] = new AtrInfoTable("ByteOrder", 0x4444433311L, AttributeInfo.EnumAttributeType.enumeration, EnumByteOrder.getEnum(0), null);
        JDFAutoTIFFFormatParams.atrInfoTable[1] = new AtrInfoTable("Interleaving", 0x4444433311L, AttributeInfo.EnumAttributeType.integer, null, "1");
        JDFAutoTIFFFormatParams.atrInfoTable[2] = new AtrInfoTable("WhiteIsZero", 0x4444433311L, AttributeInfo.EnumAttributeType.boolean_, null, "true");
        JDFAutoTIFFFormatParams.atrInfoTable[3] = new AtrInfoTable("Segmentation", 0x4444433311L, AttributeInfo.EnumAttributeType.enumeration, EnumSegmentation.getEnum(0), null);
        JDFAutoTIFFFormatParams.atrInfoTable[4] = new AtrInfoTable("RowsPerStrip", 0x4444433311L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoTIFFFormatParams.atrInfoTable[5] = new AtrInfoTable("TileSize", 0x4444433311L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFAutoTIFFFormatParams.atrInfoTable[6] = new AtrInfoTable("SeparationNameTag", 0x4444433311L, AttributeInfo.EnumAttributeType.integer, null, "270");
        elemInfoTable = new ElemInfoTable[2];
        JDFAutoTIFFFormatParams.elemInfoTable[0] = new ElemInfoTable("TIFFtag", 0x4444433331L);
        JDFAutoTIFFFormatParams.elemInfoTable[1] = new ElemInfoTable("TIFFEmbeddedFile", 0x4444433331L);
    }

    public static class EnumSegmentation
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumSegmentation SingleStrip = new EnumSegmentation("SingleStrip");
        public static final EnumSegmentation Stripped = new EnumSegmentation("Stripped");
        public static final EnumSegmentation Tiled = new EnumSegmentation("Tiled");

        protected EnumSegmentation(String name) {
            super(name, m_startValue++);
        }

        public static EnumSegmentation getEnum(String enumName) {
            return (EnumSegmentation)EnumSegmentation.getEnum(EnumSegmentation.class, (String)enumName);
        }

        public static EnumSegmentation getEnum(int enumValue) {
            return (EnumSegmentation)EnumSegmentation.getEnum(EnumSegmentation.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumSegmentation.getEnumMap(EnumSegmentation.class);
        }

        public static List getEnumList() {
            return EnumSegmentation.getEnumList(EnumSegmentation.class);
        }

        public static Iterator iterator() {
            return EnumSegmentation.iterator(EnumSegmentation.class);
        }
    }

    public static class EnumByteOrder
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumByteOrder II = new EnumByteOrder("II");
        public static final EnumByteOrder MM = new EnumByteOrder("MM");

        protected EnumByteOrder(String name) {
            super(name, m_startValue++);
        }

        public static EnumByteOrder getEnum(String enumName) {
            return (EnumByteOrder)EnumByteOrder.getEnum(EnumByteOrder.class, (String)enumName);
        }

        public static EnumByteOrder getEnum(int enumValue) {
            return (EnumByteOrder)EnumByteOrder.getEnum(EnumByteOrder.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumByteOrder.getEnumMap(EnumByteOrder.class);
        }

        public static List getEnumList() {
            return EnumByteOrder.getEnumList(EnumByteOrder.class);
        }

        public static Iterator iterator() {
            return EnumByteOrder.iterator(EnumByteOrder.class);
        }
    }
}

