/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.cformat;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.cip4.jdflib.cformat.ScanfFormat;
import org.cip4.jdflib.cformat.ScanfMatchException;

@Deprecated
public class ScanfReader
extends Reader {
    private static String hexChars = "0123456789abcdefABCDEF";
    private static String octChars = "01234567";
    private static final int BUFSIZE = 1024;
    private static ScanfFormat defaultDoubleFmt = new ScanfFormat("%f");
    private static ScanfFormat defaultIntFmt = new ScanfFormat("%i");
    private static ScanfFormat defaultDecFmt = new ScanfFormat("%d");
    private static ScanfFormat defaultHexFmt = new ScanfFormat("%x");
    private static ScanfFormat defaultOctFmt = new ScanfFormat("%o");
    private static ScanfFormat defaultStringFmt = new ScanfFormat("%s");
    private static ScanfFormat defaultCharFmt = new ScanfFormat("%c");
    private int bcnt;
    private final char[] buffer;
    private int charCnt = 0;
    private int curChar;
    private boolean curCharValid = false;
    private int lastChar;
    private int lineCnt = 1;
    private Reader reader = null;
    private boolean spacesCStandardFlag = true;

    public ScanfReader(Reader in) {
        this.reader = in;
        this.curCharValid = false;
        this.charCnt = 0;
        this.lineCnt = 1;
        this.curChar = 0;
        this.lastChar = 0;
        this.buffer = new char[1024];
        this.bcnt = 0;
    }

    public void clearLookAheadChar() {
        this.curCharValid = false;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public int getCharNumber() {
        return this.charCnt;
    }

    public int getLineNumber() {
        return this.lineCnt;
    }

    public int getLookAheadChar() {
        int i = 0;
        if (this.curCharValid) {
            i = this.curChar;
        }
        return i;
    }

    public boolean lookAheadCharValid() {
        return this.curCharValid;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int offLocal = off;
        int lenLocal = len;
        int n0 = 0;
        if (this.curCharValid) {
            this.consumeChar();
            if (this.curChar != -1) {
                cbuf[offLocal++] = (char)this.curChar;
                --lenLocal;
                n0 = 1;
            } else {
                return -1;
            }
        }
        if (lenLocal <= 0) {
            return n0;
        }
        int n = this.reader.read(cbuf, offLocal, lenLocal);
        if (n == -1) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            int c = cbuf[offLocal + i];
            if (c == 13 || c == 10 && this.lastChar != 13) {
                ++this.lineCnt;
            }
            this.lastChar = c;
        }
        this.charCnt += n;
        return n + n0;
    }

    public char scanChar() throws IOException, ScanfMatchException {
        char val = '\u0000';
        try {
            val = this.scanChar(defaultCharFmt);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return val;
    }

    public char scanChar(String s) throws IOException, ScanfMatchException, IllegalArgumentException {
        return this.scanChar(new ScanfFormat(s));
    }

    public char scanChar(ScanfFormat fmt) throws IOException, IllegalArgumentException {
        char value = '\u0000';
        this.checkTypeAndScanPrefix(fmt, "c[");
        this.initChar();
        if (this.curChar == -1) {
            throw new EOFException("EOF");
        }
        value = (char)this.curChar;
        if (fmt.type == 91 && !fmt.matchChar(value)) {
            throw new ScanfMatchException("Input char '" + value + "' does not match '[" + fmt.cmatch + "]'");
        }
        this.consumeAndReplaceChar();
        this.scanSuffix(fmt);
        return value;
    }

    public char[] scanChars(String s) throws IOException, ScanfMatchException, IllegalArgumentException {
        return this.scanChars(new ScanfFormat(s));
    }

    public char[] scanChars(int n) throws IOException, ScanfMatchException, IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("n is non-positive");
        }
        return this.scanChars(defaultCharFmt, n);
    }

    public char[] scanChars(ScanfFormat fmt) throws IOException, IllegalArgumentException {
        return this.scanChars(fmt, fmt.width);
    }

    public long scanDec() throws IOException, ScanfMatchException {
        long val = 0L;
        try {
            val = this.scanDec(defaultDecFmt, -1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return val;
    }

    public long scanDec(String s) throws IOException, ScanfMatchException, IllegalArgumentException {
        return this.scanDec(new ScanfFormat(s));
    }

    public long scanDec(ScanfFormat fmt) throws IOException, IllegalArgumentException {
        return this.scanDec(fmt, fmt.width);
    }

    public double scanDouble() throws IOException, ScanfMatchException {
        double val = 0.0;
        try {
            val = this.scanDouble(defaultDoubleFmt);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return val;
    }

    public double scanDouble(String s) throws IOException, ScanfMatchException, IllegalArgumentException {
        return this.scanDouble(new ScanfFormat(s));
    }

    public double scanDouble(ScanfFormat fmt) throws IOException, ScanfMatchException, IllegalArgumentException {
        int w;
        boolean hasDigits = false;
        double value = 0.0;
        this.checkTypeAndScanPrefix(fmt, "f");
        if (this.curChar == -1) {
            throw new EOFException("EOF");
        }
        this.bcnt = 0;
        int n = w = fmt.width == -1 ? 1000000000 : fmt.width;
        if (this.spacesCStandardFlag) {
            this.skipWhiteSpace();
        } else {
            int skippedSpaces = this.skipWhiteSpace(w);
            w -= skippedSpaces;
        }
        if (this.acceptDigits(w)) {
            hasDigits = true;
        }
        this.acceptChar('.', w);
        if (!(hasDigits || this.bcnt != w && Character.isDigit((char)this.curChar))) {
            if (this.curCharValid && this.curChar == -1) {
                throw new EOFException("EOF");
            }
            throw new ScanfMatchException("Malformed floating point number: no digits");
        }
        this.acceptDigits(w);
        if (this.acceptChar('e', w) || this.acceptChar('E', w)) {
            if (this.bcnt == w || !Character.isDigit((char)this.curChar)) {
                if (this.curCharValid && this.curChar == -1) {
                    throw new EOFException("EOF");
                }
                throw new ScanfMatchException("Malformed floating point number: no digits in exponent");
            }
            this.acceptDigits(w);
        }
        try {
            value = Double.parseDouble(new String(this.buffer, 0, this.bcnt));
        }
        catch (NumberFormatException e) {
            throw new ScanfMatchException("Malformed floating point number");
        }
        this.scanSuffix(fmt);
        return value;
    }

    public float scanFloat() throws IOException, ScanfMatchException {
        return (float)this.scanDouble();
    }

    public float scanFloat(String s) throws IOException, ScanfMatchException, IllegalArgumentException {
        return (float)this.scanDouble(new ScanfFormat(s));
    }

    public float scanFloat(ScanfFormat fmt) throws IOException, ScanfMatchException, IllegalArgumentException {
        return (float)this.scanDouble(fmt);
    }

    public long scanHex() throws IOException, ScanfMatchException {
        long val = 0L;
        try {
            val = this.scanHex(defaultHexFmt, -1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return val;
    }

    public long scanHex(String s) throws IOException, ScanfMatchException, IllegalArgumentException {
        return this.scanHex(new ScanfFormat(s));
    }

    public long scanHex(ScanfFormat fmt) throws IOException, IllegalArgumentException {
        return this.scanHex(fmt, fmt.width);
    }

    public int scanInt() throws IOException, ScanfMatchException {
        return (int)this.scanLong();
    }

    public int scanInt(String s) throws IOException, ScanfMatchException, IllegalArgumentException {
        return (int)this.scanLong(s);
    }

    public int scanInt(ScanfFormat fmt) throws IOException, IllegalArgumentException {
        return (int)this.scanLong(fmt);
    }

    public long scanLong() throws IOException, ScanfMatchException {
        long val = 0L;
        try {
            val = this.scanLong(defaultIntFmt);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return val;
    }

    public long scanLong(String s) throws IOException, ScanfMatchException, IllegalArgumentException {
        return this.scanLong(new ScanfFormat(s));
    }

    public long scanLong(ScanfFormat fmt) throws IOException, IllegalArgumentException {
        if (fmt.type == 100) {
            return this.scanDec(fmt);
        }
        if (fmt.type == 120) {
            return this.scanHex(fmt);
        }
        if (fmt.type == 111) {
            return this.scanOct(fmt);
        }
        long val = 0L;
        int sign = 1;
        int ccnt = 0;
        int width = fmt.width;
        if (width == -1) {
            width = 1000000000;
        }
        this.checkTypeAndScanPrefix(fmt, "i");
        if (this.spacesCStandardFlag) {
            this.skipWhiteSpace();
        } else {
            int skippedSpaces = this.skipWhiteSpace(width);
            width -= skippedSpaces;
        }
        if (this.curChar == 45 || this.curChar == 43) {
            if (width == 1) {
                throw new ScanfMatchException("Malformed integer");
            }
            if (this.curChar == 45) {
                sign = -1;
            }
            this.consumeAndReplaceChar();
            ++ccnt;
        }
        if (this.curChar == -1) {
            throw new EOFException("EOF");
        }
        if (this.curChar == 48) {
            this.consumeAndReplaceChar();
            if (++ccnt == width) {
                val = 0L;
            } else if (this.curChar == 120 || this.curChar == 88) {
                if (ccnt + 1 == width) {
                    throw new ScanfMatchException("Malformed hex integer");
                }
                this.consumeAndReplaceChar();
                ++ccnt;
                if (Character.isWhitespace((char)this.curChar)) {
                    throw new ScanfMatchException("Malformed hex integer");
                }
                val = this.scanHex(defaultHexFmt, width - ccnt);
            } else {
                val = Character.isWhitespace((char)this.curChar) ? 0L : this.scanOct(defaultOctFmt, width - ccnt);
            }
        } else {
            val = 0L;
            if (!Character.isDigit((char)this.curChar)) {
                throw new ScanfMatchException("Malformed decimal integer");
            }
            for (int i = 0; Character.isDigit((char)this.curChar) && i < width - ccnt; ++i) {
                val = val * 10L + (long)(this.curChar - 48);
                this.consumeAndReplaceChar();
            }
        }
        this.scanSuffix(fmt);
        return (long)sign * val;
    }

    public long scanOct() throws IOException, ScanfMatchException {
        long val = 0L;
        try {
            val = this.scanOct(defaultOctFmt, -1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return val;
    }

    public long scanOct(String s) throws IOException, ScanfMatchException, IllegalArgumentException {
        return this.scanOct(new ScanfFormat(s));
    }

    public long scanOct(ScanfFormat fmt) throws IOException, IllegalArgumentException {
        return this.scanOct(fmt, fmt.width);
    }

    public String scanString() throws IOException, ScanfMatchException {
        String val = null;
        try {
            val = this.scanString(defaultStringFmt);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return val;
    }

    public String scanString(String s) throws IOException, ScanfMatchException, IllegalArgumentException {
        return this.scanString(new ScanfFormat(s));
    }

    public String scanString(ScanfFormat fmt) throws IOException, IllegalArgumentException {
        int blimit = 1024;
        if (fmt.width != -1 && fmt.width < blimit) {
            blimit = fmt.width;
        }
        this.checkTypeAndScanPrefix(fmt, "s");
        if (this.spacesCStandardFlag) {
            this.skipWhiteSpace();
        } else {
            int skippedSpaces = this.skipWhiteSpace(blimit);
            blimit -= skippedSpaces;
        }
        if (this.curChar == -1) {
            throw new EOFException("EOF");
        }
        this.bcnt = 0;
        while (!Character.isWhitespace((char)this.curChar) && this.curChar != -1 && this.bcnt < blimit) {
            this.buffer[this.bcnt++] = (char)this.curChar;
            this.consumeAndReplaceChar();
        }
        this.scanSuffix(fmt);
        return new String(this.buffer, 0, this.bcnt);
    }

    public void setCharNumber(int n) {
        this.charCnt = n;
    }

    public void setLineNumber(int n) {
        this.lineCnt = n;
    }

    public boolean useCstandard() {
        return this.spacesCStandardFlag;
    }

    public void useCstandard(boolean flag) {
        this.spacesCStandardFlag = flag;
    }

    private final boolean acceptChar(char c, int width) throws IOException {
        boolean accept = false;
        if (this.curChar == c && this.bcnt < width) {
            this.buffer[this.bcnt++] = (char)this.curChar;
            if (this.bcnt < width) {
                this.consumeAndReplaceChar();
            } else {
                this.consumeChar();
            }
            accept = true;
        }
        return accept;
    }

    private final boolean acceptDigits(int width) throws IOException {
        boolean matched = false;
        while (Character.isDigit((char)this.curChar) && this.bcnt < width) {
            this.buffer[this.bcnt++] = (char)this.curChar;
            matched = true;
            if (this.bcnt < width) {
                this.consumeAndReplaceChar();
                continue;
            }
            this.consumeChar();
        }
        return matched;
    }

    private final void checkTypeAndScanPrefix(ScanfFormat fmt, String type) throws IOException, IllegalArgumentException {
        if (fmt.type == -1) {
            throw new IllegalArgumentException("No conversion character");
        }
        if (type.indexOf(fmt.type) == -1) {
            throw new IllegalArgumentException("Illegal conversion character '" + (char)fmt.type + "'");
        }
        if (fmt.prefix != null) {
            this.matchString(fmt.prefix);
        }
    }

    private final void consumeAndReplaceChar() throws IOException {
        if (this.curChar != -1) {
            ++this.charCnt;
            if (this.curChar == 13 || this.curChar == 10 && this.lastChar != 13) {
                ++this.lineCnt;
            }
        }
        this.lastChar = this.curChar;
        this.curChar = this.reader.read();
    }

    private final void consumeChar() {
        if (this.curChar != -1) {
            ++this.charCnt;
            if (this.curChar == 13 || this.curChar == 10 && this.lastChar != 13) {
                ++this.lineCnt;
            }
        }
        this.lastChar = this.curChar;
        this.curCharValid = false;
    }

    private final void initChar() throws IOException {
        if (!this.curCharValid) {
            this.curChar = this.reader.read();
            this.curCharValid = true;
        }
    }

    private void matchString(String s) throws IOException, ScanfMatchException {
        this.initChar();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (this.curChar == -1) {
                throw new EOFException("EOF");
            }
            if (Character.isWhitespace(c)) {
                if (this.skipWhiteSpace()) continue;
                throw new ScanfMatchException("No white space to match white space in format");
            }
            if (this.curChar != c) {
                throw new ScanfMatchException("Char '" + (char)this.curChar + "' does not match char '" + c + "' in format");
            }
            this.consumeAndReplaceChar();
        }
    }

    private char[] scanChars(ScanfFormat fmt, int w) throws IOException, IllegalArgumentException {
        int wLocal = w;
        if (wLocal == -1) {
            wLocal = 1;
        }
        char[] value = new char[wLocal];
        this.checkTypeAndScanPrefix(fmt, "c[");
        this.initChar();
        if (this.curChar == -1) {
            throw new EOFException("EOF");
        }
        for (int i = 0; i < wLocal; ++i) {
            value[i] = (char)this.curChar;
            if (fmt.type == 91 && !fmt.matchChar(value[i])) {
                throw new ScanfMatchException("Input char '" + value[i] + "' does not match '[" + fmt.cmatch + "]'");
            }
            this.consumeAndReplaceChar();
        }
        this.scanSuffix(fmt);
        return value;
    }

    private long scanDec(ScanfFormat fmt, int width) throws IOException, IllegalArgumentException {
        int widthLocal = width;
        if (widthLocal == -1) {
            widthLocal = 1000000000;
        }
        boolean negate = false;
        this.checkTypeAndScanPrefix(fmt, "d");
        if (this.spacesCStandardFlag) {
            this.skipWhiteSpace();
        } else {
            int skippedSpaces = this.skipWhiteSpace(widthLocal);
            widthLocal -= skippedSpaces;
        }
        if (this.curChar == 45 || this.curChar == 43) {
            negate = this.curChar == 45;
            this.consumeAndReplaceChar();
        }
        if (this.curChar == -1) {
            throw new EOFException("EOF");
        }
        if (!Character.isDigit((char)this.curChar)) {
            throw new ScanfMatchException("Malformed decimal integer");
        }
        long val = 0L;
        for (int i = 0; Character.isDigit((char)this.curChar) && i < widthLocal; ++i) {
            val = val * 10L + (long)(this.curChar - 48);
            this.consumeAndReplaceChar();
        }
        if (negate) {
            val = -val;
        }
        this.scanSuffix(fmt);
        return val;
    }

    private long scanHex(ScanfFormat fmt, int width) throws IOException, IllegalArgumentException {
        int k;
        int widthLocal = width;
        if (widthLocal == -1) {
            widthLocal = 1000000000;
        }
        this.checkTypeAndScanPrefix(fmt, "x");
        if (this.spacesCStandardFlag) {
            this.skipWhiteSpace();
        } else {
            int skippedSpaces = this.skipWhiteSpace(widthLocal);
            widthLocal -= skippedSpaces;
        }
        if (this.curChar == -1) {
            throw new EOFException("EOF");
        }
        if (hexChars.indexOf(this.curChar) == -1) {
            throw new ScanfMatchException("Malformed hex integer");
        }
        long val = 0L;
        for (int i = 0; (k = hexChars.indexOf(this.curChar)) != -1 && i < widthLocal; ++i) {
            if (k > 15) {
                k -= 6;
            }
            val = val * 16L + (long)k;
            this.consumeAndReplaceChar();
        }
        this.scanSuffix(fmt);
        return val;
    }

    private long scanOct(ScanfFormat fmt, int width) throws IOException, IllegalArgumentException {
        int k;
        int widthLocal = width;
        if (widthLocal == -1) {
            widthLocal = 1000000000;
        }
        this.checkTypeAndScanPrefix(fmt, "o");
        if (this.spacesCStandardFlag) {
            this.skipWhiteSpace();
        } else {
            int skippedSpaces = this.skipWhiteSpace(widthLocal);
            widthLocal -= skippedSpaces;
        }
        if (this.curChar == -1) {
            throw new EOFException("EOF");
        }
        if (octChars.indexOf(this.curChar) == -1) {
            throw new ScanfMatchException("Malformed octal integer");
        }
        long val = 0L;
        for (int i = 0; (k = octChars.indexOf(this.curChar)) != -1 && i < widthLocal; ++i) {
            val = val * 8L + (long)k;
            this.consumeAndReplaceChar();
        }
        this.scanSuffix(fmt);
        return val;
    }

    private final void scanSuffix(ScanfFormat fmt) throws IOException {
        if (fmt.suffix != null) {
            this.matchString(fmt.suffix);
        }
    }

    private boolean skipWhiteSpace() throws IOException {
        boolean encounterdWhiteSpace = false;
        this.initChar();
        while (Character.isWhitespace((char)this.curChar)) {
            encounterdWhiteSpace = true;
            this.consumeAndReplaceChar();
        }
        return encounterdWhiteSpace;
    }

    private int skipWhiteSpace(int limit) throws IOException {
        int spaces;
        this.initChar();
        for (spaces = 0; Character.isWhitespace((char)this.curChar) && spaces <= limit; ++spaces) {
            this.consumeAndReplaceChar();
        }
        return spaces;
    }
}

