/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.HashMap;
import java.util.Map;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;

public class XJDFSchemaWalker
extends BaseElementWalker {
    private final JDFAttributeMap typeMap = new JDFAttributeMap();

    public XJDFSchemaWalker() {
        super(new BaseWalkerFactory());
    }

    public JDFAttributeMap getTypeMap() {
        return this.typeMap;
    }

    public Map<String, Integer> getLengthMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (String key : this.typeMap.getKeyList()) {
            int l = this.getLength(key);
            if (l <= 0) continue;
            ret.put(key, l);
        }
        return ret;
    }

    public int getLength(String path) {
        String typ = this.typeMap.get(path);
        if (typ != null) {
            switch (typ) {
                case "XYPair": {
                    return 2;
                }
                case "shape": 
                case "LabColor": 
                case "sRGBColor": {
                    return 3;
                }
                case "rectangle": 
                case "CMYKColor": {
                    return 4;
                }
                case "matrix": {
                    return 6;
                }
            }
        }
        return 0;
    }

    public Integer getMin(String path) {
        String typ = this.typeMap.get(path);
        if (typ != null) {
            switch (typ) {
                case "shape": 
                case "sRGBColor": 
                case "CMYKColor": {
                    return 0;
                }
            }
        }
        return null;
    }

    public Integer getMax(String path) {
        String typ = this.typeMap.get(path);
        if (typ != null) {
            switch (typ) {
                case "sRGBColor": 
                case "CMYKColor": {
                    return 1;
                }
            }
        }
        return null;
    }

    protected class WalkAttribute
    extends WalkElement {
        @Override
        public KElement walk(KElement a, KElement xjdf) {
            String typ = a.getNonEmpty("type");
            String parent = a.getParentNode_KElement().getInheritedAttribute("name", null, null);
            String name = a.getNonEmpty("name");
            XJDFSchemaWalker.this.typeMap.putNotNull(parent + "/" + name, typ);
            return null;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return "xs:attribute".equals(toCheck.getNodeName());
        }
    }

    protected class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(XJDFSchemaWalker.this.getFactory());
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            return in;
        }
    }
}

