/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFDateTimeRange;
import org.cip4.jdflib.datatypes.JDFDateTimeRangeList;
import org.cip4.jdflib.datatypes.JDFDurationRangeList;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;

public class JDFDateTimeState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[6];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFDateTimeState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDateTimeState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDateTimeState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDateTimeState[  --> " + super.toString() + " ]";
    }

    public void setCurrentValue(JDFDate value) {
        this.setAttribute("CurrentValue", value == null ? null : value.getDateTimeISO(), "");
    }

    public JDFDate getCurrentValue() {
        JDFDate currentValue = null;
        String str = this.getAttribute("CurrentValue", null, "");
        if (!"".equals(str)) {
            try {
                currentValue = new JDFDate(str);
            }
            catch (DataFormatException dfe) {
                throw new JDFException("not a valid date string. Malformed JDF");
            }
        }
        return currentValue;
    }

    public void setDefaultValue(JDFDate value) {
        this.setAttribute("DefaultValue", value == null ? null : value.getDateTimeISO(), "");
    }

    public JDFDate getDefaultValue() {
        JDFDate defaultValue = null;
        String str = this.getAttribute("DefaultValue", null, "");
        if (!"".equals(str)) {
            try {
                defaultValue = new JDFDate(str);
            }
            catch (DataFormatException dfe) {
                throw new JDFException("not a valid date string. Malformed JDF");
            }
        }
        return defaultValue;
    }

    public void setAllowedValueList(JDFDateTimeRangeList value) {
        this.setAttribute("AllowedValueList", value == null ? null : value.toString());
    }

    public JDFDateTimeRangeList getAllowedValueList() {
        try {
            String attribute = this.getAttribute("AllowedValueList", null, null);
            if (attribute != null) {
                return new JDFDateTimeRangeList(attribute);
            }
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        return null;
    }

    public void setPresentValueList(JDFDateTimeRangeList value) {
        this.setAttribute("PresentValueList", value == null ? null : value.toString());
    }

    public JDFDateTimeRangeList getPresentValueList() {
        if (this.hasAttribute("PresentValueList")) {
            JDFDateTimeRangeList r = null;
            try {
                r = new JDFDateTimeRangeList(this.getAttribute("PresentValueList"));
            }
            catch (DataFormatException dfe) {
                return null;
            }
            return r;
        }
        return this.getAllowedValueList();
    }

    public void setAllowedValueDurationList(JDFDurationRangeList value) {
        this.setAttribute("AllowedValueDurationList", value == null ? null : value.toString());
    }

    public JDFDurationRangeList getAllowedValueDurationList() {
        JDFDurationRangeList r = null;
        String allowedValueDurList = this.getAttribute("AllowedValueDurationList", null, null);
        if (allowedValueDurList != null) {
            try {
                r = new JDFDurationRangeList(allowedValueDurList);
            }
            catch (DataFormatException dfe) {
                return null;
            }
        }
        return r;
    }

    public void setPresentValueDurationList(JDFDurationRangeList value) {
        this.setAttribute("PresentValueDurationList", value == null ? null : value.toString());
    }

    public JDFDurationRangeList getPresentValueDurationList() {
        if (this.hasAttribute("PresentValueDurationList")) {
            JDFDurationRangeList r = null;
            try {
                r = new JDFDurationRangeList(this.getAttribute("PresentValueDurationList"));
            }
            catch (DataFormatException dfe) {
                return null;
            }
            return r;
        }
        return this.getAllowedValueDurationList();
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        JDFDateTimeRangeList list;
        JDFDate date;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        try {
            date = new JDFDate(value);
        }
        catch (DataFormatException x) {
            return;
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals((Object)testlists)) {
            list = this.getAllowedValueList();
            if (list == null) {
                list = new JDFDateTimeRangeList();
            }
            list.append(date);
            this.setAllowedValueList(list);
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Present.equals((Object)testlists)) {
            list = this.getPresentValueList();
            if (list == null || !this.hasAttribute("PresentValueList")) {
                list = new JDFDateTimeRangeList();
            }
            list.append(date);
            this.setPresentValueList(list);
        }
    }

    @Override
    public boolean fitsValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        if (this.fitsListType(value)) {
            JDFDateTimeRangeList rangelist = null;
            try {
                rangelist = new JDFDateTimeRangeList(value);
            }
            catch (DataFormatException dfe) {
                return false;
            }
            return this.fitsValueList(rangelist, testlists) && this.fitsValueDurationList(rangelist, testlists);
        }
        return false;
    }

    private final boolean fitsValueList(JDFDateTimeRangeList rangelist, JDFBaseDataTypes.EnumFitsValue valuelist) {
        JDFDateTimeRangeList list = valuelist.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueList() : this.getPresentValueList();
        if (list == null) {
            return true;
        }
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(rangelist, list);
        }
        return list.isPartOfRange(rangelist);
    }

    private final boolean fitsValueDurationList(JDFDateTimeRangeList rangelist, JDFBaseDataTypes.EnumFitsValue valuelist) {
        JDFDurationRangeList list = valuelist.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueDurationList() : this.getPresentValueDurationList();
        if (list == null) {
            return true;
        }
        int siz = rangelist.size();
        for (int i = 0; i < siz; ++i) {
            JDFDateTimeRange range = (JDFDateTimeRange)rangelist.at(i);
            int duration = (int)((range.getRight().getTimeInMillis() - range.getLeft().getTimeInMillis()) / 1000L);
            JDFDuration d = new JDFDuration();
            d.setDuration(duration);
            if (list.inRange(d)) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteList(JDFDateTimeRangeList value, JDFDateTimeRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        JDFDateTimeRangeList valueList = new JDFDateTimeRangeList(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.at(i).equals(valueList.at(j))) continue;
                valueList.erase(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(JDFDateTimeRangeList value, JDFDateTimeRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.at(i).equals(value.at(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(JDFDateTimeRangeList value, JDFDateTimeRangeList list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.at(i).equals(list.at(j))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.DateTimeEvaluation;
    }

    static {
        JDFDateTimeState.atrInfoTable[0] = new AtrInfoTable("AllowedValueDurationList", 0x33333311L, AttributeInfo.EnumAttributeType.DurationRangeList, null, null);
        JDFDateTimeState.atrInfoTable[1] = new AtrInfoTable("AllowedValueList", 0x33333311L, AttributeInfo.EnumAttributeType.DateTimeRangeList, null, null);
        JDFDateTimeState.atrInfoTable[2] = new AtrInfoTable("CurrentValue", 0x33333311L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFDateTimeState.atrInfoTable[3] = new AtrInfoTable("DefaultValue", 0x33333311L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFDateTimeState.atrInfoTable[4] = new AtrInfoTable("PresentValueDurationList", 0x33333311L, AttributeInfo.EnumAttributeType.DurationRangeList, null, null);
        JDFDateTimeState.atrInfoTable[5] = new AtrInfoTable("PresentValueList", 0x33333311L, AttributeInfo.EnumAttributeType.DateTimeRangeList, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFDateTimeState.elemInfoTable[0] = new ElemInfoTable("ValueLoc", 0x33333311L);
    }
}

