/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Collection;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoCompany;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFCompany
extends JDFAutoCompany
implements IMatches {
    private static final long serialVersionUID = 1L;

    public JDFCompany(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFCompany(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFCompany(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFCompany[  --> " + super.toString() + " ]";
    }

    @Override
    public boolean matches(Object subset) {
        boolean matches = false;
        if (subset instanceof String) {
            matches = StringUtil.getDistance(this.getOrganizationName(), (String)subset, true, true, true) <= 2;
        } else if (subset instanceof JDFCompany) {
            JDFCompany other = (JDFCompany)subset;
            matches = this.matches(other.getOrganizationName());
        }
        return matches;
    }

    @Override
    public String getDescriptiveName() {
        String descName = this.getNonEmpty("DescriptiveName");
        return descName != null ? descName : this.getOrganizationName();
    }

    public VString getOrganizationalUnits() {
        Collection<JDFElement> vou = this.getAllOrganizationalUnit();
        if (vou != null && !vou.isEmpty()) {
            VString v = new VString();
            for (JDFElement e : vou) {
                v.addNonEmpty(e.getText());
            }
            return v;
        }
        return null;
    }

    public void setOrganizationalUnit(String unit) {
        this.removeChildren("OrganizationalUnit", null, null);
        this.appendOrganizationalUnit(unit);
    }

    public void appendOrganizationalUnit(String unit) {
        if (!StringUtil.isEmpty(unit)) {
            this.appendOrganizationalUnit().setText(unit);
        }
    }
}

