/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;

class ExtensionListener {
    protected final HotFolderListener folderListener;
    protected final Set<String> extension;

    protected ExtensionListener(HotFolderListener _hfl, String ext) {
        this.folderListener = _hfl;
        ext = StringUtil.getNonEmpty(ext);
        if (ext != null) {
            this.extension = new HashSet<String>();
            StringArray vs = StringArray.getVString(ext, ",");
            for (String s : vs) {
                if (s.startsWith(".")) {
                    s = s.substring(1);
                }
                s = s.toLowerCase();
                this.extension.add(s);
            }
        } else {
            this.extension = null;
        }
    }

    public void hotFile(File file) {
        String fileExt;
        if (file == null) {
            return;
        }
        if (this.extension != null && (fileExt = FileUtil.getExtension(file)) != null && !this.extension.contains(fileExt = fileExt.toLowerCase())) {
            return;
        }
        this.folderListener.hotFile(file);
    }

    public String toString() {
        return "ExtensionListener [" + (String)(this.extension != null ? "extension=" + this.extension : "") + "]";
    }

    public HotFolderListener getListener() {
        return this.folderListener;
    }
}

