/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.hotfolder.ExtensionListener;
import org.cip4.jdflib.util.hotfolder.FileTime;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.hotfolder.HotFolderRunner;

public class HotFolder {
    private static int defaultStabilizeTime = 6666;
    public int stabilizeTime = defaultStabilizeTime;
    private int maxCheck;
    private final File dir;
    private String allExtensions;
    private long lastModified = -1L;
    private ArrayList<FileTime> lastFileTime;
    protected final ArrayList<ExtensionListener> hfl;
    final AtomicReference<Set<File>> hfRunning;
    private static final Log log = LogFactory.getLog(HotFolder.class);

    public int getMaxCheck() {
        return this.maxCheck;
    }

    public void setMaxCheck(int maxCheck) {
        this.maxCheck = maxCheck;
    }

    public void setMaxConcurrent(int maxConcurrent) {
        HotFolderRunner.getCreateTherunner().setMaxConcurrent(maxConcurrent);
    }

    public ExtensionListener getListener(int i) {
        return ContainerUtil.get(this.hfl, i);
    }

    public int getMaxConcurrent() {
        HotFolderRunner r = HotFolderRunner.getTherunner();
        return r == null ? 0 : r.getMaxConcurrent();
    }

    boolean loop() {
        long t0 = System.currentTimeMillis();
        long lastMod = this.dir.lastModified();
        int n = this.lastFileTime.size();
        boolean mod = false;
        if (lastMod > this.lastModified || n > 0 || t0 - this.lastModified < 42000L) {
            this.lastModified = lastMod;
            File[] files = this.getHotFiles();
            if (files != null) {
                Set<File> hotFiles = ContainerUtil.toHashSet(files);
                if (!this.lastFileTime.isEmpty()) {
                    for (int i = 0; i < this.lastFileTime.size(); ++i) {
                        FileTime lftAt = this.lastFileTime.get(i);
                        hotFiles.remove(lftAt.f);
                        boolean processed = this.processSingleFile(lftAt);
                        if (!processed) continue;
                        mod = true;
                        --i;
                    }
                }
                for (File f : hotFiles) {
                    if (f == null) continue;
                    this.lastFileTime.add(new FileTime(f, false));
                    mod = true;
                }
            }
        }
        return mod;
    }

    public File getDir() {
        return this.dir;
    }

    String getAllExtensions() {
        if (this.allExtensions != null) {
            return this.allExtensions;
        }
        if (this.hfl == null) {
            return null;
        }
        StringArray allextensions = new StringArray();
        try {
            for (ExtensionListener element : this.hfl) {
                Set<String> ext = element.extension;
                if (ext != null) {
                    allextensions.addAll(ext);
                    continue;
                }
                return null;
            }
            allextensions.unify();
            this.allExtensions = allextensions.getString(",", null, null);
            return this.allExtensions;
        }
        catch (Exception x) {
            return null;
        }
    }

    ArrayList<FileTime> getLastFileTime() {
        return this.lastFileTime;
    }

    void setLastFileTime(ArrayList<FileTime> lastFileTime) {
        this.lastFileTime = lastFileTime;
    }

    @Deprecated
    public HotFolder(File _dir) {
        this(_dir, null, null);
    }

    public synchronized void addListener(HotFolderListener _hfl, String ext) {
        if (this.hfl != null) {
            this.hfl.add(new ExtensionListener(_hfl, ext));
        }
        this.allExtensions = null;
        this.lastModified = 0L;
    }

    public HotFolder(File _dir, String ext, HotFolderListener _hfl) {
        this.dir = _dir;
        this.dir.mkdirs();
        this.dir.setWritable(true);
        this.lastFileTime = new ArrayList();
        this.hfl = new ArrayList();
        this.hfRunning = new AtomicReference(new HashSet());
        this.allExtensions = null;
        HotFolderRunner.getCreateTherunner();
        if (_hfl != null) {
            this.addListener(_hfl, ext);
            this.restart();
        }
    }

    public synchronized void restart() {
        int mc = this.getMaxConcurrent();
        this.stop();
        if (this.dir.canWrite()) {
            log.info((Object)("Restarting " + this.toString()));
        } else {
            log.error((Object)("Cannot use read only hot folder at " + this));
        }
        HotFolderRunner r = HotFolderRunner.getCreateTherunner();
        this.setMaxConcurrent(mc);
        r.add(this);
        this.lastModified = -1L;
        this.hfRunning.get().clear();
    }

    public synchronized void stop() {
        HotFolderRunner r = HotFolderRunner.getTherunner();
        if (r != null && r.contains(this)) {
            r.remove(this);
            log.info((Object)("stopped hot folder at: " + this.dir.getAbsolutePath()));
        }
    }

    File[] getHotFiles() {
        HotFolderRunner r = HotFolderRunner.getTherunner();
        if (r == null) {
            return null;
        }
        File[] files = FileUtil.listFilesWithExtension(this.dir, this.getAllExtensions(), this.maxCheck);
        int n = 0;
        if (files != null) {
            Set<File> running = this.hfRunning.get();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.canWrite()) {
                    log.warn((Object)("ignoring read only file in hot folder: " + file));
                    files[i] = null;
                    continue;
                }
                if (running.contains(file) || file.isDirectory() || file.isHidden()) {
                    files[i] = null;
                    continue;
                }
                ++n;
            }
        }
        return n == 0 ? null : files;
    }

    boolean processSingleFile(FileTime lftAt) {
        if (lftAt.sameModified() && lftAt.modified + (long)this.stabilizeTime < System.currentTimeMillis()) {
            this.lastFileTime.remove(lftAt);
            HotFolderRunner.getTherunner().runFile(new HotFileRunner(lftAt.f));
        } else if (!lftAt.exists()) {
            log.warn((Object)("removed disappearing hot file " + lftAt));
            this.lastFileTime.remove(lftAt);
        } else {
            lftAt.updateModified();
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.dir + " " + this.lastModified;
    }

    public static int getDefaultStabilizeTime() {
        return defaultStabilizeTime;
    }

    public static void setDefaultStabilizeTime(int defaultStabilizeTime) {
        if (defaultStabilizeTime > 0) {
            HotFolder.defaultStabilizeTime = defaultStabilizeTime;
        }
    }

    public int getStabilizeTime() {
        return this.stabilizeTime;
    }

    public void setStabilizeTime(int stabilizeTime) {
        if (stabilizeTime >= 2000) {
            this.stabilizeTime = stabilizeTime;
        }
    }

    public int hashCode() {
        return this.dir == null ? 0 : this.dir.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.dir == null) {
            return obj == null;
        }
        if (!(obj instanceof HotFolder)) {
            return false;
        }
        return this.dir.equals(((HotFolder)obj).dir);
    }

    class HotFileRunner
    implements Runnable {
        final File fileJ;

        HotFileRunner(File fileJ) {
            HotFolder.this.hfRunning.get().add(fileJ);
            this.fileJ = fileJ;
        }

        @Override
        public void run() {
            if (this.fileJ != null) {
                for (ExtensionListener xl : HotFolder.this.hfl) {
                    try {
                        xl.hotFile(this.fileJ);
                    }
                    catch (Throwable x) {
                        log.error((Object)"exception processing hot file", x);
                    }
                }
                HotFolder.this.hfRunning.get().remove(this.fileJ);
                log.info((Object)("completed running " + this.shortString()));
            }
        }

        public String toString() {
            return "HotFileRunner [fileJ=" + this.fileJ + "]";
        }

        public String shortString() {
            return HotFolder.this.dir.getName() + "/" + this.fileJ.getName();
        }
    }
}

