/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.validate;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.commons.lang.ArrayUtils;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFParser;
import org.cip4.jdflib.core.JDFParserFactory;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.core.XMLErrorHandler;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.devicecapability.JDFDeviceCap;
import org.cip4.jdflib.resource.process.JDFColorPool;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.MimeUtil;
import org.cip4.jdflib.util.MyArgs;
import org.cip4.jdflib.util.StreamUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.validate.ICheckValidator;
import org.cip4.jdflib.validate.ICheckValidatorFactory;

public class JDFValidator {
    private static final String ERROR_TYPE = "ErrorType";
    private static final String IS_VALID = "IsValid";
    private static final String MESSAGE = "Message";
    VString foundNameSpaces = new VString();
    VString vID = new VString();
    public VString vBadID = new VString();
    public VString vMultiID = null;
    VString vBadJobPartID = new VString();
    VString vJobPartID = new VString();
    VElement vResources = new VElement();
    VElement vLinkedResources = new VElement();
    VElement vBadResourceLinks = new VElement();
    VString vSeparations = new VString();
    VString vSeparations2 = new VString();
    VString vColorPoolSeparations = new VString();
    protected XMLDoc pOut;
    static final String[] aGBList = new String[]{"ImpositionRIPing", "PlateMaking", "ProofAndPlateMaking", "ImpositionProofing", "PageProofing", "RIPing", "PrePressPreparation", "ImpositionPreparation", "ProofImaging"};
    JDFDoc theDoc = null;
    protected String translation = null;
    private boolean bTryFormats = false;
    private ICheckValidatorFactory validatorFactory = null;
    public boolean bTiming = false;
    protected boolean bWarning = false;
    public boolean bQuiet = true;
    protected boolean bPrintNameSpace = true;
    public boolean bValidate = true;
    public boolean bWarnDanglingURL = false;
    public JDFElement.EnumValidationLevel level = JDFElement.EnumValidationLevel.Incomplete;
    public VString allFiles = null;
    public String proxyHost = null;
    public String proxyPort = null;
    public String schemaLocation = null;
    public String xmlOutputName = null;
    public String xslStyleSheet = null;
    public String devCapFile = null;
    public JDFBaseDataTypes.EnumFitsValue testlists = JDFBaseDataTypes.EnumFitsValue.Allowed;
    public boolean bMultiID = false;
    private boolean inOutputLoop = false;
    protected static final String version = "JDFValidator: JDF validator; -- (c) 2001-2019 CIP4\nJDF 1.6 compatible version\n\nCode based on schema JDF_1.5.xsd\nBuild version " + JDFAudit.software();
    protected MySysOut sysOut = new MySysOut();

    public JDFValidator() {
        this.pOut = new XMLDoc("CheckOutput", null);
        this.pOut.getMemberDocument().setIgnoreNSDefault(true);
        this.pOut.getMemberDocument().setStrictNSCheck(false);
        this.pOut.getRoot().setAttribute("Version", version);
    }

    public static String toMessageString(KElement checkOut) {
        if (checkOut == null) {
            return null;
        }
        return checkOut.getAttribute(MESSAGE, null, null);
    }

    private void setErrorType(KElement reportElem, String type, String message, int indent) {
        if (reportElem == null) {
            return;
        }
        reportElem.setAttribute(IS_VALID, false, null);
        reportElem.setAttribute(ERROR_TYPE, type, null);
        reportElem.setAttribute(MESSAGE, message, null);
        if (indent > 0) {
            this.sysOut.println(this.indent(indent) + message);
        }
    }

    private void setErrorType(KElement reportElem, String type, String message) {
        this.setErrorType(reportElem, type, message, -1);
    }

    public void setDoc(JDFDoc d) {
        this.theDoc = d;
    }

    public void setIgnorePrivate(boolean bIgnore) {
        this.bPrintNameSpace = !bIgnore;
    }

    public void setPrint(boolean b) {
        this.sysOut.setPrint(b);
    }

    private String indent(int indent) {
        Object s = "";
        for (int i = 0; i < indent; ++i) {
            s = (String)s + " ";
        }
        return s;
    }

    private void printBad(KElement kElement, int indent, KElement xmlParent, boolean bIsNodeRoot) {
        String id = kElement.getAttribute("ID", null, "");
        String pref = kElement.getPrefix();
        String elmName = kElement.getNodeName();
        String nsURI = kElement.getNamespaceURI();
        KElement testElement = this.getTestElement(kElement, xmlParent);
        if (kElement instanceof JDFNode) {
            JDFNode node = (JDFNode)kElement;
            this.printNode(node, indent, testElement);
            if (bIsNodeRoot) {
                this.printNodeRoot(node, xmlParent);
            }
        }
        boolean isJDFNS = JDFElement.isInJDFNameSpaceStatic(kElement);
        boolean bTypo = false;
        if (!isJDFNS) {
            this.printNonNamespace(kElement, indent, xmlParent, pref, elmName, nsURI, testElement, isJDFNS, false);
            return;
        }
        boolean bIsValid = this.privateValidation(kElement, testElement);
        if (!(kElement instanceof JDFElement)) {
            return;
        }
        JDFElement jdfElement = this.printBadJDF(kElement, indent, xmlParent, bIsNodeRoot, id, elmName, testElement, bIsValid);
        VElement ve = jdfElement.getChildElementVector(null, null, null, true, 0, false);
        for (KElement e : ve) {
            this.printBad(e, indent + 2, testElement, false);
        }
    }

    protected JDFElement printBadJDF(KElement kElement, int indent, KElement xmlParent, boolean bIsNodeRoot, String id, String elmName, KElement testElement, boolean bIsValid) {
        JDFElement jdfElement = (JDFElement)kElement;
        bIsValid = this.isValidElement(bIsValid, jdfElement);
        VString privateAttributes = new VString(jdfElement.getUnknownAttributes(false, 9999999));
        VString unknownAttributes = new VString();
        if (!bIsValid) {
            unknownAttributes = jdfElement.getUnknownAttributes(true, 9999999);
        }
        privateAttributes.removeStrings(unknownAttributes, Integer.MAX_VALUE);
        VString privateElements = new VString(jdfElement.getUnknownElements(false, 9999999));
        VString unknownElements = new VString();
        if (!bIsValid) {
            unknownElements = jdfElement.getUnknownElements(true, 9999999);
        }
        privateElements.removeStrings(unknownElements, Integer.MAX_VALUE);
        if (this.bPrintNameSpace) {
            this.printPrivate(privateAttributes, privateElements, jdfElement, indent, testElement);
        }
        boolean bIsOK = true;
        if (jdfElement instanceof JDFResourceLinkPool) {
            bIsOK = true;
        } else if (jdfElement instanceof JDFRefElement) {
            bIsOK = this.printRefElement((JDFRefElement)jdfElement, indent, testElement);
        } else if (jdfElement instanceof JDFResourceLink) {
            bIsOK = this.printResourceLink((JDFResourceLink)jdfElement, indent, testElement);
        } else if (jdfElement instanceof JDFResource) {
            bIsOK = this.printResource((JDFResource)jdfElement, indent, testElement);
        }
        if (this.bWarnDanglingURL) {
            this.printURL(kElement, indent, testElement);
        }
        boolean bValidID = id == null || id.equals("") ? true : !this.vBadID.contains(id);
        boolean bUnknownElem = false;
        if (testElement != null && xmlParent != null) {
            String unkElems;
            JDFElement.EnumVersion v;
            String invElems;
            if (bIsOK) {
                invElems = xmlParent.getAttribute("PreReleaseElements");
                boolean bl = bIsOK = !StringUtil.hasToken(invElems, elmName, " ", 0);
                if (!bIsOK) {
                    v = ((JDFElement)jdfElement.getParentNode_KElement()).getFirstVersion(elmName, true);
                    testElement.setAttribute("FirstVersion", v.getName());
                    this.setErrorType(testElement, "PreReleaseElement", elmName + " is not valid in JDF Version" + jdfElement.getVersion(true).getName() + " First Valid version: " + v.getName(), indent + 2);
                }
            }
            if (bIsOK && this.bWarning) {
                invElems = xmlParent.getAttribute("DeprecatedElements");
                boolean bl = bIsOK = !StringUtil.hasToken(invElems, elmName, " ", 0);
                if (!bIsOK) {
                    v = ((JDFElement)jdfElement.getParentNode_KElement()).getLastVersion(elmName, true);
                    testElement.setAttribute("LastVersion", v.getName());
                    this.setErrorType(testElement, "DeprecatedElement", elmName + " is not valid in JDF Version" + jdfElement.getVersion(true).getName() + " Last Valid version: " + v.getName(), indent + 2);
                }
            }
            if (bIsOK) {
                invElems = xmlParent.getAttribute("PrivateElements");
                boolean bl = bIsOK = !StringUtil.hasToken(invElems, elmName, " ", 0);
                if (!bIsOK) {
                    this.setErrorType(testElement, "PrivateElement", elmName + " is not a valid subelement");
                }
            }
            if (bIsOK) {
                String swapElems = xmlParent.getAttribute("SwapElements");
                boolean bl = bIsOK = !StringUtil.hasToken(swapElems, elmName, " ", 0);
                if (!bIsOK) {
                    this.setErrorType(testElement, "SwapElement", elmName + " is written as an Element");
                }
            }
            if (bIsOK && (unkElems = xmlParent.getAttribute("UnknownElements", null, null)) != null) {
                boolean bl = bIsOK = !StringUtil.hasToken(unkElems, elmName, " ", 0);
                if (!bIsOK) {
                    this.setErrorType(testElement, "UnknownElement", elmName + " is not defined in a " + xmlParent.getLocalName());
                    bUnknownElem = true;
                }
            }
        }
        if (bUnknownElem && testElement != null) {
            testElement.setAttribute(IS_VALID, false, null);
        } else if (bIsValid && bValidID && bIsOK) {
            if (!this.bQuiet) {
                this.sysOut.println(this.indent(indent) + "--- Valid:" + jdfElement.buildXPath(null, 1) + " " + id);
            }
            if (testElement != null) {
                testElement.setAttribute(IS_VALID, true, null);
            }
            if (bIsNodeRoot && xmlParent != null) {
                xmlParent.setAttribute(IS_VALID, true, null);
            }
        } else {
            JDFResource res;
            JDFResource r;
            if (bIsOK) {
                this.sysOut.println(this.indent(indent) + "!!! InValid Element: " + kElement.buildXPath(null, 1) + " " + id + " !!! ");
            }
            if (testElement != null) {
                testElement.setAttribute(IS_VALID, false, null);
            }
            this.sysOut.println(this.indent(indent + 2) + "Invalid Element " + elmName + this.getInvalidText(jdfElement));
            if (testElement != null && !testElement.hasAttribute(ERROR_TYPE)) {
                this.setErrorType(testElement, "InvalidElement", elmName + this.getInvalidText(jdfElement), 2);
            }
            if (!bValidID && testElement != null) {
                KElement e = testElement.appendElement("TestAttribute");
                this.setErrorType(e, "MultipleID", "Multiply defined ID = " + id, indent);
                e.setAttribute("NodeName", "ID");
                e.setAttribute("Value", id);
                e.setAttribute("XPath", jdfElement.buildXPath(null, 1) + "/@ID");
            }
            boolean printMissElms = true;
            if (jdfElement instanceof JDFResource && (JDFResource.EnumResStatus.Incomplete.equals((Object)(r = (JDFResource)jdfElement).getResStatus(false)) || !r.isLeaf() && !JDFResource.EnumPartUsage.Implicit.equals((Object)r.getPartUsage()))) {
                printMissElms = false;
            }
            VString swapAtt = new VString();
            VString vTmp = jdfElement.knownElements();
            for (Object unknownAttr : unknownAttributes) {
                if (!vTmp.contains(unknownAttr)) continue;
                swapAtt.appendUnique((String)unknownAttr);
            }
            VString swapElem = new VString();
            vTmp = jdfElement.knownAttributes();
            for (String unknownElem : unknownElements) {
                if (!vTmp.contains(unknownElem)) continue;
                swapElem.appendUnique(unknownElem);
            }
            VString invalidAttributes = this.getInvalidAttributes(jdfElement);
            VString invalidElements = jdfElement.getInvalidElements(this.level, true, 9999999);
            VString missingAttributes = new VString();
            VString missingElements = new VString();
            VString deprecatedAttributes = jdfElement.getDeprecatedAttributes(9999999);
            VString deprecatedElements = jdfElement.getDeprecatedElements(9999999);
            VString prereleaseAttributes = jdfElement.getPrereleaseAttributes(9999999);
            VString prereleaseElements = jdfElement.getPrereleaseElements(9999999);
            invalidAttributes.removeStrings(unknownAttributes, 99999);
            invalidAttributes.removeStrings(deprecatedAttributes, 99999);
            invalidAttributes.removeStrings(prereleaseAttributes, 99999);
            unknownAttributes.removeStrings(prereleaseAttributes, 99999);
            unknownAttributes.removeStrings(deprecatedAttributes, 99999);
            invalidElements.removeStrings(unknownElements, 99999);
            invalidElements.removeStrings(deprecatedElements, 99999);
            invalidElements.removeStrings(prereleaseElements, 99999);
            unknownElements.removeStrings(deprecatedElements, 99999);
            unknownElements.removeStrings(prereleaseElements, 99999);
            unknownElements.removeStrings(swapElem, 99999);
            unknownAttributes.removeStrings(swapAtt, 99999);
            if (this.level.getValue() >= JDFElement.EnumValidationLevel.Complete.getValue()) {
                missingAttributes = new VString(jdfElement.getMissingAttributes(9999999));
                invalidAttributes.removeStrings(missingAttributes, 99999);
                missingElements = new VString(jdfElement.getMissingElements(9999999));
                invalidElements.removeStrings(missingElements, 99999);
            }
            if (!this.bWarning) {
                deprecatedElements = null;
                deprecatedAttributes = null;
            }
            unknownElements.unify();
            missingElements.unify();
            this.printAttributeList(indent, testElement, jdfElement, printMissElms, unknownAttributes, "Unknown", "Unknown Attribute");
            this.printAttributeList(indent, testElement, jdfElement, printMissElms, invalidAttributes, "Invalid", "Invalid attribute Value");
            this.printAttributeList(indent, testElement, jdfElement, printMissElms, deprecatedAttributes, "Deprecated", "Deprecated Attribute in JDF Version " + jdfElement.getVersion(true).getName());
            this.printAttributeList(indent, testElement, jdfElement, printMissElms, prereleaseAttributes, "PreRelease", "Attribute not yet defined in JDF Version " + jdfElement.getVersion(true).getName());
            this.printAttributeList(indent, testElement, jdfElement, printMissElms, missingAttributes, "Missing", "Missing Attribute");
            this.printAttributeList(indent, testElement, jdfElement, printMissElms, swapAtt, "Swap", "Element written as Attribute");
            for (String swEl : swapElem) {
                this.sysOut.println(this.indent(indent + 2) + "Attribute is written as Element: " + swEl);
            }
            if (swapElem.size() > 0 && testElement != null) {
                testElement.setAttribute("SwapElements", StringUtil.setvString(swapElem, " ", null, null));
            }
            if (printMissElms) {
                for (String missEl : missingElements) {
                    this.sysOut.println(this.indent(indent + 2) + "Missing Element: " + missEl);
                    if (testElement == null) continue;
                    KElement e = testElement.appendElement("TestElement");
                    this.setErrorType(e, "MissingElement", "Missing Element " + missEl);
                    e.setAttribute("XPath", jdfElement.buildXPath(null, 1) + "/" + missEl + "[1]");
                    e.setAttribute("NodeName", missEl);
                }
                if (testElement != null && missingElements.size() > 0) {
                    testElement.setAttribute("MissingElements", StringUtil.setvString(missingElements, " ", null, null));
                }
            }
            for (String elem : unknownElements) {
                this.sysOut.println(this.indent(indent + 2) + "Unknown Element: " + elem);
            }
            if (testElement != null && unknownElements.size() > 0) {
                testElement.setAttribute("UnknownElements", StringUtil.setvString(unknownElements, " ", null, null));
            }
            this.printElementList(indent, testElement, jdfElement, invalidElements, "Invalid");
            this.printElementList(indent, testElement, jdfElement, deprecatedElements, "Deprecated");
            this.printElementList(indent, testElement, jdfElement, prereleaseElements, "PreRelease");
            this.printElementList(indent, testElement, jdfElement, privateElements, "Private");
            if (jdfElement instanceof JDFResource && !(res = (JDFResource)jdfElement).isLeaf()) {
                VElement vr = res.getLeaves(false);
                for (KElement leaf : vr) {
                    this.printBad(leaf, indent + 2, testElement, false);
                }
            }
        }
        return jdfElement;
    }

    protected void printNonNamespace(KElement kElement, int indent, KElement xmlParent, String pref, String elmName, String nsURI, KElement testElement, boolean isJDFNS, boolean bTypo) {
        String nameSpaceURI = kElement.getNamespaceURI();
        String nsLower = nameSpaceURI.toLowerCase();
        if (nsLower.contains(".cip4.org") && !nsLower.equals("http://www.CIP4.org/JDFSchema_1_1")) {
            this.sysOut.println("Probable namespace Typo: xmlns=" + nameSpaceURI + " should be:http://www.CIP4.org/JDFSchema_1_1");
            if (testElement != null) {
                bTypo = this.setTypo(pref, elmName, nsURI, testElement);
            }
        }
        if (this.bPrintNameSpace) {
            this.sysOut.print(this.indent(indent + 2));
            String status = isJDFNS ? "Testing" : "Skipping";
            this.sysOut.print(status + " ");
            this.sysOut.println("Element that is not in JDF nameSpace: <" + kElement.getLocalName() + "> namespace:" + pref + "  uri: " + nsURI);
            this.setErrorType(testElement, "PrivateElement", "Element in Private NameSpace: " + elmName);
            if (testElement != null) {
                testElement.setAttribute("NSPrefix", pref);
                testElement.setAttribute("NSURI", nsURI);
                testElement.setAttribute("IsPrivate", true, null);
                testElement.setAttribute("Status", "Skipping");
            }
        }
        if (kElement instanceof JDFResourceLink) {
            this.printResourceLink((JDFResourceLink)kElement, indent, testElement);
        }
        if (kElement instanceof JDFRefElement) {
            this.printRefElement((JDFRefElement)kElement, indent, testElement);
        }
        if (kElement instanceof JDFResource) {
            this.printResource((JDFResource)kElement, indent, testElement);
        }
        if (!(this.bPrintNameSpace || bTypo || xmlParent == null || testElement == null || testElement.hasChildElements())) {
            testElement.deleteNode();
        }
    }

    protected KElement getTestElement(KElement kElement, KElement xmlParent) {
        KElement testElement = null;
        if (xmlParent != null) {
            testElement = xmlParent.appendElement("TestElement");
            testElement.setAttribute("XPath", kElement.buildXPath(null, 1));
            testElement.setAttribute("NodeName", kElement.getNodeName());
            String strID = kElement.getAttribute("ID", null, null);
            if (strID != null) {
                testElement.setAttribute("ID", strID);
            }
        }
        return testElement;
    }

    protected String getInvalidText(JDFElement jdfElement) {
        VString duplicateColors;
        if (jdfElement instanceof JDFColorPool && (duplicateColors = ((JDFColorPool)jdfElement).getDuplicateColors()) != null) {
            return " duplicate colors in colorPool: " + StringUtil.setvString(duplicateColors);
        }
        return " is not valid, see child elements for details";
    }

    private boolean setTypo(String pref, String elmName, String nsURI, KElement testElement) {
        boolean bTypo = true;
        testElement.setAttribute("NSPrefix", pref);
        testElement.setAttribute("NSURI", nsURI);
        testElement.setAttribute("IsPrivate", true, null);
        testElement.setAttribute("Status", "Skipping");
        this.setErrorType(testElement, "PrivateElement", "Element in Private NameSpace - probable Namespace Typo in: " + elmName + " Correct ns URI=http://www.CIP4.org/JDFSchema_1_1");
        return bTypo;
    }

    private VString getInvalidAttributes(JDFElement jdfElement) {
        VString invalidAttributes = new VString(jdfElement.getInvalidAttributes(this.level, true, 9999999));
        if (jdfElement instanceof JDFResource) {
            JDFResource r = (JDFResource)jdfElement;
            while (!r.isResourceRoot() && !r.isResourceElement()) {
                r = (JDFResource)r.getParentNode_KElement();
                invalidAttributes.appendUnique(r.getInvalidAttributes(this.level, true, 9999));
            }
        }
        return invalidAttributes;
    }

    private boolean isValidElement(boolean bIsValid, JDFElement jdfElement) {
        JDFResource r;
        boolean bl = bIsValid = jdfElement.isValid(this.level) && bIsValid;
        if (bIsValid && jdfElement instanceof JDFResource && !(r = (JDFResource)jdfElement).isResourceRoot() && !r.isResourceElement()) {
            r = (JDFResource)r.getParentNode();
            return this.isValidElement(bIsValid, r);
        }
        return bIsValid;
    }

    private boolean privateValidation(KElement toCheck, KElement report) {
        if (this.validatorFactory == null) {
            return true;
        }
        ICheckValidator v = this.validatorFactory.getValidator(toCheck);
        if (v == null) {
            return true;
        }
        return v.validate(toCheck, report);
    }

    private void printURL(KElement element, int indent, KElement testElement) {
        if (!element.hasAttribute("URL")) {
            return;
        }
        String url = element.getAttribute("URL");
        if (UrlUtil.getURLInputStream(url, element.getOwnerDocument_KElement().getBodyPart()) == null) {
            KElement e = testElement.appendElement("TestAttribute");
            this.setErrorType(e, "DanglingURL", "Dangling URL points to Nirvana: " + url, indent);
            e.setAttribute("NodeName", "URL");
            e.setAttribute("Value", url);
            e.setAttribute("XPath", element.buildXPath(null, 1) + "/@URL");
        }
    }

    private void printElementList(int indent, KElement testElement, JDFElement part, VString elementVector, String whatType) {
        if (elementVector == null) {
            return;
        }
        elementVector.unify();
        String potRef = " : ";
        if (whatType.equals("Invalid")) {
            potRef = "- (potential reference to invalid element): ";
        }
        for (int j = 0; j < elementVector.size(); ++j) {
            JDFElement ePart;
            KElement eInv;
            String invalidElem = elementVector.get(j);
            if (part.numChildElements(invalidElem, "") > 1) {
                this.sysOut.println(this.indent(indent + 2) + whatType + " Element " + potRef + invalidElem);
            }
            if ((eInv = ((KElement)(ePart = part)).getElement(invalidElem, null, 0)) != null || (eInv = ((KElement)ePart).getElement(invalidElem + "Ref", null, 0)) == null) continue;
            this.sysOut.println(this.indent(indent + 2) + whatType + " Element " + potRef + invalidElem + "Ref");
        }
        if (testElement != null && elementVector.size() > 0) {
            testElement.setAttribute(whatType + "Elements", StringUtil.setvString(elementVector, " ", null, null));
        }
    }

    private void printAttributeList(int indent, KElement testElement, JDFElement part, boolean printMissElms, VString attributeVector, String whatType, String message) {
        if (attributeVector == null) {
            return;
        }
        attributeVector.unify();
        String originalMessage = message;
        for (int j = 0; j < attributeVector.size(); ++j) {
            JDFElement.EnumVersion v;
            KElement e;
            message = originalMessage;
            String invalidAt = attributeVector.elementAt(j);
            if (!part.hasAttribute_KElement(invalidAt, "", false)) {
                if (JDFResource.EnumPartIDKey.getEnum(invalidAt) != null) {
                    if (part.getAttribute(invalidAt, null, null) == null) {
                        if (!printMissElms) continue;
                        e = testElement.appendElement("TestAttribute");
                        this.setErrorType(e, "MissingAttribute", "Missing Partition key: " + invalidAt, indent + 2);
                        e.setAttribute("NodeName", invalidAt);
                        e.setAttribute("XPath", part.buildXPath(null, 1) + "/@" + invalidAt);
                        continue;
                    }
                    e = testElement.appendElement("TestAttribute");
                    this.setErrorType(e, "InvalidAttribute", "Incorrectly placed Partition key: " + invalidAt, indent + 2);
                    e.setAttribute("NodeName", invalidAt);
                    e.setAttribute("XPath", part.buildXPath(null, 1) + "/@" + invalidAt);
                    continue;
                }
                if (part.hasAttribute(invalidAt, null, false) || !printMissElms) continue;
                e = testElement.appendElement("TestAttribute");
                this.setErrorType(e, "MissingAttribute", "Missing required attribute: " + invalidAt, indent + 2);
                e.setAttribute("NodeName", invalidAt);
                e.setAttribute("XPath", part.buildXPath(null, 1) + "/@" + invalidAt);
                continue;
            }
            this.sysOut.println(this.indent(indent + 2) + whatType + " Attribute: " + invalidAt + " = " + part.getAttribute(invalidAt));
            e = testElement.appendElement("TestAttribute");
            if (whatType.equals("PreRelease")) {
                v = part.getFirstVersion(invalidAt, false);
                if (v != null) {
                    e.setAttribute("FirstVersion", v.getName());
                    message = (String)message + " First valid Version: " + v.getName();
                }
            } else if (whatType.equals("Deprecated") && (v = part.getLastVersion(invalidAt, false)) != null) {
                e.setAttribute("LastVersion", v.getName());
                message = (String)message + " Last valid Version: " + v.getName();
            }
            this.setErrorType(e, whatType + "Attribute", invalidAt + " " + (String)message);
            e.setAttribute("NodeName", invalidAt);
            e.setAttribute("XPath", part.buildXPath(null, 1) + "/@" + invalidAt);
            e.setAttribute("Value", part.getAttribute(invalidAt));
        }
        if (attributeVector.size() > 0) {
            testElement.setAttribute(whatType + "Attributes", StringUtil.setvString(attributeVector, " ", null, null));
        }
    }

    private void printNodeRoot(JDFNode root, KElement xmlParent) {
        int i;
        VElement vProcs = root.getvJDFNode(null, null, false);
        int size = vProcs.size();
        for (i = 0; i < size; ++i) {
            VElement vLinks;
            JDFResourceLinkPool rlp;
            int j;
            JDFNode n = (JDFNode)vProcs.elementAt(i);
            this.vLinkedResources.appendUnique(n.getLinkedResources(null, true));
            JDFResourcePool rp = n.getResourcePool();
            if (rp != null) {
                VElement resources = rp.getPoolChildren(null, null, null);
                this.vResources.addAll(resources);
                int resSize = resources.size();
                for (j = 0; j < resSize; ++j) {
                    JDFResource jdfResource = (JDFResource)resources.elementAt(j);
                    VElement vjdfResource = jdfResource.getvHRefRes(true, true);
                    this.vResources.addAll(vjdfResource);
                }
                this.vResources.unify();
            }
            if ((rlp = n.getResourceLinkPool()) == null || (vLinks = rlp.getPoolChildren(null, null, null)) == null) continue;
            int size2 = vLinks.size();
            for (j = size2 - 1; j >= 0; --j) {
                JDFResourceLink rl = (JDFResourceLink)vLinks.elementAt(j);
                if (!n.isValidLink(this.level, rl)) {
                    this.vBadResourceLinks.add(rl);
                    continue;
                }
                JDFResource target = rl.getTarget();
                if (target != null) continue;
                this.vBadResourceLinks.add(rl);
            }
            this.vBadResourceLinks.unify();
        }
        VElement vr = new VElement();
        for (i = 0; i < this.vResources.size(); ++i) {
            JDFResource res = (JDFResource)this.vResources.elementAt(i);
            vr.appendUnique(res.getResourceRoot());
        }
        this.vResources = new VElement((Collection)vr);
        vr.clear();
        for (i = 0; i < this.vLinkedResources.size(); ++i) {
            if (!(this.vLinkedResources.elementAt(i) instanceof JDFResource)) continue;
            JDFResource linkedRes = (JDFResource)this.vLinkedResources.elementAt(i);
            vr.appendUnique(linkedRes.getResourceRoot());
        }
        this.vLinkedResources = new VElement((Collection)vr);
        KElement sepPool = null;
        if (xmlParent != null) {
            sepPool = xmlParent.appendElement("SeparationPool");
        }
        if (!this.bQuiet) {
            for (i = 0; i < this.vSeparations2.size(); ++i) {
                this.sysOut.println("Separation Name: " + this.vSeparations2.elementAt(i));
                if (sepPool == null) continue;
                KElement sep = sepPool.appendElement("Separation");
                sep.setAttribute("SeparationName", this.vSeparations2.get(i));
            }
        }
        for (String sep : this.vSeparations) {
            this.sysOut.println("Warning: Separation Name not in ColorPool: " + sep);
            if (sepPool == null) continue;
            KElement warn = sepPool.appendElement("Warning");
            this.setErrorType(warn, "MissingSeparation", "Separation Name " + sep + " is not in ColorPool");
            warn.setAttribute("Separation", sep);
        }
        for (String sep : this.vColorPoolSeparations) {
            this.sysOut.println("Warning: Unreferenced Separation Name    : " + sep);
            if (sepPool == null) continue;
            KElement warn = sepPool.appendElement("Warning");
            this.setErrorType(warn, "UnreferencedSeparation", "Unreferenced Separation Name: " + sep + " in ColorPool");
            warn.setAttribute("Separation", sep);
        }
        if (sepPool != null && !sepPool.hasChildElements() && xmlParent != null) {
            xmlParent.removeChild(sepPool);
        }
    }

    private void printPrivate(VString privateAttributes, VString privateElements, KElement jdfElement, int indent, KElement testElement) {
        int j;
        if (!privateAttributes.isEmpty() || !privateElements.isEmpty()) {
            this.sysOut.println(this.indent(indent) + "Element with private contents:   " + jdfElement.buildXPath(null, 1) + " " + jdfElement.getAttribute("ID", null, ""));
            if (testElement != null) {
                this.setErrorType(testElement, "PrivateContents", "Element with private contents");
                if (privateElements.size() > 0) {
                    testElement.setAttribute("PrivateElements", StringUtil.setvString(privateElements, " ", null, null));
                }
            }
        }
        for (j = 0; j < privateAttributes.size(); ++j) {
            KElement e;
            String privateAttribute = privateAttributes.elementAt(j);
            String prefix = StringUtil.token(privateAttribute, 0, ":");
            String localname = StringUtil.token(privateAttribute, 1, ":");
            if (prefix != null && prefix.equals("xmlns")) {
                if (this.foundNameSpaces.contains(privateAttribute)) continue;
                this.sysOut.println(this.indent(indent + 2) + "Foreign namespace found: " + localname + " " + jdfElement.getAttribute(privateAttribute));
                if (testElement != null) {
                    e = testElement.appendElement("ForeignNSFound");
                    e.setAttribute("NSPrefix", localname);
                    e.setAttribute("NSURI", jdfElement.getAttribute(privateAttribute));
                }
                this.foundNameSpaces.addElement(privateAttribute);
                continue;
            }
            this.sysOut.println(this.indent(indent + 2) + "Private Attribute:     " + prefix + " " + localname + " = " + jdfElement.getAttribute(privateAttribute));
            if (testElement == null) continue;
            e = testElement.appendElement("TestAttribute");
            e.setAttribute("IsPrivate", "true");
            e.setAttribute("NSPrefix", prefix);
            e.setAttribute("NSURI", jdfElement.getNamespaceURIFromPrefix(prefix));
            e.setAttribute(ERROR_TYPE, "PrivateAttribute");
            e.setAttribute("NodeName", privateAttribute);
            e.setAttribute("Value", jdfElement.getAttribute(privateAttribute));
            e.setAttribute("XPath", jdfElement.buildXPath(null, 1) + "/@" + privateAttribute);
        }
        for (j = 0; j < privateElements.size(); ++j) {
            this.sysOut.println(this.indent(indent + 2) + "Private Element:       " + privateElements.get(j));
        }
    }

    private boolean printNode(JDFNode jdfNode, int indent, KElement testElement) {
        boolean bValidJobPartID;
        boolean isValid = true;
        String jobPartID = jdfNode.getJobPartID(false);
        VString vMissingLinks = JDFElement.EnumValidationLevel.isRequired(this.level) ? jdfNode.getMissingLinkVector(9999999) : null;
        VString vInvalidLinks = jdfNode.getInvalidLinks(this.level, 9999999);
        boolean bl = bValidJobPartID = !this.vBadJobPartID.contains(jobPartID);
        if (!bValidJobPartID) {
            KElement e = testElement.appendElement("TestAttribute");
            if (jobPartID.equals("")) {
                this.setErrorType(e, "MissingAttribute", "Missing JobPartID - required by Base ICS", indent);
            } else {
                this.setErrorType(e, "MultipleID", "Multiply defined JobPartID = " + jobPartID, indent);
                e.setAttribute("Value", jobPartID);
            }
            e.setAttribute("NodeName", "JobPartID");
            e.setAttribute("XPath", jdfNode.buildXPath(null, 1) + "/@JobPartID");
        } else {
            this.vJobPartID.add(jobPartID);
        }
        isValid = this.checkType(jdfNode, indent, testElement, isValid);
        if (vMissingLinks != null) {
            if (vInvalidLinks != null) {
                vInvalidLinks.removeStrings(vMissingLinks, 9999);
            }
            if (testElement != null && JDFElement.EnumValidationLevel.isRequired(this.level)) {
                if (jdfNode.getElement("ResourceLinkPool", null, 0) == null) {
                    KElement pool = testElement.appendElement("TestElement");
                    this.setErrorType(pool, "MissingElement", "Missing ResourceLinkPool");
                    pool.setAttribute("NodeName", "ResourceLinkPool");
                }
                this.printResourceLinkPool(jdfNode.buildXPath(null, 1) + "/ResourceLinkPool[1]", testElement, vMissingLinks, "Missing");
            }
        }
        if (vInvalidLinks != null && vInvalidLinks.size() > 0) {
            this.printResourceLinkPool(jdfNode.buildXPath(null, 1) + "/ResourceLinkPool[1]", testElement, vInvalidLinks, "Invalid");
        }
        return isValid;
    }

    private boolean checkType(JDFNode jdfNode, int indent, KElement testElement, boolean isValid) {
        boolean isValidLocal = isValid;
        String errMessage = this.indent(indent) + "!!! InValid Element: " + jdfNode.buildXPath(null, 1) + " " + jdfNode.getID() + " !!! ";
        if (jdfNode.hasAttribute("Type")) {
            JDFNode n;
            String typeString = jdfNode.getType();
            String nodeType = this.indent(indent) + "Node Type = " + typeString;
            if (jdfNode.hasAttribute("Types", "", false)) {
                nodeType = nodeType + " - " + jdfNode.getAttribute("Types");
            }
            testElement.setAttribute("Type", typeString);
            if (jdfNode.hasAttribute("Types")) {
                testElement.setAttribute("Types", jdfNode.getAttribute("Types"));
                if (this.bPrintNameSpace && jdfNode.getEnumTypes() == null) {
                    VString vs = jdfNode.getTypes();
                    Object msg = "";
                    int n2 = 0;
                    if (vs != null) {
                        for (int i = 0; i < vs.size(); ++i) {
                            String t = vs.get(i);
                            if (JDFNode.EnumType.getEnum(t) != null || ArrayUtils.contains((Object[])aGBList, (Object)t)) continue;
                            if (n2++ > 0) {
                                msg = (String)msg + "; ";
                            }
                            msg = (String)msg + t;
                        }
                    }
                    if (n2 > 0) {
                        KElement e = testElement.appendElement("TestAttribute");
                        this.setErrorType(e, "ExtensionType", "JDF/@Types contains extension types: " + (String)msg, indent + 2);
                        e.setAttribute("XPath", jdfNode.buildXPath(null, 1) + "/@Types");
                        e.setAttribute("NodeName", "Types");
                        e.setAttribute("Value", (String)msg);
                    }
                }
            }
            if (this.bPrintNameSpace && JDFNode.EnumType.getEnum(typeString) == null) {
                KElement e = testElement.appendElement("TestAttribute");
                this.setErrorType(e, "ExtensionType", "Type is an extension type: " + typeString, indent + 2);
                e.setAttribute("XPath", jdfNode.buildXPath(null, 1) + "/@Type");
                e.setAttribute("NodeName", "Type");
                e.setAttribute("Value", typeString);
            }
            if (typeString.equals("Product") && (n = jdfNode.getParentJDF()) != null && !"Product".equals(n.getType())) {
                isValidLocal = false;
                this.sysOut.println(errMessage);
                this.sysOut.println(nodeType);
                this.sysOut.println(this.indent(indent) + "Invalid Parent for JDF Product: Type= " + n.getType());
                this.setErrorType(testElement, "InvalidParentForProduct", "Invalid Parent for JDF Product: Type = " + n.getType());
                testElement.setAttribute("NodeName", "JDF");
                testElement.setAttribute("XPath", n.buildXPath(null, 1));
            }
        }
        return isValidLocal;
    }

    private void printResourceLinkPool(String rlpXPath, KElement testElement, VString vLinks, String missBad) {
        if (vLinks != null) {
            int size = vLinks.size();
            for (int i = 0; i < size; ++i) {
                String missResLink = vLinks.get(0);
                if (testElement != null) {
                    String procUsage;
                    KElement e = testElement.appendElement("TestElement");
                    String name = missResLink.indexOf(":") > 0 ? StringUtil.token(missResLink, 0, ":") : missResLink;
                    String string = procUsage = missResLink.indexOf(":") > 0 ? StringUtil.token(missResLink, 1, ":") : "";
                    if (procUsage.startsWith("Any")) {
                        procUsage = procUsage.substring(3);
                    }
                    this.setErrorType(e, missBad + "ResourceLink", missBad + procUsage + " resourceLink ");
                    e.setAttribute("NodeName", name);
                    if (!procUsage.equals("")) {
                        e.setAttribute("ProcessUsage", procUsage);
                    }
                    e.setAttribute("XPath", rlpXPath + "/" + name + "[1]");
                }
                vLinks.removeElement(missResLink);
            }
        }
    }

    private boolean printRefElement(JDFRefElement re, int indent, KElement testElement) {
        boolean isValid = true;
        String rRef = re.getrRef();
        String refName = re.getNodeName();
        String errMessage = this.indent(indent) + "!!! InValid Element: " + re.buildXPath(null, 1) + " !!! ";
        if (testElement != null) {
            testElement.setAttribute("rRef", rRef);
            if (re.hasAttribute("rSubRef")) {
                testElement.setAttribute("rSubRef", re.getrSubRef());
            }
        }
        if (this.vBadID.contains(rRef)) {
            isValid = false;
            this.sysOut.println(errMessage);
            this.sysOut.println(this.indent(indent) + "Invalid RefElement: " + refName + ". Points to the element with multiply defined ID=" + rRef);
            this.setErrorType(testElement, "InvalidRefElement", "RefElement: " + refName + "Points to the multiply defined ID");
        } else {
            JDFResource targEl = re.getTarget();
            if (targEl == null) {
                isValid = false;
                this.sysOut.println(errMessage);
                this.sysOut.println(this.indent(indent) + "Dangling RefElement: " + refName + " rRef=" + rRef);
                JDFResource targRoot = re.getTargetRoot();
                if (targRoot != null) {
                    this.sysOut.println(this.indent(indent) + "Refelement points to non-existing partition: " + re.getPartMap().toString());
                }
                if (testElement != null) {
                    if (targRoot == null) {
                        this.setErrorType(testElement, "DanglingRefElement", "RefElement points to nonexisting ID. rRef=" + rRef);
                    } else {
                        this.setErrorType(testElement, "DanglingPartRefElement", "RefElement points to nonexisting Partition. rRef=" + rRef);
                        testElement.appendElement("Part").setAttributes(re.getPartMap());
                        testElement.setAttribute("ResourcePartUsage", targRoot.getPartUsage().getName(), null);
                    }
                }
            } else if (!re.isValid(this.level)) {
                isValid = false;
                this.sysOut.println(errMessage);
                this.sysOut.println(this.indent(indent) + "Invalid RefElement: " + refName + " rRef=" + rRef + (String)(re.hasAttribute("rSubRef") ? " rSubRef=" + re.getrSubRef() : "") + ". Points to " + re.getRefNodeName() + " ID=" + targEl.getAttribute("ID", null, ""));
                if (!re.validResourcePosition()) {
                    JDFNode targJDF = targEl.getParentJDF();
                    String targID = targJDF == null ? "" : targJDF.getID();
                    JDFNode refJDF = re.getParentJDF();
                    String refID = refJDF == null ? "" : refJDF.getID();
                    this.setErrorType(testElement, "InvalidRefElement", "Invalid Context: Resource node (ID=" + targID + ") is not an ancestor of RefElement node (ID=" + refID + ")", indent);
                }
            }
        }
        return isValid;
    }

    private boolean printResource(JDFResource r, int indent, KElement testElement) {
        boolean isValid = true;
        if (this.vResources.contains(r)) {
            if (!this.vLinkedResources.contains(r)) {
                isValid = false;
                this.sysOut.println(this.indent(indent) + "!!! InValid Element: " + r.buildXPath(null, 1) + " " + r.getID() + " !!! ");
                this.sysOut.println(this.indent(indent) + "Unlinked Resource: " + r.getNodeName() + " " + r.getID());
                if (testElement != null) {
                    this.setErrorType(testElement, "UnlinkedResource", "Resource is not linked or referenced");
                }
            }
            this.vResources.removeElement(r);
        }
        return isValid;
    }

    private boolean printResourceLink(JDFResourceLink rl, int indent, KElement testElement) {
        boolean isValid = true;
        if (this.vBadResourceLinks.contains(rl)) {
            String rRef = rl.getrRef();
            String resLinkName = rl.getNodeName();
            String procUsage = rl.hasAttribute("ProcessUsage") && !rl.getProcessUsage().equals("") ? "(ProcessUsage:" + rl.getProcessUsage() + ")" : "";
            String errMessage = this.indent(indent) + "!!! InValid Element: " + rl.buildXPath(null, 1) + " !!! ";
            if (testElement != null) {
                this.setErrorType(testElement, "InvalidResourceLink", "Invalid ResourceLink");
                testElement.setAttribute("rRef", rRef);
                if (rl.getUsage() != null) {
                    testElement.setAttribute("Usage", rl.getUsage().getName());
                }
                if (rl.hasAttribute("ProcessUsage") && !rl.getProcessUsage().equals("")) {
                    testElement.setAttribute("ProcessUsage", rl.getProcessUsage());
                }
            }
            if (this.vBadID.contains(rRef)) {
                isValid = false;
                this.sysOut.println(errMessage);
                this.sysOut.println(this.indent(indent) + "Invalid " + rl.getAttribute("Usage") + " ResLink: " + resLinkName + procUsage + "\nrRef points to the multiply defined ID=\"" + rRef + "\"");
                if (testElement != null) {
                    this.setErrorType(testElement, "ResLinkMultipleID", "ResourceLink rRef points to the multiply defined ID:" + rRef);
                }
            } else {
                JDFResource res = rl.getTarget();
                if (res == null) {
                    isValid = false;
                    this.sysOut.println(errMessage);
                    this.sysOut.println(this.indent(indent) + "Dangling " + rl.getAttribute("Usage") + " ResLink: " + resLinkName + procUsage + " " + rRef);
                    JDFResource targRoot = rl.getLinkRoot();
                    if (targRoot != null) {
                        this.sysOut.println(this.indent(indent) + "Resource Link points to non-existing partition: " + rl.getPartMapVector().toString());
                    }
                    if (testElement != null) {
                        if (targRoot == null) {
                            this.setErrorType(testElement, "DanglingResLink", "Dangling ResourceLink; no Resource with ID = " + rRef);
                        } else {
                            this.setErrorType(testElement, "DanglingPartResLink", "ResourceLink points to nonexisting Partition. rRef=" + rRef);
                            testElement.appendElement("Part").setAttributes(rl.getPartMapVector().elementAt(0));
                            testElement.setAttribute("ResourcePartUsage", targRoot.getPartUsage().getName(), null);
                        }
                    }
                } else {
                    isValid = false;
                    this.sysOut.println(errMessage);
                    this.sysOut.print(this.indent(indent) + "Invalid " + rl.getAttribute("Usage") + " ResLink: " + resLinkName + procUsage + " " + rRef + ". ");
                    if (!rl.validResourcePosition()) {
                        String errStr = "Points to: " + res.getNodeName() + ". Resource Node (ID=" + res.getParentJDF().getID() + ") is not an ancestor of ResLink Node (ID=" + rl.getParentJDF().getID() + ")";
                        this.sysOut.print(errStr);
                        this.setErrorType(testElement, "InvalidPosition", errStr);
                    } else if (rl.isValid(this.level)) {
                        String resName = res.getLocalName();
                        VString strLinkNames = res.getParentJDF().linkNames();
                        if (strLinkNames != null && strLinkNames.indexOf(resName) == -1) {
                            this.sysOut.print(" Unknown ResLink for this Type of Process");
                            if (testElement != null) {
                                this.setErrorType(testElement, "UnknownResourceLink", "Unknown ResourceLink for Process " + res.getParentJDF().getType());
                            }
                        } else {
                            JDFNode n = rl.getParentJDF();
                            if (!n.isValidLink(this.level, rl)) {
                                boolean foundMissing = false;
                                if (!rl.hasAttribute("ProcessUsage")) {
                                    VString vMissingLinks = n.getMissingLinkVector(9999);
                                    if (vMissingLinks != null) {
                                        int missLinkSize = vMissingLinks.size();
                                        for (int ii = 0; ii < missLinkSize; ++ii) {
                                            String linkName;
                                            VString vs = new VString(StringUtil.tokenize(vMissingLinks.elementAt(ii), ":", false));
                                            if (vs.size() != 2 || !(linkName = vs.elementAt(0)).equals(rl.getNodeName())) continue;
                                            this.sysOut.print(" (Potential missing ProcessUsage: " + vs.elementAt(1) + ")");
                                            this.setErrorType(testElement, "MissingProcessUsage", "Potential missing ProcessUsage: " + vs.elementAt(1));
                                            foundMissing = true;
                                        }
                                    }
                                    if (!foundMissing) {
                                        this.setErrorType(testElement, "UnknownResourceLink", "Incorrect ResourceLink @Usage or @ProcessUsage for Process " + n.getType());
                                    }
                                }
                            } else {
                                this.sysOut.print(" (Potentially ResLink has a wrong cardinality)");
                                if (testElement != null) {
                                    this.setErrorType(testElement, "ResLinkCardinality", "Potentially ResLink has a wrong cardinality");
                                }
                            }
                        }
                    }
                    this.sysOut.println();
                }
            }
            this.vBadResourceLinks.removeElement(rl);
        }
        return isValid;
    }

    private void printDevCap(JDFElement jdfRoot, KElement testElement) {
        if (this.devCapFile == null || this.devCapFile.equals("") || !(jdfRoot instanceof JDFNode)) {
            return;
        }
        JDFNode jdfNode = (JDFNode)jdfRoot;
        JDFDoc docDevCap = JDFDoc.parseFile(this.devCapFile);
        JDFJMF jmfRoot = docDevCap.getJMFRoot();
        if (jmfRoot == null) {
            this.sysOut.println("JMFNode == null --> can't start Test");
            if (testElement != null) {
                KElement kEl = testElement.appendElement("Error");
                kEl.setAttribute(MESSAGE, "JMFNode == null. Can't start Test");
            }
            return;
        }
        JDFDeviceCap deviceCap = (JDFDeviceCap)jmfRoot.getChildByTagName("DeviceCap", null, 0, null, false, true);
        if (deviceCap == null) {
            this.sysOut.println("No DeviceCap element found --> can't start Test");
            if (testElement != null) {
                KElement kEl = testElement.appendElement("Error");
                kEl.setAttribute(MESSAGE, "No DeviceCap element found. Can't start Test");
            }
            return;
        }
        deviceCap.setIgnoreExtensions(!this.bPrintNameSpace);
        this.sysOut.println("\n**********************************************************");
        this.sysOut.println("\nOutput of DeviceCapability test result follows:\n");
        KElement execRoot = testElement.appendElement("ExecutableNodes");
        VElement vExecNodes = deviceCap.getExecutableJDF(jdfNode, this.testlists, this.level);
        if (vExecNodes != null) {
            this.sysOut.println("\nExecutable Nodes are:");
            for (int j = 0; j < vExecNodes.size(); ++j) {
                JDFNode node = (JDFNode)vExecNodes.elementAt(j);
                String id = node.getAttribute("ID");
                String descrName = node.getAttribute("DescriptiveName", null, null);
                String xPath = node.buildXPath(null, 1);
                this.sysOut.println(xPath + " ID= " + id + " " + descrName);
                if (execRoot == null) continue;
                KElement exNode = execRoot.appendElement("ExecutableNode");
                exNode.setAttribute("XPath", xPath);
                exNode.setAttribute("ID", id);
                exNode.setAttribute("DescriptiveName", descrName);
            }
            this.sysOut.println();
        } else {
            this.sysOut.println("\nNo executable nodes that fit device capabilities were found");
            if (execRoot != null) {
                execRoot.setAttribute(MESSAGE, "No Executable Nodes were found");
            }
        }
        XMLDoc testResult = deviceCap.getBadJDFInfo(jdfNode, this.testlists, this.level);
        if (testResult == null) {
            this.sysOut.println("\nResult of getBadJDFInfo: No bad JDF are found\n");
            KElement bugReportRoot = testElement.appendElement("BugReport");
            bugReportRoot.setAttribute(MESSAGE, "No bad JDF were found");
        } else {
            testElement.copyElement(testResult.getRoot(), null);
        }
    }

    private void printJMFDevCap(JDFElement jdfRoot, KElement testElement) {
        if (this.devCapFile == null || this.devCapFile.equals("") || !(jdfRoot instanceof JDFJMF)) {
            return;
        }
        JDFJMF jdfNode = (JDFJMF)jdfRoot;
        JDFParser p = new JDFParser();
        JDFDoc docDevCap = p.parseFile(this.devCapFile);
        JDFJMF jmfRoot = docDevCap.getJMFRoot();
        if (jmfRoot == null) {
            this.sysOut.println("JMFNode == null --> can't start Test");
            if (testElement != null) {
                KElement kEl = testElement.appendElement("Error");
                kEl.setAttribute(MESSAGE, "JMFNode == null. Can't start Test");
            }
            return;
        }
        this.sysOut.println("\n**********************************************************");
        this.sysOut.println("\nOutput of DeviceCapability test result follows:\n");
        XMLDoc testResult = JDFDeviceCap.getJMFInfo(jdfNode, jmfRoot.getResponse(0), this.testlists, this.level, !this.bPrintNameSpace);
        if (testResult == null) {
            this.sysOut.println("\nResult of getBadJDFInfo: No bad JDF are found\n");
            KElement bugReportRoot = testElement.appendElement("BugReport");
            bugReportRoot.setAttribute(MESSAGE, "No bad JDF were found");
        } else {
            KElement jRoot = testElement.copyElement(testResult.getRoot(), null);
            if (!jRoot.getBoolAttribute(IS_VALID, null, true)) {
                testElement.setAttribute(IS_VALID, false, null);
            }
            this.sysOut.println("\nResult of getBadJDFInfo: " + testResult.toString());
        }
    }

    private void removeValidEntriesIfQuiet(KElement root, boolean bRoot) {
        if (root == null) {
            return;
        }
        JDFAttributeMap mInv = new JDFAttributeMap(IS_VALID, "false");
        JDFAttributeMap mVal = new JDFAttributeMap(IS_VALID, "true");
        List<KElement> vEl = root.getChildArray_KElement(null, null, null, true, 0);
        boolean bValid = true;
        for (int i = vEl.size() - 1; i >= 0; --i) {
            KElement el = vEl.get(i);
            if (el == null || !el.getLocalName().startsWith("Test")) continue;
            if (el.hasAttribute(IS_VALID) && el.getBoolAttribute(IS_VALID, null, false)) {
                KElement invChild = el.getChildByTagName(null, null, 0, mInv, false, true);
                if (invChild == null) {
                    if (!this.bQuiet) continue;
                    String eName = el.getLocalName();
                    JDFAttributeMap mPrivate = new JDFAttributeMap();
                    mPrivate.put("HasPrivateContents", "true");
                    mPrivate.put("IsPrivate", "true");
                    this.removeValidEntriesIfQuiet(el, false);
                    if (el.getBoolAttribute("HasPrivateContents", null, false) || "ForeignNSFound".equals(eName) || el.getChildByTagName(null, null, 0, mPrivate, false, false) != null) continue;
                    el.deleteNode();
                    continue;
                }
                this.removeValidEntriesIfQuiet(el, false);
                KElement valChild = el.getChildByTagName(null, null, 0, null, false, true);
                if (valChild == null || el.hasAttribute(ERROR_TYPE)) continue;
                this.setErrorType(el, "InvalidElement", "Element is not valid, see child elements for details");
                el.setAttribute(IS_VALID, false, null);
                bValid = false;
                continue;
            }
            bValid = false;
            KElement valChild = el.getChildByTagName(null, null, 0, mVal, false, true);
            if (valChild != null) {
                this.removeValidEntriesIfQuiet(el, false);
            }
            if ((valChild = el.getChildByTagName(null, null, 0, mVal, false, true)) == null || el.hasAttribute(ERROR_TYPE)) continue;
            this.setErrorType(el, "InvalidElement", "Element is not valid, see child elements for details");
        }
        if (!bValid && bRoot) {
            root.setAttribute(IS_VALID, false, null);
        }
    }

    private JDFDoc parseFile(String xmlFile, XMLErrorHandler errorHandler) {
        JDFDoc gd = null;
        JDFParser p = JDFParserFactory.getFactory().get();
        p.setJDFSchemaLocation(UrlUtil.urlToFile(this.schemaLocation));
        p.m_ErrorHandler = errorHandler;
        gd = p.parseFile(xmlFile);
        if (gd == null && !this.bTryFormats) {
            this.sysOut.println("Error parsing File: " + xmlFile);
        }
        JDFParserFactory.getFactory().push(p);
        return gd;
    }

    public void setJDFSchemaLocation(String _schemaLocation) {
        this.schemaLocation = _schemaLocation;
    }

    public void setJDFSchemaLocation(File _schemaLocation) {
        String fileToUrl = UrlUtil.fileToUrl(_schemaLocation, false);
        this.setJDFSchemaLocation(fileToUrl);
    }

    public XMLDoc processAllFiles() {
        if (this.allFiles == null) {
            return null;
        }
        this.inOutputLoop = true;
        for (int arg = 0; arg < this.allFiles.size(); ++arg) {
            String xmlFile = this.allFiles.get(arg);
            VString vFiles = new VString();
            File argFile = new File(xmlFile);
            if (argFile.isDirectory()) {
                File[] lFiles;
                for (File fil : lFiles = argFile.listFiles()) {
                    if (fil.isDirectory() || !fil.canRead()) continue;
                    vFiles.add(fil.getPath());
                }
            } else if (xmlFile.toLowerCase().endsWith(".zip")) {
                this.processZipFile(argFile);
            } else if (xmlFile.toLowerCase().endsWith(".mjm")) {
                try {
                    this.processMimeStream(new FileInputStream(argFile));
                }
                catch (FileNotFoundException lFiles) {}
            } else {
                vFiles.add(xmlFile);
            }
            for (int ff = 0; ff < vFiles.size(); ++ff) {
                xmlFile = vFiles.elementAt(ff);
                this.processSingleFile(xmlFile);
            }
        }
        this.inOutputLoop = false;
        this.finalizeOutput();
        return this.pOut;
    }

    private void finalizeOutput() {
        if (this.inOutputLoop) {
            return;
        }
        if (this.xmlOutputName != null && this.xmlOutputName.length() > 0) {
            if (this.xslStyleSheet != null) {
                this.pOut.setXSLTURL(this.xslStyleSheet);
                if (this.translation != null) {
                    this.pOut.getRoot().setAttribute("Language", this.translation);
                }
            }
            this.pOut.write2File(this.xmlOutputName, 2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLDoc processZipFile(File argFile) {
        boolean bTryKeep = this.bTryFormats;
        ZipFile zip = null;
        try {
            zip = new ZipFile(argFile);
            Enumeration<? extends ZipEntry> zipEnum = zip.entries();
            int n = 0;
            while (zipEnum.hasMoreElements()) {
                ZipEntry ze = zipEnum.nextElement();
                String nam = ze.getName();
                if (ze.isDirectory()) continue;
                if (!this.bQuiet) {
                    this.sysOut.println(++n + " " + nam);
                }
                InputStream inStream = zip.getInputStream(ze);
                this.processSingleStream(inStream, nam, null);
                if (inStream != null) {
                    inStream.close();
                }
                bTryKeep = bTryKeep && this.bTryFormats;
            }
        }
        catch (ZipException e) {
            if (!this.bTryFormats) {
                KElement testFileRoot = this.pOut.getRoot().appendElement("TestFile");
                testFileRoot = testFileRoot.appendElement("Error");
                testFileRoot.setAttribute(MESSAGE, "Invalid zip file, Bailing out!");
                this.sysOut.println("Invalid zip file, Bailing out!");
            }
        }
        catch (IOException e) {
            if (!this.bTryFormats) {
                KElement testFileRoot = this.pOut.getRoot().appendElement("TestFile");
                testFileRoot = testFileRoot.appendElement("Error");
                testFileRoot.setAttribute(MESSAGE, "I/O Exception on zip file, Bailing out!");
                this.sysOut.println("I/O Exception on zip file, Bailing out!");
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {}
            }
        }
        this.bTryFormats = bTryKeep;
        return this.pOut;
    }

    public XMLDoc processMimeStream(InputStream inStream) {
        int count;
        Multipart multi = MimeUtil.getMultiPart(inStream);
        boolean bTryKeep = this.bTryFormats;
        if (multi == null) {
            return null;
        }
        try {
            count = multi.getCount();
        }
        catch (MessagingException e1) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            try {
                BodyPart bp = multi.getBodyPart(i);
                if (bp == null) continue;
                InputStream bpStream = bp.getInputStream();
                String fiName = bp.getFileName();
                String contentType = bp.getContentType();
                if (MimeUtil.isJDFMimeType(contentType)) {
                    this.processSingleStream(bpStream, fiName, bp);
                    bTryKeep = bTryKeep && this.bTryFormats;
                    continue;
                }
                this.sysOut.println("Mime extraction Skipping: " + fiName);
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        this.bTryFormats = bTryKeep;
        return this.pOut;
    }

    public XMLDoc processSingleDocument(JDFDoc doc) {
        if (doc != null) {
            this.theDoc = doc;
        }
        return this.processSingleFile(null, null, null, null);
    }

    public boolean isValid(JDFDoc doc) {
        XMLDoc d;
        if (doc != null) {
            this.theDoc = doc;
        }
        if ((d = this.processSingleFile(null, null, null, null)) == null) {
            return false;
        }
        KElement testFile = d.getRoot().getElement("TestFile", null, -1);
        if (testFile == null) {
            return false;
        }
        return "true".equals(testFile.getXPathAttribute("CheckJDFOutput/@IsValid", null));
    }

    public XMLDoc processSingleURLStream(InputStream stream, String url) {
        this.theDoc = null;
        return this.processSingleFile(stream, url, null, null);
    }

    public XMLDoc processSingleStream(InputStream stream, String fileName, BodyPart bp) {
        this.theDoc = null;
        return this.processSingleFile(stream, null, fileName, bp);
    }

    public XMLDoc processSingleFile(String fileName) {
        this.theDoc = null;
        File file = new File(fileName);
        this.bTryFormats = file.canRead();
        XMLDoc d = this.processSingleFile(null, null, fileName, null);
        if (!this.bTryFormats) {
            return d;
        }
        if (this.bTryFormats) {
            d = this.processZipFile(file);
        }
        if (this.bTryFormats) {
            BufferedInputStream inStream = FileUtil.getBufferedInputStream(file);
            d = this.processMimeStream(inStream);
            StreamUtil.close(inStream);
        }
        return d;
    }

    @Deprecated
    public XMLDoc processSingleFile(InputStream inStream, String url, String xmlFile) {
        return this.processSingleFile(inStream, url, xmlFile, null);
    }

    protected XMLDoc processSingleFile(InputStream inStream, String url, String xmlFile, BodyPart bp) {
        KElement testFileRoot = this.pOut.getRoot().appendElement("TestFile");
        if (inStream == null && url == null && xmlFile == null && this.theDoc == null) {
            testFileRoot = testFileRoot.appendElement("Error");
            testFileRoot.setAttribute(MESSAGE, "No input URL, stream or file. Bailing out!");
            this.sysOut.println("No input URL, stream or file. Bailing out!");
            return this.pOut;
        }
        this.foundNameSpaces = new VString();
        this.vID.clear();
        this.vBadID.clear();
        this.vJobPartID.clear();
        this.vJobPartID.add("");
        this.vResources.clear();
        this.vLinkedResources.clear();
        this.vBadResourceLinks = new VElement();
        this.vSeparations = new VString();
        this.vSeparations2 = new VString();
        this.vColorPoolSeparations = new VString();
        long lSchemaValidationTime = 0L;
        long lCheckJDFTime = 0L;
        long lTotalTime = 0L;
        long lDevCapsTime = 0L;
        long lStartTime = System.currentTimeMillis();
        long lEndTime = 0L;
        long lStartTime_SchemaValidation = 0L;
        long lEndTime_SchemaValidation = 0L;
        long lStartTime_InternalCheckJDF = 0L;
        long lEndTime_InternalCheckJDF = 0L;
        if (!this.bQuiet) {
            this.sysOut.println("\n**********************************************************");
            this.sysOut.println("       *** Checking " + (xmlFile == null ? "JDFDoc" : xmlFile) + " *** ");
            if (url != null && url.length() > 0) {
                this.sysOut.println("           " + url);
            }
            this.sysOut.println("**********************************************************\n");
        }
        if (xmlFile != null) {
            testFileRoot.setAttribute("FileName", xmlFile);
        }
        if (url != null && url.length() > 0) {
            testFileRoot.setAttribute("URL", url);
        }
        try {
            lStartTime_SchemaValidation = System.currentTimeMillis();
            if (this.bValidate) {
                this.sysOut.println("\n**********************************************************");
                this.sysOut.println("\nOutput of the XERCES schema validation follows:\n");
            }
            if (this.theDoc == null) {
                if (inStream == null) {
                    this.theDoc = this.parseFile(xmlFile, null);
                } else {
                    JDFParser p = new JDFParser();
                    p.setJDFSchemaLocation(this.schemaLocation);
                    this.theDoc = p.parseStream(inStream);
                    if (this.theDoc != null) {
                        this.theDoc.setBodyPart(bp);
                    }
                }
            }
            this.bTryFormats = this.bTryFormats && this.theDoc == null;
            lEndTime_SchemaValidation = System.currentTimeMillis();
            if (this.theDoc == null) {
                if (this.bTryFormats) {
                    testFileRoot.deleteNode();
                } else {
                    KElement kEl = testFileRoot.appendElement("Error");
                    kEl.setAttribute(MESSAGE, "File " + xmlFile + " not found or not parsed");
                }
            } else {
                XMLDoc schemaValOutput = this.theDoc.getValidationResult();
                KElement schemaValRoot = null;
                if (schemaValOutput == null) {
                    schemaValRoot = testFileRoot.appendElement("SchemaValidationOutput");
                } else {
                    testFileRoot.copyElement(schemaValOutput.getRoot(), null);
                    schemaValRoot = testFileRoot.getElement("SchemaValidationOutput", null, 0);
                }
                if (this.bTiming) {
                    lSchemaValidationTime = lEndTime_SchemaValidation - lStartTime_SchemaValidation;
                    if (schemaValRoot != null) {
                        schemaValRoot.setAttribute("ValidationTime", lSchemaValidationTime + " ms");
                    }
                }
                this.processURL(url);
                if (this.theDoc != null) {
                    lStartTime_InternalCheckJDF = System.currentTimeMillis();
                    if (this.bValidate) {
                        this.sysOut.println("\n**********************************************************\n");
                        this.sysOut.println("Output of checkJDF proper follows:\n");
                    }
                    KElement checkJDFxmlRoot = testFileRoot.appendElement("CheckJDFOutput");
                    JDFNode root = this.theDoc.getJDFRoot();
                    JDFJMF jmf = this.theDoc.getJMFRoot();
                    if (root != null && jmf != null) {
                        if (jmf.isAncestor(root)) {
                            root = null;
                        } else {
                            jmf = null;
                        }
                    }
                    if (root == null) {
                        this.processNonJDF(url, xmlFile, checkJDFxmlRoot, jmf);
                    } else {
                        this.printMultipleIDs(url, xmlFile, root, checkJDFxmlRoot);
                        VElement allElms = root.getChildrenByTagName(null, null, null, false, true, 0);
                        allElms.add(root);
                        int size = allElms.size();
                        for (int i = 0; i < size; ++i) {
                            String separation;
                            KElement e = allElms.item(i);
                            if (e.hasAttribute_KElement("ID", null, false)) {
                                String id = e.getAttribute("ID", null, "");
                                if (this.vID.contains(id)) {
                                    this.vBadID.add(id);
                                } else {
                                    this.vID.add(id);
                                }
                            }
                            if (e.hasAttribute("Separation") && !(separation = e.getAttribute("Separation")).equals("All")) {
                                this.vSeparations.appendUnique(separation);
                            }
                            if (e.getLocalName().equals("SeparationSpec") && !e.getParentNode().getLocalName().equals("ColorantAlias")) {
                                this.vSeparations.appendUnique(e.getAttribute("Name"));
                            }
                            if (e.getLocalName().equals("Color") && e.getParentNode().getLocalName().equals("ColorPool")) {
                                this.vColorPoolSeparations.appendUnique(e.getAttribute("Name"));
                            }
                            if (!(e instanceof JDFNode)) continue;
                            JDFNode n = (JDFNode)e;
                            String jobPartID = n.getJobPartID(false);
                            if (this.vJobPartID.contains(jobPartID)) {
                                this.vBadJobPartID.appendUnique(jobPartID);
                                continue;
                            }
                            this.vJobPartID.add(jobPartID);
                        }
                        this.vSeparations2 = new VString(this.vSeparations);
                        this.vSeparations.removeStrings(this.vColorPoolSeparations, Integer.MAX_VALUE);
                        this.vColorPoolSeparations.removeStrings(this.vSeparations2, Integer.MAX_VALUE);
                        this.printBad(root, 0, checkJDFxmlRoot, true);
                        lDevCapsTime = this.evalDevCaps(testFileRoot, lDevCapsTime, root);
                    }
                    this.removeValidEntriesIfQuiet(checkJDFxmlRoot, true);
                    if (!checkJDFxmlRoot.hasAttributes() && !checkJDFxmlRoot.hasChildElements()) {
                        checkJDFxmlRoot.setAttribute(IS_VALID, true, null);
                    }
                    lEndTime_InternalCheckJDF = System.currentTimeMillis();
                    if (this.bTiming) {
                        lCheckJDFTime = lEndTime_InternalCheckJDF - lStartTime_InternalCheckJDF;
                        checkJDFxmlRoot.setAttribute("InternalCheckJDFTime", lCheckJDFTime + " ms");
                    }
                }
            }
        }
        catch (JDFException e) {
            this.sysOut.println("Caught Exception: " + e.getMessage());
            KElement er = testFileRoot.appendElement("Error");
            er.setAttribute(MESSAGE, "Caught Exception: " + e.getMessage());
        }
        this.sysOut.println("\n**********************************************************");
        lEndTime = System.currentTimeMillis();
        if (this.bTiming) {
            this.sysOut.println("Schema Validation time = " + lSchemaValidationTime + " ms");
            this.sysOut.println("Internal checkJDF time = " + lCheckJDFTime + " ms");
            lTotalTime = lEndTime - lStartTime;
            this.sysOut.println("Total time = " + lTotalTime + " ms");
            testFileRoot.setAttribute("TotalTime", lTotalTime + " ms");
            if (lDevCapsTime > 0L) {
                this.sysOut.println("DeviceCapabilities Test time = " + lDevCapsTime + " ms");
            }
        }
        this.finalizeOutput();
        return this.pOut;
    }

    private void processNonJDF(String url, String xmlFile, KElement checkJDFxmlRoot, JDFJMF jmf) {
        if (jmf != null) {
            this.printMultipleIDs(url, xmlFile, jmf, checkJDFxmlRoot);
            this.printBad(jmf, 0, checkJDFxmlRoot, true);
            this.printJMFDevCap(jmf, checkJDFxmlRoot);
        } else {
            checkJDFxmlRoot.setAttribute("FoundJDF", false, null);
        }
    }

    private long evalDevCaps(KElement testFileRoot, long lDevCapsTime, JDFElement root) {
        long lDevCapsTimeLocal = lDevCapsTime;
        if (this.devCapFile != null) {
            long lStartTime_TestDevCap = System.currentTimeMillis();
            KElement devCapTest = testFileRoot.appendElement("DeviceCapTest");
            this.printDevCap(root, devCapTest);
            long lEndTime_TestDevCap = System.currentTimeMillis();
            lDevCapsTimeLocal = lEndTime_TestDevCap - lStartTime_TestDevCap;
            if (this.bTiming && devCapTest != null) {
                devCapTest.setAttribute("DeviceCapTestTime", lDevCapsTimeLocal + " ms");
            }
        }
        return lDevCapsTimeLocal;
    }

    private void printMultipleIDs(String url, String xmlFile, KElement root, KElement outRoot) {
        KElement outRootLocal = outRoot;
        if (this.bMultiID) {
            if (this.bQuiet) {
                this.sysOut.println("\n**********************************************************");
                this.sysOut.println("       *** Checking " + (xmlFile == null ? "JDFDoc" : xmlFile) + " *** ");
                if (url != null && url.length() > 0) {
                    this.sysOut.println("           " + url);
                }
                this.sysOut.println("**********************************************************\n");
            }
            this.vMultiID = root.getMultipleIDs("ID");
            if (this.vMultiID != null) {
                if (outRootLocal != null) {
                    outRootLocal = outRootLocal.appendElement("MultiIDs");
                    outRootLocal.setAttribute(IS_VALID, false, null);
                }
                this.sysOut.println("Multiple ID elements:\n");
                for (int i = 0; i < this.vMultiID.size(); ++i) {
                    this.processMultiID(root, outRootLocal, i);
                }
            } else {
                this.sysOut.println("No Multiple ID elements!");
            }
        }
    }

    private void processMultiID(KElement root, KElement outRootLocal, int i) {
        String id = this.vMultiID.get(i);
        VElement v = root.getChildrenByTagName(null, null, new JDFAttributeMap("ID", id), false, true, 0);
        if (id.equals(root.getAttribute("ID"))) {
            v.add(root);
        }
        for (int ii = 0; ii < v.size(); ++ii) {
            KElement e = v.item(ii);
            this.sysOut.println(id + " \t:" + e.buildXPath(null, 2));
            if (outRootLocal == null) continue;
            KElement idRoot = outRootLocal.getChildWithAttribute("MultiID", "ID", null, e.getAttribute("ID"), 0, true);
            if (idRoot == null) {
                idRoot = outRootLocal.appendElement("MultiID");
            }
            idRoot.setAttribute("ID", e.getAttribute("ID"));
            KElement idInst = idRoot.appendElement("IDInstance");
            idInst.setAttribute("XPath", e.buildXPath(null, 2));
            idInst.setAttribute("Name", e.getNodeName());
        }
    }

    private void processURL(String url) {
        if (url != null) {
            if (this.proxyHost != null) {
                System.setProperty("http.proxyHost", this.proxyHost);
                if (this.proxyPort == null) {
                    this.proxyPort = "8080";
                }
                System.setProperty("http.proxyPort", this.proxyPort);
            }
            this.theDoc = (JDFDoc)this.theDoc.write2URL(url, this.theDoc.getContentType());
        }
    }

    protected void setAllFiles(MyArgs args) {
        for (int arg = 0; arg < args.nargs(); ++arg) {
            String xmlFile = args.argumentString(arg);
            this.addFile(xmlFile);
        }
    }

    public void addFile(String xmlFile) {
        File argFile;
        if (this.allFiles == null) {
            this.allFiles = new VString();
        }
        if ((argFile = new File(xmlFile)).canRead()) {
            this.allFiles.appendUnique(xmlFile);
        } else {
            this.sysOut.println("File not found: " + argFile.getAbsolutePath());
            KElement xmlRoot = this.pOut.getRoot();
            KElement testFileRoot = xmlRoot.appendElement("TestFile");
            testFileRoot.setAttribute("FileName", xmlFile);
            testFileRoot.setAttribute(MESSAGE, "Could not find file: " + xmlFile);
        }
    }

    public boolean isBWarning() {
        return this.bWarning;
    }

    public void setWarning(boolean warning) {
        this.bWarning = warning;
        this.level = JDFElement.EnumValidationLevel.setNoWarning(this.level, !warning);
    }

    public void setValidatorFactory(ICheckValidatorFactory pvalidatorFactory) {
        this.validatorFactory = pvalidatorFactory;
    }

    protected static class MySysOut {
        boolean wannaPrint = true;

        protected MySysOut() {
        }

        public void setPrint(boolean b) {
            this.wannaPrint = b;
        }

        public void println(String string) {
            if (this.wannaPrint) {
                System.out.println(string);
            }
        }

        public void println() {
            if (this.wannaPrint) {
                System.out.println();
            }
        }

        public void print(String string) {
            if (this.wannaPrint) {
                System.out.println(string);
            }
        }
    }
}

