/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.util.HashUtil;

public class JDFRectangleRange
extends JDFRange {
    private JDFRectangle m_left = null;
    private JDFRectangle m_right = null;

    public JDFRectangleRange() {
        this.init(null, null);
    }

    public JDFRectangleRange(JDFRectangle x) {
        this.init(x, x);
    }

    public JDFRectangleRange(JDFRectangle xmin, JDFRectangle xmax) {
        this.init(xmin, xmax);
    }

    public JDFRectangleRange(JDFRectangleRange r) {
        this.init(r.getLeft(), r.getRight());
    }

    protected void init(JDFRectangle x, JDFRectangle y) {
        this.m_left = x;
        this.m_right = y;
    }

    public JDFRectangleRange(String s) throws DataFormatException {
        String[] strArray = s.split("~");
        if (strArray.length <= 0 || strArray.length > 2) {
            throw new DataFormatException("JDFRectangleRange illegal string: " + s);
        }
        try {
            if (strArray.length == 1) {
                this.m_left = new JDFRectangle(strArray[0].trim());
                this.m_right = new JDFRectangle(strArray[0].trim());
            } else {
                this.m_left = new JDFRectangle(strArray[0].trim());
                this.m_right = new JDFRectangle(strArray[1].trim());
            }
        }
        catch (DataFormatException e) {
            throw new DataFormatException("JDFRectangleRange illegal string: " + s);
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFRectangleRange(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        JDFRectangleRange range = (JDFRectangleRange)other;
        return this.getLeft().equals(range.getLeft()) && this.getRight().equals(range.getRight());
    }

    @Override
    public int hashCode() {
        return HashUtil.hashCode(0, this.toString());
    }

    public boolean inRange(JDFRectangle x) {
        JDFRectangle min = this.getLowerValue();
        JDFRectangle max = this.getUpperValue();
        return x.isGreaterOrEqual(min) && x.isLessOrEqual(max);
    }

    @Override
    public boolean isPartOfRange(JDFRange ra) {
        JDFRectangleRange r = (JDFRectangleRange)ra;
        JDFRectangle min = this.getLowerValue();
        JDFRectangle r_min = r.getLowerValue();
        JDFRectangle max = this.getUpperValue();
        JDFRectangle r_max = r.getUpperValue();
        return r_min.isGreaterOrEqual(min) && r_max.isLessOrEqual(max);
    }

    public JDFRectangle getLeft() {
        return this.m_left;
    }

    public JDFRectangle getRight() {
        return this.m_right;
    }

    public void setLeft(JDFRectangle x) {
        this.m_left = x;
    }

    public void setRight(JDFRectangle x) {
        this.m_right = x;
    }

    public JDFRectangle getUpperValue() {
        return this.m_left.isLessOrEqual(this.m_right) ? this.m_right : this.m_left;
    }

    public JDFRectangle getLowerValue() {
        return this.m_left.isLess(this.m_right) ? this.m_left : this.m_right;
    }

    @Override
    protected Object getRightObject() {
        return this.m_right;
    }

    @Override
    protected Object getLeftObject() {
        return this.m_left;
    }

    @Override
    protected boolean inObjectRange(Object other) {
        return this.inRange((JDFRectangle)other);
    }
}

