/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.fixversion.FixVersionImpl;
import org.cip4.jdflib.span.JDFTimeSpan;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class WalkAnyElement
extends BaseWalker {
    FixVersionImpl fixVersion = null;

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        return null;
    }

    public void setParent(FixVersionImpl fixVersion) {
        this.fixVersion = fixVersion;
    }

    void fixDateTime(KElement el, String key, String value, boolean zapp) {
        int minute = 0;
        String check = key;
        if (el instanceof JDFTimeSpan) {
            check = el.getLocalName();
        }
        String timeToken = StringUtil.token(value, 1, "T");
        int hour = -1;
        if (check != null && StringUtil.length(timeToken) < 9) {
            hour = StringUtil.parseInt(StringUtil.substring(timeToken, 0, 2), -1);
            minute = StringUtil.parseInt(StringUtil.substring(timeToken, 3, 5), 0);
            if (hour < 0) {
                if (check.endsWith("End") || "Required".equals(check)) {
                    hour = this.fixVersion.lasthour;
                } else if (check.endsWith("Start") || "Earliest".equals(check)) {
                    hour = this.fixVersion.firsthour;
                }
            }
        }
        this.fixDate(el, key, value, zapp, minute, hour);
    }

    void fixDate(KElement el, String key, String value, boolean zapp, int minute, int hour) {
        StringArray vals = new StringArray(value);
        if (ContainerUtil.size(vals) > 1) {
            StringArray newVals = new StringArray();
            boolean ok = false;
            for (String val : vals) {
                JDFDate d = this.fixDate(val, hour, minute);
                ok = ok || d != null;
                newVals.add(d == null ? val : d.getDateTimeISO());
            }
            if (ok) {
                el.setAttribute(key, newVals.getString());
            }
        } else {
            JDFDate d = this.fixDate(value, hour, minute);
            if (d != null) {
                el.setAttribute(key, d.getDateTimeISO());
            } else if (zapp) {
                el.removeAttribute(key);
            }
        }
    }

    JDFDate fixDate(String value, int hour, int minute) {
        JDFDate d;
        JDFDate jDFDate = d = value.contains("INF") || StringUtil.isNumber(value) ? null : JDFDate.createDate(value);
        if (d != null && (hour > 0 || this.fixVersion.newYear > 0)) {
            if (hour >= 0 && d.getHour() == JDFDate.getDefaultHour() && d.getMinute() == 0) {
                d.setTime(hour, minute, 0);
            }
            if (this.fixVersion.newYear > 0) {
                d.setYear(this.fixVersion.newYear);
            }
        }
        return d;
    }
}

