/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.List;
import java.util.Set;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFNameRange;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDF;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDFDataCache;
import org.cip4.jdflib.resource.JDFResource;
import org.w3c.dom.Node;

public class WalkElement
extends BaseWalker {
    protected JDFToXJDF jdfToXJDF;

    public void setParent(JDFToXJDF parent) {
        this.jdfToXJDF = parent;
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        String xmlComment;
        String nodeName;
        String nsURI = jdf.getNamespaceURI();
        if ("http://www.CIP4.org/JDFSchema_1_1".equals(nsURI)) {
            nsURI = this.jdfToXJDF.getSchemaURL(null);
        }
        KElement eNew = (nodeName = this.getXJDFName(jdf)) == null ? xjdf : xjdf.appendElement(nodeName, nsURI);
        this.setAttributes(jdf, eNew);
        eNew.setText(jdf.getText());
        Node before = null;
        int i = 0;
        while ((xmlComment = jdf.getXMLComment(i)) != null) {
            Node comment = eNew.appendXMLComment(xmlComment, null);
            if (before == null) {
                before = comment.getNextSibling();
            } else {
                eNew.insertBefore(comment, before);
            }
            ++i;
        }
        if (!this.jdfToXJDF.isRetainAll()) {
            this.removeUnusedElements(jdf);
        }
        return eNew;
    }

    protected String getXJDFName(KElement jdf) {
        return jdf.getNodeName();
    }

    protected void setAttributes(KElement jdf, KElement eNew) {
        JDFAttributeMap map;
        JDFAttributeMap jDFAttributeMap = map = jdf instanceof JDFElement ? this.convertRanges((JDFElement)jdf) : jdf.getAttributeMap_KElement();
        if (map != null) {
            Set keySet = map.keySet();
            for (String key : keySet) {
                String uri;
                String prefix = KElement.xmlnsPrefix(key);
                if (prefix == null || (uri = eNew.getNamespaceURIFromPrefix(prefix)) != null || (uri = jdf.getNamespaceURIFromPrefix(prefix)) == null) continue;
                eNew.addNameSpace(prefix, uri);
            }
        }
        if (!this.jdfToXJDF.isRetainAll() && map != null) {
            this.updateAttributes(map);
        }
        eNew.setAttributes(map);
    }

    protected void updateAttributes(JDFAttributeMap map) {
        if (!this.jdfToXJDF.isRetainAll()) {
            map.renameKey("ProductID", "ExternalID");
            map.renameKey("AssemblyIDs", "BinderySignatureID");
            map.remove("xsi:type");
        }
    }

    protected boolean mustInline(String refLocalName) {
        return JDFToXJDFDataCache.getInlineSet().contains(refLocalName);
    }

    JDFAttributeMap convertRanges(JDFElement jdf) {
        JDFAttributeMap map = jdf.getAttributeMap_KElement();
        return this.convertRanges(map, jdf);
    }

    JDFAttributeMap convertRanges(JDFAttributeMap map, JDFElement jdf) {
        if (this.jdfToXJDF.isConvertTilde() && map != null) {
            StringArray keys = map.getKeyList();
            for (String key : keys) {
                JDFNameRangeList rl;
                if (!AttributeInfo.EnumAttributeType.isRange(jdf.getAtrType(key)) || (rl = JDFNameRangeList.createNameRangeList(map.get(key))) == null) continue;
                int size = rl.size();
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    JDFNameRange r = (JDFNameRange)rl.at(i);
                    if (i > 0) {
                        buf.append(" ");
                    }
                    buf.append(r.getLeft());
                    buf.append(" ");
                    buf.append(r.getRight());
                }
                map.put(key, buf.toString());
            }
        }
        return map;
    }

    protected void removeUnusedElements(KElement jdf) {
    }

    protected KElement safeRename(KElement original, String newName) {
        if (original == null) {
            return null;
        }
        if (original instanceof JDFResource) {
            List<? extends KElement> leaves = ((JDFResource)original).getDirectPartitionArray();
            for (KElement kElement : leaves) {
                this.safeRename(kElement, newName);
            }
        }
        KElement newElement = original.getParentNode_KElement().insertBefore(newName, original, null);
        newElement.copyInto(original, true);
        original.deleteNode();
        return newElement;
    }
}

