/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.List;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDF;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.StringUtil;

public class WalkResLink
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFResourceLink rl = (JDFResourceLink)jdf;
        JDFResource linkTarget = rl.getLinkRoot();
        JDFNode n = rl.getParentJDF();
        if (this.jdfToXJDF.getClassName(linkTarget) == null) {
            return null;
        }
        if (n.isProduct()) {
            if (linkTarget instanceof JDFComponent || !this.jdfToXJDF.isWantProduct() && !this.matchesRootID(n)) {
                return null;
            }
            this.walkProductLink(xjdf, rl, linkTarget, n);
        } else {
            if (!this.jdfToXJDF.isSingleNode()) {
                this.setProcess(rl);
            }
            this.setResource(rl, linkTarget, this.jdfToXJDF.newRoot);
        }
        return null;
    }

    void walkProductLink(KElement xjdf, JDFResourceLink rl, JDFResource linkTarget, JDFNode n) {
        if (this.jdfToXJDF.isProductResource(linkTarget)) {
            KElement product = this.getProductForElement(xjdf, rl);
            this.setResource(rl, linkTarget, product);
        } else {
            List<KElement> v = this.setResource(rl, linkTarget, this.jdfToXJDF.newRoot);
            if (v != null) {
                boolean isLegacy = EnumUtil.aLessThanB(this.jdfToXJDF.getNewVersion(), JDFElement.EnumVersion.Version_2_1);
                String productID = isLegacy ? this.getXJDFProductID(n) : WalkResLink.getXJDFExternalID(n);
                String key = isLegacy ? "ProductPart" : "Product";
                for (KElement e : v) {
                    ResourceHelper resourceHelper = new ResourceHelper(e);
                    resourceHelper.ensurePart(key, productID);
                }
            }
        }
    }

    static String getXJDFExternalID(JDFNode node) {
        JDFComponent c = (JDFComponent)node.getResource("Component", JDFResourceLink.EnumUsage.Output, 0);
        if (c != null) {
            VString cid = c.getAssemblyIDs();
            if (ContainerUtil.size(cid) == 1) {
                return cid.get(0);
            }
            String productID = c.getProductID();
            if (!StringUtil.isEmpty(productID)) {
                return productID;
            }
        }
        String jpid = node.ensureJobPartID();
        return "P" + jpid.substring(1);
    }

    private void setProcess(JDFResourceLink rl) {
        if (!this.jdfToXJDF.isWantProcessList() || rl == null) {
            return;
        }
        KElement process = this.getProcess(rl);
        this.setLink(process, rl);
    }

    private void setLink(KElement process, JDFResourceLink rl) {
        String usageName;
        if (rl == null || process == null) {
            return;
        }
        JDFResourceLink.EnumUsage usage = rl.getUsage();
        String string = usageName = usage == null ? null : usage.getName();
        if (usageName != null) {
            process.appendAttribute(usageName, rl.getrRef(), null, " ", true);
        }
    }

    private KElement getProcess(JDFResourceLink rl) {
        JDFNode parent = rl.getParentJDF();
        if (parent == null || parent.isProduct()) {
            return null;
        }
        if (parent.getElement("JDF") != null) {
            return null;
        }
        String jobPartID = this.getJobPartID(parent);
        if (jobPartID == null) {
            return null;
        }
        KElement processList = this.jdfToXJDF.newRoot.getCreateElement("ProcessList", null, 0);
        KElement process = processList.getChildWithAttribute("Process", "JobPartID", null, jobPartID, 0, true);
        if (process == null) {
            JDFNode grandparent;
            process = processList.appendElement("Process");
            process.setAttribute("JobPartID", jobPartID);
            if (parent.hasAttribute("Types")) {
                process.copyAttribute("Types", parent);
            } else {
                process.copyAttribute("Types", parent, "Type", null, null);
            }
            process.copyAttribute("Category", parent);
            process.copyAttribute("DescriptiveName", parent);
            for (grandparent = parent.getParentJDF(); grandparent != null && !grandparent.isProduct(); grandparent = grandparent.getParentJDF()) {
            }
            if (grandparent != null) {
                process.setAttribute("Parent", this.getJobPartID(grandparent));
            }
        }
        return process;
    }

    private String getJobPartID(JDFNode parent) {
        String jobPartID = StringUtil.getNonEmpty(parent.getJobPartID(false));
        if (jobPartID == null) {
            jobPartID = StringUtil.getNonEmpty(parent.getID());
        }
        return jobPartID;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return JDFResourceLink.isResourceLink(toCheck);
    }

    @Override
    protected List<KElement> setResource(JDFElement rl, JDFResource linkTarget, KElement xRoot) {
        List<KElement> newResources = super.setResource(rl, linkTarget, xRoot);
        if ("XJDF".equals(xRoot.getLocalName())) {
            this.setNodePartitions(rl, newResources);
        }
        return newResources;
    }

    private void setNodePartitions(JDFElement rl, List<KElement> newResources) {
        if (!(ContainerUtil.isEmpty(newResources) || this.jdfToXJDF.isWantProcessList() || this.jdfToXJDF.isSingleNode())) {
            JDFNode parentNode = rl.getParentJDF();
            JDFNode parentProduct = this.getParentProduct(parentNode);
            VString xTypes = VString.getVString(this.jdfToXJDF.newRoot.getNonEmpty("Types"), null);
            VString jTypes = VString.getVString(parentNode.getTypesString(), null);
            for (KElement newResource : newResources) {
                String jobPartID;
                ResourceHelper ph = new ResourceHelper(newResource);
                VJDFAttributeMap partMaps = ph.getPartMapVector();
                boolean bChange = false;
                if (parentProduct != null) {
                    boolean isLegacy = EnumUtil.aLessThanB(this.jdfToXJDF.getNewVersion(), JDFElement.EnumVersion.Version_2_1);
                    String productID = isLegacy ? this.getXJDFProductID(parentProduct) : WalkResLink.getXJDFExternalID(parentProduct);
                    String key = isLegacy ? "ProductPart" : "Product";
                    partMaps.put(key, productID);
                    bChange = true;
                }
                if (JDFToXJDF.EnumProcessPartition.processTypes.equals((Object)this.jdfToXJDF.getProcessPart())) {
                    if (parentNode != parentProduct && xTypes != null && jTypes != null) {
                        VString cpi = new VString();
                        for (String jtyp : jTypes) {
                            int i = xTypes.indexOf(jtyp);
                            if (i < 0) continue;
                            cpi.add("" + i);
                        }
                        if (!cpi.isEmpty()) {
                            KElement set = newResource.getParentNode_KElement();
                            set.setAttribute("CombinedProcessIndex", StringUtil.setvString(cpi));
                        }
                    }
                } else if (JDFToXJDF.EnumProcessPartition.jobPartID.equals((Object)this.jdfToXJDF.getProcessPart()) && parentNode != parentProduct && (jobPartID = StringUtil.getNonEmpty(parentNode.getJobPartID(false))) != null) {
                    partMaps.put("ProductPart", jobPartID);
                    bChange = true;
                }
                if (!bChange) continue;
                ph.setPartMapVector(partMaps);
            }
        }
    }

    protected JDFNode getParentProduct(JDFNode parentNode) {
        JDFNode parentProduct = parentNode.getParentProduct();
        if (parentProduct != null && parentProduct.isJDFRoot()) {
            parentProduct = null;
        }
        return parentProduct;
    }
}

