/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDevCaps;
import org.cip4.jdflib.auto.JDFAutoMessageService;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.ifaces.ICapabilityElement;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFMessageService;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourceLinkPool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.devicecapability.JDFDevCap;
import org.cip4.jdflib.resource.devicecapability.JDFDevCapPool;
import org.cip4.jdflib.resource.devicecapability.JDFDeviceCap;
import org.cip4.jdflib.resource.devicecapability.JDFEnumerationState;
import org.cip4.jdflib.resource.devicecapability.JDFModuleCap;
import org.cip4.jdflib.resource.devicecapability.JDFModulePool;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.VectorMap;

public class JDFDevCaps
extends JDFAutoDevCaps
implements ICapabilityElement {
    private static final long serialVersionUID = 1L;
    private final int maxPartitionDepth = 6;

    public JDFDevCaps(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDevCaps(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDevCaps(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDevCaps[  --> " + super.toString() + " ]";
    }

    public void setDevCapRef(String value) {
        this.setAttribute("DevCapRef", value, null);
    }

    public void setDevCapRef(JDFDevCap dc) {
        if (dc != null) {
            dc.appendAnchor(null);
            String id2 = dc.getID();
            this.setDevCapRef(id2);
        } else {
            this.setDevCapRef((String)null);
        }
    }

    @Override
    public JDFDevCap appendDevCap() {
        JDFDevCap dc = super.appendDevCap();
        if (this.hasAttribute("Name")) {
            dc.setName(this.getName());
        }
        return dc;
    }

    public JDFDevCap appendDevCapInPool() {
        JDFDevCapPool dcp = this.getCreateDevCapPool();
        JDFDevCap dc = dcp.appendDevCap();
        String id2 = dc.getID();
        this.setDevCapRef(id2);
        if (this.hasAttribute("Name")) {
            dc.setName(this.getName());
        }
        return dc;
    }

    public JDFDevCapPool getDevCapPool() {
        return (JDFDevCapPool)this.getParentPool("DevCapPool");
    }

    private KElement getParentPool(String poolName) {
        KElement parent = this.getParentNode_KElement();
        if (!(parent instanceof JDFDeviceCap) && !(parent instanceof JDFMessageService)) {
            throw new JDFException("JDFDevCap.getParentPool - invalid parent context");
        }
        return parent.getElement(poolName);
    }

    private KElement getCreateParentPool(String poolName) {
        KElement parent = this.getParentNode_KElement();
        if (!(parent instanceof JDFDeviceCap) && !(parent instanceof JDFMessageService)) {
            throw new JDFException("JDFDevCap.getParentPool - invalid parent context");
        }
        return parent.getCreateElement(poolName);
    }

    @Override
    public JDFModulePool getModulePool() {
        return (JDFModulePool)this.getParentPool("ModulePool");
    }

    @Override
    public JDFModulePool getCreateModulePool() {
        return (JDFModulePool)this.getCreateParentPool("ModulePool");
    }

    public JDFDevCapPool getCreateDevCapPool() {
        KElement parent = this.getParentNode_KElement();
        if (!(parent instanceof JDFDeviceCap) && !(parent instanceof JDFMessageService)) {
            throw new JDFException("JDFDevCap.getCreateDevCapPoll - invalid parent context");
        }
        return (JDFDevCapPool)parent.getCreateElement("DevCapPool");
    }

    @Override
    public JDFDevCap getDevCap() {
        String dcr = this.getAttribute("DevCapRef", null, null);
        if (dcr != null) {
            JDFDevCapPool dcp = this.getDevCapPool();
            if (dcp == null) {
                return null;
            }
            return (JDFDevCap)dcp.getChildWithAttribute("DevCap", "ID", null, dcr, 0, true);
        }
        return this.getDevCap(0);
    }

    @Deprecated
    public final String getNamePath(boolean onlyNames) {
        StringBuffer xPath = new StringBuffer(this.getName());
        if (!onlyNames) {
            xPath.append("[Context=").append(this.getContext().getName()).append(", LinkUsage=").append(this.getLinkUsage().getName()).append("]");
        }
        return xPath.toString();
    }

    @Override
    public final VString getNamePathVector() {
        Object result = this.getDevCapsName();
        JDFAutoDevCaps.EnumContext cont = this.getContext();
        VString vResult = new VString();
        if (cont.equals((Object)JDFAutoDevCaps.EnumContext.JMF) && this.getParentNode() instanceof JDFMessageService && ((String)result).length() > 4) {
            JDFMessageService serv = (JDFMessageService)this.getParentNode();
            Vector<JDFMessage.EnumFamily> vf = serv.getFamilies();
            if (vf != null) {
                int size = vf.size();
                for (int i = 0; i < size; ++i) {
                    vResult.add("JMF/" + vf.elementAt(i).getName() + "/" + ((String)result).substring(4));
                }
            }
            if (JDFAutoMessageService.EnumJMFRole.Sender.equals((Object)serv.getJMFRole())) {
                vResult.add("JMF/Response/" + ((String)result).substring(4));
            }
        } else {
            if (cont.equals((Object)JDFAutoDevCaps.EnumContext.Link)) {
                result = "JDF/ResourceLinkPool/" + (String)result;
            } else if (cont.equals((Object)JDFAutoDevCaps.EnumContext.Resource)) {
                Object nam = result;
                result = "JDF/ResourcePool/" + (String)result;
                for (int i = 0; i < 6; ++i) {
                    vResult.add(result);
                    result = (String)result + "/" + (String)nam;
                }
            }
            vResult.add(result);
        }
        return vResult;
    }

    private String getDevCapsName() {
        Object nam = this.getName();
        JDFAutoDevCaps.EnumContext cont = this.getContext();
        if (cont.equals((Object)JDFAutoDevCaps.EnumContext.Link)) {
            nam = (String)nam + "Link";
        } else if (cont.equals((Object)JDFAutoDevCaps.EnumContext.Element) && !"JDF".equals(nam)) {
            nam = "JDF/" + (String)nam;
        } else if (cont.equals((Object)JDFAutoDevCaps.EnumContext.JMF) && !"JMF".equals(nam)) {
            nam = "JMF/" + (String)nam;
        }
        return nam;
    }

    public final VElement getDevCapVector() {
        JDFDevCapPool dcp;
        VElement vDevCap = this.getChildElementVector("DevCap", null, null, true, 0, false);
        String dcr = this.getAttribute("DevCapRef", null, null);
        if (dcr != null && (dcp = this.getDevCapPool()) != null) {
            VString v = StringUtil.tokenize(dcr, " ", false);
            for (int i = 0; i < v.size(); ++i) {
                String s = v.get(i);
                KElement dcre = dcp.getChildWithAttribute("DevCap", "ID", null, s, 0, true);
                vDevCap.appendUnique(dcre);
            }
        }
        return vDevCap;
    }

    public final KElement devCapReport(KElement elem, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level, boolean ignoreExtensions, KElement parentReport) {
        if (elem == null) {
            return null;
        }
        VElement dcV = this.getDevCapVector();
        if (dcV == null || dcV.size() == 0) {
            throw new JDFException("JDFDevCaps.devCapReport: Invalid DeviceCap: DevCaps/@DevCapRef refers to the non-existent DevCap: " + this.getDevCapRef());
        }
        KElement r = parentReport.appendElement("Invalid" + this.getContext().getName());
        for (int i = 0; i < dcV.size(); ++i) {
            JDFDevCap dc = (JDFDevCap)dcV.elementAt(i);
            KElement stateTestResult = dc.stateReport(elem, testlists, level, ignoreExtensions, true, r);
            if (stateTestResult == null) {
                r.deleteNode();
                return null;
            }
            r.setAttribute("XPath", elem.buildXPath(null, 1));
            r.setAttribute("Name", this.getContextName());
            r.setAttribute("CapXPath", dc.getName());
        }
        JDFDevCaps.correction_Static(r);
        return r;
    }

    public String getContextName() {
        Object s = this.getName();
        if (s == null) {
            return null;
        }
        JDFAutoDevCaps.EnumContext context = this.getContext();
        if (JDFAutoDevCaps.EnumContext.Link.equals((Object)context)) {
            s = (String)s + "Link";
        }
        return s;
    }

    private static final void correction_Static(KElement root) {
        VElement v = root.getChildElementVector("InvalidResource", null, null, true, 0, false);
        for (int i = 0; i < v.size(); ++i) {
            KElement invRes = v.elementAt(i);
            VElement vv = invRes.getChildElementVector(null, null, null, true, 0, false);
            for (int j = vv.size() - 1; j >= 0; --j) {
                JDFDevCaps.capXPathCorrection_Static(vv.elementAt(j), invRes.getAttribute("CapXPath"));
            }
            JDFDevCaps.removePoolElements_Static(invRes);
        }
    }

    private static final void removePoolElements_Static(KElement root) {
        VElement v = root.getChildElementVector(null, null, null, true, 0, false);
        for (int j = v.size() - 1; j >= 0; --j) {
            KElement el = v.elementAt(j);
            String nam = el.getNodeName();
            if (!nam.equals("InvalidAttributes") && !nam.equals("InvalidElements") && !nam.equals("UnknownAttributes") && !nam.equals("UnknownElements") && !nam.equals("MissingAttributes")) continue;
            JDFDevCaps.moveChildElementVector_Static(root, el);
            if (el.hasChildElements() || el.hasAttributes()) continue;
            root.removeChild(el);
        }
        VElement vv = root.getChildElementVector(null, null, null, true, 0, false);
        for (int i = vv.size() - 1; i >= 0; --i) {
            JDFDevCaps.removePoolElements_Static(vv.elementAt(i));
        }
    }

    private static final void capXPathCorrection_Static(KElement elem, String originalPath) {
        String parentPath = elem.getParentNode_KElement().getAttribute("CapXPath");
        VElement vEl = elem.getChildElementVector(null, null, null, true, 0, false);
        for (int i = 0; i < vEl.size(); ++i) {
            KElement child = (KElement)((Vector)vEl).elementAt(i);
            String childPath = child.getAttribute("CapXPath");
            if (parentPath.equals("") || childPath.equals("")) continue;
            String childPathPart = childPath;
            if (childPath.startsWith(originalPath)) {
                childPathPart = childPath.substring(originalPath.length() + 1);
            }
            child.setAttribute("CapXPath", parentPath + "/" + childPathPart);
            VElement vSubEl = child.getChildElementVector(null, null, null, true, 0, false);
            for (int j = 0; j < vSubEl.size(); ++j) {
                JDFDevCaps.capXPathCorrection_Static(vSubEl.elementAt(j), childPath);
            }
        }
    }

    private static final void moveChildElementVector_Static(KElement moveToElement, KElement moveFromElement) {
        if (moveToElement != null && moveFromElement != null) {
            VElement v = moveFromElement.getChildElementVector(null, null, null, true, 0, false);
            for (int i = 0; i < v.size(); ++i) {
                moveToElement.moveElement(v.elementAt(i), null);
            }
        }
    }

    private VElement getMatchingElementsFromNode(JDFNode node) {
        VElement vElem = new VElement();
        String nam = this.getName();
        JDFAutoDevCaps.EnumContext context = this.getContext();
        JDFResourceLinkPool resLinkPool = node.getResourceLinkPool();
        if (context.equals((Object)JDFAutoDevCaps.EnumContext.Element)) {
            if (nam.equals("JDF")) {
                vElem.add(node);
            } else {
                vElem = node.getChildElementVector(nam, null, null, true, 0, false);
            }
        } else if (context.equals((Object)JDFAutoDevCaps.EnumContext.Link) || context.equals((Object)JDFAutoDevCaps.EnumContext.Resource)) {
            if (resLinkPool != null) {
                JDFResourceLink.EnumUsage linkUsage = this.getLinkUsage();
                String procUsage = this.getProcessUsage();
                boolean bLink = context.equals((Object)JDFAutoDevCaps.EnumContext.Link);
                VElement vElemLinks = resLinkPool.getInOutLinks(linkUsage, true, nam, null);
                if (vElemLinks != null) {
                    int linkSize;
                    for (int j = linkSize = vElemLinks.size() - 1; j >= 0; --j) {
                        JDFResourceLink rl = (JDFResourceLink)vElemLinks.elementAt(j);
                        String rlProcessUsage = rl.getProcessUsage();
                        if (rlProcessUsage.equals(procUsage)) continue;
                        vElemLinks.remove(j);
                    }
                }
                vElem = !bLink ? JDFResourceLinkPool.resourceVector(vElemLinks, null) : vElemLinks;
            }
        } else if (!context.equals((Object)JDFAutoDevCaps.EnumContext.JMF)) {
            throw new JDFException("JDFDevCaps wrong attribute Context value");
        }
        if (vElem != null && vElem.size() == 0) {
            vElem = null;
        }
        return vElem;
    }

    public VElement getMatchingElementsFromJMF(JDFMessage messageElement) {
        VElement vElem;
        String nam = this.getName();
        JDFAutoDevCaps.EnumContext context = this.getContext();
        if (!JDFAutoDevCaps.EnumContext.JMF.equals((Object)context) && !JDFAutoDevCaps.EnumContext.Element.equals((Object)context)) {
            return null;
        }
        if ("JMF".equals(nam)) {
            vElem = new VElement();
            vElem.add(messageElement.getParentNode_KElement());
        } else if (messageElement.getLocalName().equals(nam)) {
            vElem = new VElement();
            vElem.add(messageElement);
        } else {
            vElem = messageElement.getChildElementVector(nam, null, null, true, 0, false);
            if (vElem != null && vElem.size() == 0) {
                vElem = null;
            }
        }
        return vElem;
    }

    public KElement appendMatchingElementsToNode(JDFNode node, boolean bAll, VectorMap indexResMap, boolean bLink) {
        KElement e = null;
        JDFAutoDevCaps.EnumContext context = this.getContext();
        if (!bLink && JDFAutoDevCaps.EnumContext.Link.equals((Object)context)) {
            return null;
        }
        if (bLink && !JDFAutoDevCaps.EnumContext.Link.equals((Object)context)) {
            return null;
        }
        JDFDevCap devCap = this.getDevCap();
        if (devCap == null) {
            return null;
        }
        int minOcc = devCap.getMinOccurs();
        if (minOcc == 0 && bAll) {
            minOcc = 1;
        }
        String nam = this.getName();
        for (int i = 0; i < minOcc; ++i) {
            if (context.equals((Object)JDFAutoDevCaps.EnumContext.Element)) {
                if (nam.equals("JDF")) continue;
                e = node.getCreateElement(nam, this.getDevNS(), i);
                continue;
            }
            if (context.equals((Object)JDFAutoDevCaps.EnumContext.Resource) || context.equals((Object)JDFAutoDevCaps.EnumContext.Link)) {
                VString keys;
                JDFEnumerationState pidKeys;
                JDFIntegerList tocNum2;
                JDFResourceLink.EnumUsage linkUsage = this.getLinkUsage();
                String procUsage = this.getProcessUsage();
                JDFAttributeMap map = new JDFAttributeMap();
                JDFNode.EnumProcessUsage pu = null;
                if (procUsage != null && procUsage.length() > 0) {
                    map.put("ProcessUsage", procUsage);
                    pu = JDFNode.EnumProcessUsage.getEnum(procUsage);
                }
                if (linkUsage != null) {
                    map.put("Usage", linkUsage.getName());
                }
                VElement links = node.getResourceLinks(nam, map, null);
                JDFIntegerRangeList tocNum = this.getTypeOccurrenceNum();
                JDFIntegerList jDFIntegerList = tocNum2 = tocNum == null ? null : tocNum.getIntegerList();
                if (links != null && tocNum != null) {
                    for (int ll = links.size() - 1; ll >= 0; --ll) {
                        JDFResourceLink rl = (JDFResourceLink)links.elementAt(ll);
                        JDFIntegerList il = rl.getCombinedProcessIndex();
                        if (il != null && il.contains(tocNum2)) continue;
                        links.remove(ll);
                    }
                }
                if (links != null && links.size() > i) continue;
                JDFResource r = null;
                if (bLink) {
                    Vector v;
                    int kk;
                    int n = kk = tocNum2 == null || tocNum2.size() == 0 ? -1 : tocNum2.getInt(0);
                    if (JDFResourceLink.EnumUsage.Input.equals((Object)linkUsage)) {
                        --kk;
                    }
                    if ((v = (Vector)indexResMap.get(kk)) != null) {
                        int sv = v.size();
                        for (int kkk = 0; kkk < sv; ++kkk) {
                            JDFResource rr = (JDFResource)v.elementAt(kkk);
                            if (!rr.getLocalName().equals(nam)) continue;
                            r = rr;
                            break;
                        }
                    }
                }
                if (r == null) {
                    r = node.addResource(nam, null, linkUsage, pu, null, this.getDevNS(), null);
                    String id = devCap.getAttribute("ID", null, null);
                    if (id != null) {
                        JDFResourceLink rl = node.getLink(r, linkUsage);
                        r.setID(id);
                        if (rl != null) {
                            rl.setrRef(id);
                        }
                    }
                    if (tocNum2 == null || tocNum2.size() == 0) {
                        indexResMap.putOne(-1, r);
                    } else {
                        indexResMap.putOne(tocNum2.elementAt(0), r);
                    }
                } else {
                    e = node.linkResource(r, linkUsage, pu);
                }
                e = node.getLink(r, linkUsage);
                if (e != null) {
                    JDFResourceLink rl = (JDFResourceLink)e;
                    rl.setCombinedProcessIndex(tocNum2);
                }
                if ((pidKeys = devCap.getEnumerationState("PartIDKeys")) == null || (keys = pidKeys.getAllowedValueList()) == null || keys.size() <= 0) continue;
                JDFAttributeMap keyMap = new JDFAttributeMap();
                for (int k = 0; k < keys.size(); ++k) {
                    Object sk = "PartKey" + k;
                    String key = keys.get(k);
                    if (key.equals("RunIndex")) {
                        sk = "0~-1";
                    }
                    keyMap.put(key, (String)sk);
                }
                r.getCreatePartition(keyMap, keys);
                continue;
            }
            if (!context.equals((Object)JDFAutoDevCaps.EnumContext.JMF)) continue;
        }
        return e;
    }

    public boolean setDefaultsFromCaps(JDFNode node, boolean bAll) {
        VElement v;
        boolean modified = false;
        JDFDevCap dc = this.getDevCap();
        if (dc != null && (v = this.getMatchingElementsFromNode(node)) != null) {
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                modified = dc.setDefaultsFromCaps(v.item(i), bAll) || modified;
            }
        }
        return modified;
    }

    public int getMaxOccurs() {
        int m = 0;
        VElement vDC = this.getDevCapVector();
        if (vDC != null) {
            int svDC = vDC.size();
            for (int i = 0; i < svDC; ++i) {
                JDFDevCap dc = (JDFDevCap)vDC.elementAt(i);
                if (m >= dc.getMaxOccurs()) continue;
                m = dc.getMaxOccurs();
            }
        }
        return m;
    }

    public int getMinOccurs() {
        int m = Integer.MAX_VALUE;
        VElement vDC = this.getDevCapVector();
        if (vDC != null) {
            int svDC = vDC.size();
            for (int i = 0; i < svDC; ++i) {
                JDFDevCap dc = (JDFDevCap)vDC.elementAt(i);
                if (m <= dc.getMinOccurs()) continue;
                m = dc.getMinOccurs();
            }
        }
        if (m <= 0 && this.getRequired()) {
            m = 1;
        }
        return m;
    }

    public void analyzeDevCaps(KElement testRoot, JDFBaseDataTypes.EnumFitsValue testlists, JDFElement.EnumValidationLevel level, KElement mrp, KElement irp, HashSet goodElems, HashMap badElems, boolean ignoreExtensions) {
        String procUsage;
        JDFResourceLink.EnumUsage linkUsage;
        JDFDeviceCap.EnumAvailability av = this.getModuleAvailability();
        KElement xpathRoot = testRoot;
        VElement vElemResources = null;
        if (testRoot instanceof JDFNode) {
            JDFNode jdfNode = (JDFNode)testRoot;
            vElemResources = this.getMatchingElementsFromNode(jdfNode);
            xpathRoot = jdfNode.getResourceLinkPool();
            if (xpathRoot == null) {
                xpathRoot = testRoot;
            }
        } else {
            vElemResources = this.getMatchingElementsFromJMF((JDFMessage)testRoot);
        }
        int svElemResources = vElemResources == null ? 0 : vElemResources.size();
        JDFAutoDevCaps.EnumContext context = this.getContext();
        KElement r = null;
        if (JDFElement.EnumValidationLevel.isRequired(level) && svElemResources < this.getMinOccurs() && JDFDeviceCap.EnumAvailability.Installed.equals((Object)av)) {
            if (JDFAutoDevCaps.EnumContext.Element.equals((Object)context) || JDFAutoDevCaps.EnumContext.JMF.equals((Object)context)) {
                r = mrp.appendElement("MissingElement");
                r.setAttribute("XPath", xpathRoot.buildXPath(null, 1) + "/" + this.getName());
            } else {
                linkUsage = this.getLinkUsage();
                procUsage = this.getProcessUsage();
                r = mrp.appendElement("MissingResourceLink");
                if (linkUsage != null) {
                    r.setAttribute("Usage", linkUsage.getName());
                }
                if (procUsage != null && procUsage.length() > 0) {
                    r.setAttribute("ProcessUsage", procUsage);
                }
                r.setAttribute("XPath", xpathRoot.buildXPath(null, 1) + "/" + this.getName());
            }
            r.setAttribute("Name", this.getName());
            r.setAttribute("CapXPath", this.getName());
            r.setAttribute("Occurrences", svElemResources, (String)null);
            r.setAttribute("MinOccurs", this.getMinOccurs(), (String)null);
        } else if (svElemResources > this.getMaxOccurs() || !JDFDeviceCap.EnumAvailability.Installed.equals((Object)av)) {
            if (context.equals((Object)JDFAutoDevCaps.EnumContext.Element) || context.equals((Object)JDFAutoDevCaps.EnumContext.JMF)) {
                r = irp.appendElement("ManyElement");
                r.setAttribute("XPath", testRoot.buildXPath(null, 1) + "/" + this.getName());
            } else {
                linkUsage = this.getLinkUsage();
                procUsage = this.getProcessUsage();
                r = irp.appendElement("ManyResourceLink");
                if (linkUsage != null) {
                    r.setAttribute("Usage", linkUsage.getName());
                }
                if (procUsage != null && procUsage.length() > 0) {
                    r.setAttribute("ProcessUsage", procUsage);
                }
                r.setAttribute("XPath", xpathRoot.buildXPath(null, 1) + "/" + this.getName());
            }
            r.setAttribute("Name", this.getName());
            r.setAttribute("CapXPath", this.getName());
            r.setAttribute("Occurrences", svElemResources, (String)null);
            r.setAttribute("MaxOccurs", this.getMaxOccurs(), (String)null);
            r.setAttribute("Availability", av == null ? "None" : av.getName());
        }
        if (vElemResources != null) {
            for (int j = 0; j < svElemResources; ++j) {
                KElement elem = vElemResources.item(j);
                if (goodElems.contains(elem)) continue;
                KElement report = this.devCapReport(elem, testlists, level, ignoreExtensions, irp);
                if (report == null) {
                    goodElems.add(elem);
                    KElement badReport = (KElement)badElems.get(elem);
                    if (badReport == null) continue;
                    badReport.deleteNode();
                    continue;
                }
                badElems.put(elem, report);
            }
        }
    }

    public JDFDeviceCap.EnumAvailability getModuleAvailability() {
        return JDFModulePool.getModuleAvailability(this);
    }

    @Override
    public VString getInvalidAttributes(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        VString vs = super.getInvalidAttributes(level, bIgnorePrivate, nMax);
        if (nMax > 0 && vs.size() > nMax) {
            return vs;
        }
        if (!JDFElement.EnumValidationLevel.RecursiveComplete.equals((Object)level) && !JDFElement.EnumValidationLevel.RecursiveIncomplete.equals((Object)level)) {
            return vs;
        }
        if (vs.contains("DevCapRef")) {
            return vs;
        }
        if (this.hasAttribute("DevCapRef")) {
            JDFDevCapPool devCapPool = this.getDevCapPool();
            if (devCapPool == null) {
                vs.add("DevCapRef");
                return vs;
            }
            VString idRefs = this.getDevCapRef();
            for (int i = 0; i < idRefs.size(); ++i) {
                JDFDevCap devCap = devCapPool.getDevCap(idRefs.get(i));
                if (devCap != null) continue;
                vs.add("DevCapRef");
                return vs;
            }
        }
        return vs;
    }

    @Override
    public JDFModuleCap appendModuleRef(String id) {
        return JDFModulePool.appendModuleRef(this, id);
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.IsPresentEvaluation;
    }
}

