/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoValue;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.resource.JDFValue;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFLoc;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;

public class JDFStringState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[6];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFStringState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFStringState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFStringState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFStringState[ --> " + super.toString() + " ]";
    }

    public void setCurrentValue(String value) {
        this.setAttribute("CurrentValue", value);
    }

    public String getCurrentValue() {
        return this.getAttribute("CurrentValue", null, "");
    }

    public void setDefaultValue(String value) {
        this.setAttribute("DefaultValue", value);
    }

    public String getDefaultValue() {
        return this.getAttribute("DefaultValue", null, "");
    }

    public void setAllowedRegExp(String value) {
        this.setAttribute("AllowedRegExp", value);
    }

    @Override
    public String getAllowedRegExp() {
        return this.getAttribute("AllowedRegExp");
    }

    public void setPresentRegExp(String value) {
        this.setAttribute("PresentRegExp", value);
    }

    @Override
    public String getPresentRegExp() {
        if (this.hasAttribute("PresentRegExp")) {
            return this.getAttribute("PresentRegExp");
        }
        return this.getAllowedRegExp();
    }

    public JDFValue getValue(int iSkip) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        return e;
    }

    public JDFValue appendValue() {
        return (JDFValue)this.appendElement("Value", null);
    }

    @Override
    public JDFLoc getValueLocLoc(int iSkip, int jSkip) {
        JDFValue val = (JDFValue)this.getElement("Value", null, iSkip);
        JDFLoc loc = (JDFLoc)val.getElement("Loc", null, jSkip);
        return loc;
    }

    @Override
    public JDFLoc appendValueLocLoc(int iSkip) {
        JDFValue val = this.getValue(iSkip);
        if (val == null) {
            return null;
        }
        return val.appendLoc();
    }

    public void appendValueAllowedValue(String value) {
        JDFValue e = (JDFValue)this.appendElement("Value", null);
        e.setAllowedValue(value);
    }

    public final String getValueAllowedValue(int iSkip) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        if (e == null) {
            return null;
        }
        return e.getAllowedValue();
    }

    public void setValueValueUsage(int iSkip, JDFBaseDataTypes.EnumFitsValue value) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        e.setValueUsage(JDFAutoValue.EnumValueUsage.getEnum(value.getName()));
    }

    public final JDFBaseDataTypes.EnumFitsValue getValueValueUsage(int iSkip) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        return JDFBaseDataTypes.EnumFitsValue.getEnum(e.getValueUsage().getName());
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        JDFValue v;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals((Object)testlists)) {
            v = this.appendValue();
            v.setAllowedValue(value);
            if (testlists != null) {
                v.setValueUsage(JDFAutoValue.EnumValueUsage.Allowed);
            }
        }
        if (JDFBaseDataTypes.EnumFitsValue.Present.equals((Object)testlists)) {
            v = this.appendValue();
            v.setAllowedValue(value);
            if (testlists != null) {
                v.setValueUsage(JDFAutoValue.EnumValueUsage.Present);
            }
        }
    }

    @Override
    public final boolean fitsValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        return this.fitsLength(value, testlists) && this.fitsRegExp(value, testlists) && this.fitsValueElem(value, testlists);
    }

    private final boolean fitsValueElem(String str, JDFBaseDataTypes.EnumFitsValue valuelist) {
        if (str == null) {
            return false;
        }
        VElement v = this.getChildElementVector("Value", null, null, true, 0, false);
        int siz = v.size();
        boolean hasValue = false;
        for (int i = 0; i < siz; ++i) {
            JDFValue elm = (JDFValue)v.elementAt(i);
            if (elm.hasAttribute("ValueUsage")) {
                JDFBaseDataTypes.EnumFitsValue valueUsage = this.getValueValueUsage(i);
                if (!valuelist.equals((Object)valueUsage)) continue;
                String value = this.getValueAllowedValue(i);
                hasValue = true;
                if (!str.equals(value)) continue;
                return true;
            }
            hasValue = true;
            String value = this.getValueAllowedValue(i);
            if (!str.equals(value)) continue;
            return true;
        }
        return !hasValue;
    }

    @Override
    public void setAllowedLength(JDFIntegerRange value) {
        super.setAllowedLength(value);
    }

    @Override
    public JDFIntegerRange getAllowedLength() {
        return super.getAllowedLength();
    }

    @Override
    public void setPresentLength(JDFIntegerRange value) {
        super.setPresentLength(value);
    }

    @Override
    public JDFIntegerRange getPresentLength() {
        return super.getPresentLength();
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.StringEvaluation;
    }

    static {
        JDFStringState.atrInfoTable[1] = new AtrInfoTable("AllowedLength", 0x33333311L, AttributeInfo.EnumAttributeType.IntegerRange, null, null);
        JDFStringState.atrInfoTable[0] = new AtrInfoTable("AllowedRegExp", 0x33333311L, AttributeInfo.EnumAttributeType.RegExp, null, null);
        JDFStringState.atrInfoTable[2] = new AtrInfoTable("CurrentValue", 0x33333331L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFStringState.atrInfoTable[3] = new AtrInfoTable("DefaultValue", 0x33333331L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFStringState.atrInfoTable[5] = new AtrInfoTable("PresentLength", 0x33333311L, AttributeInfo.EnumAttributeType.IntegerRange, null, null);
        JDFStringState.atrInfoTable[4] = new AtrInfoTable("PresentRegExp", 0x33333311L, AttributeInfo.EnumAttributeType.RegExp, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFStringState.elemInfoTable[0] = new ElemInfoTable("Value", 0x33333331L);
    }
}

