/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoComChannel;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFComChannel
extends JDFAutoComChannel
implements IMatches {
    private static final String PHONE_CHARS = "+0123456789";
    private static final long serialVersionUID = 1L;
    public static final String MAILTO = "mailto:";
    public static final String TEL = "tel:";

    public JDFComChannel(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFComChannel(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFComChannel(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFComChannel[  --> " + super.toString() + " ]";
    }

    static JDFComChannel getChannelByType(JDFElement parent, JDFAutoComChannel.EnumChannelType ct) {
        JDFComChannel cc = parent == null ? null : parent.getChildWithAttribute(JDFComChannel.class, "ChannelType", ct == null ? null : ct.getName());
        return cc;
    }

    static JDFComChannel appendChannel(JDFElement parent, JDFAutoComChannel.EnumChannelType ct, String locator) {
        JDFComChannel cc = (JDFComChannel)parent.appendElement("ComChannel");
        cc.setChannelType(ct);
        cc.setLocator(locator);
        return cc;
    }

    public void setEMailLocator(String eMail) {
        Object eMailLocal = eMail;
        if (eMailLocal != null) {
            eMailLocal = ((String)eMailLocal).trim();
        }
        if (eMailLocal == null || !StringUtil.matchesIgnoreCase((String)eMailLocal, "(mailto:)?([_.a-zA-Z0-9\\-])+[@]([_.a-zA-Z0-9\\-])+[.]([_.a-zA-Z0-9\\-])+")) {
            throw new IllegalArgumentException("illegal email address:" + (String)eMailLocal);
        }
        this.setChannelType(JDFAutoComChannel.EnumChannelType.Email);
        if (!((String)eMailLocal).toLowerCase().startsWith(MAILTO)) {
            eMailLocal = MAILTO + (String)eMailLocal;
        }
        this.setLocator((String)eMailLocal);
    }

    public String getEMailAddress() {
        if (!JDFAutoComChannel.EnumChannelType.Email.equals((Object)this.getChannelType())) {
            return null;
        }
        String locator = this.getLocator();
        if (!StringUtil.matchesIgnoreCase(locator, "(mailto:)?([_.a-zA-Z0-9\\-])+[@]([_.a-zA-Z0-9\\-])+[.]([_.a-zA-Z0-9\\-])+")) {
            return null;
        }
        return StringUtil.stripPrefix(locator, MAILTO, true);
    }

    public String getPhoneNumber(boolean stripNonNumerical) {
        JDFAutoComChannel.EnumChannelType channelType = this.getChannelType();
        if (!(JDFAutoComChannel.EnumChannelType.Fax.equals((Object)channelType) || JDFAutoComChannel.EnumChannelType.Phone.equals((Object)channelType) || JDFAutoComChannel.EnumChannelType.Mobile.equals((Object)channelType))) {
            return null;
        }
        String locator = this.getLocator();
        if (!StringUtil.matchesIgnoreCase(locator, "(tel:)?([+])?(([0-9./\\-])|[(]([0-9./\\-])[)])+")) {
            return null;
        }
        locator = StringUtil.stripPrefix(locator, TEL, true);
        if (stripNonNumerical) {
            locator = StringUtil.stripNot(locator, PHONE_CHARS);
        }
        return locator;
    }

    public void setPhoneNumber(String phone) {
        if (phone == null) {
            this.setLocator(null);
            return;
        }
        JDFAutoComChannel.EnumChannelType channelType = this.getChannelType();
        this.setPhoneNumber(phone, ".", channelType);
    }

    public void setPhoneNumber(String phone, String replaceForBlank, JDFAutoComChannel.EnumChannelType channelType) {
        if (channelType == null) {
            channelType = this.getChannelType();
        }
        if (!(JDFAutoComChannel.EnumChannelType.Fax.equals((Object)channelType) || JDFAutoComChannel.EnumChannelType.Phone.equals((Object)channelType) || JDFAutoComChannel.EnumChannelType.Mobile.equals((Object)channelType))) {
            throw new IllegalArgumentException("illegal channelType: " + channelType);
        }
        if (phone != null) {
            phone = ((String)phone).trim();
        }
        if ((phone = StringUtil.replaceCharSet((String)phone, " ", replaceForBlank, 0)) == null || !StringUtil.matches((String)phone, "(tel:)?([+])?(([0-9./\\-])|[(]([0-9./\\-])[)])+")) {
            throw new IllegalArgumentException("illegal phone number:" + (String)phone);
        }
        this.setChannelType(channelType);
        if (!((String)phone).toLowerCase().startsWith(TEL)) {
            phone = TEL + (String)phone;
        }
        this.setLocator((String)phone);
    }

    @Override
    public JDFAutoComChannel.EnumChannelType getChannelType() {
        JDFAutoComChannel.EnumChannelType channelType = super.getChannelType();
        if (JDFAutoComChannel.EnumChannelType.Phone.equals((Object)channelType)) {
            String ctd = this.getChannelTypeDetails();
            if ("mobile".equals(ctd = StringUtil.normalize(ctd, true))) {
                channelType = JDFAutoComChannel.EnumChannelType.Mobile;
            }
        }
        return channelType;
    }

    @Override
    public boolean matches(Object subset) {
        if (subset instanceof String) {
            return this.stringMatch((String)subset);
        }
        if (subset instanceof JDFComChannel) {
            return this.matchesComChannel((JDFComChannel)subset);
        }
        return false;
    }

    boolean matchesComChannel(JDFComChannel other) {
        if (!ContainerUtil.equals((Object)this.getChannelType(), (Object)other.getChannelType())) {
            return false;
        }
        if (!ContainerUtil.equals(this.getChannelTypeDetails(), other.getChannelTypeDetails())) {
            return false;
        }
        if (!ContainerUtil.equals(this.getChannelUsage(), other.getChannelUsage())) {
            return false;
        }
        return this.matches(other.getLocator());
    }

    boolean stringMatch(String s) {
        JDFAutoComChannel.EnumChannelType channelType;
        boolean b = StringUtil.equals(StringUtil.normalize(s, true, null), StringUtil.normalize(this.getLocator(), true, null));
        if (!b && (JDFAutoComChannel.EnumChannelType.Fax.equals((Object)(channelType = this.getChannelType())) || JDFAutoComChannel.EnumChannelType.Phone.equals((Object)channelType) || JDFAutoComChannel.EnumChannelType.Mobile.equals((Object)channelType))) {
            b = StringUtil.equals(StringUtil.stripNot(s, PHONE_CHARS), StringUtil.stripNot(this.getLocator(), PHONE_CHARS));
        }
        return b;
    }

    public static class EnumChannelTypeDetails
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumChannelTypeDetails Unknown = new EnumChannelTypeDetails("Unknown");
        public static final EnumChannelTypeDetails LandLine = new EnumChannelTypeDetails("LandLine");
        public static final EnumChannelTypeDetails Mobile = new EnumChannelTypeDetails("Mobile");
        public static final EnumChannelTypeDetails Secure = new EnumChannelTypeDetails("Secure");
        public static final EnumChannelTypeDetails ISDN = new EnumChannelTypeDetails("ISDN");
        public static final EnumChannelTypeDetails Form = new EnumChannelTypeDetails("Form");
        public static final EnumChannelTypeDetails Target = new EnumChannelTypeDetails("Target");

        private EnumChannelTypeDetails(String name) {
            super(name, m_startValue++);
        }

        public static EnumChannelTypeDetails getEnum(String enumName) {
            return (EnumChannelTypeDetails)EnumChannelTypeDetails.getEnum(EnumChannelTypeDetails.class, (String)enumName);
        }

        public static EnumChannelTypeDetails getEnum(int enumValue) {
            return (EnumChannelTypeDetails)EnumChannelTypeDetails.getEnum(EnumChannelTypeDetails.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumChannelTypeDetails.getEnumMap(EnumChannelTypeDetails.class);
        }

        public static List getEnumList() {
            return EnumChannelTypeDetails.getEnumList(EnumChannelTypeDetails.class);
        }

        public static Iterator iterator() {
            return EnumChannelTypeDetails.iterator(EnumChannelTypeDetails.class);
        }
    }
}

