/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process.postpress;

import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoLayout;
import org.cip4.jdflib.auto.JDFAutoPart;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFSignature;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFSurface;

public class JDFSheet
extends JDFSignature {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[5];
    private static ElemInfoTable[] elemInfoTable_Surface;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        AttributeInfo ai = super.getTheAttributeInfo();
        if (this.getLocalName().equals("Sheet")) {
            ai.updateReplace(atrInfoTable);
        }
        return ai;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable_Surface);
    }

    public JDFSheet(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFSheet(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFSheet(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFSheet[  --> " + super.toString() + " ]";
    }

    public JDFSurface getCreateFrontSurface() {
        JDFSurface e = this.getSurface(JDFAutoPart.EnumSide.Front);
        if (e == null) {
            e = this.appendSurface();
            e.setSide(JDFAutoPart.EnumSide.Front);
        }
        return e;
    }

    public JDFSurface getSurface(JDFAutoPart.EnumSide side) {
        JDFSurface s = this.getSurface(0);
        if (s == null) {
            return null;
        }
        if (s.getSide() == side) {
            return s;
        }
        s = this.getSurface(1);
        if (s == null) {
            return null;
        }
        if (s.getSide() == side) {
            return s;
        }
        return null;
    }

    @Deprecated
    public JDFSurface getFrontSurface() {
        return this.getSurface(JDFAutoPart.EnumSide.Front);
    }

    public JDFSurface appendFrontSurface() {
        JDFSurface e = this.getSurface(JDFAutoPart.EnumSide.Front);
        if (e != null) {
            throw new JDFException("appendFrontSurface surface already exists");
        }
        e = this.appendSurface();
        e.setSide(JDFAutoPart.EnumSide.Front);
        return e;
    }

    public void removeFrontSurface() {
        JDFSurface e = this.getSurface(JDFAutoPart.EnumSide.Front);
        if (e != null) {
            e.deleteNode();
        }
    }

    @Override
    public String getSheetName() {
        if (this.getLocalName().equals("Sheet")) {
            return this.getName();
        }
        if (this.getLocalName().equals("Surface")) {
            KElement shE;
            JDFNode n;
            KElement surfaceRef;
            KElement k = this.getParentNode_KElement();
            if (k instanceof JDFSheet) {
                JDFSheet sh = (JDFSheet)k;
                return sh.getSheetName();
            }
            if (k instanceof JDFResourcePool && (surfaceRef = (n = ((JDFElement)k).getParentJDF()).getChildWithAttribute("SurfaceRef", "rRef", null, this.getID(), 0, false)) != null && (shE = surfaceRef.getParentNode_KElement()) instanceof JDFSheet) {
                JDFSheet sh = (JDFSheet)shE;
                return sh.getSheetName();
            }
        } else {
            return super.getSheetName();
        }
        return null;
    }

    public boolean hasFrontSurface() {
        return this.getSurface(JDFAutoPart.EnumSide.Front) != null;
    }

    public void refFrontSurface(JDFSurface refTarget) {
        this.refElement(refTarget);
        if (refTarget != null) {
            refTarget.setSide(JDFAutoPart.EnumSide.Back);
        }
    }

    public JDFSurface getCreateBackSurface() {
        JDFSurface e = this.getSurface(JDFAutoPart.EnumSide.Back);
        if (e == null) {
            e = this.appendBackSurface();
        }
        return e;
    }

    @Deprecated
    public JDFSurface getBackSurface() {
        return this.getSurface(JDFAutoPart.EnumSide.Back);
    }

    public JDFSurface appendBackSurface() {
        JDFSurface e = this.getSurface(JDFAutoPart.EnumSide.Back);
        if (e != null) {
            throw new JDFException("appendBackSurface surface already exists");
        }
        e = this.appendSurface();
        e.setSide(JDFAutoPart.EnumSide.Back);
        return e;
    }

    public void removeBackSurface() {
        JDFSurface e = this.getSurface(JDFAutoPart.EnumSide.Back);
        if (e != null) {
            e.deleteNode();
        }
    }

    public boolean hasBackSurface() {
        return this.getSurface(JDFAutoPart.EnumSide.Back) != null;
    }

    public void refBackSurface(JDFSurface refTarget) {
        this.refElement(refTarget);
        if (refTarget != null) {
            refTarget.setSide(JDFAutoPart.EnumSide.Back);
        }
    }

    public JDFSurface getCreateSurface(int iSkip) {
        JDFSurface s = this.getSurface(iSkip);
        if (s == null) {
            s = this.appendSurface();
        }
        return s;
    }

    public JDFSurface getSurface(int iSkip) {
        return JDFSheet.getLayoutElement((JDFResource)this, "Surface", "Side", iSkip);
    }

    public JDFSurface appendSurface() throws JDFException {
        if (this.numSurfaces() > 1) {
            throw new JDFException("appendSurface: sheet already has two surfaces");
        }
        return JDFSheet.appendLayoutElement(this, "Surface", "Side");
    }

    public int numSurfaces() {
        return JDFSheet.numLayoutElements(this, "Surface", "Side");
    }

    @Deprecated
    public VElement getSurfaceVector(JDFAttributeMap mAttrib, boolean bAnd) {
        VElement myResource = new VElement();
        VElement vElem = this.getChildElementVector("Surface", null, mAttrib, bAnd, 0, true);
        for (int i = 0; i < vElem.size(); ++i) {
            JDFElement k = (JDFElement)((Vector)vElem).elementAt(i);
            JDFSurface myJDFSurface = (JDFSurface)k;
            myResource.addElement(myJDFSurface);
        }
        return myResource;
    }

    public VElement getSurfaceVector() {
        return JDFSheet.getLayoutElementVector(this, "Surface", "Side");
    }

    public void refSurface(JDFSurface refTarget) {
        if (JDFLayout.isNewLayout(this)) {
            throw new JDFException("refSheet: attempting to reference a partition");
        }
        this.refElement(refTarget);
    }

    static {
        JDFSheet.atrInfoTable[0] = new AtrInfoTable("SurfaceContentsBox", 0x44444333L, AttributeInfo.EnumAttributeType.rectangle, null, null);
        JDFSheet.atrInfoTable[1] = new AtrInfoTable("LockOrigins", 0x44444333L, AttributeInfo.EnumAttributeType.boolean_, null, "false");
        JDFSheet.atrInfoTable[2] = new AtrInfoTable("Name", 0x44444333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFSheet.atrInfoTable[3] = new AtrInfoTable("SourceWorkStyle", 0x44444333L, AttributeInfo.EnumAttributeType.enumeration, JDFAutoLayout.EnumSourceWorkStyle.getEnum(0), null);
        JDFSheet.atrInfoTable[4] = new AtrInfoTable("SurfaceContentsBox", 0x44444333L, AttributeInfo.EnumAttributeType.rectangle, null, null);
        elemInfoTable_Surface = new ElemInfoTable[1];
        JDFSheet.elemInfoTable_Surface[0] = new ElemInfoTable("Surface", 0x44444333L);
    }
}

