/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.util.StreamUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class XMLZipWriter
implements IStreamWriter {
    private static final Log log = LogFactory.getLog(XMLZipWriter.class);
    private final XMLDoc doc;
    private String entryName;

    public XMLZipWriter(XMLDoc doc, String filepath) {
        this.doc = doc;
        String string = this.entryName = StringUtil.isEmpty(filepath) ? doc.getOriginalFileName() : filepath;
        if (UrlUtil.isZip(this.entryName)) {
            this.entryName = UrlUtil.extension(UrlUtil.prefix(this.entryName)) != null ? UrlUtil.prefix(this.entryName) : this.entryName + ".xml";
        }
        this.entryName = UrlUtil.getFileName(this.entryName, null);
    }

    void writeXML(ZipOutputStream zos) {
        try {
            ZipEntry ze = new ZipEntry(this.entryName);
            zos.putNextEntry(ze);
            this.doc.writeStream(zos);
            zos.closeEntry();
        }
        catch (Exception x) {
            log.error((Object)"oops: ", (Throwable)x);
        }
    }

    @Override
    public void writeStream(OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        this.writeXML(zos);
        zos.close();
        StreamUtil.close(os);
    }

    public String toString() {
        return "XMLZipWriter [doc=" + this.doc.getRootName() + ", entryName=" + this.entryName + "]";
    }
}

