/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.validate;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.elementwalker.FixVersion;
import org.cip4.jdflib.extensions.XJDF20;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.XJDFToJDFConverter;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.MyArgs;
import org.cip4.jdflib.util.UrlUtil;

public class VersionTranslator {
    private final JDFElement.EnumVersion version;

    public static int main(String[] argv) {
        MyArgs myArgs = new MyArgs(argv, "?", "ov", "v");
        if (myArgs.hasParameter('?')) {
            myArgs.usage("JDF / XJDF Version Converter");
            return 1;
        }
        if (myArgs.missingArgs() != null) {
            myArgs.usage("JDF / XJDF Version Converter - missing required switches: " + myArgs.missingArgs());
            return 2;
        }
        String version = myArgs.parameter('v');
        if (JDFElement.EnumVersion.getEnum(version) == null) {
            myArgs.usage("JDF / XJDF Version Converter - invalid versions: " + version);
            return 2;
        }
        if (myArgs.nargs() == 0) {
            myArgs.usage("JDF / XJDF Version Converter -missing input: ");
            return 2;
        }
        String out = myArgs.parameter('o');
        File outDir = UrlUtil.urlToFile(out);
        VersionTranslator translator = new VersionTranslator(myArgs);
        for (int i = 0; i < myArgs.nargs(); ++i) {
            translator.convertFile(UrlUtil.urlToFile(myArgs.argument(i)), outDir);
        }
        return 0;
    }

    void convertFile(File urlToFile, File outDir) {
        BufferedInputStream stream = FileUtil.getBufferedInputStream(urlToFile);
        if (stream == null) {
            return;
        }
        if (outDir == null) {
            outDir = urlToFile.getParentFile();
        }
        File outFile = FileUtil.getFileInDirectory(outDir, new File(urlToFile.getName()));
        outFile = FileUtil.newExtension(outFile, this.getExtension());
        Vector<InputStream> converted = this.convertStream(stream);
        if (converted != null) {
            if (converted.size() == 1) {
                FileUtil.streamToFile(converted.get(0), outFile);
            } else {
                for (int i = 0; i < converted.size(); ++i) {
                    FileUtil.streamToFile(converted.get(0), FileUtil.newExtension(outFile, i + "." + this.getExtension()));
                }
            }
        }
    }

    private String getExtension() {
        return EnumUtil.aLessThanB(this.version, JDFElement.EnumVersion.Version_2_0) ? "jdf" : "xjdf";
    }

    public VersionTranslator(JDFElement.EnumVersion version) {
        this.version = version;
    }

    VersionTranslator(MyArgs myArgs) {
        String version = myArgs.parameter('v');
        this.version = JDFElement.EnumVersion.getEnum(version);
    }

    public Vector<InputStream> convertStream(InputStream stream) {
        Vector<InputStream> v;
        JDFDoc d = JDFDoc.parseStream(stream);
        KElement root = this.getRoot(d);
        if (root == null) {
            return null;
        }
        KElement newRoot = this.convertElement(root);
        if (newRoot == null) {
            return null;
        }
        ByteArrayIOStream bios = new ByteArrayIOStream();
        try {
            newRoot.getOwnerDocument_KElement().write2Stream(bios, 2, true);
        }
        catch (IOException e) {
            bios = null;
        }
        if (bios == null) {
            v = null;
        } else {
            v = new Vector<InputStream>();
            v.add(bios.getInputStream());
        }
        return v;
    }

    public KElement convertElement(KElement root) {
        JDFElement.EnumVersion inVersion = this.getVersion(root);
        KElement retElem = EnumUtil.aLessThanB(inVersion, JDFElement.EnumVersion.Version_2_0) ? this.convertFromJDF(root) : this.convertFromXJDF(root);
        return retElem;
    }

    KElement convertFromXJDF(KElement root) {
        XJDFToJDFConverter xCon;
        JDFDoc dOut;
        KElement retElem = EnumUtil.aLessThanB(this.version, JDFElement.EnumVersion.Version_2_0) ? ((dOut = (xCon = new XJDFToJDFConverter(null)).convert(root)) == null ? null : dOut.getRoot()) : root;
        return retElem;
    }

    KElement convertFromJDF(KElement root) {
        KElement retElem;
        if (EnumUtil.aLessThanB(this.version, JDFElement.EnumVersion.Version_2_0)) {
            FixVersion fix = new FixVersion(this.version);
            fix.walkTree(root, null);
            retElem = root;
        } else {
            XJDF20 xCon = this.getJDFToXJDFConverter();
            retElem = xCon.convert(root);
        }
        return retElem;
    }

    XJDF20 getJDFToXJDFConverter() {
        XJDF20 xCon = new XJDF20();
        xCon.setSingleNode(false);
        return xCon;
    }

    private JDFElement.EnumVersion getVersion(KElement root) {
        JDFElement.EnumVersion vers = root instanceof JDFNode ? ((JDFNode)root).getVersion(true) : (root instanceof JDFJMF ? ((JDFJMF)root).getVersion(true) : JDFElement.EnumVersion.Version_2_0);
        return vers;
    }

    private KElement getRoot(JDFDoc d) {
        if (d == null) {
            return null;
        }
        KElement root = d.getJDFRoot();
        if (root == null) {
            root = d.getJMFRoot();
        }
        if (root == null) {
            XJDFHelper helper = XJDFHelper.getHelper(d);
            root = helper == null ? null : helper.getRoot();
        }
        return root;
    }

    public String toString() {
        return "VersionTranslator [version=" + this.version + "]";
    }
}

