/**
 *
 * Copyright (c) 2001 Heidelberger Druckmaschinen AG, All Rights Reserved.
 *
 * JDFAmount.java
 *
 * Last changes
 *
 */
package org.cip4.jdflib.span;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.DOMException;

public class JDFSpanJacket extends JDFEnumerationSpan
{
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor for JDFSpanJacket
	 * 
	 * @param ownerDocument
	 * @param qualifiedName
	 * @throws DOMException
	 */
	public JDFSpanJacket(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException
	{
		super(myOwnerDocument, qualifiedName);
	}

	/**
	 * Constructor for JDFSpanJacket
	 * 
	 * @param ownerDocument
	 * @param namespaceURI
	 * @param qualifiedName
	 * @throws DOMException
	 */
	public JDFSpanJacket(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName);
	}

	/**
	 * Constructor for JDFSpanJacket
	 * 
	 * @param ownerDocument
	 * @param namespaceURI
	 * @param qualifiedName
	 * @param localName
	 * @throws DOMException
	 */
	public JDFSpanJacket(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
	}

	/**
	 * Enumeration strings for EnumSpanJacket
	 */
	public static class EnumSpanJacket extends ValuedEnum
	{
		private static final long serialVersionUID = 1L;
		private static int m_startValue = 0;

		private EnumSpanJacket(String name)
		{
			super(name, m_startValue++);
		}

		public static EnumSpanJacket getEnum(String enumName)
		{
			return (EnumSpanJacket) getEnum(EnumSpanJacket.class, enumName);
		}

		public static EnumSpanJacket getEnum(int enumValue)
		{
			return (EnumSpanJacket) getEnum(EnumSpanJacket.class, enumValue);
		}

		public static Map getEnumMap()
		{
			return getEnumMap(EnumSpanJacket.class);
		}

		public static List getEnumList()
		{
			return getEnumList(EnumSpanJacket.class);
		}

		public static Iterator iterator()
		{
			return iterator(EnumSpanJacket.class);
		}

		public static final EnumSpanJacket None = new EnumSpanJacket("None");
		public static final EnumSpanJacket Loose = new EnumSpanJacket("Loose");
		public static final EnumSpanJacket Glue = new EnumSpanJacket("Glue");

	}

	// **************************************** Methods
	// *********************************************

	/**
	 * AllowedValues - vector of allowed values for this EnumerationSpan
	 * 
	 * @return Vector - vector representation of the allowed values
	 */
	@Override
	public ValuedEnum getEnumType()
	{
		return EnumSpanJacket.getEnum(0);
	}

	/**
	 * toString
	 * 
	 * @return String
	 */
	@Override
	public String toString()
	{
		return "JDFSpanJacket[  --> " + super.toString() + " ]";
	}
}
