/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.util.ListMap;
import org.cip4.jdflib.util.StringUtil;

public class XJDFSchemaWalker
extends BaseElementWalker {
    private static final String ENUM = "Enum";
    static final String MATRIX = "matrix";
    static final String CMYK_COLOR = "CMYKColor";
    static final String RECTANGLE = "rectangle";
    static final String SRGB_COLOR = "sRGBColor";
    static final String LAB_COLOR = "LabColor";
    static final String SHAPE = "shape";
    static final String XY_PAIR = "XYPair";
    private final JDFAttributeMap typeMap = new JDFAttributeMap();
    private final ListMap<String, String> enumMap = new ListMap();
    static final String NAME = "name";
    static final String TYPE = "type";

    public XJDFSchemaWalker() {
        super(new BaseWalkerFactory());
    }

    public JDFAttributeMap getTypeMap() {
        return this.typeMap;
    }

    public Map<String, Integer> getLengthMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (String key : this.typeMap.getKeyList()) {
            int l = this.getLength(key);
            if (l <= 0) continue;
            ret.put(key, l);
        }
        return ret;
    }

    public int getLength(String path) {
        String typ = this.typeMap.get(path);
        if (typ != null) {
            switch (typ) {
                case "XYPair": {
                    return 2;
                }
                case "shape": 
                case "LabColor": 
                case "sRGBColor": {
                    return 3;
                }
                case "rectangle": 
                case "CMYKColor": {
                    return 4;
                }
                case "matrix": {
                    return 6;
                }
            }
        }
        return 0;
    }

    public Integer getMin(String path) {
        String typ = this.typeMap.get(path);
        if (typ != null) {
            switch (typ) {
                case "shape": 
                case "sRGBColor": 
                case "CMYKColor": {
                    return 0;
                }
            }
        }
        return null;
    }

    public Integer getMax(String path) {
        String typ = this.typeMap.get(path);
        if (typ != null) {
            switch (typ) {
                case "sRGBColor": 
                case "CMYKColor": {
                    return 1;
                }
            }
        }
        return null;
    }

    public List<String> getEnums(String name) {
        String newName = this.getKey(name);
        return newName == null ? null : (List)this.enumMap.get(newName);
    }

    public String getKey(String name) {
        if (this.enumMap.containsKey(name)) {
            return name;
        }
        if (name.startsWith(ENUM) && this.enumMap.containsKey(name.substring(4))) {
            return name.substring(4);
        }
        if (this.enumMap.containsKey(ENUM + name)) {
            return ENUM + name;
        }
        if (name.indexOf(47) > 0) {
            return this.getKey(StringUtil.removeToken(name, 0, "/"));
        }
        return null;
    }

    public ListMap<String, String> getEnumMap() {
        return this.enumMap;
    }

    protected class WalkEnum
    extends WalkElement {
        private static final String VALUE = "value";

        @Override
        public KElement walk(KElement a, KElement xjdf) {
            String val = a.getNonEmpty(VALUE);
            if (!StringUtil.isEmpty(val)) {
                String name = this.getKey(a);
                XJDFSchemaWalker.this.enumMap.putOne(name, val);
            }
            return null;
        }

        String getKey(KElement a) {
            int i = 0;
            String strRet = "";
            while (i < 2 && a != null) {
                String name = a.getNonEmpty(XJDFSchemaWalker.NAME);
                if (name != null) {
                    strRet = i == 0 ? name : name + "/" + strRet;
                    ++i;
                }
                a = a.getParentNode_KElement();
            }
            return strRet;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return "xs:enumeration".equals(toCheck.getNodeName());
        }
    }

    protected class WalkAttribute
    extends WalkElement {
        @Override
        public KElement walk(KElement a, KElement xjdf) {
            String typ = a.getNonEmpty(XJDFSchemaWalker.TYPE);
            String parent = a.getParentNode_KElement().getInheritedAttribute(XJDFSchemaWalker.NAME, null, null);
            String name = a.getNonEmpty(XJDFSchemaWalker.NAME);
            String key = parent + "/" + name;
            XJDFSchemaWalker.this.typeMap.putNotNull(key, typ);
            return super.walk(a, xjdf);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return "xs:attribute".equals(toCheck.getNodeName());
        }
    }

    protected class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(XJDFSchemaWalker.this.getFactory());
        }

        @Override
        public KElement walk(KElement in, KElement out) {
            return in;
        }
    }
}

