/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.auto.JDFAutoAssembly;
import org.cip4.jdflib.auto.JDFAutoBinderySignature;
import org.cip4.jdflib.auto.JDFAutoStripCellParams;
import org.cip4.jdflib.auto.JDFAutoStrippingParams;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.StringArray;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.IWalker;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.IntentHelper;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.ResourceHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDFDataCache;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.MiscConsumableMaker;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.jmf.JDFMessageService;
import org.cip4.jdflib.jmf.JDFModuleInfo;
import org.cip4.jdflib.jmf.JDFResourceInfo;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFHeadBandApplicationParams;
import org.cip4.jdflib.resource.JDFLaminatingParams;
import org.cip4.jdflib.resource.JDFMarkObject;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.intent.JDFArtDelivery;
import org.cip4.jdflib.resource.intent.JDFArtDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFMediaIntent;
import org.cip4.jdflib.resource.process.JDFAssembly;
import org.cip4.jdflib.resource.process.JDFAssemblySection;
import org.cip4.jdflib.resource.process.JDFBinderySignature;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFContentObject;
import org.cip4.jdflib.resource.process.JDFDeliveryParams;
import org.cip4.jdflib.resource.process.JDFDrop;
import org.cip4.jdflib.resource.process.JDFDropItem;
import org.cip4.jdflib.resource.process.JDFFileSpec;
import org.cip4.jdflib.resource.process.JDFIdentical;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFPosition;
import org.cip4.jdflib.resource.process.JDFRunList;
import org.cip4.jdflib.resource.process.JDFSignatureCell;
import org.cip4.jdflib.resource.process.JDFStation;
import org.cip4.jdflib.resource.process.JDFStripCellParams;
import org.cip4.jdflib.resource.process.postpress.JDFStitchingParams;
import org.cip4.jdflib.resource.process.postpress.JDFThreadSewingParams;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.ListMap;
import org.cip4.jdflib.util.StringUtil;

class PostXJDFWalker
extends BaseElementWalker {
    private boolean mergeLayout;
    protected XJDFHelper newRootHelper;
    private boolean bIntentPartition;
    private boolean bDeliveryIntent;
    private boolean retainAll;
    private static final StringArray metaKeys = new StringArray(new String[]{"CommandResult", "JobID", "JobPartID", "Level", "ModuleID", "QueueEntryID", "Scope", "Speed", "TotalAmount", "Types"});
    private JDFElement.EnumVersion newVersion;
    private boolean removeSignatureName;
    private static StringArray noPrint = new StringArray(new String[]{JDFNode.EnumType.ImageSetting.getName(), JDFNode.EnumType.Imposition.getName(), JDFNode.EnumType.Interpreting.getName(), JDFNode.EnumType.Rendering.getName()});
    private static StringArray print = new StringArray(new String[]{JDFNode.EnumType.ConventionalPrinting.getName(), JDFNode.EnumType.DigitalPrinting.getName()});

    boolean isMergeLayout() {
        return this.mergeLayout;
    }

    void setMergeLayout(boolean mergeLayout) {
        this.mergeLayout = mergeLayout;
    }

    public JDFElement.EnumVersion getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(JDFElement.EnumVersion newVersion) {
        this.newVersion = newVersion == null ? BaseXJDFHelper.getDefaultVersion() : newVersion;
    }

    boolean isIntentPartition() {
        return this.bIntentPartition;
    }

    void setIntentPartition(boolean bIntentPartition) {
        this.bIntentPartition = bIntentPartition;
    }

    boolean isDeliveryIntent() {
        return this.bDeliveryIntent;
    }

    void setDeliveryIntent(boolean bDeliveryIntent) {
        this.bDeliveryIntent = bDeliveryIntent;
    }

    boolean isRemoveSignatureName() {
        return this.removeSignatureName;
    }

    void setRemoveSignatureName(boolean removeSignatureName) {
        this.removeSignatureName = removeSignatureName;
    }

    PostXJDFWalker(JDFElement newRoot) {
        super(new BaseWalkerFactory());
        this.newRootHelper = new XJDFHelper(newRoot);
        this.bDeliveryIntent = false;
        this.bIntentPartition = false;
        this.mergeLayout = true;
        this.removeSignatureName = true;
        this.retainAll = false;
        this.newVersion = XJDFHelper.defaultVersion();
    }

    protected boolean isRetainAll() {
        return this.retainAll;
    }

    protected void setRetainAll(boolean retainAll) {
        this.retainAll = retainAll;
        if (retainAll) {
            this.removeSignatureName = !retainAll;
            this.mergeLayout = !retainAll;
            this.bDeliveryIntent = retainAll;
        }
    }

    void moveToSender(KElement xjdf) {
        if (xjdf != null) {
            JDFElement sender = (JDFElement)xjdf.getCreateElement("Header");
            sender.moveAttribute("AgentName", xjdf);
            sender.moveAttribute("AgentVersion", xjdf);
            sender.moveAttribute("Author", xjdf);
            sender.moveAttribute("DeviceID", xjdf);
            sender.moveAttribute("Time", xjdf);
            sender.moveAttribute("ICSVersions", xjdf);
            sender.moveAttribute("PersonalID", xjdf);
            sender.moveAttribute("ID", xjdf);
            sender.moveAttribute("refID", xjdf);
            if (!sender.hasAttribute("DeviceID")) {
                sender.setAttribute("DeviceID", "dummy");
            }
            this.getFactory().getWalker(sender).walk(sender, null);
        }
    }

    @Override
    public String toString() {
        return "PostXJDFWalker [mergeLayout=" + this.mergeLayout + ", bIntentPartition=" + this.bIntentPartition + ", bDeliveryIntent=" + this.bDeliveryIntent + ", retainAll=" + this.retainAll + ", removeSignatureName=" + this.removeSignatureName + ", newRoot=" + this.newRootHelper.getRoot() + "]";
    }

    void combineSameSets() {
        KElement root = this.newRootHelper.getRoot();
        IWalker w = this.getFactory().getWalker(root);
        if (w instanceof WalkXJDF) {
            this.combineSameSets((JDFElement)root);
        }
    }

    void combineSameSets(JDFElement xjdf) {
        Vector<SetHelper> v;
        if (!this.isRetainAll() && (v = new XJDFHelper(xjdf).getSets()) != null) {
            this.combineSameSets(v);
        }
    }

    void combineSameSets(List<SetHelper> v) {
        while (v.size() > 1) {
            ArrayList<SetHelper> sameSets = new ArrayList<SetHelper>();
            SetHelper firstSet = v.remove(0);
            sameSets.add(firstSet);
            for (int j = 0; j < v.size(); ++j) {
                SetHelper next = v.get(j);
                if (!this.sameSetType(firstSet, next)) continue;
                sameSets.add(next);
                v.remove(j);
                --j;
            }
            KElement root = firstSet.getRoot();
            for (int j = 1; j < sameSets.size(); ++j) {
                List<ResourceHelper> parts = ((SetHelper)sameSets.get(j)).getPartitionList();
                for (ResourceHelper ph : parts) {
                    root.copyElement(ph.getRoot(), null);
                }
                ((SetHelper)sameSets.get(j)).getRoot().deleteNode();
            }
        }
    }

    private boolean sameSetType(SetHelper firstSet, SetHelper next) {
        boolean same = firstSet.getName().equals(next.getName());
        if (same) {
            same = StringUtil.equals(firstSet.getProcessUsage(), next.getProcessUsage());
        }
        if (same) {
            same = ContainerUtil.equals((Object)firstSet.getUsage(), (Object)next.getUsage());
        }
        if (same) {
            same = ContainerUtil.equals(firstSet.getXPathValue("@CombinedProcessIndex"), next.getXPathValue("@CombinedProcessIndex"));
        }
        if (same) {
            same = ContainerUtil.equals(firstSet.getXPathValue("Resource/Media/@MediaType"), next.getXPathValue("Resource/Media/@MediaType"));
        }
        return same;
    }

    protected class WalkStrippingParams
    extends WalkResourceElement {
        @Override
        public VString getElementNames() {
            return new VString("StrippingParams", null);
        }

        @Override
        public KElement walk(KElement strippingParams, KElement dummy) {
            if (!PostXJDFWalker.this.mergeLayout) {
                super.walk(strippingParams, dummy);
                return strippingParams;
            }
            SetHelper layoutseth = PostXJDFWalker.this.newRootHelper.getSet("Layout", JDFResourceLink.EnumUsage.Input);
            if (layoutseth == null && (layoutseth = PostXJDFWalker.this.newRootHelper.getSet("Layout", JDFResourceLink.EnumUsage.Output)) == null) {
                layoutseth = PostXJDFWalker.this.newRootHelper.getCreateSet("Layout", JDFResourceLink.EnumUsage.Input);
            }
            VJDFAttributeMap vmap = new ResourceHelper(strippingParams.getParentNode_KElement()).getPartMapVector();
            this.mergeStrippingParamsLayout((JDFStrippingParams)strippingParams, layoutseth, vmap);
            super.walk(strippingParams, dummy);
            return null;
        }

        private JDFAttributeMap mergeStrippingParamsLayout(JDFStrippingParams strippingParams, SetHelper layoutseth, VJDFAttributeMap layoutMaps) {
            String bsID;
            JDFAttributeMap layoutMap;
            JDFAttributeMap jDFAttributeMap = layoutMap = VJDFAttributeMap.isEmpty(layoutMaps) ? new JDFAttributeMap() : layoutMaps.get(0);
            if (PostXJDFWalker.this.isRemoveSignatureName()) {
                layoutMap.remove("SignatureName");
            }
            String bsResID = strippingParams.getNonEmpty("BinderySignatureRef");
            String newBSID = bsID = this.getBSID(strippingParams, null);
            if (StringUtil.isEmpty(bsID)) {
                String bsName = this.getBSName(strippingParams, layoutMap, bsResID);
                bsID = this.getBSID(strippingParams, bsName);
                newBSID = this.getNewBSID(bsID, layoutseth);
            }
            String cellIndex = layoutMap.remove("CellIndex");
            layoutMap.remove("BinderySignatureName");
            layoutMap.remove("BinderySignatureID");
            ResourceHelper layoutPartitionH = layoutseth.getCreateVPartition(layoutMaps, true);
            JDFLayout layoutPartition = (JDFLayout)layoutPartitionH.getResource();
            this.ensureLayoutPositions(strippingParams, layoutPartition, newBSID);
            VElement childElementVector = this.updateCells(strippingParams, cellIndex);
            ResourceHelper bsHelper = this.getBSHelper(bsID, newBSID, bsResID, strippingParams);
            JDFBinderySignature bs = (JDFBinderySignature)bsHelper.getCreateResource();
            this.moveStripCells(bs, childElementVector);
            this.moveBSFromStripping(bs, strippingParams);
            SetHelper niSet = PostXJDFWalker.this.newRootHelper.getSet("NodeInfo", 0);
            ResourceHelper ni = niSet == null ? null : niSet.getPartition(layoutMap);
            this.moveGangSourceFromStripping(ni, bsID, strippingParams);
            this.updatePositions(newBSID, layoutPartition);
            strippingParams.removeAttribute("BinderySignatureRef");
            strippingParams.removeAttribute("BinderySignatureID");
            if (layoutPartition.hasChildElement("FileSpec", null)) {
                strippingParams.removeChildrenByClass(JDFFileSpec.class);
            }
            layoutPartition.copyInto(strippingParams, false);
            return layoutMap;
        }

        protected void updatePositions(String bsID, JDFLayout layoutPartition) {
            VElement positions = layoutPartition.getChildElementVector("Position", null);
            if (positions != null) {
                for (KElement position : positions) {
                    if (position.hasAttribute("BinderySignatureID")) continue;
                    position.setAttribute("BinderySignatureID", bsID);
                }
            }
        }

        protected VElement updateCells(JDFStrippingParams strippingParams, String cellIndex) {
            VElement childElementVector = strippingParams.getChildElementVector("SignatureCell", null);
            if (childElementVector != null) {
                for (KElement kid : childElementVector) {
                    JDFStripCellParams scp = (JDFStripCellParams)kid;
                    scp.setAttribute("CellIndex", cellIndex);
                }
            }
            return childElementVector;
        }

        protected ResourceHelper getBSHelper(String bsID, String newBSID, String bsResID, JDFStrippingParams strippingParams) {
            JDFAttributeMap bsMap;
            ResourceHelper bsHelper;
            SetHelper bsSet = PostXJDFWalker.this.newRootHelper.getSet("BinderySignature", 0);
            if (bsSet == null) {
                bsSet = PostXJDFWalker.this.newRootHelper.getCreateSet("BinderySignature", JDFResourceLink.EnumUsage.Input);
            }
            if ((bsHelper = bsSet.getPartition("BinderySignatureID", bsID)) == null || !StringUtil.equals(bsID, bsHelper.getPartKey("BinderySignatureID"))) {
                bsHelper = bsSet.getExactPartition(new JDFAttributeMap("BinderySignatureID", bsID));
            }
            if (bsHelper == null || !StringUtil.equals(bsID, bsHelper.getPartKey("BinderySignatureID"))) {
                bsHelper = bsSet.getPartition(bsResID);
            }
            if (bsHelper == null) {
                bsHelper = bsSet.getPartition(0);
            }
            JDFAttributeMap jDFAttributeMap = bsMap = StringUtil.isEmpty(newBSID) ? null : new JDFAttributeMap("BinderySignatureID", newBSID);
            if (bsHelper == null) {
                bsHelper = bsSet.appendPartition(bsMap, true);
                JDFBinderySignature binderySignature = (JDFBinderySignature)bsHelper.getResource();
                binderySignature.setBinderySignatureType(JDFAutoBinderySignature.EnumBinderySignatureType.Grid);
                binderySignature.setNumberUp(1, 1);
            } else if (!(StringUtil.equals(newBSID, bsHelper.getPartKey("BinderySignatureID")) || StringUtil.isEmpty(bsHelper.getPartKey("BinderySignatureID")) || StringUtil.equals(bsResID, newBSID))) {
                bsHelper = new ResourceHelper(bsSet.copyHelper(bsHelper));
                bsHelper.setPartMap(bsMap);
                bsHelper.removeAttribute("ID", null);
            } else {
                bsHelper.ensurePart("BinderySignatureID", newBSID);
            }
            return bsHelper;
        }

        String getNewBSID(String bsID, SetHelper layoutSet) {
            int index = 1;
            Object bsIDNew = bsID;
            KElement foundpos = layoutSet.getRoot().getChildByTagName("Position", null, 0, new JDFAttributeMap("BinderySignatureID", bsID), false, false);
            while (foundpos != null) {
                bsIDNew = bsID + "." + index++;
                foundpos = layoutSet.getRoot().getChildByTagName("Position", null, 0, new JDFAttributeMap("BinderySignatureID", (String)bsIDNew), false, false);
            }
            return bsIDNew;
        }

        private String getBSID(JDFStrippingParams strippingParams, String bsName) {
            String bsID = strippingParams.getNonEmpty("BinderySignatureID");
            return bsID == null ? bsName : bsID;
        }

        private void moveGangSourceFromStripping(ResourceHelper nih, String bsName, JDFStrippingParams strippingParams) {
            String jobID = strippingParams.getNonEmpty("JobID");
            if (jobID != null) {
                if (nih == null) {
                    strippingParams.removeAttribute("JobID");
                } else {
                    KElement ni = nih.getCreateResource();
                    KElement gangSrc = ni.getCreateChildWithAttribute("GangSource", "BinderySignatureID", null, bsName, 0);
                    if (!gangSrc.hasNonEmpty("JobID")) {
                        gangSrc.moveAttribute("JobID", strippingParams);
                    }
                    if (!gangSrc.hasNonEmpty("Copies")) {
                        ProductHelper ph = this.getProduct(jobID, bsName);
                        if (ph != null) {
                            gangSrc.setAttribute("Copies", ph.getAmount(), (String)null);
                        } else {
                            gangSrc.setAttribute("Copies", 0, (String)null);
                        }
                    }
                }
            }
        }

        protected ProductHelper getProduct(String jobID, String bsName) {
            Vector<ProductHelper> vph = PostXJDFWalker.this.newRootHelper.getProductHelpers();
            if (vph != null) {
                for (ProductHelper ph : vph) {
                    for (String s : new VString("ID ExternalID", null)) {
                        String attribute = ph.getAttribute(s);
                        if (attribute == null || attribute.indexOf(bsName) < 0 && attribute.indexOf(jobID) < 0) continue;
                        return ph;
                    }
                }
            }
            return null;
        }

        String getBSName(JDFStrippingParams strippingParams, JDFAttributeMap map, String bsResID) {
            String bsName;
            String string = bsName = map == null ? null : map.remove("BinderySignatureName");
            if (bsName == null) {
                String string2 = bsName = map == null ? null : map.remove("BinderySignatureID");
            }
            if (bsName == null) {
                bsName = strippingParams.getNonEmpty("BinderySignatureIDs");
            }
            if (bsName == null) {
                ResourceHelper bsHelper;
                SetHelper bsSet = PostXJDFWalker.this.newRootHelper.getSet("BinderySignature", 0);
                if (bsSet != null && (bsHelper = bsSet.getPartition(bsResID)) != null && (bsName = bsHelper.getPartKey("BinderySignatureName")) == null) {
                    bsName = bsHelper.getPartKey("BinderySignatureID");
                }
                if (bsName == null) {
                    bsName = StringUtil.isEmpty(bsResID) ? "BS" : bsResID;
                }
            }
            return bsName;
        }

        private void ensureLayoutPositions(JDFStrippingParams strippingParams, JDFLayout layoutPartition, String bsID) {
            VElement positions = strippingParams.getChildList("Position", null);
            if (!ContainerUtil.isEmpty(positions)) {
                layoutPartition.moveArray(positions, null);
            } else {
                JDFPosition newPos = (JDFPosition)layoutPartition.appendElement("Position");
                newPos.setRelativeBox(new JDFRectangle(0.0, 0.0, 1.0, 1.0));
                positions = new VElement();
                positions.add(newPos);
            }
            String attribute = "StackDepth";
            for (KElement position : positions) {
                position.setAttribute("BinderySignatureID", bsID);
                position.copyAttribute("StackDepth", strippingParams);
            }
            strippingParams.removeAttribute("StackDepth");
        }

        private void moveBSFromStripping(JDFBinderySignature bs, JDFStrippingParams strippingParams) {
            if (bs == null) {
                strippingParams.removeAttribute("InnermostShingling");
                strippingParams.removeAttribute("OutermostShingling");
            } else {
                bs.moveAttribute("InnermostShingling", strippingParams);
                bs.moveAttribute("OutermostShingling", strippingParams);
                JDFAutoStrippingParams.EnumWorkStyle ws = strippingParams.getWorkStyle();
                if (JDFAutoStrippingParams.EnumWorkStyle.Simplex.equals((Object)ws)) {
                    bs.getCreateSignatureCell(0);
                    Collection<JDFSignatureCell> scs = bs.getAllSignatureCell();
                    for (JDFSignatureCell sc : scs) {
                        if (sc.hasNonEmpty("Sides")) continue;
                        sc.setAttribute("Sides", JDFAutoStripCellParams.EnumSides.OneSided.getName());
                    }
                }
            }
        }

        private void moveStripCells(JDFBinderySignature bindSig, VElement childElementVector) {
            if (childElementVector == null) {
                return;
            }
            for (KElement sigCell : childElementVector) {
                String cellindex = sigCell.getAttribute("CellIndex", null, null);
                JDFIntegerList il = JDFIntegerList.createIntegerList(cellindex);
                Vector<JDFSignatureCell> vbsCell = this.getSigCellForIndex(bindSig, il);
                sigCell.removeAttribute("CellIndex");
                if (vbsCell != null) {
                    for (JDFSignatureCell bsCell : vbsCell) {
                        bsCell.mergeElement(sigCell, false);
                    }
                }
                sigCell.deleteNode();
            }
        }

        private Vector<JDFSignatureCell> getSigCellForIndex(JDFBinderySignature bindSig, JDFIntegerList il) {
            Vector<JDFSignatureCell> v = bindSig.getChildrenByClass(JDFSignatureCell.class, true, 0);
            Vector<JDFSignatureCell> vRet = new Vector<JDFSignatureCell>();
            if (v == null || v.size() == 0) {
                vRet.add(bindSig.appendSignatureCell());
            } else {
                for (JDFSignatureCell sc : v) {
                    if (!this.matchesIndex(sc, il)) continue;
                    vRet.add(sc);
                }
            }
            if (vRet.size() == 0) {
                vRet.add(bindSig.appendSignatureCell());
            }
            return vRet;
        }

        private boolean matchesIndex(JDFSignatureCell sc, JDFIntegerList il) {
            if (il == null) {
                return true;
            }
            try {
                il = new JDFIntegerList(il);
            }
            catch (DataFormatException e) {
                return false;
            }
            il.scale(2.0);
            JDFIntegerList fp = sc.getFrontPages();
            return il.contains(fp);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStrippingParams;
        }
    }

    protected class WalkAudit
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            PostXJDFWalker.this.moveToSender(xjdf);
            VElement v = xjdf.getChildrenByTagName(null, null, new JDFAttributeMap("ID", "*"), false, true, 0);
            if (v != null) {
                for (KElement e : v) {
                    if ("Header".equals(e.getLocalName())) continue;
                    e.removeAttribute("ID");
                }
            }
            return super.walk(xjdf, dummy);
        }

        @Override
        public boolean matches(KElement e) {
            String localName = e.getLocalName();
            return localName.startsWith("Audit") && !"AuditPool".equals(localName);
        }
    }

    protected class WalkKnownMessageResponse
    extends WalkMessage {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.splitMessageServices(xjdf);
            return super.walk(xjdf, dummy);
        }

        void splitMessageServices(KElement xjdf) {
            List<JDFMessageService> v = xjdf.getChildArrayByClass(JDFMessageService.class, false, 0);
            for (JDFMessageService ms : v) {
                this.splitMessageService(xjdf, ms);
            }
        }

        void splitMessageService(KElement xjdf, JDFMessageService ms) {
            JDFMessageService ms0;
            int i = 0;
            boolean c = ms.getCommand();
            boolean s = ms.getSignal();
            boolean q = ms.getQuery();
            String t = ms.getType();
            ms.removeAttributes(new StringArray("Command Query Signal"));
            if (c) {
                ms.setType("Command" + t);
                ++i;
            }
            if (s) {
                ms0 = i > 0 ? xjdf.copyElement(ms, ms) : ms;
                ms0.setType("Signal" + t);
                ++i;
            }
            if (q) {
                ms0 = i > 0 ? xjdf.copyElement(ms, ms) : ms;
                ms0.setType("Query" + t);
            }
        }

        @Override
        public VString getElementNames() {
            return new VString("ResponseKnownMessages");
        }
    }

    protected class WalkResourceMessage
    extends WalkMessage {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.mergeResourceInfos(xjdf);
            return super.walk(xjdf, dummy);
        }

        private void mergeResourceInfos(KElement xjdf) {
            List<JDFResourceInfo> vr = xjdf.getChildArrayByClass(JDFResourceInfo.class, false, 0);
            if (!ContainerUtil.isEmpty(vr)) {
                ListMap<JDFAttributeMap, SetHelper> setMap = new ListMap<JDFAttributeMap, SetHelper>();
                for (JDFResourceInfo ri : vr) {
                    JDFAttributeMap metaMap = this.getMetaMap(ri);
                    List<KElement> childArray = ri.getChildList("ResourceSet", null);
                    for (KElement e : childArray) {
                        setMap.putOne(metaMap, new SetHelper(e));
                    }
                }
                for (List sets : setMap.values()) {
                    PostXJDFWalker.this.combineSameSets(sets);
                }
                for (JDFResourceInfo ri : vr) {
                    if (ri.hasChildElement("ResourceSet", null)) continue;
                    ri.deleteNode();
                }
            }
        }

        private JDFAttributeMap getMetaMap(JDFResourceInfo ri) {
            JDFAttributeMap m = ri.getAttributeMap();
            m.reduceMap(metaKeys);
            return m;
        }

        @Override
        public boolean matches(KElement e) {
            return super.matches(e) && e.getLocalName().endsWith("Resource");
        }

        @Override
        public VString getElementNames() {
            return new VString("SignalResource ResponseResource");
        }
    }

    protected class WalkMessage
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            PostXJDFWalker.this.moveToSender(xjdf);
            return super.walk(xjdf, dummy);
        }

        @Override
        public boolean matches(KElement e) {
            String localName = e.getLocalName();
            return localName.startsWith("Query") || localName.startsWith("Signal") || localName.startsWith("Response") || localName.startsWith("Command");
        }
    }

    protected class WalkXJMF
    extends WalkElement {
        @Override
        public VString getElementNames() {
            return VString.getVString("XJMF", null);
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            PostXJDFWalker.this.moveToSender(xjdf);
            return super.walk(xjdf, dummy);
        }
    }

    public class WalkProcessList
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "ProcessList".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (xjdf.numChildElements("Process", null) < 2) {
                xjdf.deleteNode();
                return null;
            }
            return super.walk(xjdf, dummy);
        }
    }

    public class WalkLooseBindindingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("LooseBindingParams", null);
        }

        @Override
        void moveToMisconsumable(KElement xjdf) {
            MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
            String typ = xjdf.getAttribute("BindingType");
            if ("CoilBinding".equals(typ)) {
                this.moveFromCoil(xjdf, mm);
            } else if ("ChannelBinding".equals(typ)) {
                this.moveFromChannel(xjdf, mm);
            }
        }

        private void moveFromCoil(KElement xjdf, MiscConsumableMaker mm) {
            mm.create("Coil", "Spine");
            mm.setTypeDetails(xjdf.getNonEmpty("Material"));
            mm.setColor(xjdf.getNonEmpty("Color"));
            mm.setColorDetails(xjdf.getNonEmpty("ColorDetails"));
            mm.setBrand(xjdf.getNonEmpty("Brand"));
            xjdf.removeAttribute("Material");
            xjdf.removeAttribute("Color");
            xjdf.removeAttribute("ColorDetails");
            xjdf.removeAttribute("Brand");
        }

        private void moveFromChannel(KElement xjdf, MiscConsumableMaker mm) {
            mm.create("ChannelBinder", "Spine");
            mm.setColor(xjdf.getNonEmpty("ClampColor"));
            mm.setColorDetails(xjdf.getNonEmpty("ClampColorDetails"));
            mm.setBrand(xjdf.getNonEmpty("Brand"));
            xjdf.removeAttribute("ClampColor");
            xjdf.removeAttribute("ClampColorDetails");
            xjdf.removeAttribute("Brand");
        }
    }

    public class WalkCustomerInfo
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("CustomerInfo", null);
        }

        @Override
        void updateAttributes(KElement xjdf) {
            super.updateAttributes(xjdf);
            this.fixReferencedContactParts(xjdf);
            xjdf.removeAttribute("ContactRefs");
        }

        public void fixReferencedContactParts(KElement xjdf) {
            StringArray a;
            ResourceHelper rh = ResourceHelper.getHelper(xjdf);
            VJDFAttributeMap vMap = rh == null ? null : rh.getPartMapVector();
            JDFAttributeMap map = vMap == null ? null : vMap.getCommonMap();
            String pp = map == null ? null : map.get("Product");
            StringArray stringArray = a = pp == null ? null : StringArray.getVString(xjdf.getNonEmpty("ContactRefs"), null);
            if (a != null) {
                SetHelper cs = PostXJDFWalker.this.newRootHelper.getSet("Contact", null);
                for (String id : a) {
                    ResourceHelper c = cs == null ? null : cs.getPartition(id);
                    if (c == null) continue;
                    c.ensurePart("Product", pp);
                }
            }
        }
    }

    public class WalkDigitalPrintingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("DigitalPrintingParams", null);
        }

        void moveToStacking(KElement xjdf) {
            String bin = xjdf.getNonEmpty("OutputBin");
            String sa = xjdf.getNonEmpty("StackAmount");
            if (bin != null || sa != null) {
                if (PostXJDFWalker.this.newRootHelper.indexOfType("Stacking", 0) < 0) {
                    PostXJDFWalker.this.newRootHelper.addType(JDFNode.EnumType.Stacking);
                }
                SetHelper sh = PostXJDFWalker.this.newRootHelper.getCreateSet("StackingParams", JDFResourceLink.EnumUsage.Input);
                ResourceHelper rh2 = sh.getCreateVPartition(ResourceHelper.getHelper(xjdf).getPartMapVector(), true);
                KElement sp = rh2.getCreateResource();
                sp.moveAttribute("OutputBin", xjdf);
                sp.moveAttribute("StackAmount", xjdf);
            }
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.moveToStacking(xjdf);
            this.updateMedia(xjdf);
            return super.walk(xjdf, dummy);
        }

        void updateMedia(KElement xjdf) {
            String ref = xjdf.getNonEmpty("MediaRef");
            if (ref != null) {
                VJDFAttributeMap maps;
                xjdf.removeAttribute("MediaRef");
                ResourceHelper helper = ResourceHelper.getHelper(xjdf);
                VJDFAttributeMap vJDFAttributeMap = maps = helper == null ? null : helper.getPartMapVector();
                if (!ContainerUtil.isEmpty(maps)) {
                    ResourceHelper medHelp;
                    KElement m = PostXJDFWalker.this.newRootHelper.getRoot().getChildWithAttribute("Resource", "ID", null, "Comp." + ref, 0, false);
                    if (m == null) {
                        m = PostXJDFWalker.this.newRootHelper.getRoot().getChildWithAttribute("Resource", "ID", null, ref, 0, false);
                    }
                    if ((medHelp = ResourceHelper.getHelper(m)) != null) {
                        VJDFAttributeMap vPartMedia = medHelp.getPartMapVector();
                        vPartMedia.appendUnique(maps);
                        medHelp.setPartMapVector(vPartMedia);
                    }
                }
            }
        }
    }

    public class WalkStitchingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("StitchingParams", null);
        }

        @Override
        void moveToMisconsumable(KElement xjdf) {
            JDFStitchingParams sp = (JDFStitchingParams)xjdf;
            String brand = sp.getNonEmpty("WireBrand");
            if (brand != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("Wire", null);
                mm.setBrand(brand);
                String gauge = sp.getNonEmpty("WireGauge");
                mm.setTypeDetails(gauge);
                sp.removeAttribute("WireBrand");
                sp.removeAttribute("WireGauge");
            }
        }
    }

    public class WalkAssembly
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("Assembly", null);
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.updateSections((JDFAssembly)xjdf);
            return super.walk(xjdf, dummy);
        }

        private void updateSections(JDFAssembly assembly) {
            JDFAutoAssembly.EnumOrder o = assembly.getOrder();
            JDFAssemblySection ass = assembly.getElementByClass(JDFAssemblySection.class, 0, false);
            if (ass != null) {
                List<JDFAssemblySection> l;
                int size;
                if (JDFAutoAssembly.EnumOrder.Collecting.equals((Object)o) && (size = ContainerUtil.size(l = assembly.getChildArrayByClass(JDFAssemblySection.class, false, 0))) > 1) {
                    for (int i = 1; i < size; ++i) {
                        l.get(i - 1).moveElement(l.get(i), null);
                    }
                }
                assembly.setOrder(JDFAutoAssembly.EnumOrder.List);
            }
        }
    }

    public class WalkNodeInfo
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("NodeInfo", null);
        }

        void moveEmployee(KElement xjdf) {
            JDFContact c = ((JDFNodeInfo)xjdf).getContact();
            if (c != null) {
                SetHelper contactSet = PostXJDFWalker.this.newRootHelper.getCreateSet("Contact", JDFResourceLink.EnumUsage.Input);
                ResourceHelper newPart = contactSet.getCreatePartition("ContactType", "Employee", false);
                if (newPart.getResource() == null) {
                    newPart.getRoot().moveElement(c, null);
                    newPart.getRoot().moveAttribute("ExternalID", c);
                } else {
                    c.deleteNode();
                }
            }
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.moveEmployee(xjdf);
            return super.walk(xjdf, dummy);
        }
    }

    public class WalkLaminatingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll();
        }

        @Override
        public VString getElementNames() {
            return new VString("LaminatingParams", null);
        }

        @Override
        void moveToMisconsumable(KElement xjdf) {
            String hard;
            JDFLaminatingParams lp = (JDFLaminatingParams)xjdf;
            String adhesive = lp.getNonEmpty("AdhesiveType");
            if (adhesive != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("Glue", null);
                mm.setTypeDetails(adhesive);
                lp.removeAttribute("AdhesiveType");
            }
            if ((hard = lp.getNonEmpty("HardenerType")) != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("Hardener", null);
                mm.setTypeDetails(hard);
                lp.removeAttribute("HardenerType");
            }
        }
    }

    public class WalkThreadSewingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll() && toCheck instanceof JDFThreadSewingParams;
        }

        @Override
        public VString getElementNames() {
            return new VString("ThreadSewingParams", null);
        }

        @Override
        void moveToMisconsumable(KElement xjdf) {
            String cast;
            JDFThreadSewingParams tsp = (JDFThreadSewingParams)xjdf;
            String core = tsp.getNonEmpty("CoreMaterial");
            String string = cast = core == null ? tsp.getNonEmpty("CastingMaterial") : core;
            if (cast != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("Thread", null);
                mm.setTypeDetails(cast);
                tsp.removeAttribute("CoreMaterial");
                tsp.removeAttribute("CastingMaterial");
            }
        }
    }

    public class WalkHeadBandApplicationParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.isRetainAll() && toCheck instanceof JDFHeadBandApplicationParams;
        }

        @Override
        public VString getElementNames() {
            return new VString("HeadBandApplicationParams", null);
        }

        @Override
        void moveToMisconsumable(KElement xjdf) {
            this.moveHeadBand(xjdf);
            this.moveBackStrip(xjdf);
        }

        private void moveHeadBand(KElement xjdf) {
            JDFHeadBandApplicationParams hap = (JDFHeadBandApplicationParams)xjdf;
            String col = hap.getNonEmpty("TopColor");
            String brand = hap.getNonEmpty("TopBrand");
            if (col != null || brand != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("HeadBand", null);
                mm.setColor(col);
                mm.setColorDetails(hap.getNonEmpty("TopColorDetails"));
                mm.setBrand(brand);
                hap.removeAttribute("TopColor");
                hap.removeAttribute("TopColorDetails");
                hap.removeAttribute("TopBrand");
                hap.removeAttribute("BottomColor");
                hap.removeAttribute("BottomColorDetails");
                hap.removeAttribute("BottomBrand");
            }
        }

        private void moveBackStrip(KElement xjdf) {
            JDFHeadBandApplicationParams hap = (JDFHeadBandApplicationParams)xjdf;
            String mat = hap.getNonEmpty("StripMaterial");
            if (mat != null) {
                MiscConsumableMaker mm = new MiscConsumableMaker(ResourceHelper.getHelper(xjdf));
                mm.create("BackStrip", null);
                mm.setTypeDetails(mat);
                hap.removeAttribute("StripMaterial");
            }
        }
    }

    public class WalkIdentical
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (xjdf instanceof JDFIdentical) {
                KElement set;
                JDFIdentical id = (JDFIdentical)xjdf;
                KElement xjdfRes = xjdf.getDeepParent("Resource", 0);
                KElement kElement = set = xjdfRes == null ? null : xjdfRes.getDeepParent("ResourceSet", 0);
                if (set != null) {
                    SetHelper sh = new SetHelper(set);
                    JDFAttributeMap trgMap = id.getPartMap();
                    ResourceHelper targetHelper = sh.getPartition(trgMap);
                    if (targetHelper != null) {
                        targetHelper.appendPartMap(new ResourceHelper(xjdfRes).getPartMap());
                    }
                    xjdfRes.deleteNode();
                }
            }
            return null;
        }

        @Override
        public VString getElementNames() {
            return new VString("Identical", null);
        }
    }

    public class WalkProduct
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "Product".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.fixChildRefs(xjdf);
            return super.walk(xjdf, dummy);
        }

        private void fixChildRefs(KElement xjdf) {
            ProductHelper ph = new ProductHelper(xjdf);
            IntentHelper bind = ph.getIntent("BindingIntent");
            if (bind != null) {
                bind.getCreateResource().moveAttribute("ChildRefs", ph.getRoot());
            } else {
                IntentHelper insert = ph.getIntent("AssemblingIntent");
                if (insert != null) {
                    insert.getCreateResource().moveAttribute("ChildRefs", ph.getRoot());
                }
            }
        }

        @Override
        public VString getElementNames() {
            return new VString("Product", null);
        }
    }

    public class WalkProductList
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "ProductList".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement firstProduct = xjdf.getElement("Product");
            if (firstProduct == null) {
                xjdf.deleteNode();
                return null;
            }
            return super.walk(xjdf, dummy);
        }

        @Override
        public VString getElementNames() {
            return new VString("ProductList", null);
        }
    }

    protected class WalkXJDF
    extends WalkElement {
        @Override
        public VString getElementNames() {
            return new VString("XJDF", null);
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (!PostXJDFWalker.this.retainAll) {
                this.reorderSets((JDFElement)xjdf);
                this.reorderProductList(xjdf);
            }
            super.walk(xjdf, dummy);
            return xjdf;
        }

        protected void reorderProductList(KElement xjdf) {
            KElement productList = xjdf.getElement("ProductList");
            KElement auditPool = xjdf.getElement("AuditPool");
            if (productList != null && auditPool != null) {
                xjdf.moveElement(productList, auditPool);
            }
        }

        private void reorderSets(JDFElement xjdf) {
            Vector<SetHelper> v = new XJDFHelper(xjdf).getSets();
            if (v == null) {
                return;
            }
            int n = v.size();
            int j = 0;
            while (n > 0) {
                for (int i = 0; i < v.size(); ++i) {
                    KElement e;
                    SetHelper setHelper = v.get(i);
                    KElement kElement = e = setHelper == null ? null : setHelper.getSet();
                    if (e == null) continue;
                    JDFIntegerList lcpi = null;
                    String cpi = e.getAttribute("CombinedProcessIndex", null, null);
                    try {
                        lcpi = cpi == null ? null : new JDFIntegerList(cpi);
                    }
                    catch (DataFormatException dataFormatException) {
                        // empty catch block
                    }
                    if (lcpi == null || lcpi.contains(j)) {
                        v.set(i, null);
                        --n;
                        continue;
                    }
                    xjdf.moveElement(e, null);
                }
                ++j;
            }
            PostXJDFWalker.this.combineSameSets(xjdf);
        }
    }

    protected class WalkIntent
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "Intent".equals(toCheck.getLocalName());
        }

        @Override
        void updateAttributes(KElement xjdf) {
            xjdf.removeAttribute("Status");
            xjdf.removeAttribute("StatusDetails");
            xjdf.removeAttribute("ID");
            super.updateAttributes(xjdf);
        }
    }

    protected class WalkResourceSet
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.moveFromSet(xjdf);
            return super.walk(xjdf, dummy);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return "ResourceSet".equals(toCheck.getLocalName());
        }

        void moveFromSet(KElement xjdf) {
            for (String a : new String[]{"Orientation", "Transformation"}) {
                String val = xjdf.getNonEmpty(a);
                if (val == null) continue;
                xjdf.removeAttribute(a);
                VElement v = xjdf.getChildElementVector("Resource", null);
                for (KElement r : v) {
                    r.setAttribute(a, val);
                }
            }
        }
    }

    protected class WalkResource
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "Resource".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.moveToSet(xjdf);
            ResourceHelper rh = new ResourceHelper(xjdf);
            this.moveAmountToPool(rh);
            KElement ret = super.walk(xjdf, dummy);
            return ret;
        }

        private void moveAmountToPool(ResourceHelper rh) {
            KElement res = rh.getRoot();
            int amount = res.getIntAttribute("Amount", null, 0);
            res.removeAttribute("Amount");
            if (amount > 0 && rh.getAmountPool() == null) {
                rh.setAmount(amount, null, true);
            }
        }

        void moveToSet(KElement xjdf) {
            KElement set;
            KElement kElement = set = xjdf == null ? null : xjdf.getParentNode_KElement();
            if (set != null) {
                if (xjdf.hasNonEmpty("Unit")) {
                    set.moveAttribute("Unit", xjdf);
                }
                String desc = xjdf.getNonEmpty("DescriptiveName");
                String setdesc = set.getNonEmpty("DescriptiveName");
                if (setdesc != null && StringUtil.equals(desc, setdesc)) {
                    set.removeAttribute("DescriptiveName");
                }
            }
        }
    }

    protected class WalkResourceElement
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return ResourceHelper.isResourceElement(toCheck);
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement ret = super.walk(xjdf, dummy);
            this.moveToMisconsumable(xjdf);
            this.moveGeneralIDs(xjdf);
            return ret;
        }

        protected void moveGeneralIDs(KElement xjdf) {
            VElement v = xjdf.getChildElementVector("GeneralID", null);
            for (KElement e : v) {
                xjdf.getParentNode_KElement().moveElement(e, null);
            }
        }

        void moveToMisconsumable(KElement xjdf) {
        }
    }

    protected class WalkIntentSet
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "IntentSet".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = xjdf.getElement("Intent");
            if (!PostXJDFWalker.this.bIntentPartition && intent != null) {
                intent.copyAttribute("Name", xjdf);
                xjdf.getParentNode_KElement().moveElement(intent, xjdf);
                xjdf.deleteNode();
            } else {
                super.walk(xjdf, dummy);
            }
            return intent;
        }
    }

    public class WalkStation
    extends WalkElement {
        @Override
        public VString getElementNames() {
            return VString.getVString("Station", null);
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            int sa = ((JDFStation)xjdf).getStationAmount();
            KElement ret = super.walk(xjdf, dummy);
            for (int i = 1; i < sa; ++i) {
                ret.getParentNode_KElement().copyElement(ret, ret);
            }
            return ret;
        }

        @Override
        void updateAttributes(KElement xjdf) {
            xjdf.removeAttribute("StationAmount");
            super.updateAttributes(xjdf);
            xjdf.renameAttribute("BinderySignatureID", "BinderySignatureIDs");
        }
    }

    public class WalkDeliveryParamsSet
    extends WalkResourceSet {
        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && "DeliveryParams".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            SetHelper sh = SetHelper.getHelper(xjdf);
            List<ResourceHelper> partitionList = sh.getPartitionList();
            for (ResourceHelper rh : partitionList) {
                JDFDeliveryParams dp = (JDFDeliveryParams)rh.getResource();
                int i = 0;
                for (JDFDrop drop : dp.getAllDrop()) {
                    ResourceHelper rh2;
                    JDFDeliveryParams dp2;
                    Object dropid = drop.getDropID();
                    if (StringUtil.isEmpty((String)dropid)) {
                        dropid = "DROP_" + i++;
                    }
                    if ((dp2 = (JDFDeliveryParams)(rh2 = StringUtil.isEmpty((String)dropid) ? sh.getCreateExactPartition(null, false) : sh.getCreateExactPartition(new JDFAttributeMap("DropID", (String)dropid), false)).getResource()) == null) {
                        dp2 = (JDFDeliveryParams)rh2.getRoot().copyElement(dp, null);
                        dp2.setAttributes(drop);
                        dp2.removeChildren("Drop", null);
                    }
                    for (JDFDropItem dropitem : drop.getAllDropItem()) {
                        dropitem.renameAttribute("ProductRef", "ItemRef");
                        dropitem.renameAttribute("ComponentRef", "ItemRef");
                        if (!dropitem.hasNonEmpty("ItemRef")) {
                            XJDFHelper xh;
                            ProductHelper p;
                            String productRef = rh.getPartKey("Product");
                            if (productRef != null && (p = (xh = sh.getXJDF()).getProductByExternalID(productRef)) != null) {
                                productRef = p.ensureID();
                            }
                            dropitem.setAttribute("ItemRef", productRef);
                        }
                        if (!dropitem.hasNonEmpty("ItemRef")) continue;
                        dp2.moveElement(dropitem, null);
                    }
                }
                rh.deleteNode();
            }
            return super.walk(xjdf, dummy);
        }
    }

    public class WalkArtDeliveryIntentSet
    extends WalkIntentSet {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.retainAll && super.matches(toCheck) && "ArtDeliveryIntent".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = super.walk(xjdf, dummy);
            if (intent != null) {
                XJDFHelper h = new XJDFHelper(intent.getDeepParent("XJDF", 0));
                SetHelper artDelResHelper = h.getCreateSet("Resource", "DeliveryParams", JDFResourceLink.EnumUsage.Input);
                ResourceHelper ph = artDelResHelper.appendPartition(null, true);
                JDFDeliveryParams dp = (JDFDeliveryParams)ph.getResource();
                this.setFromArtDelivery(dp, (JDFArtDeliveryIntent)intent.getElement("ArtDeliveryIntent"));
                intent.deleteNode();
                return null;
            }
            return intent;
        }

        private void setFromArtDelivery(JDFDeliveryParams dp, JDFArtDeliveryIntent adi) {
            Vector<JDFArtDelivery> vAD;
            Vector<JDFArtDelivery> vector = vAD = adi == null ? null : adi.getChildrenByClass(JDFArtDelivery.class, false, 0);
            if (vAD != null) {
                for (JDFArtDelivery ad : vAD) {
                    dp.setMethod(StringUtil.getNonEmpty(ad.getArtDeliveryType()));
                    KElement dropItem = dp.appendElement("DropItem");
                    dropItem.copyAttribute("ItemRef", ad, "RunListRef", null, null);
                    dropItem.setAttribute("Amount", 1, (String)null);
                }
            }
        }
    }

    protected class WalkRunListSet
    extends WalkResourceSet {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.retainAll && toCheck.getLocalName().equals("ResourceSet") && "RunList".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.splitPages(xjdf);
            return super.walk(xjdf, dummy);
        }

        void splitPages(KElement xjdf) {
            SetHelper sh = SetHelper.getHelper(xjdf);
            if (sh.size() > 0) {
                int i = 0;
                for (ResourceHelper rh : sh.getPartitionList()) {
                    JDFRunList ruli = (JDFRunList)rh.getResource();
                    JDFIntegerList pages = ruli == null ? null : JDFIntegerList.createIntegerList(ruli.getNonEmpty("Pages"));
                    ResourceHelper rh2 = rh;
                    if (ruli == null || pages == null) continue;
                    int nPage = ruli.getNPage();
                    if (pages.size() <= 2) continue;
                    int nPage0 = 0;
                    for (int pos = 0; pos < pages.size(); pos += 2) {
                        rh2 = pos > 0 ? rh2.clonePartition() : rh;
                        VJDFAttributeMap vParts = rh2.getPartMapVector();
                        if (!VJDFAttributeMap.isEmpty(vParts)) {
                            vParts.put("Run", "SplitRun" + i++);
                            rh2.setPartMapVector(vParts);
                        } else {
                            rh2.setPartMap(new JDFAttributeMap("Run", "SplitRun" + i++));
                        }
                        JDFRunList ruli2 = (JDFRunList)rh2.getResource();
                        int pages0 = pages.getInt(pos);
                        int pages1 = pages.getInt(pos + 1);
                        ruli2.setAttribute("Pages", pages0 + " " + pages1);
                        if (ruli2.hasNonEmpty("LogicalPage") && nPage0 > 0) {
                            ruli2.addAttribute("LogicalPage", nPage0, (String)null);
                        } else if (pos > 0) {
                            ruli2.setAttribute("LogicalPage", null);
                        }
                        if (pages0 < 0) {
                            pages0 += nPage;
                        }
                        if (pages1 < 0) {
                            pages1 += nPage;
                        }
                        if (pages0 >= 0 && pages1 >= 0) {
                            nPage0 = 1 + Math.abs(pages0 - pages1);
                            ruli2.setAttribute("NPage", "" + nPage0);
                            continue;
                        }
                        ruli2.setAttribute("NPage", null);
                        nPage0 = 0;
                    }
                }
            }
        }
    }

    protected class WalkMediaSet
    extends WalkResourceSet {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.retainAll && toCheck.getLocalName().equals("ResourceSet") && "Media".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement parent = xjdf.getParentNode_KElement();
            if (this.isRemoveUsage(parent)) {
                xjdf.removeAttribute("Usage");
            }
            return super.walk(xjdf, dummy);
        }

        boolean isRemoveUsage(KElement parent) {
            boolean isXJDF = parent != null && "XJDF".equals(parent.getLocalName());
            VString types = PostXJDFWalker.this.newRootHelper.getTypes();
            isXJDF = isXJDF && ContainerUtil.containsAny(types, print);
            return isXJDF && !ContainerUtil.containsAny(types, noPrint);
        }
    }

    protected class WalkStrippingSet
    extends WalkResourceSet {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.retainAll && toCheck.getLocalName().equals("ResourceSet") && "StrippingParams".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (PostXJDFWalker.this.mergeLayout) {
                xjdf.deleteNode();
                return null;
            }
            return super.walk(xjdf, dummy);
        }
    }

    protected class WalkSurfaceColor
    extends WalkElement {
        @Override
        void updateAttributes(KElement xjdf) {
            xjdf.renameAttribute("ColorICCStandard", "PrintStandard");
            xjdf.renameAttribute("ColorStandard", "PrintStandard");
            super.updateAttributes(xjdf);
        }

        @Override
        public VString getElementNames() {
            return new VString("SurfaceColor", null);
        }
    }

    protected class WalkStripCellParams
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStripCellParams;
        }

        @Override
        public KElement walk(KElement stripCellParams, KElement dummy) {
            if (!PostXJDFWalker.this.mergeLayout) {
                super.walk(stripCellParams, dummy);
                return stripCellParams;
            }
            stripCellParams.renameElement("SignatureCell", null);
            super.walk(stripCellParams, dummy);
            return stripCellParams;
        }

        @Override
        void updateAttributes(KElement xjdf) {
            xjdf.renameAttribute("Spine", "TrimSpine");
            super.updateAttributes(xjdf);
        }

        @Override
        public VString getElementNames() {
            return new VString("StripCellParams", null);
        }
    }

    protected class WalkMediaIntent
    extends WalkIntent {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.retainAll && toCheck instanceof JDFMediaIntent;
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("MediaIntent", null);
        }

        @Override
        void updateAttributes(KElement xjdf) {
            String coating = xjdf.getNonEmpty("FrontCoatings");
            if (xjdf != null) {
                xjdf.removeAttribute("FrontCoatings");
                xjdf.setAttribute("Coating", this.getCoating(coating));
            }
            super.updateAttributes(xjdf);
        }
    }

    public class WalkModuleInfo
    extends WalkElement {
        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement parent = xjdf.getParentNode_KElement();
            if (parent instanceof JDFJobPhase) {
                this.moveToDeviceInfo((JDFJobPhase)parent, (JDFModuleInfo)xjdf);
            }
            return super.walk(xjdf, dummy);
        }

        void moveToDeviceInfo(JDFJobPhase jp, JDFModuleInfo moduleInfo) {
            String id;
            JDFDeviceInfo di = (JDFDeviceInfo)jp.getParentNode_KElement();
            JDFModuleInfo existing = di.getModuleInfo(id = moduleInfo.getModuleID());
            if (existing == null) {
                di.moveElement(moduleInfo, null);
            } else {
                moduleInfo.deleteNode();
            }
            jp.appendAttribute("ModuleIDs", id, true);
        }

        @Override
        public VString getElementNames() {
            return new VString(new String[]{"ModuleInfo"});
        }
    }

    public class WalkPlacedObject
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFContentObject || toCheck instanceof JDFMarkObject;
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.copyToPlaceObject(xjdf);
            return super.walk(xjdf, dummy);
        }

        KElement copyToPlaceObject(KElement xjdf) {
            KElement po = xjdf.getParentNode_KElement().insertBefore("PlacedObject", xjdf, null);
            StringArray poAttribs = JDFToXJDFDataCache.getPlacedObjectAttribs();
            for (String att : poAttribs) {
                po.moveAttribute(att, xjdf);
            }
            this.moveToStripMark(xjdf);
            po.moveElement(xjdf, null);
            return po;
        }

        void moveToStripMark(KElement xjdf) {
            for (KElement child : xjdf.getChildList()) {
                KElement layout;
                if (!JDFToXJDFDataCache.getStripMarkElements().contains(child.getLocalName()) || (layout = xjdf.getDeepParent("Layout", 0)) == null) continue;
                KElement sm = layout.appendElement("StripMark");
                sm.moveElement(child, null);
            }
        }

        @Override
        public VString getElementNames() {
            return new VString(new String[]{"ContentObject", "MarkObject"});
        }
    }

    protected class WalkPartAmount
    extends WalkElement {
        @Override
        public KElement walk(KElement pa, KElement dummy) {
            JDFPartAmount partAmount = (JDFPartAmount)pa;
            if (!PostXJDFWalker.this.retainAll) {
                this.moveToResource(partAmount);
                this.removeRedundantPartKeys(partAmount);
            }
            return super.walk(partAmount, dummy);
        }

        void moveToResource(JDFPartAmount partAmount) {
            if (partAmount.hasNonEmpty("Transformation") || partAmount.hasNonEmpty("Orientation")) {
                KElement parentRes = partAmount.getDeepParent("Resource", 0);
                List<JDFPartAmount> vPA = partAmount.getParentNode_KElement().getChildArrayByClass(JDFPartAmount.class, false, 0);
                for (int i = 1; i < vPA.size(); ++i) {
                    KElement parentResClone = parentRes.getParentNode_KElement().copyElement(parentRes, parentRes.getNextSiblingElement());
                    KElement ap = parentResClone.getElement("AmountPool");
                    ap.removeChildrenByClass(JDFPartAmount.class);
                    JDFPartAmount paClone = (JDFPartAmount)ap.moveElement(partAmount, null);
                    this.moveToResource(paClone);
                }
                parentRes.moveAttribute("Transformation", partAmount);
                parentRes.moveAttribute("Orientation", partAmount);
                ResourceHelper resourceHelper = new ResourceHelper(parentRes);
                VJDFAttributeMap map = resourceHelper.getPartMapVector();
                VJDFAttributeMap partMap = partAmount.getPartMapVector();
                VJDFAttributeMap combined = map.getOrMaps(partMap);
                resourceHelper.setPartMapVector(combined);
                partAmount.setPartMap(null);
            }
        }

        void removeRedundantPartKeys(JDFPartAmount partAmount) {
            VElement parentParts = this.getParentParts(partAmount);
            if (parentParts != null) {
                VString keys = new VString();
                for (KElement e : parentParts) {
                    JDFPart p = (JDFPart)e;
                    JDFAttributeMap partMap = p.getPartMap();
                    Set nextKeys = partMap.keySet();
                    ContainerUtil.appendUnique(keys, nextKeys);
                }
                VJDFAttributeMap vPA = partAmount.getPartMapVector();
                if (vPA == null) {
                    vPA = new VJDFAttributeMap();
                }
                if (vPA != null && keys != null && keys.size() > 0) {
                    vPA.removeKeys(keys);
                }
                if (vPA.isEmpty()) {
                    vPA = null;
                }
                partAmount.setPartMapVector(vPA);
                VElement v = partAmount.getParts();
                for (KElement e : v) {
                    this.updateNamespaces(e);
                }
            }
        }

        private VElement getParentParts(KElement part) {
            return part.getXPathElementVector("../../Part", 0);
        }

        @Override
        public VString getElementNames() {
            return VString.getVString("PartAmount", null);
        }
    }

    protected class WalkPart
    extends WalkElement {
        @Override
        public VString getElementNames() {
            return VString.getVString("Part", null);
        }

        @Override
        void updateAttributes(KElement part) {
            int[] ia;
            JDFIntegerRangeList pnr;
            JDFIntegerList pns;
            if (PostXJDFWalker.this.retainAll) {
                return;
            }
            if (PostXJDFWalker.this.isRemoveSignatureName()) {
                part.removeAttribute("SignatureName");
            }
            this.ensureNmtoken(part, "SheetName");
            part.renameAttribute("BinderySignatureName", "BinderySignatureID");
            part.removeAttribute("BinderySignaturePaginationIndex");
            part.removeAttribute("BundleItemIndex");
            part.removeAttribute("CellIndex");
            part.removeAttribute("Condition");
            part.removeAttribute("DocCopies");
            part.renameAttribute("DocRunIndex", "RunIndex");
            part.renameAttribute("DocSheetIndex", "SheetIndex");
            part.removeAttribute("DeliveryUnit0");
            part.removeAttribute("DeliveryUnit1");
            part.removeAttribute("DeliveryUnit2");
            part.removeAttribute("DeliveryUnit3");
            part.removeAttribute("DeliveryUnit4");
            part.removeAttribute("DeliveryUnit5");
            part.removeAttribute("DeliveryUnit6");
            part.removeAttribute("DeliveryUnit7");
            part.removeAttribute("DeliveryUnit8");
            part.removeAttribute("DeliveryUnit9");
            part.removeAttribute("DocTags");
            part.removeAttribute("Edition");
            part.removeAttribute("EditionVersion");
            part.removeAttribute("FountainNumber");
            part.removeAttribute("ItemNames");
            part.removeAttribute("LayerIDs");
            part.renameAttribute("Metadata0", "Metadata");
            part.removeAttribute("Metadata1");
            part.removeAttribute("Metadata2");
            part.removeAttribute("Metadata3");
            part.removeAttribute("Metadata4");
            part.removeAttribute("Metadata5");
            part.removeAttribute("Metadata6");
            part.removeAttribute("Metadata7");
            part.removeAttribute("Metadata8");
            part.removeAttribute("Metadata9");
            part.removeAttribute("PageTags");
            part.removeAttribute("PlateLayout");
            part.removeAttribute("PreflightRule");
            part.renameAttribute("RunPage", "PageNumber");
            part.renameAttribute("RunPageRange", "PageNumber");
            String pn = part.getNonEmpty("PageNumber");
            if (pn != null && (pns = JDFIntegerList.createIntegerList(pn)) != null && (pnr = new JDFIntegerRangeList(ia = pns.getIntArray())).size() == 1) {
                JDFIntegerRange r = (JDFIntegerRange)pnr.elementAt(0);
                part.setAttribute("PageNumber", r.getXJDFString(0));
            }
            part.removeAttribute("RunSet");
            part.removeAttribute("RunTags");
            part.removeAttribute("SectionIndex");
            part.removeAttribute("SetCopies");
            part.renameAttribute("SetDocIndex", "DocIndex");
            part.renameAttribute("SetRunIndex", "RunIndex");
            part.renameAttribute("SetSheetIndex", "SheetIndex");
            part.removeAttribute("SubRun");
            part.renameAttribute("WebProduct", "Product");
            part.removeAttribute("WebSetup");
            String name = part.getNonEmpty("TransferCurveName");
            if ("Paper".equals(name)) {
                part.setAttribute("TransferCurveName", "Substrate");
            }
            super.updateAttributes(part);
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement walk = super.walk(xjdf, dummy);
            if (!PostXJDFWalker.this.retainAll) {
                this.splitPartVersion(xjdf, walk);
                this.splitIndex(xjdf, walk, "DocIndex");
                this.splitIndex(xjdf, walk, "RunIndex");
                this.splitIndex(xjdf, walk, "SetIndex");
                this.splitIndex(xjdf, walk, "SheetIndex");
            }
            return walk;
        }

        void splitPartVersion(KElement xjdf, KElement walk) {
            int size;
            VString pv = StringUtil.tokenize(walk.getAttribute("PartVersion"), null, false);
            KElement parent = xjdf.getParentNode_KElement();
            int n = size = parent == null ? 0 : ContainerUtil.size(pv);
            if (size > 1) {
                pv.unify();
                size = pv.size();
                for (int i = size - 1; i > 0; --i) {
                    KElement clone = parent.copyElement(xjdf, xjdf);
                    clone.setAttribute("PartVersion", pv.remove(0));
                }
                xjdf.setAttribute("PartVersion", pv.remove(0));
            }
        }

        void splitIndex(KElement xjdf, KElement walk, String attribute) {
            int size;
            VString indexes = StringUtil.tokenize(walk.getAttribute(attribute), null, false);
            KElement parent = xjdf.getParentNode_KElement();
            int n = size = parent == null ? 0 : ContainerUtil.size(indexes);
            if (size > 2) {
                for (int i = size - 2; i > 0; i -= 2) {
                    String single = indexes.remove(0) + " " + indexes.remove(0);
                    KElement clone = parent.copyElement(xjdf, xjdf);
                    clone.setAttribute(attribute, single);
                }
                String single = indexes.remove(0) + " " + indexes.remove(0);
                xjdf.setAttribute(attribute, single);
            }
        }
    }

    protected class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(PostXJDFWalker.this.getFactory());
        }

        public String getCoating(String coating) {
            if (coating == null) {
                return null;
            }
            if ("glossy".equalsIgnoreCase(coating)) {
                return "Gloss";
            }
            return coating;
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.updateNamespaces(xjdf);
            if (!PostXJDFWalker.this.retainAll) {
                this.updateAttributes(xjdf);
            }
            return xjdf;
        }

        protected void ensureNmtoken(KElement e, String name) {
            String token = e.getNonEmpty(name);
            String newToken = StringUtil.replaceChar(token, ' ', "_", 0);
            e.setAttribute(name, newToken);
        }

        void updateAttributes(KElement xjdf) {
        }

        void updateNamespaces(KElement xjdf) {
            if (xjdf.hasAttribute("xmlns")) {
                xjdf.removeAttribute("xmlns");
            }
            if (xjdf.getNamespaceURI().equals(JDFElement.getSchemaURL())) {
                xjdf.setNamespaceURI(JDFElement.getSchemaURL(PostXJDFWalker.this.newVersion));
            }
        }
    }
}

