/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.io.File;
import java.io.InputStream;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoFileSpec;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.resource.process.JDFContainer;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.mime.MimeReader;
import org.w3c.dom.DOMException;

public class JDFFileSpec
extends JDFAutoFileSpec
implements IURLSetter {
    private static final long serialVersionUID = 1L;

    public JDFFileSpec(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFFileSpec(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFFileSpec(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFFileSpec[  --> " + super.toString() + " ]";
    }

    public void setAbsoluteFileURL(File f, boolean bEscape128) {
        String s = UrlUtil.fileToUrl(f, bEscape128);
        this.setMimeURL(s);
    }

    public void setRelativeURL(File f, File baseDir, boolean bEscape128) {
        String s = UrlUtil.getRelativeURL(f, baseDir, bEscape128);
        this.setMimeURL(s);
    }

    @Override
    public InputStream getURLInputStream() {
        return this.getURLInputStream(this.getURL());
    }

    public void setMimeURL(String url) {
        this.setURL(url);
        String mimeTypeFromURL = UrlUtil.getMimeTypeFromURL(url);
        if (!"text/unknown".equals(mimeTypeFromURL)) {
            this.setMimeType(mimeTypeFromURL);
        }
    }

    @Deprecated
    public File moveToDir(File dir) {
        return UrlUtil.moveToDir(this, dir, true);
    }

    public String getFileName() {
        String filename = this.getUserFileName();
        if (!StringUtil.isEmpty(filename)) {
            return filename;
        }
        String url = this.getURL();
        if (StringUtil.isEmpty(url)) {
            return null;
        }
        return new MimeReader(this.getOwnerDocument_KElement().getMultiPart()).getFileName(url);
    }

    @Deprecated
    public static String getMimeTypeFromURL(String url) {
        return UrlUtil.getMimeTypeFromURL(url);
    }

    public JDFFileSpec setContainer(String containerUrl, String mimeType) {
        JDFContainer c = this.getCreateContainer();
        JDFFileSpec fs = c.getCreateFileSpec();
        fs.setURL(containerUrl);
        fs.setMimeType(mimeType);
        return fs;
    }

    public void setFileSize(long value) {
        this.setAttribute("FileSize", value, (String)null);
    }

    public long getFileSizeLong() {
        return this.getLongAttribute("FileSize", null, -1L);
    }

    public void setCheckSum(byte[] value) {
        super.setCheckSum(StringUtil.setHexBinaryBytes(value, -1));
    }

    public byte[] getCheckSumBytes() {
        return StringUtil.getHexBinaryBytes(this.getCheckSum().getBytes());
    }

    public void setResourceUsage(EnumResourceUsage usage) {
        super.setResourceUsage(usage == null ? null : usage.name());
    }

    public EnumResourceUsage getResourceUsageEnum() {
        return EnumResourceUsage.getEnum(this.getResourceUsage());
    }

    public static enum EnumResourceUsage {
        Accepted,
        AbstractProfile,
        AddressList,
        ActualOutputProfile,
        CIP3,
        ColorProfile,
        Combined,
        CorrectionProfile,
        CurrentSchema,
        DataList,
        DeliveryContents,
        DeviceLinkProfile,
        ExternalImpositionTemplate,
        FinalTargetDevice,
        Font,
        Image,
        MailingList,
        OutputProfile,
        PDL,
        PDLSourceProfile,
        Preview,
        RasterFileLocation,
        ReferenceOutputProfile,
        Rejected,
        RemoteURL,
        ScanProfile,
        Schema,
        SearchPath,
        Setup,
        SourceProfile,
        TargetProfile,
        Unknown,
        Verification,
        WorkingColorSpace;


        public static EnumResourceUsage getEnum(String val) {
            return EnumUtil.getJavaEnumIgnoreCase(EnumResourceUsage.class, val);
        }
    }
}

