/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.auto.JDFAutoGeneralID;
import org.cip4.jdflib.auto.JDFAutoQueueEntry;
import org.cip4.jdflib.core.AtrInfo;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.DocumentXMLImpl;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDocUserData;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFAttributeMapArray;
import org.cip4.jdflib.datatypes.JDFNameRange;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.FixVersion;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.node.JDFAncestor;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.resource.process.JDFPreview;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.ListMap;
import org.cip4.jdflib.util.MyPair;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.URLReader;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.VectorMap;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JDFElement
extends KElement {
    private MyPair<AttributeInfo, ElementInfo> infotables = null;
    private static final long serialVersionUID = 1L;
    private static final Log jLog = LogFactory.getLog(JDFElement.class);
    private static EnumVersion defaultVersion = EnumVersion.Version_1_8;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[7];
    private static ElemInfoTable[] elemInfoTable;
    private static DocumentJDFImpl m_dummyDocumentJDFImpl;

    public static void setLongID(boolean bLong) {
        KElement.setLongID(bLong);
    }

    public static JDFElement createRoot(String nodename) {
        return (JDFElement)new JDFDoc(nodename).getRoot();
    }

    public static JDFElement createRoot(String nodename, EnumVersion v) {
        return (JDFElement)new JDFDoc(nodename, v).getRoot();
    }

    protected AttributeInfo getTheAttributeInfo() {
        return this.getTheAttributeInfo_JDFElement();
    }

    public final AttributeInfo getAttributeInfo() {
        if (this.infotables == null) {
            this.infotables = new MyPair<AttributeInfo, ElementInfo>(this.getTheAttributeInfo(), this.getTheElementInfo());
        }
        return (AttributeInfo)this.infotables.a;
    }

    public AttributeInfo.EnumAttributeType getAtrType(String attributeName) {
        AttributeInfo ai = this.getAttributeInfo();
        return ai.getAttributeType(attributeName);
    }

    public EnumVersion getFirstVersion(String eaName, boolean bElement) {
        EnumVersion v = null;
        if (bElement) {
            ElementInfo ei = this.getElementInfo();
            v = ei.getFirstVersion(eaName);
        } else {
            AttributeInfo ai = this.getAttributeInfo();
            v = ai.getFirstVersion(eaName);
        }
        if (v == null) {
            v = EnumVersion.Version_1_0;
        }
        return v;
    }

    @Override
    public boolean isDirty() {
        XMLDocUserData usrDat = this.getXMLDocUserData();
        if (usrDat != null) {
            return usrDat.isDirty(this);
        }
        return false;
    }

    public boolean isDeprecated() {
        KElement parent = this.getParentNode_KElement();
        if (parent instanceof JDFElement) {
            VString v = ((JDFElement)parent).getElementInfo().deprecatedElements();
            return v != null && v.contains(this.getLocalName());
        }
        return false;
    }

    @Override
    public void setDirty(boolean bAttribute) {
        XMLDocUserData usrDat;
        if (!((DocumentXMLImpl)this.ownerDocument).bGlobalDirtyPolicy && (usrDat = this.getXMLDocUserData()) != null) {
            usrDat.setDirty(this, bAttribute);
        }
    }

    public XMLDocUserData getXMLDocUserData() {
        return this.ownerDocument == null ? null : ((DocumentJDFImpl)this.ownerDocument).getMyUserData();
    }

    public EnumVersion getLastVersion(String eaName, boolean bElement) {
        EnumVersion v = null;
        if (bElement) {
            ElementInfo ei = this.getElementInfo();
            v = ei.getLastVersion(eaName);
        } else {
            AttributeInfo ai = this.getAttributeInfo();
            v = ai.getLastVersion(eaName);
        }
        return v;
    }

    public VString requiredAttributes() {
        return this.getAttributeInfo().requiredAttribs();
    }

    public VString optionalAttributes() {
        return this.getAttributeInfo().optionalAttribs();
    }

    public JDFAttributeMap getDefaultAttributeMap() {
        return this.getAttributeInfo().getDefaultAttributeMap();
    }

    protected AttributeInfo getTheAttributeInfo_JDFElement() {
        AttributeInfo ai = new AttributeInfo(atrInfoTable);
        ai.setVersion(this.getAIVersion());
        return ai;
    }

    private EnumVersion getAIVersion() {
        Document d = this.getOwnerDocument();
        Element e = d.getDocumentElement();
        String s = e.getAttribute("Version");
        EnumVersion v = EnumVersion.getEnum(s);
        return v == null ? JDFElement.getDefaultJDFVersion() : v;
    }

    protected ElementInfo getTheElementInfo_JDFElement() {
        ElementInfo ei = new ElementInfo(null, elemInfoTable);
        ei.setVersion(this.getAIVersion());
        return ei;
    }

    public VString deprecatedAttributes() {
        return this.getAttributeInfo().deprecatedAttribs();
    }

    public VString prereleaseAttributes() {
        return this.getAttributeInfo().prereleaseAttribs();
    }

    public VString knownAttributes() {
        return this.getAttributeInfo().knownAttribs();
    }

    public VString getMissingAttributeVector(VString vReqKeys, int nMax) {
        VString vMissing = new VString();
        if (vReqKeys == null || vReqKeys.isEmpty()) {
            return vMissing;
        }
        VString vAtts = this.getAttributeVector();
        Object prefix = this.getPrefix();
        prefix = prefix != null && !((String)prefix).equals("") ? (String)prefix + ":" : "";
        for (int i = 0; i < vReqKeys.size() && vMissing.size() < nMax; ++i) {
            String req = vReqKeys.get(i);
            if (vAtts.contains((String)prefix + req) || vAtts.contains(req) || req.equals("xmlns") && super.getNamespaceURI() != null) continue;
            vMissing.addElement((String)prefix + req);
        }
        return vMissing;
    }

    private VString getMatchingAttributeVector(VString vReqKeys, int nMax) {
        VString vAtts = this.getAttributeVector();
        VString vMatching = new VString();
        Object prefix = this.getPrefix();
        prefix = prefix != null && !((String)prefix).equals("") ? (String)prefix + ":" : "";
        for (int i = 0; i < vReqKeys.size() && vMatching.size() < nMax; ++i) {
            String req = vReqKeys.elementAt(i);
            if (!vAtts.contains((String)prefix + req) && !vAtts.contains(req)) continue;
            vMatching.addElement((String)prefix + req);
        }
        return vMatching;
    }

    protected ElementInfo getTheElementInfo() {
        return this.getTheElementInfo_JDFElement();
    }

    public final ElementInfo getElementInfo() {
        if (this.infotables == null) {
            this.infotables = new MyPair<AttributeInfo, ElementInfo>(this.getTheAttributeInfo(), this.getTheElementInfo());
        }
        return (ElementInfo)this.infotables.b;
    }

    public VString getMissingElements(int nMax) {
        VString v = this.getElementInfo().requiredElements();
        return this.getMissingElementVector(v, nMax);
    }

    public VString requiredElements() {
        return this.getElementInfo().requiredElements();
    }

    public VString optionalElements() {
        return this.getElementInfo().optionalElements();
    }

    public VString uniqueElements() {
        return this.getElementInfo().uniqueElements();
    }

    public String prereleaseElements() {
        VString v = this.getElementInfo().prereleaseElements();
        return StringUtil.setvString(v, ",", null, null);
    }

    public VString getPrereleaseElements(int nMax) {
        VString v = this.getElementInfo().prereleaseElements();
        return this.getMatchingElementVector(v, nMax);
    }

    public VString getDeprecatedElements(int nMax) {
        VString v = this.getElementInfo().deprecatedElements();
        return this.getMatchingElementVector(v, nMax);
    }

    public VString knownElements() {
        VString s = this.requiredElements();
        if (s.size() == 0) {
            return this.optionalElements();
        }
        s.appendUnique(this.optionalElements());
        return s;
    }

    private VString getMatchingElementVector(VString vReqKeys, int nMax) {
        VString vAtts = this.getElementNameVector();
        VString vReturn = new VString();
        for (int i = 0; i < vReqKeys.size() && vReturn.size() < nMax; ++i) {
            if (!vAtts.contains(vReqKeys.elementAt(i))) continue;
            vReturn.addElement(vReqKeys.elementAt(i));
        }
        return vReturn;
    }

    public VString getMissingAttributes(int nMax) {
        VString v = this.getAttributeInfo().requiredAttribs();
        return this.getMissingAttributeVector(v, nMax);
    }

    public VString getDeprecatedAttributes(int nMax) {
        VString v = this.deprecatedAttributes();
        return this.getMatchingAttributeVector(v, nMax);
    }

    public VString getUnknownAttributes(boolean bIgnorePrivate, int nMax) {
        VString vKnownAttribs = this.knownAttributes();
        VString v = bIgnorePrivate ? new VString(StringUtil.tokenize(" :JDF", ":", false)) : new VString();
        return this.getUnknownAttributeVector(vKnownAttribs, v, nMax);
    }

    public VString getUnknownAttributeVector(VString vKnownKeys, VString vInNameSpace, int nMax) {
        if (nMax < 0) {
            nMax = Integer.MAX_VALUE;
        }
        List<String> vAtts = this.getAttributeArray_KElement();
        VString vUnknown = new VString();
        if (vKnownKeys.contains("*")) {
            return vUnknown;
        }
        boolean bAllNS = vInNameSpace.isEmpty();
        if (!bAllNS) {
            for (int j = 0; j < vInNameSpace.size(); ++j) {
                if (!vInNameSpace.elementAt(j).equals(" ")) continue;
                vInNameSpace.setElementAt("", j);
            }
        }
        if (vUnknown.size() < nMax) {
            for (String strAtts : vAtts) {
                String ns = KElement.xmlnsPrefix(strAtts);
                if ("xsi".equals(ns) || "xmlns".equals(ns) || !bAllNS && ns != null && !vInNameSpace.contains(ns) || vKnownKeys.contains(strAtts)) continue;
                vUnknown.addElement(strAtts);
                if (vUnknown.size() < nMax) continue;
                break;
            }
        }
        return vUnknown;
    }

    public VString getUnknownElements(boolean bIgnorePrivate, int nMax) {
        VString v1 = this.knownElements();
        VString v2 = StringUtil.tokenize(" :JDF", ":", false);
        return this.getUnknownElementVector(v1, bIgnorePrivate ? v2 : new VString(), nMax);
    }

    public VString getUnknownElementVector(VString vKnownKeys, VString vInNameSpace, int nMax) {
        for (int j = 0; j < vInNameSpace.size(); ++j) {
            if (!vInNameSpace.elementAt(j).equals(" ")) continue;
            vInNameSpace.setElementAt("", j);
        }
        VString vAtts = this.getElementNameVector();
        VString vUnknown = new VString();
        if (vAtts.size() > 0) {
            int i = 0;
            boolean bAllNS = vInNameSpace.isEmpty();
            do {
                String attr;
                String ns;
                if ((ns = KElement.xmlnsPrefix(attr = vAtts.elementAt(i))) == null) {
                    ns = "";
                }
                if (!bAllNS && !vInNameSpace.contains(ns) || vKnownKeys.contains(attr)) continue;
                vUnknown.addElement(attr);
            } while (vUnknown.size() < nMax && ++i < vAtts.size());
        }
        return vUnknown;
    }

    public ValuedEnum getTypeForAttribute(String key) {
        return this.getAttributeInfo().getAttributeType(key);
    }

    public boolean validAttribute(String key, String nameSpaceURI, EnumValidationLevel level) {
        return this.getAttributeInfo().validAttribute(key, this.getAttribute(key, nameSpaceURI, null), level);
    }

    public ValuedEnum getEnumforAttribute(String key) {
        return this.getAttributeInfo().getAttributeEnum(key);
    }

    public void eraseDefaultAttributes(boolean bRecurse) {
        NamedNodeMap nm;
        JDFAttributeMap aMap = this.getDefaultAttributeMap();
        if (aMap != null && (nm = this.getAttributes()) != null) {
            int siz = nm.getLength();
            for (int i = siz - 1; i >= 0; --i) {
                Node item = nm.item(i);
                String attVal = item.getNodeName();
                if (!aMap.containsKey(attVal) || !item.getNodeValue().equals(aMap.get(attVal))) continue;
                this.removeAttribute(attVal);
            }
        }
        if (bRecurse) {
            for (KElement e = this.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
                if (!(e instanceof JDFElement)) continue;
                ((JDFElement)e).eraseDefaultAttributes(true);
            }
        }
    }

    public boolean hasMissingAttributes() {
        return this.getMissingAttributes(1).size() > 0;
    }

    public boolean hasUnknownAttributes(boolean bIgnorePrivate) {
        return this.getUnknownAttributes(bIgnorePrivate, 1).size() > 0;
    }

    public boolean hasMissingElements() {
        return this.getMissingElements(1).size() > 0;
    }

    public boolean hasUnknownElements(boolean bIgnorePrivate) {
        return this.getUnknownElements(bIgnorePrivate, 1).size() > 0;
    }

    public VString getPrereleaseAttributes(int nMax) {
        VString v = this.getMatchingAttributeVector(this.prereleaseAttributes(), nMax);
        AttributeInfo ai = null;
        if (!v.isEmpty()) {
            ai = this.getAttributeInfo();
        }
        for (int i = v.size() - 1; i >= 0; --i) {
            String key = v.get(i);
            if (ai == null || !this.getAttribute(key).equals(ai.getAttributeDefault(key))) continue;
            v.remove(i);
        }
        return v;
    }

    public VString getInsertElements() {
        VString vKnownElements = this.knownElements();
        VString vUniqueElements = this.uniqueElements();
        VString vStrRet = this.getInsertElementVector(vKnownElements, vUniqueElements);
        return vStrRet;
    }

    public VString getInsertElementVector(VString vKnownKeys, VString vUnique) {
        VString vAtts = new VString(this.getElementNameVector());
        VString vInsert = vKnownKeys;
        for (int i = 0; i < vAtts.size(); ++i) {
            if (!vUnique.contains(vAtts.elementAt(i))) continue;
            vInsert.removeElement(vAtts.elementAt(i));
        }
        return vInsert;
    }

    public AttributeInfo.EnumAttributeType attributeType(String attributeName) {
        return this.getAttributeInfo().getAttributeType(attributeName);
    }

    public VString getNamesVector(String key) {
        ValuedEnum enu = this.getEnumforAttribute(key);
        if (enu != null) {
            return EnumUtil.getNamesVector(enu.getClass());
        }
        return null;
    }

    private boolean checkInstance(VString vElements, String requiredKey) {
        if (m_dummyDocumentJDFImpl == null) {
            m_dummyDocumentJDFImpl = new DocumentJDFImpl();
        }
        Class<?> requiredClass = m_dummyDocumentJDFImpl.getFactoryClass(requiredKey);
        Class<?> elementClass = null;
        Iterator elemIter = vElements.iterator();
        while (elemIter.hasNext() && !requiredClass.equals(elementClass)) {
            String elemName = (String)elemIter.next();
            elementClass = m_dummyDocumentJDFImpl.getFactoryClass(elemName);
        }
        return requiredClass.equals(elementClass);
    }

    public VString getMissingElementVector(VString vRequiredKeys, int nMax) {
        VString vMissing = new VString();
        if (vRequiredKeys == null || vRequiredKeys.isEmpty()) {
            return vMissing;
        }
        VString vElements = this.getElementNameVector();
        for (int i = 0; i < vRequiredKeys.size() && vMissing.size() < nMax; ++i) {
            String requiredKey = vRequiredKeys.elementAt(i);
            if (vElements.contains(requiredKey) || this.checkInstance(vElements, requiredKey)) continue;
            vMissing.add(requiredKey);
        }
        return vMissing;
    }

    public JDFElement(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, null, qualifiedName);
    }

    public JDFElement(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFElement(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public boolean isValid(EnumValidationLevel level) {
        return this.isValid_JDFElement(level);
    }

    public boolean isValid_JDFElement(EnumValidationLevel level) {
        Class<?> class1 = this.getClass();
        if (class1 == JDFElement.class || class1 == JDFResource.class) {
            return true;
        }
        try {
            VString invalidAttributes = this.getInvalidAttributes(level, true, 0);
            if (!invalidAttributes.isEmpty()) {
                jLog.info((Object)("Invalid attributes " + invalidAttributes));
                return false;
            }
            VString invalidElements = this.getInvalidElements(level, true, 1);
            if (invalidElements.size() > 0) {
                return false;
            }
            if (EnumValidationLevel.isRecursive(level)) {
                EnumValidationLevel valDown = level == EnumValidationLevel.RecursiveIncomplete ? EnumValidationLevel.Incomplete : EnumValidationLevel.Complete;
                VElement v = this.getChildElementVector(null, null, null, true, 0, false);
                for (KElement e : v) {
                    JDFResource res;
                    if (!(e instanceof JDFRefElement) || (res = ((JDFRefElement)e).getTarget()).isValid(valDown)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (JDFException x) {
            return false;
        }
    }

    public final boolean fixVersion(EnumVersion version) {
        FixVersion fixVersion = new FixVersion(version);
        fixVersion.walkTree(this, null);
        return fixVersion.isOK();
    }

    @Deprecated
    public boolean hasSettingsPolicy(boolean bInherit) {
        return this.hasAttribute("SettingsPolicy", null, bInherit);
    }

    @Deprecated
    public void removeSettingsPolicy() {
        this.removeAttribute("SettingsPolicy", null);
    }

    @Deprecated
    public void removeBestEffortExceptions() {
        this.removeAttribute("BestEffortExceptions", null);
    }

    @Deprecated
    public String getHRef() {
        return this.getAttribute("rRef", null, "");
    }

    public JDFElement appendHRef(JDFResource target, String refAttribute, String preSet) {
        if (target == null) {
            return null;
        }
        String idRef = target.getID();
        if (idRef == null || idRef.equals("")) {
            target.appendAnchor(preSet);
            idRef = target.getID();
        }
        return this.appendHRef(idRef, refAttribute, null);
    }

    public JDFElement appendHRef(String idRef, String refAttribute, String nameSpaceURI) {
        String refAttributeLocal = refAttribute;
        if (idRef == null || idRef.length() < 1) {
            return null;
        }
        if (refAttributeLocal == null || refAttributeLocal.equals("")) {
            refAttributeLocal = "rRef";
        }
        this.setAttribute(refAttributeLocal, idRef, nameSpaceURI);
        return this;
    }

    public void setAttribute(String key, JDFDuration value, String nameSpaceURI) {
        if (value == null) {
            this.removeAttribute(key, nameSpaceURI);
        } else {
            super.setAttribute(key, value.getDurationISO(), nameSpaceURI);
        }
    }

    public void setAttribute(String key, JDFNumList value, String nameSpaceURI) {
        if (value == null) {
            this.removeAttribute(key, nameSpaceURI);
        } else {
            super.setAttribute(key, value.toString(), nameSpaceURI);
        }
    }

    public void setAttribute(String key, JDFNumList value, String nameSpaceURI, int precision) {
        if (value == null) {
            this.removeAttribute(key, nameSpaceURI);
        } else {
            super.setAttribute(key, value.getString(precision), nameSpaceURI);
        }
    }

    public void setAttribute(String key, JDFRangeList value, String nameSpaceURI) {
        if (value == null) {
            this.removeAttribute(key, nameSpaceURI);
        } else {
            super.setAttribute(key, value.toString(), nameSpaceURI);
        }
    }

    public void setAttribute(String key, JDFRangeList value, String nameSpaceURI, int precision) {
        if (value == null) {
            this.removeAttribute(key, nameSpaceURI);
        } else {
            super.setAttribute(key, value.getString(precision), nameSpaceURI);
        }
    }

    public void setAttribute(String key, JDFRange value, String nameSpaceURI) {
        if (value == null) {
            this.removeAttribute(key, nameSpaceURI);
        } else {
            super.setAttribute(key, value.toString(), nameSpaceURI);
        }
    }

    public void setAttribute(String key, JDFRange value, String nameSpaceURI, int precision) {
        if (value == null) {
            this.removeAttribute(key, nameSpaceURI);
        } else {
            super.setAttribute(key, value.getString(precision), nameSpaceURI);
        }
    }

    @Deprecated
    public void setvStringAttribute(String key, JDFNameRange value, String nameSpaceURI) {
        this.setAttribute(key, value.toString(), nameSpaceURI);
    }

    public boolean exclusiveOneOfAttribute(EnumValidationLevel level, String att1, String att2, String att3, String att4) {
        int n = 0;
        boolean hasAtt1 = this.hasAttribute(att1);
        n += hasAtt1 ? 1 : 0;
        n += this.hasAttribute(att2) ? 1 : 0;
        if (!att3.equals("")) {
            n += this.hasAttribute(att3) ? 1 : 0;
        }
        if (!att4.equals("")) {
            n += this.hasAttribute(att4) ? 1 : 0;
        }
        if (EnumValidationLevel.isRequired(level)) {
            return n == 1 || !hasAtt1 && n >= 1;
        }
        return n <= 1 || !hasAtt1;
    }

    public boolean exclusiveOneOfElement(EnumValidationLevel level, String elm1, String ns1, String elm2, String ns2) {
        int n = 0;
        n += this.hasChildElement(elm1, ns1) ? 1 : 0;
        n += this.hasChildElement(elm2, ns2) ? 1 : 0;
        if (EnumValidationLevel.isRequired(level)) {
            return n == 1;
        }
        return n <= 1;
    }

    public VString getChildIds(String attrib, String element, String nameSpaceURI) {
        VString setID = new VString();
        VElement nl = this.getElementsByTagName_KElement(element, nameSpaceURI);
        int l = nl.size();
        if (l != 0) {
            nl.elementAt(l - 1);
        }
        for (int i = 0; i < l; ++i) {
            KElement kElem = nl.elementAt(i);
            String s = kElem.getAttribute(attrib, nameSpaceURI, "");
            if (s.equals("")) continue;
            setID.addElement(s);
        }
        return setID;
    }

    @Deprecated
    public JDFResource getTarget() {
        return (JDFResource)this.getTarget_JDFElement(this.getAttribute("rRef"), "ID");
    }

    @Override
    public KElement getTarget(String id, String attrib) {
        return this.getTarget_JDFElement(id, attrib);
    }

    public JDFNode getJDFRoot() {
        return (JDFNode)this.getDeepParent("JDF", Integer.MAX_VALUE);
    }

    public JDFJMF getJMFRoot() {
        return (JDFJMF)this.getDeepParent("JMF", Integer.MAX_VALUE);
    }

    @Deprecated
    public boolean isRefElement() {
        return this instanceof JDFRefElement;
    }

    @Deprecated
    public static boolean isRefElementStatic(KElement kElem) {
        return kElem instanceof JDFRefElement;
    }

    @Deprecated
    public boolean isResource() {
        return this instanceof JDFResource;
    }

    @Deprecated
    public static boolean isResourceStatic(KElement e) {
        return e instanceof JDFResource;
    }

    public boolean isResourceUpdate() {
        return this.getLocalName().endsWith("Update");
    }

    @Deprecated
    public boolean isResourceLink() {
        return this instanceof JDFResourceLink;
    }

    @Deprecated
    public static boolean isResourceLinkStatic(KElement kElem) {
        return kElem instanceof JDFResourceLink;
    }

    @Deprecated
    public boolean isComment() {
        return this instanceof JDFComment;
    }

    @Deprecated
    public static boolean isCommentStatic(KElement kElem) {
        return kElem instanceof JDFComment;
    }

    @Deprecated
    public boolean isJDFNode() {
        return this instanceof JDFNode;
    }

    public boolean isXJDF() {
        return JDFElement.isInXJDFNameSpaceStatic(this.getNamespaceURI());
    }

    @Deprecated
    public boolean isInJDFNameSpace() {
        return JDFElement.isInJDFNameSpaceStatic(this);
    }

    public void removeExtensions() {
        Node n = this.getFirstChild();
        while (n != null) {
            Node next = n.getNextSibling();
            String nsuri = n.getNamespaceURI();
            if (!JDFElement.isInJDFNameSpaceStatic(nsuri)) {
                this.removeChild(n);
            } else if (n instanceof JDFElement) {
                ((JDFElement)n).removeExtensions();
            }
            n = next;
        }
        NamedNodeMap nm = this.getAttributes();
        if (nm != null) {
            int siz = nm.getLength();
            for (int i = siz - 1; i >= 0; --i) {
                Node na = nm.item(i);
                String nsuri = na.getNamespaceURI();
                if (JDFElement.isInJDFNameSpaceStatic(nsuri)) continue;
                this.removeAttributeNode((Attr)na);
            }
        }
    }

    public static boolean isInJDFNameSpaceStatic(String ns) {
        return ns == null || ns.equals("") || ns.compareToIgnoreCase("http://www.CIP4.org/JDFSchema_1_1") == 0 || ns.compareToIgnoreCase("http://www.CIP4.org/JDFSchema_1") == 0;
    }

    public static boolean isInXJDFNameSpaceStatic(String ns) {
        return ns != null && ns.startsWith("http://www.CIP4.org/JDFSchema_2");
    }

    public static boolean isInAnyCIP4NameSpaceStatic(String ns) {
        return ns != null && ns.startsWith("http://www.CIP4.org/");
    }

    public static boolean isInAnyCIP4NameSpaceStatic(KElement kElem) {
        if (kElem == null) {
            return false;
        }
        String ns = kElem.getNamespaceURI();
        return JDFElement.isInAnyCIP4NameSpaceStatic(ns);
    }

    public static boolean isInAnyJDFNameSpaceStatic(String ns) {
        return ns != null && ns.startsWith("http://www.CIP4.org/JDFSchema_");
    }

    public static boolean isInAnyJDFNameSpaceStatic(KElement kElem) {
        if (kElem == null) {
            return false;
        }
        String ns = kElem.getNamespaceURI();
        return JDFElement.isInAnyJDFNameSpaceStatic(ns);
    }

    public static boolean isInJDFNameSpaceStatic(KElement kElem) {
        if (kElem == null) {
            return false;
        }
        String ns = kElem.getNamespaceURI();
        return JDFElement.isInJDFNameSpaceStatic(ns);
    }

    public static boolean isInXJDFNameSpaceStatic(KElement kElem) {
        if (kElem == null) {
            return false;
        }
        String ns = kElem.getNamespaceURI();
        return JDFElement.isInXJDFNameSpaceStatic(ns);
    }

    public JDFRefElement getRefElement(JDFResource target) {
        String id;
        if (target == null) {
            return null;
        }
        JDFAttributeMap map = target.getPartMap();
        if (map != null && map.size() == 0) {
            map = null;
        }
        if (JDFElement.isWildCard(id = target.getID())) {
            return null;
        }
        VElement v = this.getChildrenByTagName(target.getLocalName() + "Ref", target.getNamespaceURI(), new JDFAttributeMap("rRef", id), false, true, 0);
        if (v != null) {
            int siz = v.size();
            for (int i = 0; i < siz; ++i) {
                JDFRefElement re = (JDFRefElement)v.elementAt(i);
                JDFAttributeMap partMap = re.getPartMap();
                if (partMap != null && partMap.size() == 0) {
                    partMap = null;
                }
                if (!ContainerUtil.equals(partMap, map)) continue;
                return re;
            }
        }
        return null;
    }

    public JDFRefElement getCreateRefElement(JDFResource target) {
        if (target == null) {
            return null;
        }
        target.makeRootResource(null, null, true);
        JDFRefElement re = this.getRefElement(target);
        return re == null ? this.refElement(target) : re;
    }

    public KElement getCreateElement_JDFElement(String nodeName, String nameSpaceURI, int iSkip) {
        KElement kElem = this.getElement_JDFElement(nodeName, nameSpaceURI, iSkip);
        if (kElem == null) {
            kElem = this.appendElement(nodeName, nameSpaceURI);
        }
        return kElem;
    }

    public JDFRefElement refElement(JDFResource target) {
        if (target == null) {
            return null;
        }
        JDFRefElement newRef = (JDFRefElement)this.appendElement(target.getNodeName() + "Ref", target.getNamespaceURI());
        JDFResource root = target.getResourceRoot();
        if (target.isResourceElement()) {
            target = target.makeRootResource(null, null, true);
        }
        if (!target.isResourceRoot()) {
            JDFAttributeMap partMap = target.getPartMap();
            newRef.setPartMap(partMap);
        }
        newRef.appendHRef(root, "rRef", null);
        JDFNode parent = root.getParentJDF();
        while (parent != null && !parent.isAncestor(this) && (parent = root.getParentJDF()) != null) {
            if ((parent = parent.getParentJDF()) == null) {
                newRef.deleteNode();
                throw new JDFException("appendRefElement resource is not in the same document");
            }
            root = (JDFResource)parent.getCreateResourcePool().moveElement(root, null);
        }
        return newRef;
    }

    public void removeRefElement(JDFResource target) {
        String id = target.getID();
        if (id.equals("")) {
            throw new JDFException("RemoveRefElement: target has no id");
        }
        VElement v = this.getChildElementVector(target.getRefString(), null, null, true, 0, false);
        for (int i = 0; i < v.size(); ++i) {
            JDFRefElement re = (JDFRefElement)v.elementAt(i);
            if (!re.getrRef().equals(id) && !re.getrSubRef().equals(id)) continue;
            re.deleteNode();
            break;
        }
    }

    public VElement getRefElements() {
        List<JDFRefElement> vr = this.getChildArrayByClass(JDFRefElement.class, false, 0);
        VElement v = new VElement();
        v.addAll(vr);
        return v;
    }

    @Deprecated
    public VString upDaterRefs() {
        VString vrRefs = new VString();
        VElement v = this.getChildrenByTagName(null, null, new JDFAttributeMap("rRef", ""), false, true, 0);
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            KElement el_i = v.elementAt(i);
            vrRefs.add(el_i.getAttribute("rRef", null, ""));
        }
        vrRefs.unify();
        return vrRefs;
    }

    public void inlineRefElements(String nodeName, String nameSpaceURI, boolean bDirect) {
        List<JDFRefElement> v = this.getChildArrayByClass_KElement(JDFRefElement.class, false, 0);
        for (JDFRefElement re : v) {
            if (!re.fitsName(nodeName, nameSpaceURI)) continue;
            try {
                re.inlineRef();
            }
            catch (JDFException x) {
                re.deleteNode();
            }
        }
        if (!bDirect) {
            List<KElement> v2 = this.getChildArray_KElement(null, null, null, true, 0);
            for (KElement e : v2) {
                if (!(e instanceof JDFElement)) continue;
                ((JDFElement)e).inlineRefElements(nodeName, nameSpaceURI, bDirect);
            }
        }
    }

    @Override
    public VElement getChildElementVector(String nodeName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bAnd, int maxSize, boolean bResolveTarget) {
        return this.getChildElementVector_JDFElement(nodeName, nameSpaceURI, mAttrib, bAnd, maxSize, bResolveTarget);
    }

    @Override
    public VElement getChildrenByTagName(String elementName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bDirect, boolean bAnd, int maxSize) {
        return this.getChildrenByTagName(elementName, nameSpaceURI, mAttrib, bDirect, bAnd, maxSize, !JDFElement.isWildCard(elementName) && !elementName.endsWith("Ref"));
    }

    public VElement getChildrenByTagName(String elementName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bDirect, boolean bAnd, int maxSize, boolean bFollowRefs) {
        VElement v = super.getChildrenByTagName_KElement(bFollowRefs ? null : elementName, nameSpaceURI, mAttrib, bDirect, bAnd, bFollowRefs ? -1 : maxSize);
        if (!bFollowRefs) {
            return v;
        }
        if (v != null) {
            int i;
            int size = v.size();
            for (i = size - 1; i >= 0; --i) {
                KElement refElem = v.elementAt(i);
                if (!refElem.fitsName(elementName, nameSpaceURI)) {
                    v.remove(i);
                    continue;
                }
                if (!(refElem instanceof JDFRefElement)) continue;
                JDFResource target = ((JDFRefElement)refElem).getTarget();
                if (target == null) {
                    jLog.warn((Object)("Ignoring missing refelement target: " + refElem.getNodeName() + " rRef=" + refElem.getAttribute("rRef")));
                    v.remove(i);
                    continue;
                }
                if (!(target instanceof JDFResource)) {
                    jLog.warn((Object)("target is not a resource: " + refElem.getNodeName() + " rRef=" + refElem.getAttribute("rRef")));
                }
                v.set(i, target);
            }
            if (maxSize > 0) {
                for (i = v.size() - 1; i >= maxSize; --i) {
                    v.remove(i);
                }
            }
        }
        return v;
    }

    public VElement getChildElementVector_JDFElement(String nodeName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bAnd, int maxSize, boolean bResolveTarget) {
        VElement v = new VElement();
        if (JDFElement.isWildCard(nodeName)) {
            nodeName = null;
        }
        if (JDFElement.isWildCard(nameSpaceURI)) {
            nameSpaceURI = null;
        }
        if (mAttrib != null && mAttrib.isEmpty()) {
            mAttrib = null;
        }
        if (maxSize == 0) {
            maxSize = -1;
        }
        boolean bAlwaysFit = nodeName == null && nameSpaceURI == null;
        boolean bMapEmpty = mAttrib == null;
        int iSize = 0;
        for (KElement kElem = this.getFirstChildElement(); kElem != null; kElem = kElem.getNextSiblingElement()) {
            if (!bAlwaysFit && !kElem.fitsName(nodeName, nameSpaceURI)) continue;
            if (bResolveTarget && kElem instanceof JDFRefElement) {
                try {
                    JDFRefElement ref = (JDFRefElement)kElem;
                    JDFResource target = ref.getTarget();
                    if (target != null && (bMapEmpty || target.includesAttributes(mAttrib, bAnd))) {
                        v.addElement(target);
                        ++iSize;
                    }
                }
                catch (JDFException jDFException) {}
            } else if (bMapEmpty || kElem.includesAttributes(mAttrib, bAnd)) {
                v.addElement(kElem);
                ++iSize;
            }
            if (iSize == maxSize) break;
        }
        return v;
    }

    @Override
    public VString getElementNameVector() {
        VElement e = this.getChildElementVector(null, null, null, true, 0, false);
        VString v = new VString();
        for (int i = 0; i < e.size(); ++i) {
            KElement el = e.elementAt(i);
            String s = el.getNodeName();
            if (el instanceof JDFRefElement) {
                s = s.substring(0, s.length() - "ref".length());
            }
            v.appendUnique(s);
        }
        return v;
    }

    @Override
    public KElement getElement(String nodeName, String nameSpaceURI, int iSkip) {
        return this.getElement_JDFElement(nodeName, nameSpaceURI, iSkip);
    }

    public KElement getElement_JDFElement(String nodeName, String nameSpaceURI, int iSkip) {
        boolean bExplicitRefElement;
        int i = 0;
        if (iSkip < 0) {
            iSkip = this.numChildElements_JDFElement(nodeName, nameSpaceURI) + iSkip;
        }
        if (iSkip < 0) {
            return null;
        }
        boolean bl = bExplicitRefElement = nodeName != null && nodeName.endsWith("Ref");
        for (KElement jdfElem = this.getFirstChildElement(); jdfElem != null; jdfElem = jdfElem.getNextSiblingElement()) {
            if (!jdfElem.fitsName(nodeName, nameSpaceURI) || i++ != iSkip) continue;
            if (jdfElem instanceof JDFRefElement && !bExplicitRefElement) {
                try {
                    JDFRefElement re = (JDFRefElement)jdfElem;
                    JDFResource target = re.getTarget();
                    if (target != null) {
                        return target;
                    }
                }
                catch (JDFException jDFException) {
                    // empty catch block
                }
                --i;
                continue;
            }
            return jdfElem;
        }
        return null;
    }

    @Override
    public int numChildElements(String nodeName, String nameSpaceURI) {
        return this.getChildElementVector(nodeName, nameSpaceURI, null, true, 0, false).size();
    }

    public int numChildElements_JDFElement(String nodeName, String nameSpaceURI) {
        return this.getChildElementVector_JDFElement(nodeName, nameSpaceURI, null, true, 0, false).size();
    }

    @Override
    public void removeChildren(String nodeName, String nameSpaceURI, JDFAttributeMap mAttrib) {
        VElement v = this.getChildElementVector_JDFElement(nodeName, nameSpaceURI, mAttrib, true, 0, false);
        for (KElement e : v) {
            e.deleteNode();
        }
    }

    protected boolean validResourcePosition(JDFResource r) {
        if (r == null) {
            return false;
        }
        JDFNode nodeResource = r.getParentJDF();
        JDFNode nodeLink = this.getParentJDF();
        if (nodeResource != null && nodeLink != null) {
            if (nodeResource.equals(nodeLink)) {
                return true;
            }
            if (nodeResource.isAncestor(nodeLink)) {
                return true;
            }
        } else if (this.getDeepParent("JMF", 0) != null) {
            return this.getDeepParentChild("JMF") == r.getDeepParentChild("JMF");
        }
        return false;
    }

    @Override
    public KElement removeChild(String node, String nameSpaceURI, int n) {
        VElement v = this.getChildElementVector_JDFElement(node, nameSpaceURI, null, true, 0, false);
        if (n >= v.size()) {
            return null;
        }
        KElement kelem = v.elementAt(n);
        return kelem.deleteNode();
    }

    @Override
    public String appendAnchor(String strName) {
        if (this.hasAttribute("ID")) {
            return this.getAttribute("ID", null, null);
        }
        if (strName == null || ((String)strName).equals("")) {
            JDFJMF jmf;
            Object local = "";
            JDFNode n = this.getJDFRoot();
            if (n != null && !JDFElement.isWildCard((String)(local = n.getSpawnID(true)))) {
                local = "." + StringUtil.rightStr((String)local, 6) + ".";
            }
            if ((jmf = this.getJMFRoot()) != null && !StringUtil.isEmpty((String)(local = jmf.getSenderID()))) {
                local = StringUtil.replaceCharSet((String)local, " \t\n\f", null, 0);
                local = "." + (((String)local).hashCode() & 0xFFFF) % 10000 + ".";
            }
            strName = this.getIDPrefix() + (String)local + JDFElement.uniqueID(0);
        }
        this.setAttribute("ID", (String)strName, null);
        return strName;
    }

    public void setAttributeNameTimeStamp(String attributeName, JDFDate timestamp) {
        if (timestamp == null) {
            timestamp = new JDFDate();
        }
        this.setAttribute(attributeName, timestamp.getDateTimeISO(), null);
    }

    @Override
    public int setAttributes(KElement kElem, VString ignoreList) {
        if (kElem == null) {
            return 0;
        }
        KElement parent = null;
        if (kElem instanceof JDFResource && (parent = kElem.getParentNode_KElement()) != null && kElem.getNodeName().equals(parent.getNodeName())) {
            JDFResource r = (JDFResource)parent;
            VString il2 = new VString();
            il2.add("ID");
            il2.add("PartUsage");
            il2.add("PartIDKeys");
            il2.add("Class");
            il2.appendUnique(r.getPartIDKeys());
            il2.appendUnique(ignoreList);
            this.setAttributes(parent, il2);
        }
        return super.setAttributes(kElem, ignoreList);
    }

    @Deprecated
    public String idString(int id) {
        Object s = "Link";
        String strID = Integer.toString(id);
        for (int i = "Link".length() - strID.length(); i > 0; --i) {
            s = (String)s + "0";
        }
        s = (String)s + strID;
        return s;
    }

    public static JDFNode getParentJDF(KElement e) {
        KElement e2 = e;
        if (e2 instanceof JDFNode) {
            e2 = e2.getParentNode_KElement();
        }
        if (e2 == null) {
            return null;
        }
        return (e2 = e2.getDeepParent("JDF", 0)) == e ? null : (JDFNode)e2;
    }

    public JDFNode getParentJDF() {
        return JDFElement.getParentJDF(this);
    }

    public VString getInvalidAttributes(EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        AttributeInfo ai = this.getAttributeInfo();
        VString v = this.getInvalidAttributes_JDFElement(level, bIgnorePrivate, nMax, ai);
        String s = this.getNamespaceURI();
        if (s != null && s.toLowerCase().indexOf(".cip4.org") >= 0 && !s.equals("http://www.CIP4.org/JDFSchema_1_1")) {
            if (v == null) {
                v = new VString("xmlns", null);
            } else {
                v.appendUnique("xmlns");
            }
        }
        if ((s = this.getAttribute("xmlns:xsi", null, null)) != null && !s.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            v.appendUnique("xmlns:xsi");
        }
        return v;
    }

    private VString getInvalidAttributes_JDFElement(EnumValidationLevel level, boolean bIgnorePrivate, int nMax, AttributeInfo ai) {
        VString vAttsReturn = new VString();
        if (!JDFElement.isInJDFNameSpaceStatic(this)) {
            return vAttsReturn;
        }
        int numAtts = 0;
        Set<String> vReq = EnumValidationLevel.isRequired(level) && !this.isIncomplete() ? this.getAttributeInfo().requiredAttribs().getSet() : null;
        NamedNodeMap nm = this.getAttributes();
        if (nm != null) {
            int siz = nm.getLength();
            for (int i = 0; i < siz; ++i) {
                boolean rem;
                Node a = nm.item(i);
                String nodeName = a.getNodeName();
                String key = JDFElement.xmlnsLocalName(nodeName);
                String ns = JDFElement.xmlnsPrefix(nodeName);
                if ("xsi".equals(ns) || "xmlns".equals(ns) || bIgnorePrivate && !JDFElement.isWildCard(ns) && !"http://www.CIP4.org/JDFSchema_1_1".equals(ns)) continue;
                if (ai.getAttributeType(key) == null || !ai.validAttribute(key, a.getNodeValue(), level)) {
                    vAttsReturn.add(key);
                    if (++numAtts >= nMax) {
                        return vAttsReturn;
                    }
                }
                if (vReq == null || !(rem = vReq.remove(key)) || !vReq.isEmpty()) continue;
                vReq = null;
            }
        }
        if (vReq != null) {
            VString v = this.getLocalRequiredAttributes(vReq);
            vAttsReturn.appendUnique(v);
        }
        return vAttsReturn;
    }

    private VString getLocalRequiredAttributes(Set<String> vReq) {
        VString v = new VString();
        for (String next : vReq) {
            if (this.getAttribute(next, null, null) != null) continue;
            v.add(next);
        }
        return v;
    }

    private boolean isIncomplete() {
        boolean isLocal = this instanceof JDFResource && ((JDFResource)this).isResourceElement();
        JDFResource r = (JDFResource)(isLocal ? this : JDFResource.getResourceRoot(this));
        return r == null ? false : "Incomplete".equals(r.getAttribute("Status", null, null));
    }

    public VString getInvalidElements(EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        return this.getInvalidElements_JDFElement(level, bIgnorePrivate, nMax);
    }

    public VString getInvalidElements_JDFElement(EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        VString vBad = new VString();
        if (bIgnorePrivate && !JDFElement.isInJDFNameSpaceStatic(this)) {
            return vBad;
        }
        int num = 0;
        VElement v = this.getChildElementVector(null, null, null, true, 0, false);
        for (KElement e : v) {
            if (!(e instanceof JDFElement) || ((JDFElement)e).isValid(level)) continue;
            vBad.add(e.getLocalName());
            jLog.warn((Object)("invalid element: " + e.getLocalName()));
            if (++num < nMax) continue;
            return vBad;
        }
        if (EnumValidationLevel.isRequired(level) && !this.isIncomplete()) {
            vBad.appendUnique(new VString(this.getMissingElements(nMax)));
        }
        if (!(nMax > 0 && vBad.size() >= nMax || EnumValidationLevel.isNoWarn(level))) {
            vBad.appendUnique(new VString(this.getDeprecatedElements(nMax)));
            if (nMax <= 0 || vBad.size() < nMax) {
                VString prereleaseElements = this.getPrereleaseElements(nMax);
                vBad.appendUnique(new VString(prereleaseElements));
            }
        }
        vBad.appendUnique(new VString(this.getUnknownElements(bIgnorePrivate, nMax)));
        return vBad;
    }

    public void setCommentURL(String value) {
        this.setAttribute("CommentURL", value, null);
    }

    public JDFComment setCommentText(String text) {
        if (StringUtil.isEmpty(text)) {
            this.removeChildrenByClass(JDFComment.class);
            return null;
        }
        JDFComment c = this.getCreateComment(0);
        c.setText(text);
        return c;
    }

    public JDFComment setCommentText(String text, String name) {
        if (StringUtil.isEmpty(text)) {
            JDFComment c;
            while ((c = this.getComment(name, 0)) != null) {
                c.deleteNode();
            }
            return null;
        }
        JDFComment c = this.getCreateComment(name, 0);
        c.setText(text);
        return c;
    }

    public String getCommentURL() {
        return this.getAttribute("CommentURL", null, "");
    }

    protected String getRefString() {
        return this.getNodeName() + "Ref";
    }

    public String jdfVersion() {
        return "1.6";
    }

    public static String getSchemaURL() {
        return JDFElement.getSchemaURL(1, 1);
    }

    public static String getSchemaURL(int majorVersion, int minorVersion) {
        if (majorVersion == 1) {
            if (minorVersion == 0) {
                return "http://www.CIP4.org/JDFSchema_1";
            }
            if (minorVersion >= 1) {
                return "http://www.CIP4.org/JDFSchema_1_1";
            }
        } else if (majorVersion == 2) {
            return "http://www.CIP4.org/JDFSchema_2_0";
        }
        return "http://www.CIP4.org/JDFSchema_" + majorVersion + "_" + minorVersion;
    }

    public static EnumVersion getDefaultJDFVersion() {
        return defaultVersion;
    }

    public static void setDefaultJDFVersion(EnumVersion vers) {
        defaultVersion = vers;
    }

    public String getElementIDPrefix() {
        return "l";
    }

    public String newID(String lastID) {
        String idPrefix = this.getIDPrefix();
        if (lastID == null || lastID.equals("")) {
            return idPrefix + JDFElement.uniqueID(0);
        }
        JDFElement p = (JDFElement)this.getParentNode_KElement();
        if (p == null) {
            return idPrefix + JDFElement.uniqueID(0);
        }
        return this.generateDotID("ID", null);
    }

    @Deprecated
    public int getEnumAttribute(String key, Vector v, String nameSpaceURI, int def, boolean bInherit) {
        String s = null;
        int i = def;
        s = bInherit ? this.getInheritedAttribute(key, nameSpaceURI, "") : this.getAttribute(key, nameSpaceURI, "");
        if (!s.equals("") && v.contains(s)) {
            i = v.indexOf(s);
        }
        return i;
    }

    @Deprecated
    public Vector getEnumerationsAttribute(String key, Vector v, String nameSpaceURI, int def, boolean bInherit) {
        VString vAllowed = new VString();
        vAllowed.addAll(v);
        String strAtt = "";
        VString vs = new VString();
        VString vAtts = null;
        strAtt = bInherit ? this.getInheritedAttribute(key, nameSpaceURI, "") : this.getAttribute(key, nameSpaceURI, "");
        if (strAtt.equals("")) {
            vs.add(strAtt);
        }
        vAtts = StringUtil.tokenize(strAtt, " ", false);
        vs.addAll(vAtts);
        Vector<Integer> ret = new Vector<Integer>();
        if (vs.isEmpty()) {
            if (def >= 0) {
                ret.addElement(def);
            }
            return ret;
        }
        for (int i = 0; i < vs.size(); ++i) {
            int enumIndex = vAllowed.index(vs.get(i));
            if (enumIndex >= 0) {
                ret.addElement(enumIndex);
                continue;
            }
            ret.addElement(-1);
        }
        return ret;
    }

    public Vector<? extends ValuedEnum> getEnumerationsAttribute(String key, String nameSpaceURI, ValuedEnum enu, boolean bInherit) {
        String strAtt = null;
        Vector<ValuedEnum> vEnum = new Vector<ValuedEnum>();
        strAtt = bInherit ? this.getInheritedAttribute(key, nameSpaceURI, null) : this.getAttribute(key, nameSpaceURI, null);
        if (strAtt == null) {
            return null;
        }
        VString vAtts = StringUtil.tokenize(strAtt, " ", false);
        try {
            Class[] methodArgs = new Class[]{String.class};
            Method m = enu.getClass().getMethod("getEnum", methodArgs);
            for (int i = 0; i < vAtts.size(); ++i) {
                Object[] args = new Object[]{vAtts.elementAt(i)};
                ValuedEnum ve = (ValuedEnum)m.invoke(null, args);
                if (ve == null) continue;
                vEnum.add(ve);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vEnum.size() == 0 ? null : vEnum;
    }

    protected void setEnumerationsAttribute(String key, Vector<? extends ValuedEnum> value, String nameSpaceURI) {
        Object s = null;
        if (value != null) {
            int n = 0;
            for (ValuedEnum valuedEnum : value) {
                s = n++ > 0 ? s + " " : "";
                s = (String)s + valuedEnum.getName();
            }
        }
        this.setAttribute(key, (String)s, nameSpaceURI);
    }

    @Deprecated
    public boolean validAttribute(String key, AttributeInfo.EnumAttributeType iType, boolean bRequired, String nameSpaceURI) {
        if (!this.hasAttribute(key, null, false)) {
            return !bRequired;
        }
        String val = this.getAttribute(key, nameSpaceURI, null);
        return AttributeInfo.validStringForType(val, iType, null);
    }

    @Deprecated
    public boolean validEnumAttribute(String key, Vector v, boolean bRequired, String nameSpaceURI) {
        if (!this.hasAttribute(key, nameSpaceURI, false)) {
            return !bRequired;
        }
        return this.getEnumAttribute(key, v, nameSpaceURI, -1, false) >= 0;
    }

    @Deprecated
    public boolean validEnumerationsAttribute(String key, Vector vs, boolean bRequired, String nameSpaceURI) {
        if (!this.hasAttribute(key, nameSpaceURI, false)) {
            return !bRequired;
        }
        Vector v = this.getEnumerationsAttribute(key, vs, nameSpaceURI, -1, false);
        for (int i = 0; i < v.size(); ++i) {
            if ((Integer)v.elementAt(i) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized Node replaceChild(Node arg0, Node arg1) throws DOMException {
        this.setDirty(false);
        if (arg1 instanceof JDFElement) {
            ((JDFElement)arg1).clearTargets();
        }
        return super.replaceChild(arg0, arg1);
    }

    @Override
    public synchronized Node removeChild(Node arg0) throws DOMException {
        this.setDirty(false);
        if (arg0 instanceof JDFElement) {
            ((JDFElement)arg0).clearTargets();
        }
        return super.removeChild(arg0);
    }

    public KElement getTarget_JDFElement(String id, String attrib) {
        if (id == null || id.equals("")) {
            return null;
        }
        boolean bID = false;
        KElement kRet = null;
        if (attrib == null) {
            attrib = "ID";
        }
        XMLDocUserData userData = this.getXMLDocUserData();
        if (attrib.equals("ID") && userData != null) {
            kRet = userData.getTarget(id);
            bID = true;
        }
        if (kRet == null) {
            JDFElement excludeElement = null;
            KElement root = this;
            KElement docRoot = this.getDocRoot();
            boolean bFound = false;
            if (!bID) {
                userData = null;
            }
            while (root != null && !bFound) {
                KElement deepElement = JDFElement.getDeepElementByID(root, attrib, id, excludeElement, userData);
                if (deepElement == null) {
                    if (root == docRoot) {
                        kRet = null;
                        bFound = true;
                        continue;
                    }
                    excludeElement = root;
                    root = root.getParentNode_KElement();
                    continue;
                }
                kRet = deepElement;
                bFound = true;
            }
        }
        return kRet;
    }

    @Override
    public KElement insertBefore(String elementName, Node beforeChild, String nameSpaceURI) {
        Document od;
        KElement newChild = super.insertBefore(elementName, beforeChild, nameSpaceURI);
        if (newChild != null && (od = this.getOwnerDocument()) instanceof DocumentJDFImpl && ((DocumentJDFImpl)((Object)od)).bInitOnCreate) {
            newChild.init();
        }
        return newChild;
    }

    @Override
    protected void clearTargets() {
        XMLDocUserData ud = this.getXMLDocUserData();
        if (ud != null) {
            if (this.hasChildElements()) {
                ud.clearTargets();
            } else {
                String id = this.getAttributeRaw("ID");
                if (id != null) {
                    ud.removeTarget(id);
                }
            }
        }
    }

    @Override
    public KElement cloneNewDoc() {
        JDFDoc d = new JDFDoc();
        d.copyMeta(this.getOwnerDocument_KElement());
        d.setInitOnCreate(false);
        d.setRoot(this.getNodeName(), this.getNamespaceURI());
        KElement e = d.getRoot();
        e.copyInto(this, false);
        d.setInitOnCreate(true);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KElement copyInto(KElement src, boolean bRemove) {
        if (src == null || src == this) {
            return this;
        }
        JDFDoc ownerDocument_JDF = this.getOwnerDocument_JDFElement();
        boolean b = ownerDocument_JDF.getInitOnCreate();
        try {
            ownerDocument_JDF.setInitOnCreate(false);
            super.copyInto(src, bRemove);
        }
        finally {
            ownerDocument_JDF.setInitOnCreate(b);
        }
        return this;
    }

    @Deprecated
    public String getEnumString(int value, String allowedValues) {
        Vector<String> vs = new Vector<String>();
        vs.addAll(StringUtil.tokenize(allowedValues, ",", false));
        if (value >= vs.size()) {
            return "";
        }
        return (String)vs.elementAt(value);
    }

    public JDFDoc getOwnerDocument_JDFElement() {
        Document doc = this.getOwnerDocument();
        return new JDFDoc(doc);
    }

    @Deprecated
    public int getEnumNodeName(Vector allowedValues) {
        String s = this.getLocalName();
        for (int i = 0; i < allowedValues.size(); ++i) {
            if (!s.equalsIgnoreCase((String)allowedValues.elementAt(i))) continue;
            return i;
        }
        return 0;
    }

    protected VJDFAttributeMap getPartMapVector() {
        List<JDFPart> vE = this.getChildArrayByClass(JDFPart.class, false, 0);
        VJDFAttributeMap v = ContainerUtil.isEmpty(vE) ? null : new VJDFAttributeMap();
        for (JDFPart part : vE) {
            v.add(part.getPartMap());
        }
        return v;
    }

    protected JDFAttributeMapArray getPartMapArray() {
        List<JDFPart> aPart = this.getChildArrayByClass(JDFPart.class, false, 0);
        JDFAttributeMapArray a = ContainerUtil.isEmpty(aPart) ? null : new JDFAttributeMapArray();
        for (JDFPart pt : aPart) {
            a.add(pt.getPartMap());
        }
        return a;
    }

    protected JDFAttributeMap getPartMap() {
        JDFPart p = this.getElementByClass(JDFPart.class, 0, false);
        if (p == null) {
            return null;
        }
        return p.getPartMap();
    }

    protected void setPartMapVector(VJDFAttributeMap vPart) {
        this.removeChildrenByClass(JDFPart.class);
        if (!VJDFAttributeMap.isEmpty(vPart)) {
            for (JDFAttributeMap part : vPart) {
                KElement p = this.appendElement("Part", null);
                p.setAttributes(part);
            }
        }
    }

    protected void setPartMap(JDFAttributeMap mPart) {
        this.removeChildrenByClass(JDFPart.class);
        if (!JDFAttributeMap.isEmpty(mPart)) {
            KElement p = this.appendElement("Part", null);
            p.setAttributes(mPart);
        }
    }

    protected void removePartMap(JDFAttributeMap mPart) {
        List<JDFPart> aPart = this.getChildArrayByClass(JDFPart.class, false, 0);
        int i = 0;
        for (KElement kElement : aPart) {
            JDFAttributeMap a_Map = kElement.getAttributeMap();
            if (a_Map.subMap(mPart)) {
                aPart.remove(i);
                continue;
            }
            ++i;
        }
    }

    protected boolean hasPartMap(JDFAttributeMap mPart) {
        List<JDFPart> aPart = this.getChildArrayByClass(JDFPart.class, false, 0);
        for (KElement kElement : aPart) {
            JDFAttributeMap map = kElement.getAttributeMap();
            if (!map.subMap(mPart)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean requiredLevel(EnumValidationLevel level) {
        return EnumValidationLevel.isRequired(level);
    }

    @Deprecated
    public VString getHRefs(VString vDoneRefs, boolean bRecurse) {
        return this.getHRefs(vDoneRefs, bRecurse, false);
    }

    public VString getHRefs(VString vDoneRefs, boolean bRecurse, boolean bExpand) {
        if (vDoneRefs == null) {
            vDoneRefs = new VString();
        }
        HashSet<Object> h = new HashSet();
        if (bExpand && this instanceof JDFResource) {
            List<JDFResource> vLeaves = ((JDFResource)this).getLeafArray(true);
            int siz = vLeaves.size();
            for (int i = 0; i < siz; ++i) {
                HashSet<String> h2 = vLeaves.get(i).fillHashSet("rRef", null);
                if (h2 == null) continue;
                h.addAll(h2);
            }
        } else {
            h = this.fillHashSet("rRef", null);
        }
        int iFirstPos = vDoneRefs.size();
        VString v2 = new VString();
        if (h != null) {
            v2.addAll(h);
        }
        vDoneRefs.appendUnique(v2);
        if (bRecurse) {
            int iLastPos = vDoneRefs.size();
            for (int i = iFirstPos; i < iLastPos; ++i) {
                String s = vDoneRefs.elementAt(i);
                KElement e = this.getTarget(s, "ID");
                if (!(e instanceof JDFElement)) continue;
                vDoneRefs = ((JDFElement)e).getHRefs(vDoneRefs, true, bExpand);
            }
        }
        return vDoneRefs;
    }

    @Deprecated
    public VElement getvHRefRes(boolean bRecurse) {
        return this.getvHRefRes(bRecurse, false);
    }

    public VElement getvHRefRes(boolean bRecurse, boolean bExpand) {
        VString sRefs = this.getHRefs(null, bRecurse, bExpand);
        VElement v = new VElement();
        for (int i = 0; i < sRefs.size(); ++i) {
            KElement kEl = this.getTarget(sRefs.elementAt(i), "ID");
            if (!(kEl instanceof JDFResource)) continue;
            v.add(kEl);
        }
        v.unify();
        return v;
    }

    @Deprecated
    public void appendrRefs(String value) {
        this.appendAttribute("rRefs", value, null, " ", true);
    }

    @Deprecated
    public int removeFromrRefs(String value) {
        return this.removeFromAttribute("rRefs", value, null, " ", -1);
    }

    @Deprecated
    public VString getrRefs() {
        VString vStr = new VString();
        vStr.setAllStrings(this.getAttribute_KElement("rRefs", null, ""), " ");
        return vStr;
    }

    public JDFResource getLinkRoot(String id) {
        String myid;
        String string = myid = id == null ? this.getNonEmpty("rRef") : id;
        if (myid == null) {
            return null;
        }
        JDFResource ret = this.getLinkFromUserData(myid);
        if (ret == null) {
            KElement rootElem;
            KElement jmf;
            boolean bSearching = true;
            JDFNode nod = (JDFNode)this.getDeepParent("JDF", 0);
            if (nod != null) {
                while (bSearching) {
                    if (nod == null) continue;
                    JDFResourcePool rp = nod.getResourcePool();
                    if (rp != null) {
                        ret = rp.getResourceByID(myid);
                        boolean bl = bSearching = ret == null;
                    }
                    if (!bSearching) continue;
                    bSearching = (nod = nod.getParentJDF()) != null;
                }
            } else if (bSearching && (jmf = this.getDeepParent("JMF", 0)) != null && (rootElem = jmf.getChildWithAttribute(null, "ID", null, myid, 0, false)) instanceof JDFResource) {
                ret = (JDFResource)rootElem;
            }
        }
        return ret;
    }

    protected JDFResource getLinkFromUserData(String myid) {
        JDFResource ret = null;
        XMLDocUserData ud = this.getXMLDocUserData();
        if (ud != null) {
            KElement kOwner = ud.getTarget(myid);
            if (kOwner != null && kOwner instanceof JDFResource && !(ret = (JDFResource)kOwner).isResourceRootRoot()) {
                ret = null;
            }
            if (ret != null && !this.validResourcePosition(ret)) {
                ret = null;
            }
        }
        return ret;
    }

    @Deprecated
    public final String version() {
        String ver = this.getInheritedAttribute("Version", null, "");
        EnumVersion e = EnumVersion.getEnum(ver);
        if (e == null) {
            return "1.3";
        }
        return e.getName();
    }

    public File write2Dir(String dir) {
        String jobID = this.getInheritedAttribute("JobID", null, "unknown");
        Object jobPartID = this.getInheritedAttribute("JobPartID", null, "");
        if (!((String)jobPartID).isEmpty()) {
            jobPartID = (String)jobPartID + ".";
        }
        String extension = "xml";
        if (this instanceof JDFNode || this.getParentJDF() != null) {
            extension = "jdf";
        } else if (this.getOwnerDocument_KElement().getRoot() instanceof JDFJMF) {
            extension = "jmf";
        }
        Object file = jobID + "." + (String)jobPartID;
        file = UrlUtil.newExtension((String)file, extension);
        String newURL = UrlUtil.getURLWithDirectory(dir, (String)file);
        boolean ok = this.write2File(newURL);
        return ok ? new File(newURL) : null;
    }

    public void setVersion(EnumVersion enumVer) {
        this.setAttribute("Version", enumVer == null ? null : enumVer.getName(), null);
        AttributeInfo.fixedMap.clear();
        ElementInfo.getFixedmap().clear();
    }

    @Deprecated
    public EnumVersion getVersion() {
        return this.getVersion(true);
    }

    public EnumVersion getVersion(boolean bInherit) {
        KElement root;
        String versionName;
        String string = versionName = bInherit ? this.getInheritedAttribute("Version", null, null) : this.getNonEmpty("Version");
        if (StringUtil.isEmpty(versionName) && (root = this.getDocRoot()) != null) {
            String rootName = root.getLocalName();
            if ('J' == rootName.charAt(0) && ("JDF".equals(rootName) || "JMF".equals(rootName))) {
                return JDFElement.getDefaultJDFVersion();
            }
            if ("XJDF".equals(rootName) || "XJMF".equals(rootName) || "PrintTalk".equals(rootName)) {
                return XJDFHelper.getDefaultVersion();
            }
        }
        return EnumVersion.getEnum(versionName);
    }

    public EnumVersion getMaxVersion(boolean bInherit) {
        String version;
        String string = version = bInherit ? this.getInheritedAttribute("MaxVersion", null, null) : this.getAttribute("MaxVersion", null, null);
        if (version == null) {
            return this.getVersion(bInherit);
        }
        return EnumVersion.getEnum(version);
    }

    @Deprecated
    public static EnumVersion stringToVersion(String enumName) {
        return EnumVersion.getEnum(enumName);
    }

    @Deprecated
    public KElement[] getChildElements() {
        return this.getChildElementArray();
    }

    @Override
    public void copyChildren(String elementName, KElement src) {
        super.copyChildren(elementName, src);
        VElement refs = src.getChildElementVector_KElement(JDFRefElement.getRefName(elementName), null, null, true, 0);
        for (KElement e : refs) {
            JDFRefElement re = (JDFRefElement)e;
            JDFResource r = re.getTarget();
            this.refElement(r);
        }
    }

    @Deprecated
    public JDFElement getChildElement(int n) {
        int nLocal = n;
        JDFElement eReturn = null;
        NodeList children = this.getChildNodes();
        int cnt = children.getLength();
        for (int i = 0; i < cnt && eReturn == null; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1 || --nLocal != 0) continue;
            eReturn = (JDFElement)node;
        }
        return eReturn;
    }

    protected VString getUnknownPoolElements(EnumPoolType poolType, int nMax) {
        VElement v = this.getChildElementVector(null, null, null, true, 0, false);
        VString vElem = new VString();
        int n = 0;
        VString knownElements = this.knownElements();
        for (KElement e : v) {
            String refName;
            if (e instanceof JDFComment || (EnumPoolType.ResourcePool.equals((Object)poolType) || EnumPoolType.ProductionIntent.equals((Object)poolType) || EnumPoolType.PipeParams.equals((Object)poolType)) && e instanceof JDFResource || (EnumPoolType.ProductionIntent.equals((Object)poolType) || EnumPoolType.RefElement.equals((Object)poolType) || EnumPoolType.PipeParams.equals((Object)poolType)) && e instanceof JDFRefElement || (EnumPoolType.ResourceLinkPool.equals((Object)poolType) || EnumPoolType.PipeParams.equals((Object)poolType)) && e instanceof JDFResourceLink || EnumPoolType.AuditPool.equals((Object)poolType) && e instanceof JDFAudit || EnumPoolType.AncestorPool.equals((Object)poolType) && e instanceof JDFAncestor || knownElements.contains(e.getLocalName()) || e instanceof JDFRefElement && knownElements.contains(refName = ((JDFRefElement)e).getRefLocalName())) continue;
            vElem.add(e.getLocalName());
            if (++n <= nMax) continue;
            return vElem;
        }
        return vElem;
    }

    public void setSettingsPolicy(EnumSettingsPolicy value) {
        this.setAttribute("SettingsPolicy", value, null);
    }

    public EnumSettingsPolicy getSettingsPolicy(boolean bInherit) {
        String s = null;
        s = bInherit ? this.getInheritedAttribute("SettingsPolicy", null, null) : this.getAttribute("SettingsPolicy", null, null);
        return EnumSettingsPolicy.getEnum(s);
    }

    public void setBestEffortExceptions(VString value) {
        this.setAttribute("BestEffortExceptions", value, (String)null);
    }

    public void appendBestEffortExceptions(String value) {
        this.appendAttribute("BestEffortExceptions", value, null, " ", true);
    }

    public void removeFromBestEffortExceptions(String value) {
        this.removeFromAttribute("BestEffortExceptions", value, null, " ", -1);
    }

    public String getBestEffortExceptions() {
        return this.getAttribute("BestEffortExceptions", null, "");
    }

    public void setMustHonorExceptions(VString value) {
        this.setAttribute("MustHonorExceptions", value, (String)null);
    }

    public void appendMustHonorExceptions(String value) {
        this.appendAttribute("MustHonorExceptions", value, null, " ", true);
    }

    public void removeFromMustHonorExceptions(String value) {
        this.removeFromAttribute("MustHonorExceptions", value, null, " ", -1);
    }

    public String getMustHonorExceptions() {
        return this.getAttribute("MustHonorExceptions", null, "");
    }

    public void setOperatorInterventionExceptions(VString value) {
        this.setAttribute("OperatorInterventionExceptions", value, (String)null);
    }

    public void appendOperatorInterventionExceptions(String value) {
        this.appendAttribute("OperatorInterventionExceptions", value, null, " ", true);
    }

    public void removeFromOperatorInterventionExceptions(String value) {
        this.removeFromAttribute("OperatorInterventionExceptions", value, null, " ", -1);
    }

    public String getOperatorInterventionExceptions() {
        return this.getAttribute("OperatorInterventionExceptions", null, "");
    }

    public void setDescriptiveName(String value) {
        this.setAttribute("DescriptiveName", value, null);
    }

    public String getDescriptiveName() {
        return this.getAttribute("DescriptiveName", null, "");
    }

    public JDFGeneralID appendGeneralID() {
        KElement appendElement = this.appendElement("GeneralID", null);
        KElement next = this.getFirstChildElement();
        while (next instanceof JDFGeneralID) {
            next = next.getNextSiblingElement();
        }
        this.moveElement(appendElement, next);
        return (JDFGeneralID)appendElement;
    }

    public JDFGeneralID appendGeneralID(String idUsage, String idValue) {
        return this.appendGeneralID(idUsage, idValue, null);
    }

    public JDFGeneralID appendGeneralID(String idUsage, String idValue, JDFAutoGeneralID.EnumDataType namedfeature) {
        if (idValue == null) {
            return null;
        }
        JDFGeneralID gid = this.appendGeneralID();
        gid.setIDValue(idValue);
        gid.setIDUsage(idUsage);
        gid.setDataType(namedfeature);
        return gid;
    }

    public JDFGeneralID getGeneralID(int i) {
        return (JDFGeneralID)this.getElement("GeneralID", null, i);
    }

    public JDFGeneralID setGeneralID(String idUsage, String idValue) {
        JDFGeneralID gid;
        List<KElement> v = this.getChildArray_KElement("GeneralID", null, new JDFAttributeMap("IDUsage", idUsage), true, 0);
        if (!v.isEmpty()) {
            gid = (JDFGeneralID)v.get(0);
            for (int i = 1; i < v.size(); ++i) {
                v.get(i).deleteNode();
            }
            gid.setIDValue(idValue);
            gid.setIDUsage(idUsage);
            if (idValue == null) {
                gid.deleteNode();
                return null;
            }
        } else {
            gid = this.appendGeneralID(idUsage, idValue);
        }
        return gid;
    }

    public void removeGeneralID(String idUsage) {
        VElement v = this.getChildElementVector_JDFElement("GeneralID", null, new JDFAttributeMap("IDUsage", idUsage), true, 0, true);
        for (KElement e : v) {
            e.deleteNode();
        }
    }

    public String getGeneralID(String idUsage) {
        return this.getGeneralID(idUsage, 0);
    }

    public String getGeneralID(String idUsage, int iPos) {
        VElement v = this.getChildElementVector("GeneralID", null, new JDFAttributeMap("IDUsage", idUsage), true, 0, true);
        JDFGeneralID gid = (JDFGeneralID)ContainerUtil.get(v, iPos);
        return gid == null ? null : gid.getIDValue();
    }

    @Deprecated
    public VectorMap<String, JDFGeneralID> getGeneralIDVectorMap() {
        VElement v = this.getChildElementVector("GeneralID", null);
        if (v.size() == 0) {
            return null;
        }
        VectorMap<String, JDFGeneralID> vm = new VectorMap<String, JDFGeneralID>();
        for (KElement e : v) {
            JDFGeneralID gid = (JDFGeneralID)e;
            vm.putOne(gid.getIDUsage(), gid);
        }
        return vm;
    }

    public ListMap<String, JDFGeneralID> getGeneralIDListMap() {
        List<KElement> v = this.getChildList("GeneralID", null);
        if (v.isEmpty()) {
            return null;
        }
        ListMap<String, JDFGeneralID> vm = new ListMap<String, JDFGeneralID>();
        for (KElement e : v) {
            JDFGeneralID gid = (JDFGeneralID)e;
            vm.putOne(gid.getIDUsage(), gid);
        }
        return vm;
    }

    public JDFAttributeMap getGeneralIDMap() {
        List<KElement> v = this.getChildList("GeneralID", null);
        if (v.size() == 0) {
            return null;
        }
        JDFAttributeMap m = new JDFAttributeMap();
        for (KElement e : v) {
            JDFGeneralID gid = (JDFGeneralID)e;
            m.put(gid.getIDUsage(), gid.getIDValue());
        }
        return m;
    }

    @Override
    public synchronized KElement appendElement(String elementName, String nameSpaceURI) {
        KElement newChild = this.appendElementRaw(elementName, nameSpaceURI);
        this.setDirty(false);
        Document od = this.getOwnerDocument();
        if (od instanceof DocumentJDFImpl && ((DocumentJDFImpl)((Object)od)).bInitOnCreate) {
            newChild.init();
        }
        return newChild;
    }

    public JDFComment appendComment() {
        return (JDFComment)this.appendElement("Comment", null);
    }

    public JDFComment getCreateComment(int iSkip) {
        return (JDFComment)this.getCreateElement_KElement("Comment", null, iSkip);
    }

    public JDFComment getComment(int iSkip) {
        return (JDFComment)this.getElement("Comment", null, iSkip);
    }

    public JDFComment getComment(String _name, int index) {
        return (JDFComment)this.getChildWithAttribute("Comment", "Name", null, _name, index, true);
    }

    public String getCommentText(String _name, int index) {
        JDFComment c = this.getComment(_name, index);
        if (c == null && StringUtil.isEmpty(_name)) {
            c = this.getComment(index);
        }
        return c == null ? null : c.getText();
    }

    public JDFComment getCreateComment(String _name, int index) {
        return (JDFComment)this.getCreateChildWithAttribute("Comment", "Name", null, _name, index);
    }

    public JDFPreview appendPreview() {
        return (JDFPreview)this.appendElement("Preview", null);
    }

    public JDFPreview getCreatePreview(int iSkip) {
        return (JDFPreview)this.getCreateElement_KElement("Preview", null, iSkip);
    }

    public JDFPreview getPreview(int iSkip) {
        return (JDFPreview)this.getElement("Preview", null, iSkip);
    }

    public JDFElement getChildWithMatchingAttribute(String nodeName, String attName, String nameSpaceURI, String attVal, int index, boolean bDirect, AttributeInfo.EnumAttributeType dataType) {
        VElement v = this.getChildrenByTagName(nodeName, nameSpaceURI, null, bDirect, true, 0);
        int siz = v.size();
        int n = 0;
        for (int i = 0; i < siz; ++i) {
            JDFElement e = (JDFElement)v.elementAt(i);
            if (!e.includesMatchingAttribute(attName, attVal, dataType) || n++ != index) continue;
            return e;
        }
        return null;
    }

    @Override
    public KElement getChildWithAttribute(String nodeName, String attName, String nameSpaceURI, String attVal, int index, boolean bDirect) {
        KElement kRet = null;
        XMLDocUserData userData = null;
        boolean bID = "ID".equals(attName);
        if (bID && !JDFElement.isWildCard(attVal) && (userData = this.getXMLDocUserData()) != null) {
            kRet = userData.getTarget(attVal);
            if (kRet != null && (bDirect && kRet.getParentNode_KElement() != this || kRet.getOwnerDocument() != this.getOwnerDocument())) {
                kRet = null;
            }
            if (kRet != null) {
                return kRet;
            }
        }
        if (JDFElement.isWildCard(nodeName)) {
            nodeName = null;
        }
        if (JDFElement.isWildCard(nameSpaceURI)) {
            nameSpaceURI = null;
        }
        if (JDFElement.isWildCard(attVal)) {
            attVal = null;
        }
        if (bDirect && index >= 0) {
            KElement e0 = this.getFirstChildElement();
            if (e0 != null) {
                boolean bAlwaysFit;
                boolean bl = bAlwaysFit = nodeName == null && nameSpaceURI == null;
                do {
                    String idVal;
                    KElement e;
                    if ((e = e0) instanceof JDFRefElement && !(this instanceof JDFResourcePool)) {
                        e = ((JDFRefElement)e0).getTarget();
                    }
                    if (e == null) continue;
                    if ((bAlwaysFit || e.fitsName(nodeName, nameSpaceURI)) && e.includesAttribute(attName, attVal) && index-- == 0) {
                        kRet = e;
                    }
                    if (!bID || userData == null || (idVal = e.getAttribute_KElement("ID", null, null)) == null) continue;
                    userData.setTarget(e, idVal);
                } while ((e0 = e0.getNextSiblingElement()) != null && kRet == null);
            }
        } else {
            JDFAttributeMap m = new JDFAttributeMap(attName, attVal);
            kRet = this.getChildByTagName(nodeName, nameSpaceURI, index, m, bDirect, true);
        }
        return kRet;
    }

    public boolean includesMatchingAttribute(String attName, String attVal, AttributeInfo.EnumAttributeType dataType) {
        String thisVal = this.getAttribute(attName, null, null);
        if (thisVal == null) {
            return false;
        }
        if (JDFElement.isWildCard(attVal)) {
            return true;
        }
        if (attVal.equals(thisVal)) {
            return true;
        }
        return AtrInfo.matchesAttribute(attVal, thisVal, dataType);
    }

    public void setStatus(EnumNodeStatus s) {
        this.setAttribute("Status", s == null ? null : s.getName(), null);
    }

    public EnumNodeStatus getStatus() {
        return EnumNodeStatus.getEnum(this.getAttribute("Status", null, null));
    }

    protected static KElement getDeepElementByID(KElement base, String attName, String id, KElement childToExclude, XMLDocUserData ud) {
        String attVal;
        Attr attr = base.getAttributeNode(attName);
        String string = attVal = attr != null ? attr.getValue() : null;
        if (attVal != null) {
            if (ud != null) {
                ud.setTarget(base, attVal);
            }
            if (attVal.equals(id)) {
                return base;
            }
        }
        for (KElement childElement = base.getFirstChildElement(); childElement != null; childElement = childElement.getNextSiblingElement()) {
            KElement kDeepElement;
            if (childElement.equals(childToExclude) || (kDeepElement = JDFElement.getDeepElementByID(childElement, attName, id, childToExclude, ud)) == null) continue;
            return kDeepElement;
        }
        return null;
    }

    public HashSet<JDFElement> getAllRefs(HashSet<JDFElement> vDoneRefs, boolean bRecurse) {
        if (vDoneRefs.contains(this)) {
            return vDoneRefs;
        }
        List<KElement> v = this.getChildArray_KElement(null, null, null, true, 0);
        for (KElement e : v) {
            if (e instanceof JDFRefElement) {
                JDFResource r;
                JDFRefElement ref = (JDFRefElement)e;
                if (vDoneRefs.contains(ref)) continue;
                vDoneRefs.add(ref);
                if (!bRecurse || (r = ref.getTarget()) == null) continue;
                vDoneRefs = r.getAllRefs(vDoneRefs, bRecurse);
                continue;
            }
            if (!(e instanceof JDFElement)) continue;
            vDoneRefs = ((JDFElement)e).getAllRefs(vDoneRefs, bRecurse);
        }
        return vDoneRefs;
    }

    @Override
    public boolean matchesPath(String path, boolean bFollowRefs) {
        if (path == null) {
            return true;
        }
        VString v = StringUtil.tokenize(path, "/", false);
        KElement e = this;
        JDFElement eLast = null;
        for (int i = v.size() - 1; i >= 0; --i) {
            if (e == null) {
                return false;
            }
            String locName = e.getLocalName();
            if (!e.matchesPathName(v.get(i))) {
                JDFResource r;
                VElement vRefs;
                if (bFollowRefs && eLast != null && locName.equals("ResourcePool") && eLast instanceof JDFResource && (vRefs = (r = (JDFResource)eLast).getLinks(r.getRefString(), null)) != null) {
                    Object subPath = v.get(0);
                    for (int k = 1; k <= i + 1; ++k) {
                        subPath = (String)subPath + "/" + v.get(k);
                    }
                    subPath = (String)subPath + "Ref";
                    for (KElement eRef : vRefs) {
                        boolean b = eRef.matchesPath((String)subPath, bFollowRefs);
                        if (!b) continue;
                        return true;
                    }
                }
                return false;
            }
            eLast = e;
            e = e.getParentNode_KElement();
        }
        if (path.startsWith("/")) {
            return e == null || path.startsWith("//");
        }
        return true;
    }

    public static String getValueForNewAttribute(KElement ke, String attName) {
        AttributeInfo.EnumAttributeType attyp;
        if (StringUtil.getNonEmpty(attName) == null) {
            return null;
        }
        if (!(ke instanceof JDFElement)) {
            return "New Value";
        }
        JDFElement e = (JDFElement)ke;
        JDFAttributeMap map = e.getDefaultAttributeMap();
        if (map != null && map.containsKey(attName)) {
            return map.get(attName);
        }
        if ("ID".equals(attName)) {
            return "ID" + KElement.uniqueID(0);
        }
        if ("JobID".equals(attName)) {
            return "J" + KElement.uniqueID(0);
        }
        if ("JobPartID".equals(attName)) {
            return e.generateDotID("JobPartID", null);
        }
        if ("Status".equals(attName) && e instanceof JDFNode) {
            return "Waiting";
        }
        if ("Status".equals(attName) && e instanceof JDFResource) {
            return "Unavailable";
        }
        if ("Type".equals(attName) && e instanceof JDFNode) {
            return "Product";
        }
        if ("Type".equals(attName) && e instanceof JDFMessage) {
            return "Status";
        }
        if ("TimeStamp".equals(attName)) {
            return new JDFDate().getDateTimeISO();
        }
        if ("ComponentType".equals(attName)) {
            return "PartialProduct";
        }
        if ("PreviewType".equals(attName)) {
            return "Separation";
        }
        if (e != null && (attyp = e.getAtrType(attName)) != null) {
            if (AttributeInfo.EnumAttributeType.boolean_.equals((Object)attyp)) {
                return "true";
            }
            if (AttributeInfo.EnumAttributeType.CMYKColor.equals((Object)attyp)) {
                return "0 0 0 1";
            }
            if (AttributeInfo.EnumAttributeType.RGBColor.equals((Object)attyp)) {
                return "1 1 1";
            }
            if (AttributeInfo.EnumAttributeType.dateTime.equals((Object)attyp) || AttributeInfo.EnumAttributeType.DateTimeRange.equals((Object)attyp) || AttributeInfo.EnumAttributeType.DateTimeRangeList.equals((Object)attyp)) {
                return new JDFDate().getDateTimeISO();
            }
            if (AttributeInfo.EnumAttributeType.double_.equals((Object)attyp)) {
                return "0.0";
            }
            if (AttributeInfo.EnumAttributeType.duration.equals((Object)attyp) || AttributeInfo.EnumAttributeType.DurationRange.equals((Object)attyp) || AttributeInfo.EnumAttributeType.DurationRangeList.equals((Object)attyp)) {
                return "PT1H";
            }
            if (AttributeInfo.EnumAttributeType.integer.equals((Object)attyp) || AttributeInfo.EnumAttributeType.IntegerRange.equals((Object)attyp) || AttributeInfo.EnumAttributeType.IntegerRangeList.equals((Object)attyp) || AttributeInfo.EnumAttributeType.IntegerList.equals((Object)attyp)) {
                return "0";
            }
            if (AttributeInfo.EnumAttributeType.JDFJMFVersion.equals((Object)attyp)) {
                return "1.4";
            }
            if (AttributeInfo.EnumAttributeType.matrix.equals((Object)attyp)) {
                return "1 0 0 1 0 0";
            }
            if (AttributeInfo.EnumAttributeType.XYPair.equals((Object)attyp) || AttributeInfo.EnumAttributeType.XYPairRange.equals((Object)attyp) || AttributeInfo.EnumAttributeType.XYPairRangeList.equals((Object)attyp)) {
                return "0 0";
            }
        }
        return "New Value";
    }

    protected JDFDoc getURLDoc(String url) {
        URLReader r = new URLReader(url, this.getOwnerDocument_JDFElement());
        return r.getJDFDoc();
    }

    protected InputStream getURLInputStream(String url) {
        URLReader r = new URLReader(url, this.getOwnerDocument_JDFElement());
        return r.getURLInputStream();
    }

    public static String getSchemaURL(EnumVersion version) {
        if (EnumUtil.aLessThanB(version, EnumVersion.Version_2_0)) {
            return JDFElement.getSchemaURL(1, 1);
        }
        return JDFElement.getSchemaURL(2, 0);
    }

    @Override
    public boolean init() {
        this.infotables = null;
        return super.init();
    }

    public static JDFElement parseFile(File file) {
        JDFDoc f = JDFDoc.parseFile(file);
        return f == null ? null : (JDFElement)f.getRoot();
    }

    public static JDFElement parseFile(String filename) {
        JDFDoc f = JDFDoc.parseFile(filename);
        return f == null ? null : (JDFElement)f.getRoot();
    }

    public static JDFElement parseStream(InputStream s) {
        JDFDoc f = JDFDoc.parseStream(s);
        return f == null ? null : (JDFElement)f.getRoot();
    }

    public static JDFElement parseString(String string) {
        JDFDoc f = JDFDoc.parseString(string);
        return f == null ? null : (JDFElement)f.getRoot();
    }

    static {
        JDFElement.atrInfoTable[0] = new AtrInfoTable("SettingsPolicy", 0x33333311L, AttributeInfo.EnumAttributeType.enumeration, EnumSettingsPolicy.getEnum(0), null);
        JDFElement.atrInfoTable[1] = new AtrInfoTable("CommentURL", 0x33333333L, AttributeInfo.EnumAttributeType.URL, null, null);
        JDFElement.atrInfoTable[2] = new AtrInfoTable("DescriptiveName", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFElement.atrInfoTable[3] = new AtrInfoTable("BestEffortExceptions", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFElement.atrInfoTable[4] = new AtrInfoTable("MustHonorExceptions", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFElement.atrInfoTable[5] = new AtrInfoTable("OperatorInterventionExceptions", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKENS, null, null);
        JDFElement.atrInfoTable[6] = new AtrInfoTable("xmlns", 0x33333333L, AttributeInfo.EnumAttributeType.URI, null, null);
        elemInfoTable = new ElemInfoTable[3];
        JDFElement.elemInfoTable[0] = new ElemInfoTable("Comment", 0x33333333L);
        JDFElement.elemInfoTable[1] = new ElemInfoTable("Preview", 0x33331111L);
        JDFElement.elemInfoTable[2] = new ElemInfoTable("GeneralID", 0x33333111L);
        m_dummyDocumentJDFImpl = null;
    }

    public static final class EnumValidationLevel
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumValidationLevel NoWarnIncomplete = new EnumValidationLevel("NoWarnIncomplete");
        public static final EnumValidationLevel NoWarnComplete = new EnumValidationLevel("NoWarnComplete");
        public static final EnumValidationLevel Incomplete = new EnumValidationLevel("Incomplete");
        public static final EnumValidationLevel Complete = new EnumValidationLevel("Complete");
        public static final EnumValidationLevel RecursiveIncomplete = new EnumValidationLevel("RecursiveIncomplete");
        public static final EnumValidationLevel RecursiveComplete = new EnumValidationLevel("RecursiveComplete");

        protected EnumValidationLevel(String name) {
            super(name, m_startValue++);
        }

        public static EnumValidationLevel getEnum(String enumName) {
            return (EnumValidationLevel)EnumValidationLevel.getEnum(EnumValidationLevel.class, (String)enumName);
        }

        public static EnumValidationLevel getEnum(int enumValue) {
            return (EnumValidationLevel)EnumValidationLevel.getEnum(EnumValidationLevel.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumValidationLevel.getEnumMap(EnumValidationLevel.class);
        }

        public static List getEnumList() {
            return EnumValidationLevel.getEnumList(EnumValidationLevel.class);
        }

        public static Iterator iterator() {
            return EnumValidationLevel.iterator(EnumValidationLevel.class);
        }

        public static boolean isRecursive(EnumValidationLevel vl) {
            return RecursiveIncomplete.equals((Object)vl) || RecursiveComplete.equals((Object)vl);
        }

        public static boolean isNoWarn(EnumValidationLevel vl) {
            return NoWarnComplete.equals((Object)vl) || NoWarnIncomplete.equals((Object)vl);
        }

        public static boolean isRequired(EnumValidationLevel level) {
            return Complete.equals((Object)level) || RecursiveComplete.equals((Object)level) || NoWarnComplete.equals((Object)level);
        }

        public static EnumValidationLevel setNoWarning(EnumValidationLevel level, boolean noWarning) {
            if (noWarning && !EnumValidationLevel.isNoWarn(level)) {
                EnumValidationLevel enumValidationLevel = level = EnumValidationLevel.isRequired(level) ? NoWarnComplete : NoWarnIncomplete;
            }
            if (!noWarning && EnumValidationLevel.isNoWarn(level)) {
                level = EnumValidationLevel.isRequired(level) ? Complete : Incomplete;
            }
            return level;
        }

        public static EnumValidationLevel incompleteLevel(EnumValidationLevel level) {
            if (Complete.equals((Object)level)) {
                level = Incomplete;
            } else if (RecursiveComplete.equals((Object)level)) {
                level = RecursiveIncomplete;
            } else if (NoWarnComplete.equals((Object)level)) {
                level = NoWarnIncomplete;
            }
            return level;
        }
    }

    public static final class EnumVersion
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumVersion Unknown = new EnumVersion("Unknown");
        public static final EnumVersion Version_1_0 = new EnumVersion("1.0");
        public static final EnumVersion Version_1_1 = new EnumVersion("1.1");
        public static final EnumVersion Version_1_2 = new EnumVersion("1.2");
        public static final EnumVersion Version_1_3 = new EnumVersion("1.3");
        public static final EnumVersion Version_1_4 = new EnumVersion("1.4");
        public static final EnumVersion Version_1_5 = new EnumVersion("1.5");
        public static final EnumVersion Version_1_6 = new EnumVersion("1.6");
        public static final EnumVersion Version_1_7 = new EnumVersion("1.7");
        public static final EnumVersion Version_1_8 = new EnumVersion("1.8");
        public static final EnumVersion Version_1_9 = new EnumVersion("1.9");
        public static final EnumVersion Version_1_10 = new EnumVersion("1.10");
        public static final EnumVersion Version_1_11 = new EnumVersion("1.11");
        public static final EnumVersion Version_2_0 = new EnumVersion("2.0");
        public static final EnumVersion Version_2_1 = new EnumVersion("2.1");
        public static final EnumVersion Version_2_2 = new EnumVersion("2.2");
        public static final EnumVersion Version_2_3 = new EnumVersion("2.3");
        public static final EnumVersion Version_2_4 = new EnumVersion("2.4");
        private static int LAST_1 = EnumVersion.getEnumList().indexOf((Object)Version_2_0) - 1;

        public String toString() {
            return this.getMajorVersion() + "." + this.getMinorVersion();
        }

        private EnumVersion(String name) {
            super(name, m_startValue++);
        }

        public EnumVersion getXJDFVersion() {
            if (this.getMajorVersion() == 1) {
                return this.getMinorVersion() >= 6 ? EnumVersion.getEnum(2, this.getMinorVersion() - 6) : null;
            }
            return this;
        }

        public EnumVersion getJDFVersion() {
            if (this.getMajorVersion() == 2) {
                return EnumVersion.getEnum(1, this.getMinorVersion() + 6);
            }
            return this;
        }

        public static EnumVersion getEnum(String enumName) {
            if (enumName != null && enumName.indexOf(32) >= 0) {
                enumName = StringUtil.normalize(enumName, false, null);
            }
            if (StringUtil.isEmpty(enumName)) {
                return null;
            }
            char charAt = enumName.charAt(0);
            if (charAt == '1') {
                if ("1.9".equals(enumName)) {
                    return Version_1_9;
                }
                if ("1.8".equals(enumName)) {
                    return Version_1_8;
                }
                if ("1.7".equals(enumName)) {
                    return Version_1_7;
                }
                if ("1.6".equals(enumName)) {
                    return Version_1_6;
                }
                if ("1.5".equals(enumName)) {
                    return Version_1_5;
                }
                if ("1.4".equals(enumName)) {
                    return Version_1_4;
                }
                if ("1.3".equals(enumName)) {
                    return Version_1_3;
                }
                if ("1.2".equals(enumName)) {
                    return Version_1_2;
                }
                if ("1.1".equals(enumName)) {
                    return Version_1_1;
                }
                if ("1.0".equals(enumName)) {
                    return Version_1_0;
                }
            } else if (charAt == '2') {
                if ("2.0".equals(enumName)) {
                    return Version_2_0;
                }
                if ("2.1".equals(enumName)) {
                    return Version_2_1;
                }
                if ("2.2".equals(enumName)) {
                    return Version_2_2;
                }
                if ("2.3".equals(enumName)) {
                    return Version_2_3;
                }
                return XJDFHelper.defaultVersion();
            }
            return JDFElement.getDefaultJDFVersion();
        }

        public static EnumVersion getEnum(int enumValue) {
            return (EnumVersion)EnumVersion.getEnum(EnumVersion.class, (int)enumValue);
        }

        public static EnumVersion getEnum(int major, int minor) {
            return EnumVersion.getEnum(major + "." + minor);
        }

        public static Map getEnumMap() {
            return EnumVersion.getEnumMap(EnumVersion.class);
        }

        public static List getEnumList() {
            return EnumVersion.getEnumList(EnumVersion.class);
        }

        public static Iterator iterator() {
            return EnumVersion.iterator(EnumVersion.class);
        }

        public boolean isGreater(EnumVersion other) {
            if (other == null) {
                return true;
            }
            return this.getValue() > other.getValue();
        }

        public boolean isXJDF() {
            return !EnumUtil.aLessThanB(this, Version_2_0);
        }

        public int getMinorVersion() {
            return (this.getValue() - 1) % LAST_1;
        }

        public int getMajorVersion() {
            return 1 + (this.getValue() - 1) / LAST_1;
        }
    }

    public static final class EnumNamedColor
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumNamedColor White = new EnumNamedColor("White");
        public static final EnumNamedColor Black = new EnumNamedColor("Black");
        public static final EnumNamedColor Gray = new EnumNamedColor("Gray");
        public static final EnumNamedColor Red = new EnumNamedColor("Red");
        public static final EnumNamedColor Yellow = new EnumNamedColor("Yellow");
        public static final EnumNamedColor Green = new EnumNamedColor("Green");
        public static final EnumNamedColor Blue = new EnumNamedColor("Blue");
        public static final EnumNamedColor Turquoise = new EnumNamedColor("Turquoise");
        public static final EnumNamedColor Violet = new EnumNamedColor("Violet");
        public static final EnumNamedColor Orange = new EnumNamedColor("Orange");
        public static final EnumNamedColor Brown = new EnumNamedColor("Brown");
        public static final EnumNamedColor Gold = new EnumNamedColor("Gold");
        public static final EnumNamedColor Silver = new EnumNamedColor("Silver");
        public static final EnumNamedColor Pink = new EnumNamedColor("Pink");
        public static final EnumNamedColor Buff = new EnumNamedColor("Buff");
        public static final EnumNamedColor Ivory = new EnumNamedColor("Ivory");
        public static final EnumNamedColor Goldenrod = new EnumNamedColor("Goldenrod");
        public static final EnumNamedColor DarkWhite = new EnumNamedColor("DarkWhite");
        public static final EnumNamedColor DarkBlack = new EnumNamedColor("DarkBlack");
        public static final EnumNamedColor DarkGray = new EnumNamedColor("DarkGray");
        public static final EnumNamedColor DarkRed = new EnumNamedColor("DarkRed");
        public static final EnumNamedColor DarkYellow = new EnumNamedColor("DarkYellow");
        public static final EnumNamedColor DarkGreen = new EnumNamedColor("DarkGreen");
        public static final EnumNamedColor DarkBlue = new EnumNamedColor("DarkBlue");
        public static final EnumNamedColor DarkTurquoise = new EnumNamedColor("DarkTurquoise");
        public static final EnumNamedColor DarkViolet = new EnumNamedColor("DarkViolet");
        public static final EnumNamedColor DarkOrange = new EnumNamedColor("DarkOrange");
        public static final EnumNamedColor DarkBrown = new EnumNamedColor("DarkBrown");
        public static final EnumNamedColor DarkGold = new EnumNamedColor("DarkGold");
        public static final EnumNamedColor DarkSilver = new EnumNamedColor("DarkSilver");
        public static final EnumNamedColor DarkPink = new EnumNamedColor("DarkPink");
        public static final EnumNamedColor DarkBuff = new EnumNamedColor("DarkBuff");
        public static final EnumNamedColor DarkIvory = new EnumNamedColor("DarkIvory");
        public static final EnumNamedColor DarkGoldenrod = new EnumNamedColor("DarkGoldenrod");
        public static final EnumNamedColor DarkMustard = new EnumNamedColor("DarkMustard");
        public static final EnumNamedColor LightWhite = new EnumNamedColor("LightWhite");
        public static final EnumNamedColor LightBlack = new EnumNamedColor("LightBlack");
        public static final EnumNamedColor LightGray = new EnumNamedColor("LightGray");
        public static final EnumNamedColor LightRed = new EnumNamedColor("LightRed");
        public static final EnumNamedColor LightYellow = new EnumNamedColor("LightYellow");
        public static final EnumNamedColor LightGreen = new EnumNamedColor("LightGreen");
        public static final EnumNamedColor LightBlue = new EnumNamedColor("LightBlue");
        public static final EnumNamedColor LightTurquoise = new EnumNamedColor("LightTurquoise");
        public static final EnumNamedColor LightViolet = new EnumNamedColor("LightViolet");
        public static final EnumNamedColor LightOrange = new EnumNamedColor("LightOrange");
        public static final EnumNamedColor LightBrown = new EnumNamedColor("LightBrown");
        public static final EnumNamedColor LightGold = new EnumNamedColor("LightGold");
        public static final EnumNamedColor LightSilver = new EnumNamedColor("LightSilver");
        public static final EnumNamedColor LightPink = new EnumNamedColor("LightPink");
        public static final EnumNamedColor LightBuff = new EnumNamedColor("LightBuff");
        public static final EnumNamedColor LightIvory = new EnumNamedColor("LightIvory");
        public static final EnumNamedColor LightGoldenrod = new EnumNamedColor("LightGoldenrod");
        public static final EnumNamedColor LightMustard = new EnumNamedColor("LightMustard");
        public static final EnumNamedColor ClearWhite = new EnumNamedColor("ClearWhite");
        public static final EnumNamedColor ClearBlack = new EnumNamedColor("ClearBlack");
        public static final EnumNamedColor ClearGray = new EnumNamedColor("ClearGray");
        public static final EnumNamedColor ClearRed = new EnumNamedColor("ClearRed");
        public static final EnumNamedColor ClearGreen = new EnumNamedColor("ClearGreen");
        public static final EnumNamedColor ClearBlue = new EnumNamedColor("ClearBlue");
        public static final EnumNamedColor ClearTurquoise = new EnumNamedColor("ClearTurquoise");
        public static final EnumNamedColor ClearViolet = new EnumNamedColor("ClearViolet");
        public static final EnumNamedColor ClearOrange = new EnumNamedColor("ClearOrange");
        public static final EnumNamedColor ClearBrown = new EnumNamedColor("ClearBrown");
        public static final EnumNamedColor ClearGold = new EnumNamedColor("ClearGold");
        public static final EnumNamedColor ClearSilver = new EnumNamedColor("ClearSilver");
        public static final EnumNamedColor ClearPink = new EnumNamedColor("ClearPink");
        public static final EnumNamedColor ClearBuff = new EnumNamedColor("ClearBuff");
        public static final EnumNamedColor ClearIvory = new EnumNamedColor("ClearIvory");
        public static final EnumNamedColor ClearGoldenrod = new EnumNamedColor("ClearGoldenrod");
        public static final EnumNamedColor ClearMustard = new EnumNamedColor("ClearMustard");
        public static final EnumNamedColor ClearDarkWhite = new EnumNamedColor("ClearDarkWhite");
        public static final EnumNamedColor ClearDarkBlack = new EnumNamedColor("ClearDarkBlack");
        public static final EnumNamedColor ClearDarkGray = new EnumNamedColor("ClearDarkGray");
        public static final EnumNamedColor ClearDarkRed = new EnumNamedColor("ClearDarkRed");
        public static final EnumNamedColor ClearDarkYellow = new EnumNamedColor("ClearDarkYellow");
        public static final EnumNamedColor ClearDarkGreen = new EnumNamedColor("ClearDarkGreen");
        public static final EnumNamedColor ClearDarkBlue = new EnumNamedColor("ClearDarkBlue");
        public static final EnumNamedColor ClearDarkTurquoise = new EnumNamedColor("ClearDarkTurquoise");
        public static final EnumNamedColor ClearDarkViolet = new EnumNamedColor("ClearDarkViolet");
        public static final EnumNamedColor ClearDarkOrange = new EnumNamedColor("ClearDarkOrange");
        public static final EnumNamedColor ClearDarkBrown = new EnumNamedColor("ClearDarkBrown");
        public static final EnumNamedColor ClearDarkGold = new EnumNamedColor("ClearDarkGold");
        public static final EnumNamedColor ClearDarkSilver = new EnumNamedColor("ClearDarkSilver");
        public static final EnumNamedColor ClearDarkPink = new EnumNamedColor("ClearDarkPink");
        public static final EnumNamedColor ClearDarkBuff = new EnumNamedColor("ClearDarkBuff");
        public static final EnumNamedColor ClearDarkIvory = new EnumNamedColor("ClearDarkIvory");
        public static final EnumNamedColor ClearDarkGoldenrod = new EnumNamedColor("ClearDarkGoldenrod");
        public static final EnumNamedColor ClearLightWhite = new EnumNamedColor("ClearLightWhite");
        public static final EnumNamedColor ClearLightBlack = new EnumNamedColor("ClearLightBlack");
        public static final EnumNamedColor ClearLightGray = new EnumNamedColor("ClearLightGray");
        public static final EnumNamedColor ClearLightRed = new EnumNamedColor("ClearLightRed");
        public static final EnumNamedColor ClearLightYellow = new EnumNamedColor("ClearLightYellow");
        public static final EnumNamedColor ClearLightGreen = new EnumNamedColor("ClearLightGreen");
        public static final EnumNamedColor ClearLightBlue = new EnumNamedColor("ClearLightBlue");
        public static final EnumNamedColor ClearLightTurquoise = new EnumNamedColor("ClearLightTurquoise");
        public static final EnumNamedColor ClearLightViolet = new EnumNamedColor("ClearLightViolet");
        public static final EnumNamedColor ClearLightOrange = new EnumNamedColor("ClearLightOrange");
        public static final EnumNamedColor ClearLightBrown = new EnumNamedColor("ClearLightBrown");
        public static final EnumNamedColor ClearLightGold = new EnumNamedColor("ClearLightGold");
        public static final EnumNamedColor ClearLightSilver = new EnumNamedColor("ClearLightSilver");
        public static final EnumNamedColor ClearLightPink = new EnumNamedColor("ClearLightPink");
        public static final EnumNamedColor ClearLightBuff = new EnumNamedColor("ClearLightBuff");
        public static final EnumNamedColor ClearLightIvory = new EnumNamedColor("ClearLightIvory");
        public static final EnumNamedColor ClearLightGoldenrod = new EnumNamedColor("ClearLightGoldenrod");
        public static final EnumNamedColor ClearLightMustard = new EnumNamedColor("ClearLightMustard");
        public static final EnumNamedColor MultiColor = new EnumNamedColor("MultiColor");
        public static final EnumNamedColor NoColor = new EnumNamedColor("NoColor");

        private EnumNamedColor(String name) {
            super(name, m_startValue++);
        }

        public static EnumNamedColor getEnum(String enumName) {
            return (EnumNamedColor)EnumNamedColor.getEnum(EnumNamedColor.class, (String)enumName);
        }

        public static EnumNamedColor getEnum(int enumValue) {
            return (EnumNamedColor)EnumNamedColor.getEnum(EnumNamedColor.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumNamedColor.getEnumMap(EnumNamedColor.class);
        }

        public static List getEnumList() {
            return EnumNamedColor.getEnumList(EnumNamedColor.class);
        }

        public static Iterator iterator() {
            return EnumNamedColor.iterator(EnumNamedColor.class);
        }
    }

    public static final class EnumSettingsPolicy
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumSettingsPolicy BestEffort = new EnumSettingsPolicy("BestEffort");
        public static final EnumSettingsPolicy MustHonor = new EnumSettingsPolicy("MustHonor");
        public static final EnumSettingsPolicy OperatorIntervention = new EnumSettingsPolicy("OperatorIntervention");

        private EnumSettingsPolicy(String name) {
            super(name, m_startValue++);
        }

        public static EnumSettingsPolicy getEnum(String enumName) {
            return (EnumSettingsPolicy)EnumSettingsPolicy.getEnum(EnumSettingsPolicy.class, (String)enumName);
        }

        public static EnumSettingsPolicy getEnum(int enumValue) {
            return (EnumSettingsPolicy)EnumSettingsPolicy.getEnum(EnumSettingsPolicy.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumSettingsPolicy.getEnumMap(EnumSettingsPolicy.class);
        }

        public static List getEnumList() {
            return EnumSettingsPolicy.getEnumList(EnumSettingsPolicy.class);
        }

        public static Iterator iterator() {
            return EnumSettingsPolicy.iterator(EnumSettingsPolicy.class);
        }
    }

    public static final class EnumNodeStatus
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumNodeStatus Waiting = new EnumNodeStatus("Waiting");
        public static final EnumNodeStatus TestRunInProgress = new EnumNodeStatus("TestRunInProgress");
        public static final EnumNodeStatus Ready = new EnumNodeStatus("Ready");
        public static final EnumNodeStatus FailedTestRun = new EnumNodeStatus("FailedTestRun");
        public static final EnumNodeStatus Setup = new EnumNodeStatus("Setup");
        public static final EnumNodeStatus InProgress = new EnumNodeStatus("InProgress");
        public static final EnumNodeStatus Cleanup = new EnumNodeStatus("Cleanup");
        public static final EnumNodeStatus Spawned = new EnumNodeStatus("Spawned");
        public static final EnumNodeStatus Suspended = new EnumNodeStatus("Suspended");
        public static final EnumNodeStatus Stopped = new EnumNodeStatus("Stopped");
        public static final EnumNodeStatus Completed = new EnumNodeStatus("Completed");
        public static final EnumNodeStatus Aborted = new EnumNodeStatus("Aborted");
        public static final EnumNodeStatus Part = new EnumNodeStatus("Part");
        public static final EnumNodeStatus Pool = new EnumNodeStatus("Pool");

        private EnumNodeStatus(String name) {
            super(name, m_startValue++);
        }

        public static EnumNodeStatus getEnum(String enumName) {
            return (EnumNodeStatus)EnumNodeStatus.getEnum(EnumNodeStatus.class, (String)enumName);
        }

        public static EnumNodeStatus getEnum(int enumValue) {
            return (EnumNodeStatus)EnumNodeStatus.getEnum(EnumNodeStatus.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumNodeStatus.getEnumMap(EnumNodeStatus.class);
        }

        public static List getEnumList() {
            return EnumNodeStatus.getEnumList(EnumNodeStatus.class);
        }

        public static JDFAutoQueueEntry.EnumQueueEntryStatus getQueueEntryStatus(EnumNodeStatus ns) {
            if (Waiting.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting;
            }
            if (TestRunInProgress.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting;
            }
            if (Ready.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting;
            }
            if (FailedTestRun.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted;
            }
            if (Setup.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Running;
            }
            if (InProgress.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Running;
            }
            if (Cleanup.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Running;
            }
            if (Spawned.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Running;
            }
            if (Suspended.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Suspended;
            }
            if (Stopped.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Suspended;
            }
            if (Completed.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Completed;
            }
            if (Aborted.equals((Object)ns)) {
                return JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted;
            }
            return null;
        }

        public static JDFAutoDeviceInfo.EnumDeviceStatus getDeviceStatus(EnumNodeStatus ns) {
            if (Waiting.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Stopped;
            }
            if (TestRunInProgress.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Setup;
            }
            if (Ready.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Stopped;
            }
            if (FailedTestRun.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Stopped;
            }
            if (Setup.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Setup;
            }
            if (InProgress.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Running;
            }
            if (Cleanup.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Cleanup;
            }
            if (Spawned.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Unknown;
            }
            if (Suspended.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Unknown;
            }
            if (Stopped.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Stopped;
            }
            if (Completed.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Stopped;
            }
            if (Aborted.equals((Object)ns)) {
                return JDFAutoDeviceInfo.EnumDeviceStatus.Unknown;
            }
            return null;
        }

        public static EnumNodeStatus getNodeStatus(JDFAutoQueueEntry.EnumQueueEntryStatus qes) {
            if (JDFAutoQueueEntry.EnumQueueEntryStatus.Waiting.equals((Object)qes)) {
                return Waiting;
            }
            if (JDFAutoQueueEntry.EnumQueueEntryStatus.Running.equals((Object)qes)) {
                return InProgress;
            }
            if (JDFAutoQueueEntry.EnumQueueEntryStatus.Suspended.equals((Object)qes)) {
                return Suspended;
            }
            if (JDFAutoQueueEntry.EnumQueueEntryStatus.Completed.equals((Object)qes)) {
                return Completed;
            }
            if (JDFAutoQueueEntry.EnumQueueEntryStatus.Aborted.equals((Object)qes)) {
                return Aborted;
            }
            if (JDFAutoQueueEntry.EnumQueueEntryStatus.PendingReturn.equals((Object)qes)) {
                return Cleanup;
            }
            if (JDFAutoQueueEntry.EnumQueueEntryStatus.Held.equals((Object)qes)) {
                return Waiting;
            }
            return null;
        }

        public static Iterator iterator() {
            return EnumNodeStatus.iterator(EnumNodeStatus.class);
        }

        public static boolean isCompleted(EnumNodeStatus nodeStatus) {
            return Completed.equals((Object)nodeStatus) || Aborted.equals((Object)nodeStatus);
        }
    }

    public static final class EnumPoolType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPoolType RefElement = new EnumPoolType("RefElement");
        public static final EnumPoolType ResourcePool = new EnumPoolType("ResourcePool");
        public static final EnumPoolType PipeParams = new EnumPoolType("PipeParams");
        public static final EnumPoolType ResourceLinkPool = new EnumPoolType("ResourceLinkPool");
        public static final EnumPoolType AncestorPool = new EnumPoolType("AncestorPool");
        public static final EnumPoolType AuditPool = new EnumPoolType("AuditPool");
        public static final EnumPoolType ProductionIntent = new EnumPoolType("ProductionIntent");

        private EnumPoolType(String name) {
            super(name, m_startValue++);
        }

        public static EnumPoolType getEnum(String enumName) {
            return (EnumPoolType)EnumPoolType.getEnum(EnumPoolType.class, (String)enumName);
        }

        public static EnumPoolType getEnum(int enumValue) {
            return (EnumPoolType)EnumPoolType.getEnum(EnumPoolType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumPoolType.getEnumMap(EnumPoolType.class);
        }

        public static List getEnumList() {
            return EnumPoolType.getEnumList(EnumPoolType.class);
        }

        public static Iterator iterator() {
            return EnumPoolType.iterator(EnumPoolType.class);
        }
    }

    public static final class EnumSeparation
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumSeparation Cyan = new EnumSeparation("Cyan");
        public static final EnumSeparation Magenta = new EnumSeparation("Magenta");
        public static final EnumSeparation Yellow = new EnumSeparation("Yellow");
        public static final EnumSeparation Black = new EnumSeparation("Black");
        public static final EnumSeparation Red = new EnumSeparation("Red");
        public static final EnumSeparation Green = new EnumSeparation("Green");
        public static final EnumSeparation Blue = new EnumSeparation("Blue");
        public static final EnumSeparation Orange = new EnumSeparation("Orange");
        public static final EnumSeparation Spot = new EnumSeparation("Spot");
        public static final EnumSeparation Varnish = new EnumSeparation("Varnish");

        private EnumSeparation(String name) {
            super(name, m_startValue++);
        }

        public static EnumSeparation getEnum(String enumName) {
            return (EnumSeparation)EnumSeparation.getEnum(EnumSeparation.class, (String)enumName);
        }

        public static EnumSeparation getEnum(int enumValue) {
            return (EnumSeparation)EnumSeparation.getEnum(EnumSeparation.class, (int)enumValue);
        }

        public static Map<EnumSeparation, String> getEnumMap() {
            return EnumSeparation.getEnumMap(EnumSeparation.class);
        }

        public static List<EnumSeparation> getEnumList() {
            return EnumSeparation.getEnumList(EnumSeparation.class);
        }

        public static Iterator<EnumSeparation> iterator() {
            return EnumSeparation.iterator(EnumSeparation.class);
        }
    }

    public static final class EnumXYRelation
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumXYRelation gt = new EnumXYRelation("gt");
        public static final EnumXYRelation ge = new EnumXYRelation("ge");
        public static final EnumXYRelation eq = new EnumXYRelation("eq");
        public static final EnumXYRelation le = new EnumXYRelation("le");
        public static final EnumXYRelation lt = new EnumXYRelation("lt");
        public static final EnumXYRelation ne = new EnumXYRelation("ne");

        private EnumXYRelation(String name) {
            super(name, m_startValue++);
        }

        public static EnumXYRelation getEnum(String enumName) {
            return (EnumXYRelation)EnumXYRelation.getEnum(EnumXYRelation.class, (String)enumName);
        }

        public static EnumXYRelation getEnum(int enumValue) {
            return (EnumXYRelation)EnumXYRelation.getEnum(EnumXYRelation.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumXYRelation.getEnumMap(EnumXYRelation.class);
        }

        public static List getEnumList() {
            return EnumXYRelation.getEnumList(EnumXYRelation.class);
        }

        public static Iterator iterator() {
            return EnumXYRelation.iterator(EnumXYRelation.class);
        }

        public boolean evaluateXY(double x, double y, double nt, double pt) {
            if (this == gt) {
                return x + pt > y - nt;
            }
            if (this == ge) {
                return x + pt >= y - nt;
            }
            if (this == eq) {
                return x >= y - nt && x <= y + pt;
            }
            if (this == le) {
                return x - nt <= y + pt;
            }
            if (this == lt) {
                return x - nt < y + pt;
            }
            if (this == ne) {
                return x < y - nt || x > y + pt;
            }
            return true;
        }
    }

    public static enum eUnit {
        count,
        um,
        pt,
        m,
        m2,
        m3,
        l,
        g,
        kWh;


        public static eUnit getEnum(String name) {
            return EnumUtil.getJavaEnumIgnoreCase(eUnit.class, name);
        }
    }

    public static final class EnumOrientation
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumOrientation Flip0 = new EnumOrientation("Flip0");
        public static final EnumOrientation Flip90 = new EnumOrientation("Flip90");
        public static final EnumOrientation Flip180 = new EnumOrientation("Flip180");
        public static final EnumOrientation Flip270 = new EnumOrientation("Flip270");
        public static final EnumOrientation Rotate0 = new EnumOrientation("Rotate0");
        public static final EnumOrientation Rotate90 = new EnumOrientation("Rotate90");
        public static final EnumOrientation Rotate180 = new EnumOrientation("Rotate180");
        public static final EnumOrientation Rotate270 = new EnumOrientation("Rotate270");

        private EnumOrientation(String name) {
            super(name, m_startValue++);
        }

        public static EnumOrientation getEnum(String enumName) {
            return (EnumOrientation)EnumOrientation.getEnum(EnumOrientation.class, (String)enumName);
        }

        public static EnumOrientation getEnum(int enumValue) {
            return (EnumOrientation)EnumOrientation.getEnum(EnumOrientation.class, (int)enumValue);
        }

        public static Map<String, EnumOrientation> getEnumMap() {
            return EnumOrientation.getEnumMap(EnumOrientation.class);
        }

        public static List<EnumOrientation> getEnumList() {
            return EnumOrientation.getEnumList(EnumOrientation.class);
        }

        public static Iterator<EnumOrientation> iterator() {
            return EnumOrientation.iterator(EnumOrientation.class);
        }
    }

    public static final class EnumBoolean
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumBoolean True = new EnumBoolean("true");
        public static final EnumBoolean False = new EnumBoolean("false");

        private EnumBoolean(String name) {
            super(name.toLowerCase(), m_startValue++);
        }

        public static EnumBoolean getEnum(String enumName) {
            return (EnumBoolean)EnumBoolean.getEnum(EnumBoolean.class, (String)enumName.toLowerCase());
        }

        public static EnumBoolean getEnum(int enumValue) {
            return (EnumBoolean)EnumBoolean.getEnum(EnumBoolean.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumBoolean.getEnumMap(EnumBoolean.class);
        }

        public static List getEnumList() {
            return EnumBoolean.getEnumList(EnumBoolean.class);
        }

        public static Iterator iterator() {
            return EnumBoolean.iterator(EnumBoolean.class);
        }
    }
}

