/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.ArrayList;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.util.HashUtil;

public abstract class JDFRangeList
implements JDFBaseDataTypes {
    protected ArrayList<JDFRange> rangeList = new ArrayList();

    public final Object elementAt(int i) {
        return this.rangeList.get(i);
    }

    public final void remove(int i) {
        this.rangeList.remove(i);
    }

    public final boolean isPartOfRange(JDFRange x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFRange r = this.rangeList.get(i);
            if (!r.isPartOfRange(x)) continue;
            return true;
        }
        return false;
    }

    public final boolean isPartOfRange(JDFRangeList x) {
        int sz = x.size();
        for (int i = 0; i < sz; ++i) {
            JDFRange range = x.at(i);
            if (!this.isPartOfRange(range)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public final String getString() {
        return this.toString();
    }

    public final String toString() {
        int sz = this.rangeList.size();
        StringBuilder s = new StringBuilder((sz + 1) * 16);
        for (int i = 0; i < sz; ++i) {
            s.append(this.rangeList.get(i).toString());
            if (i >= sz - 1) continue;
            s.append(" ");
        }
        return s.toString();
    }

    public final String getString(int precision) {
        int sz = this.rangeList.size();
        StringBuffer s = new StringBuffer((sz + 1) * 16);
        for (int i = 0; i < sz; ++i) {
            s.append(this.rangeList.get(i).getString(precision));
            if (i >= sz - 1) continue;
            s.append(" ");
        }
        return s.toString();
    }

    public final int size() {
        return this.rangeList.size();
    }

    public final void clear() {
        this.rangeList.clear();
    }

    public final JDFRange at(int i) {
        if (i < 0 || i >= this.rangeList.size()) {
            throw new JDFException("JDFDateTimeRangeList.at(i): illegal index" + i);
        }
        return this.rangeList.get(i);
    }

    public final JDFRange begin() {
        return this.rangeList.get(0);
    }

    public final JDFRange end() {
        return this.rangeList.get(this.rangeList.size() - 1);
    }

    public final void erase(int i) {
        this.rangeList.remove(i);
    }

    public final boolean isList() {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFRange range = this.at(i);
            if (range.getLeftObject().equals(range.getRightObject())) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        int size = this.rangeList.size();
        JDFRangeList rangeListOther = (JDFRangeList)other;
        int sizeOther = rangeListOther.rangeList.size();
        if (size != sizeOther) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            JDFRange rangeOther;
            JDFRange range = this.at(i);
            if (range.equals(rangeOther = rangeListOther.at(i))) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        return HashUtil.hashCode(0, this.toString());
    }

    public abstract boolean isUniqueOrdered();

    public final boolean isUnique() {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFRange range = this.at(i);
            for (int j = 0; j < sz; ++j) {
                JDFRange other;
                if (j == i || !(other = this.at(j)).inObjectRange(range.getLeftObject()) && !other.inObjectRange(range.getRightObject())) continue;
                return false;
            }
        }
        return true;
    }

    public abstract boolean isOrdered();
}

