/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFSubscription;
import org.cip4.jdflib.jmf.JMFBuilder;
import org.cip4.jdflib.jmf.JMFBuilderFactory;
import org.cip4.jdflib.util.EnumUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class MessageHelper
extends BaseXJDFHelper {
    String getMessageType(KElement e, String messageName, String family) {
        String type = StringUtil.rightStr(messageName, -family.length());
        return type;
    }

    public MessageHelper(KElement mes) {
        this.theElement = mes;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        MessageHelper.ensureHeader(this.theElement);
    }

    static KElement ensureHeader(KElement message) {
        KElement header = message.getCreateElement("Header");
        header.appendAnchor(null);
        if (!header.hasAttribute("Time")) {
            header.setAttribute("Time", new JDFDate().getDateTimeISO());
        }
        JMFBuilder jmfBuilder = JMFBuilderFactory.getJMFBuilder("XJMF");
        if (!header.hasAttribute("DeviceID")) {
            String senderID = jmfBuilder.getSenderID();
            if (StringUtil.getNonEmpty(senderID) == null) {
                senderID = JDFJMF.getTheSenderID();
            }
            if (StringUtil.getNonEmpty(senderID) == null) {
                senderID = StringUtil.replaceString(JDFAudit.getStaticAgentName(), " ", "_");
            }
            header.setAttribute("DeviceID", senderID);
        }
        if (!header.hasAttribute("AgentName")) {
            header.setAttribute("AgentName", jmfBuilder.getAgentName());
        }
        if (!header.hasAttribute("AgentVersion")) {
            header.setAttribute("AgentVersion", jmfBuilder.getAgentVersion());
        }
        return header;
    }

    public KElement getHeader() {
        return MessageHelper.ensureHeader(this.theElement);
    }

    public String getDeviceID() {
        return MessageHelper.ensureHeader(this.theElement).getNonEmpty("DeviceID");
    }

    public int getReturnCode() {
        if (!this.isResponse()) {
            return -1;
        }
        String rc = this.getAttribute("ReturnCode");
        return StringUtil.parseInt(rc, 0);
    }

    public void setReturnCode(int rc) {
        if (!this.isResponse()) {
            throw new IllegalArgumentException("Can only set return code on response");
        }
        this.setAttribute("ReturnCode", rc);
    }

    public void setHeader(String headerAttribute, String value) {
        KElement header = this.getCreateElement("Header");
        header.setAttribute(headerAttribute, value);
    }

    public JDFSubscription subscribe(String url) {
        if (!this.isQuery()) {
            return null;
        }
        JDFSubscription sub = (JDFSubscription)this.getCreateElement("Subscription");
        sub.setURL(url);
        return sub;
    }

    public boolean isQuery() {
        return this.getLocalName().startsWith("Query");
    }

    public static boolean isMessage(KElement element) {
        String localName;
        String string = localName = element == null ? null : element.getLocalName();
        if (localName == null) {
            return false;
        }
        return new MessageHelper(element).getEFamily() != null;
    }

    public boolean isCommand() {
        return this.getLocalName().startsWith("Command");
    }

    public boolean isResponse() {
        return this.getLocalName().startsWith("Response");
    }

    public boolean isAudit() {
        return this.getLocalName().startsWith("Audit");
    }

    public boolean isSignal() {
        return this.getLocalName().startsWith("Signal");
    }

    public void setQuery(MessageHelper hQuery) {
        if (!this.isResponse() && !this.isSignal() || hQuery == null || hQuery.isResponse() || hQuery.isSignal()) {
            return;
        }
        String id = MessageHelper.ensureHeader(hQuery.theElement).appendAnchor(null);
        MessageHelper.ensureHeader(this.theElement).setAttribute("refID", id);
    }

    @Deprecated
    public JDFMessage.EnumFamily getFamily() {
        if (this.isCommand()) {
            return JDFMessage.EnumFamily.Command;
        }
        if (this.isQuery()) {
            return JDFMessage.EnumFamily.Query;
        }
        if (this.isSignal()) {
            return JDFMessage.EnumFamily.Signal;
        }
        if (this.isResponse()) {
            return JDFMessage.EnumFamily.Response;
        }
        return null;
    }

    public EFamily getEFamily() {
        if (this.isCommand()) {
            return EFamily.Command;
        }
        if (this.isQuery()) {
            return EFamily.Query;
        }
        if (this.isSignal()) {
            return EFamily.Signal;
        }
        if (this.isResponse()) {
            return EFamily.Response;
        }
        if (this.isAudit()) {
            return EFamily.Audit;
        }
        return null;
    }

    public String getType() {
        EFamily f = this.getEFamily();
        String name = this.getLocalName();
        return f == null || f.name().equals(name) ? null : StringUtil.rightStr(name, -f.name().length());
    }

    public static enum EFamily {
        Audit,
        Command,
        Query,
        Response,
        Signal;


        public static EFamily getEnum(String name) {
            EFamily ret = EnumUtil.getJavaEnumIgnoreCase(EFamily.class, name);
            if (ret == null && name != null) {
                String sl = name.toLowerCase();
                for (EFamily f : EFamily.values()) {
                    if (!sl.startsWith(f.name().toLowerCase())) continue;
                    return f;
                }
            }
            return ret;
        }

        public String getType(String base) {
            if (StringUtil.length(base) > this.name().length() && base.toLowerCase().startsWith(this.name().toLowerCase())) {
                return base.substring(this.name().length());
            }
            return null;
        }
    }
}

